/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.table.AbstractTableModel;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.ThrottleFrame;

public class ThrottlesTableModel
extends AbstractTableModel
implements AddressListener,
PropertyChangeListener {
    private final ArrayList<ThrottleFrame> throttleFrames = new ArrayList(5);

    @Override
    public int getRowCount() {
        return this.throttleFrames.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public Object getValueAt(int i, int i1) {
        return this.throttleFrames.get(i);
    }

    public Iterator<ThrottleFrame> iterator() {
        return this.throttleFrames.iterator();
    }

    public void addThrottleFrame(ThrottleFrame tf) {
        this.throttleFrames.add(tf);
        this.fireTableDataChanged();
    }

    public void removeThrottleFrame(ThrottleFrame tf, DccLocoAddress la) {
        this.throttleFrames.remove(tf);
        if (la != null) {
            InstanceManager.throttleManagerInstance().removeListener(la, this);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void notifyAddressChosen(LocoAddress la) {
    }

    @Override
    public void notifyAddressReleased(LocoAddress addr) {
        if (addr instanceof DccLocoAddress) {
            DccLocoAddress la = (DccLocoAddress)addr;
            this.fireTableDataChanged();
            InstanceManager.throttleManagerInstance().removeListener(la, this);
        }
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle throttle) {
        this.fireTableDataChanged();
        throttle.addPropertyChangeListener(this);
    }

    @Override
    public void notifyConsistAddressChosen(int newAddress, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressReleased(int address, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle throttle) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("SpeedSetting") || e.getPropertyName().equals("SpeedSteps") || e.getPropertyName().equals("IsForward")) {
            this.fireTableDataChanged();
        }
    }
}

