/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.LoadXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottlesPreferences;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ThrottlesPreferencesUISettingsPane
extends JPanel {
    private JCheckBox cbUseToolBar;
    private JCheckBox cbUseFunctionIcon;
    private JCheckBox cbUseLargeSpeedSlider;
    private JCheckBox cbResizeWinImg;
    private JCheckBox cbUseExThrottle;
    private JCheckBox cbUseRosterImage;
    private JCheckBox cbEnableRosterSearch;
    private JCheckBox cbEnableAutoLoad;
    private JCheckBox cbHideUndefinedButtons;
    private JCheckBox cbIgnoreThrottlePosition;
    private JCheckBox cbSaveThrottleOnLayoutSave;
    private JCheckBox cbSilentSteal;
    private JCheckBox cbSilentShare;
    private JTextField tfDefaultThrottleLocation;
    private boolean isDirty = false;

    public ThrottlesPreferencesUISettingsPane(ThrottlesPreferences tp) {
        this.initComponents();
        this.resetComponents(tp);
        this.checkConsistancy();
    }

    private void initComponents() {
        this.cbUseExThrottle = new JCheckBox();
        this.cbUseToolBar = new JCheckBox();
        this.cbUseFunctionIcon = new JCheckBox();
        this.cbUseLargeSpeedSlider = new JCheckBox();
        this.cbUseRosterImage = new JCheckBox();
        this.cbResizeWinImg = new JCheckBox();
        this.cbEnableRosterSearch = new JCheckBox();
        this.cbEnableAutoLoad = new JCheckBox();
        this.cbHideUndefinedButtons = new JCheckBox();
        this.cbIgnoreThrottlePosition = new JCheckBox();
        this.cbSaveThrottleOnLayoutSave = new JCheckBox();
        this.cbSilentSteal = new JCheckBox();
        this.cbSilentShare = new JCheckBox();
        this.tfDefaultThrottleLocation = new JTextField();
        this.cbUseExThrottle.setText(Bundle.getMessage("UseExThrottle"));
        this.cbResizeWinImg.setText(Bundle.getMessage("ExThrottleForceResize"));
        this.cbUseToolBar.setText(Bundle.getMessage("ExThrottleUseToolBar"));
        this.cbUseFunctionIcon.setText(Bundle.getMessage("ExThrottleUseFunctionIcons"));
        this.cbUseLargeSpeedSlider.setText(Bundle.getMessage("ExThrottleUseLargeSpeedSlider"));
        this.cbUseRosterImage.setText(Bundle.getMessage("ExThrottleUseRosterImageBkg"));
        this.cbEnableRosterSearch.setText(Bundle.getMessage("ExThrottleEnableRosterSearch"));
        this.cbEnableAutoLoad.setText(Bundle.getMessage("ExThrottleEnableAutoSave"));
        this.cbHideUndefinedButtons.setText(Bundle.getMessage("ExThrottleHideUndefinedFunctionButtons"));
        this.cbIgnoreThrottlePosition.setText(Bundle.getMessage("ExThrottleIgnoreThrottlePosition"));
        this.cbSaveThrottleOnLayoutSave.setText(Bundle.getMessage("ExThrottleSaveThrottleOnLayoutSave"));
        this.cbSilentSteal.setText(Bundle.getMessage("ExThrottleSilentSteal"));
        this.cbSilentShare.setText(Bundle.getMessage("ExThrottleSilentShare"));
        ActionListener dirtyAL = evt -> {
            this.isDirty = true;
        };
        this.cbUseExThrottle.addActionListener(dirtyAL);
        this.cbResizeWinImg.addActionListener(dirtyAL);
        this.cbUseToolBar.addActionListener(dirtyAL);
        this.cbUseFunctionIcon.addActionListener(dirtyAL);
        this.cbUseLargeSpeedSlider.addActionListener(dirtyAL);
        this.cbUseRosterImage.addActionListener(dirtyAL);
        this.cbEnableRosterSearch.addActionListener(dirtyAL);
        this.cbEnableAutoLoad.addActionListener(dirtyAL);
        this.cbHideUndefinedButtons.addActionListener(dirtyAL);
        this.cbIgnoreThrottlePosition.addActionListener(dirtyAL);
        this.cbSaveThrottleOnLayoutSave.addActionListener(dirtyAL);
        this.cbSilentSteal.addActionListener(dirtyAL);
        this.cbSilentShare.addActionListener(dirtyAL);
        ActionListener al = evt -> this.checkConsistancy();
        this.cbUseExThrottle.addActionListener(al);
        this.cbUseToolBar.addActionListener(al);
        this.cbUseRosterImage.addActionListener(al);
        this.cbEnableAutoLoad.addActionListener(al);
        ActionListener stealCheck = evt -> this.checkStealButtonOk();
        ActionListener shareCheck = evt -> this.checkShareButtonOk();
        this.cbSilentSteal.addActionListener(stealCheck);
        this.cbSilentShare.addActionListener(shareCheck);
        ActionListener tal = evt -> this.checkDefaultThrottleFile();
        this.tfDefaultThrottleLocation.addActionListener(tal);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.ipadx = 5;
        constraints.ipady = 5;
        Insets x0 = new Insets(2, 2, 2, 2);
        Insets x1 = new Insets(2, 18, 2, 2);
        Insets x2 = new Insets(2, 32, 2, 2);
        constraints.insets = x0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.add((Component)this.cbUseExThrottle, constraints);
        ++constraints.gridy;
        constraints.insets = x1;
        this.add((Component)this.cbSaveThrottleOnLayoutSave, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbUseRosterImage, constraints);
        ++constraints.gridy;
        constraints.insets = x2;
        this.add((Component)this.cbResizeWinImg, constraints);
        ++constraints.gridy;
        constraints.insets = x1;
        this.add((Component)this.cbEnableRosterSearch, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbEnableAutoLoad, constraints);
        ++constraints.gridy;
        constraints.insets = x2;
        this.add((Component)this.cbIgnoreThrottlePosition, constraints);
        ++constraints.gridy;
        constraints.insets = x1;
        this.add((Component)this.cbHideUndefinedButtons, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbUseToolBar, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbUseFunctionIcon, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbUseLargeSpeedSlider, constraints);
        ++constraints.gridy;
        constraints.insets = x0;
        this.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        this.add((Component)this.cbSilentSteal, constraints);
        ++constraints.gridy;
        this.add((Component)this.cbSilentShare, constraints);
        ++constraints.gridy;
        this.add((Component)new JSeparator(), constraints);
        ++constraints.gridy;
        this.add((Component)this.defaultThrottleLocationPanel(), constraints);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
            this.cbSilentSteal.setEnabled(InstanceManager.throttleManagerInstance().enablePrefSilentStealOption());
            this.cbSilentShare.setEnabled(InstanceManager.throttleManagerInstance().enablePrefSilentShareOption());
        }
    }

    public final void resetComponents(ThrottlesPreferences tp) {
        if (tp == null) {
            return;
        }
        this.cbSaveThrottleOnLayoutSave.setSelected(tp.isSavingThrottleOnLayoutSave());
        this.cbResizeWinImg.setSelected(tp.isResizingWindow());
        this.cbUseToolBar.setSelected(tp.isUsingToolBar());
        this.cbUseFunctionIcon.setSelected(tp.isUsingFunctionIcon());
        this.cbUseRosterImage.setSelected(tp.isUsingRosterImage());
        this.cbUseExThrottle.setSelected(tp.isUsingExThrottle());
        this.cbEnableRosterSearch.setSelected(tp.isEnablingRosterSearch());
        this.cbEnableAutoLoad.setSelected(tp.isAutoLoading());
        this.cbHideUndefinedButtons.setSelected(tp.isHidingUndefinedFuncButt());
        this.cbIgnoreThrottlePosition.setSelected(tp.isIgnoringThrottlePosition());
        this.cbUseLargeSpeedSlider.setSelected(tp.isUsingLargeSpeedSlider());
        this.cbSilentSteal.setSelected(tp.isSilentSteal());
        this.cbSilentShare.setSelected(tp.isSilentShare());
        this.tfDefaultThrottleLocation.setText(tp.getDefaultThrottleFilePath());
        this.checkConsistancy();
        this.isDirty = false;
    }

    public ThrottlesPreferences updateThrottlesPreferences(ThrottlesPreferences tp) {
        tp.setUseExThrottle(this.cbUseExThrottle.isSelected());
        tp.setUsingToolBar(this.cbUseToolBar.isSelected());
        tp.setUsingFunctionIcon(this.cbUseFunctionIcon.isSelected());
        tp.setResizeWindow(this.cbResizeWinImg.isSelected());
        tp.setUseRosterImage(this.cbUseRosterImage.isSelected());
        tp.setSaveThrottleOnLayoutSave(this.cbSaveThrottleOnLayoutSave.isSelected());
        tp.setSilentSteal(this.cbSilentSteal.isSelected());
        tp.setSilentShare(this.cbSilentShare.isSelected());
        tp.setEnableRosterSearch(this.cbEnableRosterSearch.isSelected());
        tp.setAutoLoad(this.cbEnableAutoLoad.isSelected());
        tp.setHideUndefinedFuncButt(this.cbHideUndefinedButtons.isSelected());
        tp.setIgnoreThrottlePosition(this.cbIgnoreThrottlePosition.isSelected());
        tp.setUseLargeSpeedSlider(this.cbUseLargeSpeedSlider.isSelected());
        tp.setDefaultThrottleFilePath(this.tfDefaultThrottleLocation.getText());
        return tp;
    }

    private void checkConsistancy() {
        this.cbSaveThrottleOnLayoutSave.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbUseToolBar.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbUseFunctionIcon.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbEnableRosterSearch.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbEnableAutoLoad.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbUseRosterImage.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbResizeWinImg.setEnabled(this.cbUseExThrottle.isSelected() && this.cbUseRosterImage.isSelected());
        this.cbHideUndefinedButtons.setEnabled(this.cbUseExThrottle.isSelected());
        this.cbIgnoreThrottlePosition.setEnabled(this.cbUseExThrottle.isSelected() && this.cbEnableAutoLoad.isSelected());
        this.cbUseLargeSpeedSlider.setEnabled(this.cbUseExThrottle.isSelected());
        if (this.cbUseExThrottle.isSelected() && this.cbUseToolBar.isSelected()) {
            this.cbIgnoreThrottlePosition.setSelected(true);
            this.cbIgnoreThrottlePosition.setEnabled(false);
        }
    }

    private void checkStealButtonOk() {
        if (this.cbSilentShare.isSelected()) {
            this.cbSilentShare.setSelected(false);
        }
    }

    private void checkShareButtonOk() {
        if (this.cbSilentSteal.isSelected()) {
            this.cbSilentSteal.setSelected(false);
        }
    }

    private void checkDefaultThrottleFile() {
        boolean isBad = false;
        try {
            LoadXmlThrottlesLayoutAction.ThrottlePrefs prefs = new LoadXmlThrottlesLayoutAction.ThrottlePrefs();
            Element root = prefs.rootFromFile(new File(this.tfDefaultThrottleLocation.getText()));
            if (root == null || root.getChildren("ThrottleFrame").size() != 1) {
                isBad = true;
            }
        }
        catch (IOException | JDOMException throwable) {
            isBad = true;
        }
        if (isBad) {
            this.tfDefaultThrottleLocation.setText(null);
            JOptionPane.showMessageDialog(this, Bundle.getMessage("DefaultThrottleFileNotValid"), Bundle.getMessage("DefaultThrottleFile"), 0);
        }
    }

    private JPanel defaultThrottleLocationPanel() {
        JFileChooser fileChooser = XmlFile.userFileChooser(Bundle.getMessage("PromptXmlFileTypes"), "xml");
        fileChooser.setDialogType(0);
        fileChooser.setCurrentDirectory(new File(ThrottleFrame.getDefaultThrottleFolder()));
        fileChooser.setDialogTitle(Bundle.getMessage("MessageSelectDefaultThrottleFile"));
        JButton bScript = new JButton(Bundle.getMessage("ButtonSetDots"));
        bScript.addActionListener(new OpenAction(fileChooser, this.tfDefaultThrottleLocation));
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel(Bundle.getMessage("DefaultThrottleFile")), "Before");
        p.add((Component)this.tfDefaultThrottleLocation, "Center");
        p.add((Component)bScript, "After");
        return p;
    }

    boolean isDirty() {
        return this.isDirty;
    }

    private class OpenAction
    extends AbstractAction {
        JFileChooser chooser;
        JTextField field;

        OpenAction(JFileChooser chooser, JTextField field) {
            this.chooser = chooser;
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int retVal = this.chooser.showOpenDialog(this.field);
            if (retVal != 0 || this.chooser.getSelectedFile() == null) {
                return;
            }
            this.field.setText(this.chooser.getSelectedFile().toString());
            ThrottlesPreferencesUISettingsPane.this.checkDefaultThrottleFile();
        }
    }
}

