/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jmri.InstanceManager;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.ThrottlesPreferencesControlsSettingsPane;
import jmri.jmrit.throttle.ThrottlesPreferencesUISettingsPane;
import jmri.swing.PreferencesPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlesPreferencesPane
extends JPanel
implements PropertyChangeListener,
PreferencesPanel {
    private ThrottlesPreferencesUISettingsPane uiSettingsPane;
    private ThrottlesPreferencesControlsSettingsPane ctrlSettingsPane;
    private static final Logger log = LoggerFactory.getLogger(ThrottlesPreferencesPane.class);

    public ThrottlesPreferencesPane() {
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            log.debug("Creating new ThrottlesPreference Instance");
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        this.initComponents();
    }

    private void initComponents() {
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        ThrottlesPreferences tp = InstanceManager.getDefault(ThrottlesPreferences.class);
        tp.addPropertyChangeListener(this);
        this.uiSettingsPane = new ThrottlesPreferencesUISettingsPane(tp);
        this.ctrlSettingsPane = new ThrottlesPreferencesControlsSettingsPane(tp);
        JScrollPane scrollPane1 = new JScrollPane(this.uiSettingsPane);
        JScrollPane scrollPane2 = new JScrollPane(this.ctrlSettingsPane);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Bundle.getMessage("UISettingsPane"), scrollPane1);
        tabbedPane.addTab(Bundle.getMessage("ControlsSettingsPane"), scrollPane2);
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().compareTo("ThrottlePreferences") == 0) {
            if (evt.getNewValue() == null || !(evt.getNewValue() instanceof ThrottlesPreferences)) {
                return;
            }
            this.uiSettingsPane.resetComponents((ThrottlesPreferences)evt.getNewValue());
            this.ctrlSettingsPane.resetComponents((ThrottlesPreferences)evt.getNewValue());
        }
    }

    public void resetComponents() {
        ThrottlesPreferences tp = InstanceManager.getDefault(ThrottlesPreferences.class);
        this.uiSettingsPane.resetComponents(tp);
        this.ctrlSettingsPane.resetComponents(tp);
    }

    @Override
    public String getPreferencesItem() {
        return "THROTTLE";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuThrottle");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return null;
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        this.applyPreferences();
        InstanceManager.getDefault(ThrottlesPreferences.class).save();
    }

    void applyPreferences() {
        ThrottlesPreferences tp = InstanceManager.getDefault(ThrottlesPreferences.class);
        this.uiSettingsPane.updateThrottlesPreferences(tp);
        this.ctrlSettingsPane.updateThrottlesPreferences(tp);
        InstanceManager.getDefault(ThrottlesPreferences.class).set(tp);
        InstanceManager.getDefault(ThrottleFrameManager.class).applyPreferences();
    }

    @Override
    public boolean isDirty() {
        return this.uiSettingsPane.isDirty() && this.ctrlSettingsPane.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return false;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

