/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import jmri.jmrit.XmlFile;
import jmri.jmrit.throttle.ThrottlesPreferencesWindowKeyboardControls;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottlesPreferences {
    private boolean _useExThrottle = true;
    private boolean _useToolBar = true;
    private boolean _useFunctionIcon = false;
    private boolean _useLargeSpeedSlider = false;
    private boolean _resizeWinImg = false;
    private boolean _useRosterImage = true;
    private boolean _enableRosterSearch = true;
    private boolean _enableAutoLoad = true;
    private boolean _hideUndefinedFunButton = false;
    private boolean _ignoreThrottlePosition = true;
    private boolean _saveThrottleOnLayoutSave = true;
    private boolean _isSilentSteal = false;
    private boolean _isSilentShare = false;
    private String _defaultThrottleFilePath = null;
    private ThrottlesPreferencesWindowKeyboardControls _tpwkc = new ThrottlesPreferencesWindowKeyboardControls();
    protected boolean dirty = false;
    private Dimension _winDim = new Dimension(800, 600);
    private String prefFile;
    private ArrayList<PropertyChangeListener> listeners;
    private static final Logger log = LoggerFactory.getLogger(ThrottlesPreferences.class);

    public ThrottlesPreferences() {
        Element root;
        String dirname = String.valueOf(FileUtil.getUserFilesPath()) + "throttle" + File.separator;
        FileUtil.createDirectory(dirname);
        this.prefFile = String.valueOf(dirname) + "ThrottlesPreferences.xml";
        ThrottlesPrefsXml prefs = new ThrottlesPrefsXml();
        File file = new File(this.prefFile);
        try {
            root = prefs.rootFromFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.info("Did not find throttle preferences file.  This is normal if you haven't save the preferences before");
            root = null;
        }
        catch (Exception e) {
            log.error("Exception while loading throttles preferences: {}", (Throwable)e);
            root = null;
        }
        if (root != null) {
            this.load(root.getChild("throttlesPreferences"));
        }
    }

    public void load(Element e) {
        Attribute b;
        if (e == null) {
            return;
        }
        Attribute a = e.getAttribute("isUsingExThrottle");
        if (a != null) {
            this.setUseExThrottle(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isUsingToolBar")) != null) {
            this.setUsingToolBar(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isResizingWindow")) != null) {
            this.setResizeWindow(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isUsingFunctionIcon")) != null) {
            this.setUsingFunctionIcon(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("windowDimensionWidth")) != null && (b = e.getAttribute("windowDimensionHeight")) != null) {
            this.setWindowDimension(new Dimension(Integer.parseInt(a.getValue()), Integer.parseInt(b.getValue())));
        }
        if ((a = e.getAttribute("isSavingThrottleOnLayoutSave")) != null) {
            this.setSaveThrottleOnLayoutSave(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isUsingRosterImage")) != null) {
            this.setUseRosterImage(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isEnablingRosterSearch")) != null) {
            this.setEnableRosterSearch(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isAutoLoading")) != null) {
            this.setAutoLoad(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isHidingUndefinedFunctionButtons")) != null) {
            this.setHideUndefinedFuncButt(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isIgnoringThrottlePosition")) != null) {
            this.setIgnoreThrottlePosition(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isSilentSteal")) != null) {
            this.setSilentSteal(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isSilentShare")) != null) {
            this.setSilentShare(a.getValue().compareTo("true") == 0);
        }
        if ((a = e.getAttribute("isUsingLargeSpeedSlider")) != null) {
            this.setUseLargeSpeedSlider(a.getValue().compareTo("true") == 0);
        }
        if (e.getChild("throttlesControls") != null) {
            this._tpwkc.load(e.getChild("throttlesControls"));
        }
        if ((a = e.getAttribute("defaultThrottleFilePath")) != null) {
            this.setDefaultThrottleFilePath(a.getValue());
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public Element store() {
        Element e = new Element("throttlesPreferences");
        e.setAttribute("isUsingExThrottle", "" + this.isUsingExThrottle());
        e.setAttribute("isUsingToolBar", "" + this.isUsingToolBar());
        e.setAttribute("isUsingFunctionIcon", "" + this.isUsingFunctionIcon());
        e.setAttribute("isResizingWindow", "" + this.isResizingWindow());
        e.setAttribute("windowDimensionWidth", "" + (int)this.getWindowDimension().getWidth());
        e.setAttribute("windowDimensionHeight", "" + (int)this.getWindowDimension().getHeight());
        e.setAttribute("isSavingThrottleOnLayoutSave", "" + this.isSavingThrottleOnLayoutSave());
        e.setAttribute("isUsingRosterImage", "" + this.isUsingRosterImage());
        e.setAttribute("isEnablingRosterSearch", "" + this.isEnablingRosterSearch());
        e.setAttribute("isAutoLoading", "" + this.isAutoLoading());
        e.setAttribute("isHidingUndefinedFunctionButtons", "" + this.isHidingUndefinedFuncButt());
        e.setAttribute("isIgnoringThrottlePosition", "" + this.isIgnoringThrottlePosition());
        e.setAttribute("isSilentSteal", "" + this.isSilentSteal());
        e.setAttribute("isSilentShare", "" + this.isSilentShare());
        e.setAttribute("isUsingLargeSpeedSlider", "" + this.isUsingLargeSpeedSlider());
        e.setAttribute("defaultThrottleFilePath", this.getDefaultThrottleFilePath());
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(this._tpwkc.store());
        e.setContent(children);
        return e;
    }

    public void set(ThrottlesPreferences tp) {
        this.setWindowDimension(tp.getWindowDimension());
        this.setUseExThrottle(tp.isUsingExThrottle());
        this.setUsingToolBar(tp.isUsingToolBar());
        this.setUsingFunctionIcon(tp.isUsingFunctionIcon());
        this.setResizeWindow(tp.isResizingWindow());
        this.setSaveThrottleOnLayoutSave(tp.isSavingThrottleOnLayoutSave());
        this.setUseRosterImage(tp.isUsingRosterImage());
        this.setEnableRosterSearch(tp.isEnablingRosterSearch());
        this.setAutoLoad(tp.isAutoLoading());
        this.setHideUndefinedFuncButt(tp.isHidingUndefinedFuncButt());
        this.setIgnoreThrottlePosition(tp.isIgnoringThrottlePosition());
        this.setSilentSteal(tp.isSilentSteal());
        this.setSilentShare(tp.isSilentShare());
        this.setUseLargeSpeedSlider(tp.isUsingLargeSpeedSlider());
        this.setThrottlesKeyboardControls(tp.getThrottlesKeyboardControls());
        this.setDefaultThrottleFilePath(tp.getDefaultThrottleFilePath());
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                PropertyChangeListener l = this.listeners.get(i);
                PropertyChangeEvent e = new PropertyChangeEvent(this, "ThrottlePreferences", null, this);
                l.propertyChange(e);
                ++i;
            }
        }
    }

    public void save() {
        if (this.prefFile == null) {
            return;
        }
        XmlFile xf = new XmlFile(){};
        xf.makeBackupFile(this.prefFile);
        File file = new File(this.prefFile);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.error("failed to make parent directory");
            }
            if (!file.createNewFile()) {
                log.error("createNewFile failed");
            }
        }
        catch (Exception exp) {
            log.error("Exception while writing the new throttles preferences file, may not be complete: {}", (Throwable)exp);
        }
        try {
            Element root = new Element("throttles-preferences");
            Document doc = XmlFile.newDocument(root, String.valueOf(XmlFile.getDefaultDtdLocation()) + "throttles-preferences.dtd");
            root.setContent((Content)this.store());
            xf.writeXML(file, doc);
        }
        catch (IOException ex) {
            log.warn("Exception in storing throttles preferences xml: {}", (Throwable)ex);
        }
        this.dirty = false;
    }

    public Dimension getWindowDimension() {
        return this._winDim;
    }

    public void setWindowDimension(Dimension d) {
        this._winDim = d;
        this.dirty = true;
    }

    public boolean isUsingExThrottle() {
        return this._useExThrottle;
    }

    public void setUseExThrottle(boolean exThrottle) {
        this._useExThrottle = exThrottle;
        this.dirty = true;
    }

    public boolean isUsingToolBar() {
        return this._useToolBar;
    }

    public void setUsingToolBar(boolean win4all) {
        this._useToolBar = win4all;
        this.dirty = true;
    }

    public boolean isUsingFunctionIcon() {
        return this._useFunctionIcon;
    }

    public void setUsingFunctionIcon(boolean useFunctionIcon) {
        this._useFunctionIcon = useFunctionIcon;
        this.dirty = true;
    }

    public boolean isResizingWindow() {
        return this._resizeWinImg;
    }

    public void setResizeWindow(boolean winImg) {
        this._resizeWinImg = winImg;
        this.dirty = true;
    }

    public boolean isUsingRosterImage() {
        return this._useRosterImage;
    }

    public void setUseRosterImage(boolean rosterImage) {
        this._useRosterImage = rosterImage;
        this.dirty = true;
    }

    public boolean isEnablingRosterSearch() {
        return this._enableRosterSearch;
    }

    public void setEnableRosterSearch(boolean b) {
        this._enableRosterSearch = b;
        this.dirty = true;
    }

    public void setAutoLoad(boolean b) {
        this._enableAutoLoad = b;
        this.dirty = true;
    }

    public boolean isAutoLoading() {
        return this._enableAutoLoad;
    }

    public void setHideUndefinedFuncButt(boolean b) {
        this._hideUndefinedFunButton = b;
        this.dirty = true;
    }

    public boolean isHidingUndefinedFuncButt() {
        return this._hideUndefinedFunButton;
    }

    public void setIgnoreThrottlePosition(boolean b) {
        this._ignoreThrottlePosition = b;
        this.dirty = true;
    }

    public boolean isIgnoringThrottlePosition() {
        return this._ignoreThrottlePosition;
    }

    public void setSaveThrottleOnLayoutSave(boolean b) {
        this._saveThrottleOnLayoutSave = b;
        this.dirty = true;
    }

    public boolean isSavingThrottleOnLayoutSave() {
        return this._saveThrottleOnLayoutSave;
    }

    public boolean isSilentSteal() {
        return this._isSilentSteal;
    }

    public boolean isSilentShare() {
        return this._isSilentShare;
    }

    public void setSilentSteal(boolean b) {
        this._isSilentSteal = b;
        this.dirty = true;
    }

    public void setSilentShare(boolean b) {
        this._isSilentShare = b;
        this.dirty = true;
    }

    public void setUseLargeSpeedSlider(boolean b) {
        this._useLargeSpeedSlider = b;
        this.dirty = true;
    }

    public boolean isUsingLargeSpeedSlider() {
        return this._useLargeSpeedSlider;
    }

    public void setDefaultThrottleFilePath(String p) {
        this._defaultThrottleFilePath = p;
        this.dirty = true;
    }

    public String getDefaultThrottleFilePath() {
        return this._defaultThrottleFilePath;
    }

    public ThrottlesPreferencesWindowKeyboardControls getThrottlesKeyboardControls() {
        return this._tpwkc;
    }

    public void setThrottlesKeyboardControls(ThrottlesPreferencesWindowKeyboardControls tpwkc) {
        this._tpwkc = tpwkc;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    static class ThrottlesPrefsXml
    extends XmlFile {
        ThrottlesPrefsXml() {
        }
    }
}

