/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import jmri.InstanceManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrit.throttle.StopAllButton;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottlesPreferencesAction;
import jmri.jmrit.throttle.ThrottlesTableCellRenderer;
import jmri.jmrit.throttle.ThrottlesTableModel;
import jmri.jmrit.throttle.WindowPreferences;
import org.jdom2.Element;

public class ThrottlesListPanel
extends JPanel {
    private final ThrottlesTableModel throttleFramesLM = new ThrottlesTableModel();
    private JTable throttleFrames;

    public ThrottlesListPanel() {
        this.initGUI();
    }

    public ThrottlesTableModel getTableModel() {
        return this.throttleFramesLM;
    }

    private void initGUI() {
        this.throttleFrames = new JTable(this.throttleFramesLM);
        this.throttleFrames.setSelectionMode(0);
        this.throttleFrames.setRowHeight(42);
        this.throttleFrames.setTableHeader(null);
        this.throttleFrames.setDefaultRenderer(Object.class, new ThrottlesTableCellRenderer());
        this.throttleFrames.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ThrottlesListPanel.this.throttleFrames.rowAtPoint(e.getPoint());
                ThrottlesListPanel.this.throttleFrames.getSelectionModel().setSelectionInterval(row, row);
                ((ThrottleFrame)ThrottlesListPanel.this.throttleFramesLM.getValueAt(row, 0)).toFront();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        JScrollPane scrollPane1 = new JScrollPane(this.throttleFrames);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(320, 200));
        JToolBar throttleToolBar = new JToolBar("Throttles list toolbar");
        JButton jbNew = new JButton();
        jbNew.setIcon(new NamedIcon("resources/icons/throttles/new.png", "resources/icons/throttles/new.png"));
        jbNew.setToolTipText(Bundle.getMessage("ThrottleToolBarNewWindowToolTip"));
        jbNew.setVerticalTextPosition(3);
        jbNew.setHorizontalTextPosition(0);
        jbNew.addActionListener(e -> {
            ThrottleFrame tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
            tf.toFront();
        });
        throttleToolBar.add(jbNew);
        throttleToolBar.addSeparator();
        throttleToolBar.add(new StopAllButton());
        throttleToolBar.add(new LargePowerManagerButton(false));
        this.add((Component)throttleToolBar, "First");
        this.add((Component)scrollPane1, "Center");
        throttleToolBar.addSeparator();
        JButton jbPreferences = new JButton();
        jbPreferences.setIcon(new NamedIcon("resources/icons/throttles/preferences.png", "resources/icons/throttles/Preferences24.png"));
        jbPreferences.setToolTipText(Bundle.getMessage("ThrottleToolBarPreferencesToolTip"));
        jbPreferences.setVerticalTextPosition(3);
        jbPreferences.setHorizontalTextPosition(0);
        jbPreferences.addActionListener(new ThrottlesPreferencesAction());
        throttleToolBar.add(jbPreferences);
    }

    public Element getXml() {
        Element me = new Element("ThrottlesListPanel");
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this.getTopLevelAncestor()));
        me.setContent(children);
        return me;
    }

    public void setXml(Element tlp) {
        Element window = tlp.getChild("window");
        if (window != null) {
            WindowPreferences.setPreferences(this.getTopLevelAncestor(), window);
        }
    }

    void applyPreferences() {
        this.repaint();
    }
}

