/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JynstrumentFactory;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.LargePowerManagerButton;
import jmri.jmrit.throttle.LoadDefaultXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.LoadXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.SmallPowerManagerButton;
import jmri.jmrit.throttle.StopAllButton;
import jmri.jmrit.throttle.StoreDefaultXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.StoreXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.ThrottleCreationAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottleFramePropertyEditor;
import jmri.jmrit.throttle.ThrottleWindowActionsFactory;
import jmri.jmrit.throttle.ThrottleWindowInputsListener;
import jmri.jmrit.throttle.ThrottlesListAction;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.ThrottlesPreferencesAction;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.jmrit.withrottle.WiThrottleCreationAction;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.iharder.dnd.URIDrop;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleWindow
extends JmriJFrame {
    private JPanel throttlesPanel;
    private ThrottleFrame currentThrottleFrame;
    private CardLayout throttlesLayout;
    private JCheckBoxMenuItem viewControlPanel;
    private JCheckBoxMenuItem viewFunctionPanel;
    private JCheckBoxMenuItem viewAddressPanel;
    private JCheckBoxMenuItem viewSpeedPanel;
    private JMenuItem viewAllButtons;
    private JMenuItem fileMenuSave;
    private JMenuItem editMenuExportRoster;
    private JButton jbPrevious = null;
    private JButton jbNext = null;
    private JButton jbPreviousRunning = null;
    private JButton jbNextRunning = null;
    private JButton jbThrottleList = null;
    private JButton jbNew = null;
    private JButton jbClose = null;
    private JButton jbMode = null;
    private JToolBar throttleToolBar;
    private String titleText = "";
    private String titleTextType = "rosterID";
    private boolean isEditMode = true;
    private final PowerManager powerMgr;
    private SmallPowerManagerButton smallPowerMgmtButton;
    private final ThrottleWindowInputsListener myInputsListener;
    private final ThrottleWindowActionsFactory myActionFactory;
    private HashMap<String, ThrottleFrame> throttleFrames = new HashMap(5);
    private int cardCounterID = 0;
    private int cardCounterNB = 1;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(ThrottleWindow.class);

    public ThrottleWindow() {
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            log.debug("Creating new ThrottlesPreference Instance");
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        this.myInputsListener = new ThrottleWindowInputsListener(this);
        this.myActionFactory = new ThrottleWindowActionsFactory(this);
        this.powerMgr = InstanceManager.getNullableDefault(PowerManager.class);
        if (this.powerMgr == null) {
            log.info("No power manager instance found, panel not active");
        }
        this.initGUI();
        this.applyPreferences();
    }

    private void initGUI() {
        this.setTitle(Bundle.getMessage("ThrottleTitle"));
        this.setLayout(new BorderLayout());
        this.throttlesLayout = new CardLayout();
        this.throttlesPanel = new JPanel(this.throttlesLayout);
        this.throttlesPanel.setDoubleBuffered(true);
        this.initializeToolbar();
        this.initializeMenu();
        this.setCurrentThrottleFrame(new ThrottleFrame(this));
        this.getCurrentThrottleFrame().setTitle("default");
        this.throttlesPanel.add((Component)this.getCurrentThrottleFrame(), "default");
        this.throttleFrames.put("default", this.getCurrentThrottleFrame());
        this.add((Component)this.throttlesPanel, "Center");
        this.installInputsListenerOnAllComponents(this);
        this.getRootPane().setFocusable(true);
        ActionMap am = this.myActionFactory.buildActionMap();
        Object[] objectArray = am.allKeys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            this.getRootPane().getActionMap().put(k, am.get(k));
            ++n2;
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Component[] cmps;
                ThrottleWindow me = (ThrottleWindow)e.getSource();
                InstanceManager.getDefault(ThrottleFrameManager.class).requestThrottleWindowDestruction(me);
                if (ThrottleWindow.this.throttleToolBar != null && (cmps = ThrottleWindow.this.throttleToolBar.getComponents()) != null) {
                    Component[] componentArray = cmps;
                    int n = cmps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component cmp = componentArray[n2];
                        if (cmp instanceof Jynstrument) {
                            ((Jynstrument)cmp).exit();
                        }
                        ++n2;
                    }
                }
            }
        });
        this.updateGUI();
    }

    public void updateGUI() {
        this.getCurrentThrottleFrame().setFrameTitle();
        this.viewAddressPanel.setEnabled(this.isEditMode);
        this.viewControlPanel.setEnabled(this.isEditMode);
        this.viewFunctionPanel.setEnabled(this.isEditMode);
        this.viewSpeedPanel.setEnabled(this.isEditMode);
        if (this.isEditMode) {
            this.viewAddressPanel.setSelected(this.getCurrentThrottleFrame().getAddressPanel().isVisible());
            this.viewControlPanel.setSelected(this.getCurrentThrottleFrame().getControlPanel().isVisible());
            this.viewFunctionPanel.setSelected(this.getCurrentThrottleFrame().getFunctionPanel().isVisible());
            this.viewSpeedPanel.setSelected(this.getCurrentThrottleFrame().getSpeedPanel().isVisible());
        }
        this.fileMenuSave.setEnabled(this.getCurrentThrottleFrame().getLastUsedSaveFile() != null || this.getCurrentThrottleFrame().getRosterEntry() != null);
        this.editMenuExportRoster.setEnabled(this.getCurrentThrottleFrame().getRosterEntry() != null);
        if (this.jbPrevious != null) {
            if (this.cardCounterNB > 1) {
                this.jbPrevious.setEnabled(true);
                this.jbNext.setEnabled(true);
                this.jbClose.setEnabled(true);
                this.jbPreviousRunning.setEnabled(true);
                this.jbNextRunning.setEnabled(true);
            } else {
                this.jbPrevious.setEnabled(false);
                this.jbNext.setEnabled(false);
                this.jbClose.setEnabled(false);
                this.jbPreviousRunning.setEnabled(false);
                this.jbNextRunning.setEnabled(false);
            }
        }
        this.getRootPane().requestFocusInWindow();
    }

    private void initializeToolbar() {
        this.throttleToolBar = new JToolBar("Throttles toolbar");
        this.jbNew = new JButton();
        this.jbNew.setIcon(new NamedIcon("resources/icons/throttles/add.png", "resources/icons/throttles/add.png"));
        this.jbNew.setToolTipText(Bundle.getMessage("ThrottleToolBarNewToolTip"));
        this.jbNew.setVerticalTextPosition(3);
        this.jbNew.setHorizontalTextPosition(0);
        this.jbNew.addActionListener(e -> {
            ThrottleFrame throttleFrame = this.addThrottleFrame();
        });
        this.throttleToolBar.add(this.jbNew);
        this.jbClose = new JButton();
        this.jbClose.setIcon(new NamedIcon("resources/icons/throttles/remove.png", "resources/icons/throttles/remove.png"));
        this.jbClose.setToolTipText(Bundle.getMessage("ThrottleToolBarCloseToolTip"));
        this.jbClose.setVerticalTextPosition(3);
        this.jbClose.setHorizontalTextPosition(0);
        this.jbClose.addActionListener(e -> this.removeThrottleFrame());
        this.throttleToolBar.add(this.jbClose);
        this.throttleToolBar.addSeparator();
        this.jbPreviousRunning = new JButton();
        this.jbPreviousRunning.setIcon(new NamedIcon("resources/icons/throttles/previous-jump.png", "resources/icons/throttles/previous-jump.png"));
        this.jbPreviousRunning.setVerticalTextPosition(3);
        this.jbPreviousRunning.setHorizontalTextPosition(0);
        this.jbPreviousRunning.setToolTipText(Bundle.getMessage("ThrottleToolBarPrevRunToolTip"));
        this.jbPreviousRunning.addActionListener(e -> this.previousRunningThrottleFrame());
        this.throttleToolBar.add(this.jbPreviousRunning);
        this.jbPrevious = new JButton();
        this.jbPrevious.setIcon(new NamedIcon("resources/icons/throttles/previous.png", "resources/icons/throttles/previous.png"));
        this.jbPrevious.setVerticalTextPosition(3);
        this.jbPrevious.setHorizontalTextPosition(0);
        this.jbPrevious.setToolTipText(Bundle.getMessage("ThrottleToolBarPrevToolTip"));
        this.jbPrevious.addActionListener(e -> this.previousThrottleFrame());
        this.throttleToolBar.add(this.jbPrevious);
        this.jbNext = new JButton();
        this.jbNext.setIcon(new NamedIcon("resources/icons/throttles/next.png", "resources/icons/throttles/next.png"));
        this.jbNext.setToolTipText(Bundle.getMessage("ThrottleToolBarNextToolTip"));
        this.jbNext.setVerticalTextPosition(3);
        this.jbNext.setHorizontalTextPosition(0);
        this.jbNext.addActionListener(e -> this.nextThrottleFrame());
        this.throttleToolBar.add(this.jbNext);
        this.jbNextRunning = new JButton();
        this.jbNextRunning.setIcon(new NamedIcon("resources/icons/throttles/next-jump.png", "resources/icons/throttles/next-jump.png"));
        this.jbNextRunning.setToolTipText(Bundle.getMessage("ThrottleToolBarNextRunToolTip"));
        this.jbNextRunning.setVerticalTextPosition(3);
        this.jbNextRunning.setHorizontalTextPosition(0);
        this.jbNextRunning.addActionListener(e -> this.nextRunningThrottleFrame());
        this.throttleToolBar.add(this.jbNextRunning);
        this.throttleToolBar.addSeparator();
        this.throttleToolBar.add(new StopAllButton());
        if (this.powerMgr != null) {
            this.throttleToolBar.add(new LargePowerManagerButton(false));
        }
        this.throttleToolBar.addSeparator();
        this.jbMode = new JButton();
        this.jbMode.setIcon(new NamedIcon("resources/icons/throttles/edit-view.png", "resources/icons/throttles/edit-view.png"));
        this.jbMode.setToolTipText(Bundle.getMessage("ThrottleToolBarEditToolTip"));
        this.jbMode.setVerticalTextPosition(3);
        this.jbMode.setHorizontalTextPosition(0);
        this.jbMode.addActionListener(e -> this.setEditMode(!this.isEditMode));
        this.throttleToolBar.add(this.jbMode);
        this.throttleToolBar.addSeparator();
        this.jbThrottleList = new JButton();
        this.jbThrottleList.setIcon(new NamedIcon("resources/icons/throttles/list.png", "resources/icons/throttles/list.png"));
        this.jbThrottleList.setToolTipText(Bundle.getMessage("ThrottleToolBarOpenThrottleListToolTip"));
        this.jbThrottleList.setVerticalTextPosition(3);
        this.jbThrottleList.setHorizontalTextPosition(0);
        this.jbThrottleList.addActionListener(new ThrottlesListAction());
        this.throttleToolBar.add(this.jbThrottleList);
        new URIDrop(this.throttleToolBar, uris -> {
            URI[] uRIArray = uris;
            int n = uris.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                this.ynstrument(new File(uri).getPath());
                ++n2;
            }
        });
        this.add((Component)this.throttleToolBar, "First");
    }

    public void setEditMode(boolean mode) {
        if (mode == this.isEditMode) {
            return;
        }
        this.isEditMode = mode;
        if (!this.throttleFrames.isEmpty()) {
            this.throttleFrames.values().forEach(throttleFrame -> throttleFrame.setEditMode(this.isEditMode));
        }
        this.updateGUI();
    }

    public boolean getEditMode() {
        return this.isEditMode;
    }

    @Deprecated
    public void switchMode() {
        this.setEditMode(!this.isEditMode);
    }

    public Jynstrument ynstrument(String path) {
        Jynstrument it = JynstrumentFactory.createInstrument(path, this);
        if (it == null) {
            log.error("Error while creating Jynstrument {}", (Object)path);
            return null;
        }
        ThrottleFrame.setTransparent(it, true);
        it.setVisible(true);
        this.throttleToolBar.add(it);
        this.throttleToolBar.repaint();
        return it;
    }

    private void initializeMenu() {
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        JMenuItem fileMenuLoad = new JMenuItem(Bundle.getMessage("ThrottleFileMenuLoadThrottle"));
        fileMenuLoad.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindow.this.getCurrentThrottleFrame().loadThrottle();
            }
        });
        this.fileMenuSave = new JMenuItem(Bundle.getMessage("ThrottleFileMenuSaveThrottle"));
        this.fileMenuSave.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindow.this.getCurrentThrottleFrame().saveThrottle();
            }
        });
        JMenuItem fileMenuSaveAs = new JMenuItem(Bundle.getMessage("ThrottleFileMenuSaveAsThrottle"));
        fileMenuSaveAs.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThrottleWindow.this.getCurrentThrottleFrame().saveThrottleAs();
            }
        });
        fileMenu.add(new ThrottleCreationAction(Bundle.getMessage("MenuItemNewThrottle")));
        fileMenu.add(fileMenuLoad);
        fileMenu.add(this.fileMenuSave);
        fileMenu.add(fileMenuSaveAs);
        fileMenu.addSeparator();
        fileMenu.add(new LoadXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemLoadThrottleLayout")));
        fileMenu.add(new StoreXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemSaveThrottleLayout")));
        fileMenu.addSeparator();
        fileMenu.add(new LoadDefaultXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemLoadDefaultThrottleLayout")));
        fileMenu.add(new StoreDefaultXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemSaveAsDefaultThrottleLayout")));
        fileMenu.addSeparator();
        fileMenu.add(new WiThrottleCreationAction(Bundle.getMessage("MenuItemStartWiThrottle")));
        JMenu viewMenu = new JMenu(Bundle.getMessage("ThrottleMenuView"));
        this.viewAddressPanel = new JCheckBoxMenuItem(Bundle.getMessage("ThrottleMenuViewAddressPanel"));
        this.viewAddressPanel.setSelected(true);
        this.viewAddressPanel.addItemListener(e -> this.getCurrentThrottleFrame().getAddressPanel().setVisible(e.getStateChange() == 1));
        this.viewControlPanel = new JCheckBoxMenuItem(Bundle.getMessage("ThrottleMenuViewControlPanel"));
        this.viewControlPanel.setSelected(true);
        this.viewControlPanel.addItemListener(e -> this.getCurrentThrottleFrame().getControlPanel().setVisible(e.getStateChange() == 1));
        this.viewFunctionPanel = new JCheckBoxMenuItem(Bundle.getMessage("ThrottleMenuViewFunctionPanel"));
        this.viewFunctionPanel.setSelected(true);
        this.viewFunctionPanel.addItemListener(e -> this.getCurrentThrottleFrame().getFunctionPanel().setVisible(e.getStateChange() == 1));
        this.viewSpeedPanel = new JCheckBoxMenuItem(Bundle.getMessage("ThrottleMenuViewSpeedPanel"));
        this.viewSpeedPanel.setSelected(false);
        this.viewSpeedPanel.addItemListener(e -> this.getCurrentThrottleFrame().getSpeedPanel().setVisible(e.getStateChange() == 1));
        this.viewAllButtons = new JMenuItem(Bundle.getMessage("ThrottleMenuViewAllFunctionButtons"));
        this.viewAllButtons.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ThrottleWindow.this.getCurrentThrottleFrame().getFunctionPanel().resetFnButtons();
                ThrottleWindow.this.getCurrentThrottleFrame().getFunctionPanel().setEnabled();
            }
        });
        JMenuItem makeAllComponentsInBounds = new JMenuItem(Bundle.getMessage("ThrottleMenuViewMakeAllComponentsInBounds"));
        makeAllComponentsInBounds.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ThrottleWindow.this.getCurrentThrottleFrame().makeAllComponentsInBounds();
            }
        });
        JMenuItem switchViewMode = new JMenuItem(Bundle.getMessage("ThrottleMenuViewSwitchMode"));
        switchViewMode.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ThrottleWindow.this.setEditMode(!ThrottleWindow.this.isEditMode);
            }
        });
        JMenuItem viewThrottlesList = new JMenuItem(Bundle.getMessage("ThrottleMenuViewViewThrottleList"));
        viewThrottlesList.addActionListener(new ThrottlesListAction());
        viewMenu.add(this.viewAddressPanel);
        viewMenu.add(this.viewControlPanel);
        viewMenu.add(this.viewFunctionPanel);
        viewMenu.add(this.viewSpeedPanel);
        viewMenu.addSeparator();
        viewMenu.add(this.viewAllButtons);
        viewMenu.add(makeAllComponentsInBounds);
        viewMenu.addSeparator();
        viewMenu.add(switchViewMode);
        viewMenu.add(viewThrottlesList);
        JMenu editMenu = new JMenu(Bundle.getMessage("MenuEdit"));
        JMenuItem preferencesItem = new JMenuItem(Bundle.getMessage("ThrottleMenuEditFrameProperties"));
        editMenu.add(preferencesItem);
        preferencesItem.addActionListener(e -> this.editPreferences());
        this.editMenuExportRoster = new JMenuItem(Bundle.getMessage("ThrottleMenuEditSaveCustoms"));
        editMenu.add(this.editMenuExportRoster);
        this.editMenuExportRoster.addActionListener(e -> this.getCurrentThrottleFrame().saveRosterChanges());
        editMenu.addSeparator();
        editMenu.add(new ThrottlesPreferencesAction(Bundle.getMessage("MenuItemThrottlesPreferences")));
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().add(fileMenu);
        this.getJMenuBar().add(editMenu);
        this.getJMenuBar().add(viewMenu);
        if (this.powerMgr != null) {
            JMenu powerMenu = new JMenu(Bundle.getMessage("ThrottleMenuPower"));
            JMenuItem powerOn = new JMenuItem(Bundle.getMessage("ThrottleMenuPowerOn"));
            powerMenu.add(powerOn);
            powerOn.addActionListener(e -> {
                try {
                    this.powerMgr.setPower(2);
                }
                catch (JmriException e1) {
                    log.error("Error when setting power: ", (Throwable)e1);
                }
            });
            JMenuItem powerOff = new JMenuItem(Bundle.getMessage("ThrottleMenuPowerOff"));
            powerMenu.add(powerOff);
            powerOff.addActionListener(e -> {
                try {
                    this.powerMgr.setPower(4);
                }
                catch (JmriException e1) {
                    log.error("Error when setting power: ", (Throwable)e1);
                }
            });
            this.getJMenuBar().add(powerMenu);
            this.smallPowerMgmtButton = new SmallPowerManagerButton();
            this.getJMenuBar().add(this.smallPowerMgmtButton);
        }
        this.addHelpMenu("package.jmri.jmrit.throttle.ThrottleFrame", true);
    }

    private void editPreferences() {
        ThrottleFramePropertyEditor editor = new ThrottleFramePropertyEditor(this);
        editor.setVisible(true);
    }

    @Override
    public void dispose() {
        if (this.throttleFrames != null && !this.throttleFrames.isEmpty()) {
            this.throttleFrames.values().forEach(throttleFrame -> throttleFrame.dispose());
        }
        this.throttleFrames = null;
        this.throttlesPanel.removeAll();
        this.removeAll();
        super.dispose();
    }

    public JCheckBoxMenuItem getViewControlPanel() {
        return this.viewControlPanel;
    }

    public JCheckBoxMenuItem getViewFunctionPanel() {
        return this.viewFunctionPanel;
    }

    public JCheckBoxMenuItem getViewAddressPanel() {
        return this.viewAddressPanel;
    }

    public JCheckBoxMenuItem getViewSpeedPanel() {
        return this.viewSpeedPanel;
    }

    public ThrottleFrame getCurrentThrottleFrame() {
        return this.currentThrottleFrame;
    }

    public void setCurrentThrottleFrame(ThrottleFrame tf) {
        if (this.getCurrentThrottleFrame() != null) {
            log.debug("setCurrentThrottleFrame from {} to {}", (Object)this.getCurrentThrottleFrame().getAddressPanel().getCurrentAddress(), (Object)tf.getAddressPanel().getCurrentAddress());
        }
        this.pcs.firePropertyChange("ThrottleFrame", this.getCurrentThrottleFrame(), tf);
        this.currentThrottleFrame = tf;
    }

    public void removeThrottleFrame(ThrottleFrame tf) {
        if (this.cardCounterNB > 1) {
            --this.cardCounterNB;
            if (this.getCurrentThrottleFrame() == tf) {
                log.debug("Closing last created");
            }
            this.throttlesPanel.remove(tf);
            this.throttleFrames.remove(tf.getTitle());
            tf.dispose();
            this.throttlesLayout.invalidateLayout(this.throttlesPanel);
        }
        this.updateGUI();
    }

    public void nextThrottleFrame() {
        this.throttlesLayout.next(this.throttlesPanel);
        this.updateGUI();
    }

    public void previousThrottleFrame() {
        this.throttlesLayout.previous(this.throttlesPanel);
        this.updateGUI();
    }

    public void previousRunningThrottleFrame() {
        if (!this.throttleFrames.isEmpty()) {
            ThrottleFrame cf = this.getCurrentThrottleFrame();
            ThrottleFrame nf = null;
            boolean passed = false;
            for (ThrottleFrame tf : this.throttleFrames.values()) {
                if (tf != cf) {
                    if (tf.getAddressPanel() == null || tf.getAddressPanel().getThrottle() == null || !(tf.getAddressPanel().getThrottle().getSpeedSetting() > 0.0f)) continue;
                    if (passed) {
                        nf = tf;
                        break;
                    }
                    if (nf != null) continue;
                    nf = tf;
                    continue;
                }
                passed = true;
            }
            if (nf != null) {
                nf.toFront();
            }
        }
    }

    public void nextRunningThrottleFrame() {
        if (!this.throttleFrames.isEmpty()) {
            ThrottleFrame cf = this.getCurrentThrottleFrame();
            ThrottleFrame nf = null;
            for (ThrottleFrame tf : this.throttleFrames.values()) {
                if (tf != cf && tf.getAddressPanel() != null && tf.getAddressPanel().getThrottle() != null && tf.getAddressPanel().getThrottle().getSpeedSetting() > 0.0f) {
                    nf = tf;
                }
                if (tf == cf && nf != null) break;
            }
            if (nf != null) {
                nf.toFront();
            }
        }
    }

    public void removeThrottleFrame() {
        this.removeThrottleFrame(this.getCurrentThrottleFrame());
    }

    public void addThrottleFrame(ThrottleFrame tp) {
        ++this.cardCounterID;
        ++this.cardCounterNB;
        String txt = "Card-" + this.cardCounterID;
        tp.setTitle(txt);
        this.throttleFrames.put(txt, tp);
        this.throttlesPanel.add((Component)tp, txt);
        this.throttlesLayout.show(this.throttlesPanel, txt);
        if (!this.isEditMode) {
            tp.setEditMode(this.isEditMode);
        }
        this.updateGUI();
    }

    public ThrottleFrame addThrottleFrame() {
        this.setCurrentThrottleFrame(new ThrottleFrame(this));
        this.installInputsListenerOnAllComponents(this.getCurrentThrottleFrame());
        this.addThrottleFrame(this.getCurrentThrottleFrame());
        return this.getCurrentThrottleFrame();
    }

    public void toFront(String throttleFrameTitle) {
        this.throttlesLayout.show(this.throttlesPanel, throttleFrameTitle);
        this.setVisible(true);
        this.requestFocus();
        this.toFront();
    }

    public String getTitleTextType() {
        return this.titleTextType;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public void setTitleTextType(String titleTextType) {
        this.titleTextType = titleTextType;
    }

    public Element getXml() {
        Component[] cmps;
        Element me = new Element("ThrottleWindow");
        me.setAttribute("title", this.titleText);
        me.setAttribute("titleType", this.titleTextType);
        me.setAttribute("isEditMode", String.valueOf(this.isEditMode));
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this));
        if (!this.throttleFrames.isEmpty()) {
            ThrottleFrame cf = this.getCurrentThrottleFrame();
            for (ThrottleFrame tf : this.throttleFrames.values()) {
                Element tfe;
                if (InstanceManager.getDefault(ThrottlesPreferences.class).isUsingExThrottle() && InstanceManager.getDefault(ThrottlesPreferences.class).isSavingThrottleOnLayoutSave()) {
                    tf.toFront();
                    tf.saveThrottle();
                }
                if ((tfe = tf.getXmlFile()) == null) {
                    tfe = tf.getXml();
                }
                children.add(tfe);
            }
            if (cf != null) {
                cf.toFront();
            }
        }
        if (this.throttleToolBar != null && (cmps = this.throttleToolBar.getComponents()) != null) {
            Component[] componentArray = cmps;
            int n = cmps.length;
            int n2 = 0;
            while (n2 < n) {
                Component cmp = componentArray[n2];
                try {
                    if (cmp instanceof Jynstrument) {
                        Jynstrument jyn = (Jynstrument)cmp;
                        Element elt = new Element("Jynstrument");
                        elt.setAttribute("JynstrumentFolder", FileUtil.getPortableFilename(jyn.getFolder()));
                        Element je = jyn.getXml();
                        if (je != null) {
                            ArrayList<Element> jychildren = new ArrayList<Element>(1);
                            jychildren.add(je);
                            elt.setContent(jychildren);
                        }
                        children.add(elt);
                    }
                }
                catch (Exception ex) {
                    log.debug("Got exception (no panic): ", (Throwable)ex);
                }
                ++n2;
            }
        }
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        List jinsts;
        List tfes;
        Element window;
        if (e.getAttribute("title") != null) {
            this.setTitle(e.getAttribute("title").getValue());
        }
        if (e.getAttribute("title") != null) {
            this.setTitleText(e.getAttribute("title").getValue());
        }
        if (e.getAttribute("titleType") != null) {
            this.setTitleTextType(e.getAttribute("titleType").getValue());
        }
        if (e.getAttribute("isEditMode") != null) {
            this.isEditMode = Boolean.parseBoolean(e.getAttribute("isEditMode").getValue());
        }
        if ((window = e.getChild("window")) != null) {
            WindowPreferences.setPreferences(this, window);
        }
        if ((tfes = e.getChildren("ThrottleFrame")) != null && tfes.size() > 0) {
            int i = 0;
            while (i < tfes.size()) {
                ThrottleFrame tf = i == 0 ? this.getCurrentThrottleFrame() : this.addThrottleFrame();
                tf.setXml((Element)tfes.get(i));
                tf.setEditMode(this.isEditMode);
                ++i;
            }
        }
        if ((jinsts = e.getChildren("Jynstrument")) != null && jinsts.size() > 0) {
            jinsts.forEach(jinst -> {
                Jynstrument jyn = this.ynstrument(FileUtil.getExternalFilename(jinst.getAttributeValue("JynstrumentFolder")));
                if (jyn != null) {
                    jyn.setXml((Element)jinst);
                }
            });
        }
        this.updateGUI();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private void installInputsListenerOnAllComponents(Container c) {
        if (!(c instanceof JTextField)) {
            c.addMouseWheelListener(this.myInputsListener);
            c.setFocusable(false);
        }
        Component[] componentArray = c.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof Container) {
                this.installInputsListenerOnAllComponents((Container)component);
            } else if (!(component instanceof JTextField)) {
                component.addMouseWheelListener(this.myInputsListener);
                component.setFocusable(false);
            }
            ++n2;
        }
    }

    public void applyPreferences() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        ComponentInputMap im = new ComponentInputMap(this.getRootPane());
        Object[] objectArray = this.getRootPane().getActionMap().allKeys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            KeyStroke[] kss = preferences.getThrottlesKeyboardControls().getKeyStrokes((String)k);
            if (kss != null) {
                KeyStroke[] keyStrokeArray = kss;
                int n3 = kss.length;
                int n4 = 0;
                while (n4 < n3) {
                    KeyStroke keystroke = keyStrokeArray[n4];
                    if (keystroke != null) {
                        im.put(keystroke, k);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        this.getRootPane().setInputMap(2, im);
        this.throttleToolBar.setVisible(preferences.isUsingExThrottle() && preferences.isUsingToolBar());
        if (this.smallPowerMgmtButton != null) {
            this.smallPowerMgmtButton.setVisible(!preferences.isUsingExThrottle() || !preferences.isUsingToolBar());
        }
        this.throttleFrames.values().forEach(tf -> tf.applyPreferences());
    }
}

