/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.configurexml.LoadXmlConfigAction;
import jmri.configurexml.StoreXmlConfigAction;
import jmri.jmrit.XmlFile;
import jmri.jmrit.jython.Jynstrument;
import jmri.jmrit.jython.JynstrumentFactory;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.BackgroundPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ControlPanel;
import jmri.jmrit.throttle.FunctionButton;
import jmri.jmrit.throttle.FunctionPanel;
import jmri.jmrit.throttle.SpeedPanel;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.jmrit.throttle.ThrottleWindow;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.util.FileUtil;
import jmri.util.iharder.dnd.URIDrop;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleFrame
extends JDesktopPane
implements ComponentListener,
AddressListener {
    private final Integer BACKPANEL_LAYER = Integer.MIN_VALUE;
    private final Integer PANEL_LAYER_FRAME = 1;
    private final Integer PANEL_LAYER_PANEL = 2;
    private static final int ADDRESS_PANEL_INDEX = 0;
    private static final int CONTROL_PANEL_INDEX = 1;
    private static final int FUNCTION_PANEL_INDEX = 2;
    private static final int SPEED_DISPLAY_INDEX = 3;
    private static final int NUM_FRAMES = 4;
    private JInternalFrame[] frameList;
    private int activeFrame;
    private final ThrottleWindow throttleWindow;
    private ControlPanel controlPanel;
    private FunctionPanel functionPanel;
    private AddressPanel addressPanel;
    private BackgroundPanel backgroundPanel;
    private FrameListener frameListener;
    private SpeedPanel speedPanel;
    private String title;
    private String lastUsedSaveFile = null;
    private boolean isEditMode = true;
    private boolean willSwitch = false;
    private static final String DEFAULT_THROTTLE_FILENAME = "JMRI_ThrottlePreference.xml";
    private HashMap<Container, JInternalFrame> contentPanes;
    private static final Logger log = LoggerFactory.getLogger(ThrottleFrame.class);

    public static String getDefaultThrottleFolder() {
        return String.valueOf(FileUtil.getUserFilesPath()) + "throttle" + File.separator;
    }

    public static String getDefaultThrottleFilename() {
        return String.valueOf(ThrottleFrame.getDefaultThrottleFolder()) + DEFAULT_THROTTLE_FILENAME;
    }

    public ThrottleFrame(ThrottleWindow tw) {
        this.throttleWindow = tw;
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            log.debug("Creating new ThrottlesPreference Instance");
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        this.initGUI();
        this.applyPreferences();
        InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().getTableModel().addThrottleFrame(this);
    }

    public ThrottleWindow getThrottleWindow() {
        return this.throttleWindow;
    }

    public ControlPanel getControlPanel() {
        return this.controlPanel;
    }

    public FunctionPanel getFunctionPanel() {
        return this.functionPanel;
    }

    public AddressPanel getAddressPanel() {
        return this.addressPanel;
    }

    public RosterEntry getRosterEntry() {
        return this.addressPanel.getRosterEntry();
    }

    public void toFront() {
        if (this.throttleWindow == null) {
            return;
        }
        this.throttleWindow.toFront(this.title);
    }

    public SpeedPanel getSpeedPanel() {
        return this.speedPanel;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.throttleWindow == null) {
            return;
        }
        this.throttleWindow.setLocation(new Point(x, y));
    }

    public void setTitle(String txt) {
        this.title = txt;
    }

    public String getTitle() {
        return this.title;
    }

    private void saveThrottle(String sfile) {
        XmlFile xf = new XmlFile(){};
        xf.makeBackupFile(sfile);
        File file = new File(sfile);
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists() && !parentDir.mkdir()) {
                log.error("could not make parent directory");
            }
            if (!file.createNewFile()) {
                log.error("createNewFile failed");
            }
        }
        catch (IOException exp) {
            log.error("Exception while writing the throttle file, may not be complete: {}", (Object)exp.getMessage());
        }
        try {
            Element root = new Element("throttle-config");
            Document doc = XmlFile.newDocument(root, String.valueOf(XmlFile.getDefaultDtdLocation()) + "throttle-config.dtd");
            Element throttleElement = this.getXml();
            if (this.getRosterEntry() != null && (String.valueOf(ThrottleFrame.getDefaultThrottleFolder()) + this.addressPanel.getRosterEntry().getId().trim() + ".xml").compareTo(sfile) == 0) {
                throttleElement.getChild("FunctionPanel").removeChildren("FunctionButton");
            }
            root.setContent((Content)throttleElement);
            xf.writeXML(file, doc);
            this.setLastUsedSaveFile(sfile);
        }
        catch (IOException ex) {
            log.warn("Exception while storing throttle xml: {}", (Object)ex.getMessage());
        }
    }

    private void loadDefaultThrottle() {
        String dtf = InstanceManager.getDefault(ThrottlesPreferences.class).getDefaultThrottleFilePath();
        if (dtf == null || dtf.isEmpty()) {
            return;
        }
        log.debug("Loading default throttle file : " + dtf);
        this.loadThrottle(dtf);
    }

    public void loadThrottle() {
        JFileChooser fileChooser = XmlFile.userFileChooser(Bundle.getMessage("PromptXmlFileTypes"), "xml");
        fileChooser.setCurrentDirectory(new File(ThrottleFrame.getDefaultThrottleFolder()));
        fileChooser.setDialogType(0);
        File file = LoadXmlConfigAction.getFile(fileChooser);
        if (file == null) {
            return;
        }
        this.loadThrottle(file.getAbsolutePath());
    }

    public void loadThrottle(String sfile) {
        if (sfile == null) {
            this.loadThrottle();
            return;
        }
        log.debug("Loading throttle file : " + sfile);
        boolean switchAfter = false;
        if (!this.isEditMode) {
            this.setEditMode(true);
            switchAfter = true;
        }
        try {
            Component[] cmps;
            XmlFile xf = new XmlFile(){};
            File f = new File(sfile);
            Element root = xf.rootFromFile(f);
            Element conf = root.getChild("ThrottleFrame");
            this.setLastUsedSaveFile(sfile);
            Component[] componentArray = cmps = this.getComponents();
            int n = cmps.length;
            int n2 = 0;
            while (n2 < n) {
                Component cmp = componentArray[n2];
                try {
                    if (cmp instanceof JInternalFrame) {
                        Component[] cmps2;
                        JInternalFrame jyf = (JInternalFrame)cmp;
                        Component[] componentArray2 = cmps2 = jyf.getContentPane().getComponents();
                        int n3 = cmps2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Component cmp2 = componentArray2[n4];
                            if (cmp2 instanceof Jynstrument) {
                                ((Jynstrument)cmp2).exit();
                                jyf.dispose();
                            }
                            ++n4;
                        }
                    }
                }
                catch (Exception ex) {
                    log.debug("Got exception (no panic) {}", (Object)ex.getMessage());
                }
                ++n2;
            }
            this.setXml(conf);
        }
        catch (IOException | NullPointerException | JDOMException ex) {
            log.debug("Loading throttle exception: {}", (Object)ex.getMessage());
            log.info("Couldn't load throttle file " + sfile + " , reverting to default one, if any");
            this.loadDefaultThrottle();
        }
        if (switchAfter) {
            this.setEditMode(false);
        }
    }

    private void initGUI() {
        this.frameListener = new FrameListener();
        this.controlPanel = new ControlPanel();
        this.controlPanel.setResizable(true);
        this.controlPanel.setClosable(true);
        this.controlPanel.setIconifiable(true);
        this.controlPanel.setTitle(Bundle.getMessage("ThrottleMenuViewControlPanel"));
        this.controlPanel.pack();
        this.controlPanel.setVisible(true);
        this.controlPanel.setEnabled(false);
        this.controlPanel.addInternalFrameListener(this.frameListener);
        this.functionPanel = new FunctionPanel();
        this.functionPanel.setResizable(true);
        this.functionPanel.setClosable(true);
        this.functionPanel.setIconifiable(true);
        this.functionPanel.setTitle(Bundle.getMessage("ThrottleMenuViewFunctionPanel"));
        int width = 3 * FunctionButton.getButtonWidth() + 30 + 10;
        int height = 8 * FunctionButton.getButtonHeight() + 60 + 20;
        this.functionPanel.setSize(width, height);
        this.functionPanel.setLocation(this.controlPanel.getWidth(), 0);
        this.functionPanel.setVisible(true);
        this.functionPanel.setEnabled(false);
        this.functionPanel.addInternalFrameListener(this.frameListener);
        this.speedPanel = new SpeedPanel();
        this.speedPanel.setResizable(true);
        this.speedPanel.setVisible(false);
        this.speedPanel.setClosable(true);
        this.speedPanel.setIconifiable(true);
        this.speedPanel.setTitle(Bundle.getMessage("ThrottleMenuViewSpeedPanel"));
        this.speedPanel.addInternalFrameListener(this.frameListener);
        this.speedPanel.pack();
        this.addressPanel = new AddressPanel();
        this.addressPanel.setResizable(true);
        this.addressPanel.setClosable(true);
        this.addressPanel.setIconifiable(true);
        this.addressPanel.setTitle(Bundle.getMessage("ThrottleMenuViewAddressPanel"));
        this.addressPanel.pack();
        if (this.addressPanel.getWidth() < this.functionPanel.getWidth()) {
            this.addressPanel.setSize(this.functionPanel.getWidth(), this.addressPanel.getHeight());
        }
        this.addressPanel.setLocation(this.controlPanel.getWidth(), this.functionPanel.getHeight());
        this.addressPanel.setVisible(true);
        this.addressPanel.addInternalFrameListener(this.frameListener);
        this.functionPanel.setAddressPanel(this.addressPanel);
        this.controlPanel.setAddressPanel(this.addressPanel);
        this.speedPanel.setAddressPanel(this.addressPanel);
        if (this.controlPanel.getHeight() < this.functionPanel.getHeight() + this.addressPanel.getHeight()) {
            this.controlPanel.setSize(this.controlPanel.getWidth(), this.functionPanel.getHeight() + this.addressPanel.getHeight());
        }
        if (this.controlPanel.getHeight() > this.functionPanel.getHeight() + this.addressPanel.getHeight()) {
            this.addressPanel.setSize(this.addressPanel.getWidth(), this.controlPanel.getHeight() - this.functionPanel.getHeight());
        }
        if (this.functionPanel.getWidth() < this.addressPanel.getWidth()) {
            this.functionPanel.setSize(this.addressPanel.getWidth(), this.functionPanel.getHeight());
        }
        this.speedPanel.setSize(this.addressPanel.getWidth() + this.controlPanel.getWidth(), this.addressPanel.getHeight() / 2);
        this.speedPanel.setLocation(0, this.controlPanel.getHeight());
        this.addressPanel.addAddressListener(this.controlPanel);
        this.addressPanel.addAddressListener(this.functionPanel);
        this.addressPanel.addAddressListener(this.speedPanel);
        this.addressPanel.addAddressListener(this);
        this.addressPanel.addAddressListener(InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().getTableModel());
        this.add((Component)this.controlPanel, this.PANEL_LAYER_FRAME);
        this.add((Component)this.functionPanel, this.PANEL_LAYER_FRAME);
        this.add((Component)this.addressPanel, this.PANEL_LAYER_FRAME);
        this.add((Component)this.speedPanel, this.PANEL_LAYER_FRAME);
        this.backgroundPanel = new BackgroundPanel();
        this.backgroundPanel.setAddressPanel(this.addressPanel);
        this.addComponentListener(this.backgroundPanel);
        this.addressPanel.addAddressListener(this.backgroundPanel);
        this.addressPanel.setBackgroundPanel(this.backgroundPanel);
        this.add((Component)this.backgroundPanel, this.BACKPANEL_LAYER);
        this.addComponentListener(this);
        this.frameList = new JInternalFrame[4];
        this.frameList[0] = this.addressPanel;
        this.frameList[1] = this.controlPanel;
        this.frameList[2] = this.functionPanel;
        this.frameList[3] = this.speedPanel;
        this.activeFrame = 0;
        this.setPreferredSize(new Dimension(Math.max(this.controlPanel.getWidth() + this.functionPanel.getWidth(), this.controlPanel.getWidth() + this.addressPanel.getWidth()), Math.max(this.addressPanel.getHeight() + this.functionPanel.getHeight(), this.controlPanel.getHeight())));
        new URIDrop(this, uris -> {
            if (this.isEditMode) {
                URI[] uRIArray = uris;
                int n = uris.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri = uRIArray[n2];
                    this.ynstrument(new File(uri).getPath());
                    ++n2;
                }
            }
        });
        try {
            this.addressPanel.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            log.error("Error selecting InternalFrame: {}", (Object)ex.getMessage());
        }
    }

    public JInternalFrame ynstrument(String path) {
        if (path == null) {
            return null;
        }
        Jynstrument it = JynstrumentFactory.createInstrument(path, this);
        if (it == null) {
            log.error("Error while creating Jynstrument {}", (Object)path);
            return null;
        }
        ThrottleFrame.setTransparentBackground(it);
        JInternalFrame newiFrame = new JInternalFrame(it.getClassName());
        newiFrame.add(it);
        newiFrame.addInternalFrameListener(this.frameListener);
        newiFrame.setDoubleBuffered(true);
        newiFrame.setResizable(true);
        newiFrame.setClosable(true);
        newiFrame.setIconifiable(true);
        newiFrame.getContentPane().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Container c = e.getContainer();
                while (!(c instanceof JInternalFrame) && !(c instanceof TranslucentJPanel)) {
                    c = c.getParent();
                }
                c.setVisible(false);
                ThrottleFrame.this.remove(c);
                ThrottleFrame.this.repaint();
            }
        });
        newiFrame.pack();
        this.add((Component)newiFrame, this.PANEL_LAYER_FRAME);
        newiFrame.setVisible(true);
        return newiFrame;
    }

    private void checkPosition(Component comp) {
        if (this.getWidth() < 1 || this.getHeight() < 1) {
            return;
        }
        Rectangle pos = comp.getBounds();
        if (pos.width > this.getWidth()) {
            pos.width = this.getWidth() - 2;
            pos.x = 1;
        }
        if (pos.x + pos.width > this.getWidth()) {
            pos.x = this.getWidth() - pos.width - 1;
        }
        if (pos.x < 0) {
            pos.x = 1;
        }
        if (pos.height > this.getHeight()) {
            pos.height = this.getHeight() - 2;
            pos.y = 1;
        }
        if (pos.y + pos.height > this.getHeight()) {
            pos.y = this.getHeight() - pos.height - 1;
        }
        if (pos.y < 0) {
            pos.y = 1;
        }
        comp.setBounds(pos);
    }

    public void makeAllComponentsInBounds() {
        Component[] cmps;
        Component[] componentArray = cmps = this.getComponents();
        int n = cmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            this.checkPosition(cmp);
            ++n2;
        }
    }

    public void applyPreferences() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        this.backgroundPanel.setVisible(preferences.isUsingExThrottle() && preferences.isUsingRosterImage());
        this.controlPanel.applyPreferences();
        this.functionPanel.applyPreferences();
        this.addressPanel.applyPreferences();
        this.backgroundPanel.applyPreferences();
    }

    private void playRendering() {
        Component[] cmps = this.getComponentsInLayer(this.PANEL_LAYER_FRAME);
        this.contentPanes = new HashMap();
        Component[] componentArray = cmps;
        int n = cmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            if (cmp instanceof JInternalFrame && cmp.isVisible()) {
                this.translude((JInternalFrame)cmp);
            }
            ++n2;
        }
    }

    private void translude(JInternalFrame jif) {
        Dimension cpSize = jif.getContentPane().getSize();
        Point cpLoc = jif.getContentPane().getLocationOnScreen();
        TranslucentJPanel pane = new TranslucentJPanel();
        pane.setLayout(new BorderLayout());
        this.contentPanes.put(pane, jif);
        pane.add((Component)jif.getContentPane(), "Center");
        ThrottleFrame.setTransparent(pane, true);
        jif.setContentPane(new JPanel());
        jif.setVisible(false);
        Point loc = new Point(cpLoc.x - this.getLocationOnScreen().x, cpLoc.y - this.getLocationOnScreen().y);
        this.add((Component)pane, this.PANEL_LAYER_PANEL);
        pane.setLocation(loc);
        pane.setSize(cpSize);
    }

    private void editRendering() {
        Component[] cmps;
        Component[] componentArray = cmps = this.getComponentsInLayer(this.PANEL_LAYER_PANEL);
        int n = cmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            if (cmp instanceof JPanel) {
                JPanel pane = (JPanel)cmp;
                JInternalFrame jif = this.contentPanes.get(pane);
                jif.setContentPane((Container)pane.getComponent(0));
                ThrottleFrame.setTransparent(jif, false);
                jif.setVisible(true);
                this.remove(pane);
            }
            ++n2;
        }
    }

    public void setEditMode(boolean mode) {
        if (mode == this.isEditMode) {
            return;
        }
        if (this.isVisible()) {
            if (!mode) {
                this.playRendering();
            } else {
                this.editRendering();
            }
            this.isEditMode = mode;
            this.willSwitch = false;
        } else {
            this.willSwitch = true;
        }
        this.throttleWindow.updateGUI();
    }

    public boolean getEditMode() {
        return this.isEditMode;
    }

    @Deprecated
    public void switchMode() {
        this.setEditMode(!this.isEditMode);
    }

    public void dispose() {
        log.debug("Disposing {}", (Object)this.getTitle());
        this.addressPanel.removeAddressListener(this);
        InstanceManager.getDefault(ThrottleFrameManager.class).getThrottlesListPanel().getTableModel().removeThrottleFrame(this, this.addressPanel.getCurrentAddress());
        this.controlPanel.destroy();
        this.functionPanel.destroy();
        this.speedPanel.destroy();
        this.addressPanel.destroy();
    }

    public void saveRosterChanges() {
        RosterEntry rosterEntry = this.addressPanel.getRosterEntry();
        if (rosterEntry == null) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ThrottleFrameNoRosterItemMessageDialog"), Bundle.getMessage("ThrottleFrameNoRosterItemTitleDialog"), 0);
            return;
        }
        if (JOptionPane.showConfirmDialog(this, Bundle.getMessage("ThrottleFrameRosterChangeMesageDialog"), Bundle.getMessage("ThrottleFrameRosterChangeTitleDialog"), 0) != 0) {
            return;
        }
        this.functionPanel.saveFunctionButtonsToRoster(rosterEntry);
        this.controlPanel.saveToRoster(rosterEntry);
    }

    public Element getXml() {
        Component[] cmps;
        boolean switchAfter = false;
        if (!this.isEditMode) {
            this.setEditMode(true);
            switchAfter = true;
        }
        Element me = new Element("ThrottleFrame");
        if (((BasicInternalFrameUI)this.getControlPanel().getUI()).getNorthPane() != null) {
            Dimension bDim = ((BasicInternalFrameUI)this.getControlPanel().getUI()).getNorthPane().getPreferredSize();
            me.setAttribute("border", Integer.toString(bDim.height));
        }
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(this.controlPanel.getXml());
        children.add(this.functionPanel.getXml());
        children.add(this.addressPanel.getXml());
        children.add(this.speedPanel.getXml());
        Component[] componentArray = cmps = this.getComponents();
        int n = cmps.length;
        int n2 = 0;
        while (n2 < n) {
            Component cmp = componentArray[n2];
            try {
                if (cmp instanceof JInternalFrame) {
                    Component[] cmps2 = ((JInternalFrame)cmp).getContentPane().getComponents();
                    int j = 0;
                    while (j < cmps2.length && !(cmps2[j] instanceof Jynstrument)) {
                        ++j;
                    }
                    if (j < cmps2.length && cmps2[j] instanceof Jynstrument) {
                        Jynstrument jyn = (Jynstrument)cmps2[j];
                        Element elt = new Element("Jynstrument");
                        elt.setAttribute("JynstrumentFolder", FileUtil.getPortableFilename(jyn.getFolder()));
                        ArrayList<Element> jychildren = new ArrayList<Element>(1);
                        jychildren.add(WindowPreferences.getPreferences((JInternalFrame)cmp));
                        Element je = jyn.getXml();
                        if (je != null) {
                            jychildren.add(je);
                        }
                        elt.setContent(jychildren);
                        children.add(elt);
                    }
                }
            }
            catch (Exception ex) {
                log.debug("Got exception (no panic) {}", (Object)ex.getMessage());
            }
            ++n2;
        }
        me.setContent(children);
        if (switchAfter) {
            this.setEditMode(false);
        }
        return me;
    }

    public Element getXmlFile() {
        if (this.getLastUsedSaveFile() == null) {
            return null;
        }
        Element me = new Element("ThrottleFrame");
        me.setAttribute("ThrottleXMLFile", FileUtil.getPortableFilename(this.getLastUsedSaveFile()));
        return me;
    }

    public void setXml(Element e) {
        List jinsts;
        Element speedPanelElement;
        if (e == null) {
            return;
        }
        String sfile = e.getAttributeValue("ThrottleXMLFile");
        if (sfile != null) {
            this.loadThrottle(FileUtil.getExternalFilename(sfile));
            return;
        }
        boolean switchAfter = false;
        if (!this.isEditMode) {
            this.setEditMode(true);
            switchAfter = true;
        }
        int bSize = 23;
        if (e.getAttribute("border") != null) {
            bSize = Integer.parseInt(e.getAttribute("border").getValue());
        }
        if (e.getChild("window") != null) {
            this.throttleWindow.setXml(e);
        }
        Element controlPanelElement = e.getChild("ControlPanel");
        this.controlPanel.setXml(controlPanelElement);
        if (((BasicInternalFrameUI)this.controlPanel.getUI()).getNorthPane() != null) {
            ((BasicInternalFrameUI)this.controlPanel.getUI()).getNorthPane().setPreferredSize(new Dimension(0, bSize));
        }
        Element functionPanelElement = e.getChild("FunctionPanel");
        this.functionPanel.setXml(functionPanelElement);
        if (((BasicInternalFrameUI)this.functionPanel.getUI()).getNorthPane() != null) {
            ((BasicInternalFrameUI)this.functionPanel.getUI()).getNorthPane().setPreferredSize(new Dimension(0, bSize));
        }
        Element addressPanelElement = e.getChild("AddressPanel");
        this.addressPanel.setXml(addressPanelElement);
        if (((BasicInternalFrameUI)this.addressPanel.getUI()).getNorthPane() != null) {
            ((BasicInternalFrameUI)this.addressPanel.getUI()).getNorthPane().setPreferredSize(new Dimension(0, bSize));
        }
        if ((speedPanelElement = e.getChild("SpeedPanel")) != null) {
            this.speedPanel.setXml(speedPanelElement);
            if (((BasicInternalFrameUI)this.speedPanel.getUI()).getNorthPane() != null) {
                ((BasicInternalFrameUI)this.speedPanel.getUI()).getNorthPane().setPreferredSize(new Dimension(0, bSize));
            }
        }
        if ((jinsts = e.getChildren("Jynstrument")) != null && jinsts.size() > 0) {
            for (Element jinst : jinsts) {
                JInternalFrame jif = this.ynstrument(FileUtil.getExternalFilename(jinst.getAttributeValue("JynstrumentFolder")));
                Element window = jinst.getChild("window");
                if (jif == null) continue;
                if (window != null) {
                    WindowPreferences.setPreferences(jif, window);
                }
                Component[] cmps2 = jif.getContentPane().getComponents();
                int j = 0;
                while (j < cmps2.length && !(cmps2[j] instanceof Jynstrument)) {
                    ++j;
                }
                if (j < cmps2.length && cmps2[j] instanceof Jynstrument) {
                    ((Jynstrument)cmps2[j]).setXml(jinst);
                }
                jif.repaint();
            }
        }
        this.setFrameTitle();
        if (switchAfter) {
            this.setEditMode(false);
        }
    }

    public void setFrameTitle() {
        String addr = Bundle.getMessage("ThrottleTitle");
        if (this.addressPanel.getThrottle() != null) {
            addr = this.addressPanel.getCurrentAddress().toString();
        }
        if (this.throttleWindow.getTitleTextType().compareTo("address") == 0) {
            this.throttleWindow.setTitle(addr);
        } else if (this.throttleWindow.getTitleTextType().compareTo("text") == 0) {
            this.throttleWindow.setTitle(this.throttleWindow.getTitleText());
        } else if (this.throttleWindow.getTitleTextType().compareTo("addressText") == 0) {
            this.throttleWindow.setTitle(String.valueOf(addr) + " " + this.throttleWindow.getTitleText());
        } else if (this.throttleWindow.getTitleTextType().compareTo("textAddress") == 0) {
            this.throttleWindow.setTitle(String.valueOf(this.throttleWindow.getTitleText()) + " " + addr);
        } else if (this.throttleWindow.getTitleTextType().compareTo("rosterID") == 0) {
            if (this.addressPanel.getRosterEntry() != null && this.addressPanel.getRosterEntry().getId() != null && this.addressPanel.getRosterEntry().getId().length() > 0) {
                this.throttleWindow.setTitle(this.addressPanel.getRosterEntry().getId());
            } else {
                this.throttleWindow.setTitle(addr);
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.throttleWindow.setCurrentThrottleFrame(this);
        if (this.willSwitch) {
            this.setEditMode(this.throttleWindow.getEditMode());
            this.repaint();
        }
        this.throttleWindow.updateGUI();
    }

    public void saveThrottle() {
        if (this.getRosterEntry() != null) {
            this.saveThrottle(String.valueOf(ThrottleFrame.getDefaultThrottleFolder()) + this.addressPanel.getRosterEntry().getId().trim() + ".xml");
        } else if (this.getLastUsedSaveFile() != null) {
            this.saveThrottle(this.getLastUsedSaveFile());
        }
    }

    public void saveThrottleAs() {
        JFileChooser fileChooser = XmlFile.userFileChooser(Bundle.getMessage("PromptXmlFileTypes"), "xml");
        fileChooser.setCurrentDirectory(new File(ThrottleFrame.getDefaultThrottleFolder()));
        fileChooser.setDialogType(1);
        File file = StoreXmlConfigAction.getFileName(fileChooser);
        if (file == null) {
            return;
        }
        this.saveThrottle(file.getAbsolutePath());
    }

    public void activateNextJInternalFrame() {
        try {
            this.activeFrame = (this.activeFrame + 1) % 4;
            this.frameList[this.activeFrame].setSelected(true);
        }
        catch (PropertyVetoException ex) {
            log.warn("Exception selecting internal frame:{}", (Object)ex.getMessage());
        }
    }

    public void activatePreviousJInternalFrame() {
        try {
            --this.activeFrame;
            if (this.activeFrame < 0) {
                this.activeFrame = 3;
            }
            this.frameList[this.activeFrame].setSelected(true);
        }
        catch (PropertyVetoException ex) {
            log.warn("Exception selecting internal frame:{}", (Object)ex.getMessage());
        }
    }

    @Override
    public void notifyAddressChosen(LocoAddress l) {
    }

    @Override
    public void notifyAddressReleased(LocoAddress la) {
        this.setLastUsedSaveFile(null);
        this.setFrameTitle();
        this.throttleWindow.updateGUI();
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle throttle) {
        if (InstanceManager.getDefault(ThrottlesPreferences.class).isUsingExThrottle() && InstanceManager.getDefault(ThrottlesPreferences.class).isAutoLoading() && this.addressPanel != null && this.addressPanel.getRosterEntry() != null && (this.getLastUsedSaveFile() == null || this.getLastUsedSaveFile().compareTo(String.valueOf(ThrottleFrame.getDefaultThrottleFolder()) + this.addressPanel.getRosterEntry().getId().trim() + ".xml") != 0)) {
            this.loadThrottle(String.valueOf(ThrottleFrame.getDefaultThrottleFolder()) + this.addressPanel.getRosterEntry().getId().trim() + ".xml");
        } else if (this.addressPanel != null && this.addressPanel.getRosterEntry() == null) {
            this.loadDefaultThrottle();
        }
        this.setFrameTitle();
        this.throttleWindow.updateGUI();
    }

    @Override
    public void notifyConsistAddressChosen(int newAddress, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressReleased(int address, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle throttle) {
    }

    public String getLastUsedSaveFile() {
        return this.lastUsedSaveFile;
    }

    public void setLastUsedSaveFile(String lusf) {
        this.lastUsedSaveFile = lusf;
        this.throttleWindow.updateGUI();
    }

    public static void setTransparentBackground(JComponent jcomp) {
        if (jcomp instanceof JPanel) {
            jcomp.setBackground(new Color(0, 0, 0, 0));
        }
        ThrottleFrame.setTransparentBackground(jcomp.getComponents());
    }

    public static void setTransparentBackground(Component[] comps) {
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            try {
                if (comp instanceof JComponent) {
                    ThrottleFrame.setTransparentBackground((JComponent)comp);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    public static void setTransparent(JComponent jcomp) {
        ThrottleFrame.setTransparent(jcomp, true);
    }

    public static void setTransparent(JComponent jcomp, boolean transparency) {
        if (jcomp instanceof JPanel) {
            jcomp.setOpaque(!transparency);
        }
        ThrottleFrame.setTransparent(jcomp.getComponents(), transparency);
    }

    private static void setTransparent(Component[] comps, boolean transparency) {
        Component[] componentArray = comps;
        int n = comps.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            try {
                if (comp instanceof JComponent) {
                    ThrottleFrame.setTransparent((JComponent)comp, transparency);
                }
            }
            catch (Exception exception) {}
            ++n2;
        }
    }

    class FrameListener
    extends InternalFrameAdapter {
        FrameListener() {
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            if (e.getSource() == ThrottleFrame.this.controlPanel) {
                ThrottleFrame.this.throttleWindow.getViewControlPanel().setSelected(false);
                ThrottleFrame.this.controlPanel.setVisible(false);
            } else if (e.getSource() == ThrottleFrame.this.addressPanel) {
                ThrottleFrame.this.throttleWindow.getViewAddressPanel().setSelected(false);
                ThrottleFrame.this.addressPanel.setVisible(false);
            } else if (e.getSource() == ThrottleFrame.this.functionPanel) {
                ThrottleFrame.this.throttleWindow.getViewFunctionPanel().setSelected(false);
                ThrottleFrame.this.functionPanel.setVisible(false);
            } else if (e.getSource() == ThrottleFrame.this.speedPanel) {
                ThrottleFrame.this.throttleWindow.getViewSpeedPanel().setSelected(false);
                ThrottleFrame.this.speedPanel.setVisible(false);
            } else {
                try {
                    if (e.getSource() instanceof JInternalFrame) {
                        Component[] cmps = ((JInternalFrame)e.getSource()).getContentPane().getComponents();
                        int i = 0;
                        while (i < cmps.length && !(cmps[i] instanceof Jynstrument)) {
                            ++i;
                        }
                        if (i < cmps.length && cmps[i] instanceof Jynstrument) {
                            ((Jynstrument)cmps[i]).exit();
                        }
                    }
                }
                catch (Exception exc) {
                    log.debug("Got exception, can ignore: ", (Throwable)exc);
                }
            }
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            if (e.getSource() == ThrottleFrame.this.controlPanel) {
                ThrottleFrame.this.activeFrame = 1;
            } else if (e.getSource() == ThrottleFrame.this.addressPanel) {
                ThrottleFrame.this.activeFrame = 0;
            } else if (e.getSource() == ThrottleFrame.this.functionPanel) {
                ThrottleFrame.this.activeFrame = 2;
            } else if (e.getSource() == ThrottleFrame.this.functionPanel) {
                ThrottleFrame.this.activeFrame = 3;
            }
        }
    }

    private static class TranslucentJPanel
    extends JPanel {
        private final Color TRANS_COL = new Color(100, 100, 100, 100);

        public TranslucentJPanel() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.TRANS_COL);
            g.fillRoundRect(0, 0, this.getSize().width, this.getSize().height, 10, 10);
            super.paintComponent(g);
        }
    }
}

