/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.Font;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Throttle;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.AddressPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.FunctionButton;
import jmri.jmrit.throttle.FunctionListener;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.util.FileUtil;
import jmri.util.swing.WrapLayout;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionPanel
extends JInternalFrame
implements FunctionListener,
PropertyChangeListener,
AddressListener {
    private static final int DEFAULT_FUNCTION_BUTTONS = 24;
    private DccThrottle mThrottle;
    private JPanel mainPanel;
    private FunctionButton[] functionButtons;
    private AddressPanel addressPanel = null;
    private static final Logger log = LoggerFactory.getLogger(FunctionPanel.class);

    public FunctionPanel() {
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            log.debug("Creating new ThrottlesPreference Instance");
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        this.initGUI();
        this.applyPreferences();
    }

    public void destroy() {
        if (this.addressPanel != null) {
            this.addressPanel.removeAddressListener(this);
        }
        if (this.mThrottle != null) {
            this.mThrottle.removePropertyChangeListener(this);
            this.mThrottle = null;
        }
    }

    public FunctionButton[] getFunctionButtons() {
        return Arrays.copyOf(this.functionButtons, this.functionButtons.length);
    }

    private void resizeFnButonsArray(int n) {
        FunctionButton[] newFunctionButtons = new FunctionButton[n];
        System.arraycopy(this.functionButtons, 0, newFunctionButtons, 0, Math.min(this.functionButtons.length, n));
        if (n > this.functionButtons.length) {
            int i = this.functionButtons.length;
            while (i < n) {
                newFunctionButtons[i] = new FunctionButton();
                this.mainPanel.add(newFunctionButtons[i]);
                this.resetFnButton(newFunctionButtons[i], i);
                MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
                int n2 = mouseWheelListenerArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    MouseWheelListener mwl = mouseWheelListenerArray[n3];
                    newFunctionButtons[i].addMouseWheelListener(mwl);
                    ++n3;
                }
                ++i;
            }
        }
        this.functionButtons = newFunctionButtons;
    }

    @Override
    public void notifyFunctionStateChanged(int functionNumber, boolean isSet) {
        log.debug("notifyFunctionStateChanged: fNumber={} isSet={} ", (Object)functionNumber, (Object)isSet);
        if (this.mThrottle != null) {
            this.mThrottle.setFunction(functionNumber, isSet);
        }
    }

    @Override
    public void notifyFunctionLockableChanged(int functionNumber, boolean isLockable) {
        log.debug("notifyFnLockableChanged: fNumber={} isLockable={} ", (Object)functionNumber, (Object)isLockable);
        if (this.mThrottle != null) {
            this.mThrottle.setFunctionMomentary(functionNumber, !isLockable);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        FunctionButton[] functionButtonArray = this.functionButtons;
        int n = this.functionButtons.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionButton functionButton = functionButtonArray[n2];
            functionButton.setEnabled(isEnabled);
            ++n2;
        }
    }

    public void setEnabled() {
        this.setEnabled(this.mThrottle != null);
    }

    public void setAddressPanel(AddressPanel addressPanel) {
        this.addressPanel = addressPanel;
    }

    public void saveFunctionButtonsToRoster(RosterEntry rosterEntry) {
        log.debug("saveFunctionButtonsToRoster");
        if (rosterEntry == null) {
            return;
        }
        FunctionButton[] functionButtonArray = this.functionButtons;
        int n = this.functionButtons.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionButton functionButton = functionButtonArray[n2];
            int functionNumber = functionButton.getIdentity();
            String text = functionButton.getButtonLabel();
            boolean lockable = functionButton.getIsLockable();
            String imagePath = functionButton.getIconPath();
            String imageSelectedPath = functionButton.getSelectedIconPath();
            if (functionButton.isDirty()) {
                String imgButtonSizeKey;
                String fontSizeKey;
                if (!text.equals(rosterEntry.getFunctionLabel(functionNumber))) {
                    if (text.isEmpty()) {
                        text = null;
                    }
                    rosterEntry.setFunctionLabel(functionNumber, text);
                }
                if (rosterEntry.getAttribute(fontSizeKey = "function" + functionNumber + "_ThrottleFontSize") != null && functionButton.getFont().getSize() == 12) {
                    rosterEntry.deleteAttribute(fontSizeKey);
                }
                if (functionButton.getFont().getSize() != 12) {
                    rosterEntry.putAttribute(fontSizeKey, "" + functionButton.getFont().getSize());
                }
                if (rosterEntry.getAttribute(imgButtonSizeKey = "function" + functionNumber + "_ThrottleImageButtonSize") != null && functionButton.getButtonImageSize() == 48) {
                    rosterEntry.deleteAttribute(imgButtonSizeKey);
                }
                if (functionButton.getButtonImageSize() != 48) {
                    rosterEntry.putAttribute(imgButtonSizeKey, "" + functionButton.getButtonImageSize());
                }
                if (rosterEntry.getFunctionLabel(functionNumber) != null) {
                    if (lockable != rosterEntry.getFunctionLockable(functionNumber)) {
                        rosterEntry.setFunctionLockable(functionNumber, lockable);
                    }
                    if (!imagePath.isEmpty() && rosterEntry.getFunctionImage(functionNumber) == null || rosterEntry.getFunctionImage(functionNumber) != null && imagePath.compareTo(rosterEntry.getFunctionImage(functionNumber)) != 0) {
                        rosterEntry.setFunctionImage(functionNumber, imagePath);
                    }
                    if (!imageSelectedPath.isEmpty() && rosterEntry.getFunctionSelectedImage(functionNumber) == null || rosterEntry.getFunctionSelectedImage(functionNumber) != null && imageSelectedPath.compareTo(rosterEntry.getFunctionSelectedImage(functionNumber)) != 0) {
                        rosterEntry.setFunctionSelectedImage(functionNumber, imageSelectedPath);
                    }
                }
                functionButton.setDirty(false);
            }
            ++n2;
        }
        Roster.getDefault().writeRoster();
    }

    private void initGUI() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new WrapLayout(1, 2, 2));
        this.resetFnButtons();
        JScrollPane scrollPane = new JScrollPane(this.mainPanel);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(false);
        EmptyBorder empyBorder = new EmptyBorder(0, 0, 0, 0);
        scrollPane.setViewportBorder(empyBorder);
        scrollPane.setBorder(empyBorder);
        scrollPane.setWheelScrollingEnabled(false);
        this.setContentPane(scrollPane);
        this.setDefaultCloseOperation(0);
    }

    private void setUpDefaultLightFunctionButton() {
        try {
            try {
                this.functionButtons[0].setIconPath("resources/icons/functionicons/svg/lightsOff.svg");
                this.functionButtons[0].setSelectedIconPath("resources/icons/functionicons/svg/lightsOn.svg");
            }
            catch (Exception e) {
                log.debug("Exception loading svg icon : " + e.getMessage());
                if (this.functionButtons[0].getIcon() == null || this.functionButtons[0].getSelectedIcon() == null) {
                    log.debug("Issue loading svg icon, reverting to png");
                    this.functionButtons[0].setIconPath("resources/icons/functionicons/transparent_background/lights_off.png");
                    this.functionButtons[0].setSelectedIconPath("resources/icons/functionicons/transparent_background/lights_on.png");
                }
            }
        }
        finally {
            if (this.functionButtons[0].getIcon() == null || this.functionButtons[0].getSelectedIcon() == null) {
                log.debug("Issue loading svg icon, reverting to png");
                this.functionButtons[0].setIconPath("resources/icons/functionicons/transparent_background/lights_off.png");
                this.functionButtons[0].setSelectedIconPath("resources/icons/functionicons/transparent_background/lights_on.png");
            }
        }
    }

    public final void applyPreferences() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        RosterEntry re = null;
        if (this.mThrottle != null && this.addressPanel != null) {
            re = this.addressPanel.getRosterEntry();
        }
        int i = 0;
        while (i < this.functionButtons.length) {
            if (i == 0 && preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
                this.setUpDefaultLightFunctionButton();
            } else {
                this.functionButtons[i].setIconPath(null);
                this.functionButtons[i].setSelectedIconPath(null);
            }
            if (re != null) {
                if (re.getFunctionLabel(i) != null) {
                    this.functionButtons[i].setDisplay(true);
                    this.functionButtons[i].setButtonLabel(re.getFunctionLabel(i));
                    if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
                        this.functionButtons[i].setIconPath(re.getFunctionImage(i));
                        this.functionButtons[i].setSelectedIconPath(re.getFunctionSelectedImage(i));
                    } else {
                        this.functionButtons[i].setIconPath(null);
                        this.functionButtons[i].setSelectedIconPath(null);
                    }
                    this.functionButtons[i].setIsLockable(re.getFunctionLockable(i));
                } else {
                    this.functionButtons[i].setDisplay(!preferences.isUsingExThrottle() || !preferences.isHidingUndefinedFuncButt());
                }
            }
            this.functionButtons[i].updateLnF();
            ++i;
        }
    }

    private void rebuildFnButons(int n) {
        this.mainPanel.removeAll();
        this.functionButtons = new FunctionButton[n];
        int i = 0;
        while (i < this.functionButtons.length) {
            this.functionButtons[i] = new FunctionButton();
            this.resetFnButton(this.functionButtons[i], i);
            this.mainPanel.add(this.functionButtons[i]);
            MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
            int n2 = mouseWheelListenerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MouseWheelListener mwl = mouseWheelListenerArray[n3];
                this.functionButtons[i].addMouseWheelListener(mwl);
                ++n3;
            }
            ++i;
        }
    }

    private void updateFnButtons() {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        if (this.mThrottle != null && this.addressPanel != null) {
            RosterEntry rosterEntry = this.addressPanel.getRosterEntry();
            if (rosterEntry != null) {
                log.debug("RosterEntry found: {}", (Object)rosterEntry.getId());
            }
            int i = 0;
            while (i < this.functionButtons.length) {
                this.functionButtons[i].setEnabled(true);
                this.functionButtons[i].setIdentity(i);
                this.functionButtons[i].setThrottle(this.mThrottle);
                this.functionButtons[i].setState(this.mThrottle.getFunction(i));
                this.functionButtons[i].setIsLockable(!this.mThrottle.getFunctionMomentary(i));
                this.functionButtons[i].setDropFolder(FileUtil.getUserResourcePath());
                if (rosterEntry != null) {
                    String text;
                    this.functionButtons[i].setDropFolder(Roster.getDefault().getRosterFilesLocation());
                    boolean needUpdate = false;
                    String imgButtonSize = rosterEntry.getAttribute("function" + i + "_ThrottleImageButtonSize");
                    if (imgButtonSize != null) {
                        try {
                            this.functionButtons[i].setButtonImageSize(Integer.parseInt(imgButtonSize));
                            needUpdate = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.debug("setFnButtons(): can't parse button image size attribute ");
                        }
                    }
                    if ((text = rosterEntry.getFunctionLabel(i)) != null) {
                        this.functionButtons[i].setDisplay(true);
                        this.functionButtons[i].setButtonLabel(text);
                        if (preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
                            this.functionButtons[i].setIconPath(rosterEntry.getFunctionImage(i));
                            this.functionButtons[i].setSelectedIconPath(rosterEntry.getFunctionSelectedImage(i));
                        } else {
                            this.functionButtons[i].setIconPath(null);
                            this.functionButtons[i].setSelectedIconPath(null);
                        }
                        this.functionButtons[i].setIsLockable(rosterEntry.getFunctionLockable(i));
                        needUpdate = true;
                    } else if (preferences.isUsingExThrottle() && preferences.isHidingUndefinedFuncButt()) {
                        this.functionButtons[i].setDisplay(false);
                        needUpdate = true;
                    }
                    String fontSize = rosterEntry.getAttribute("function" + i + "_ThrottleFontSize");
                    if (fontSize != null) {
                        try {
                            this.functionButtons[i].setFont(new Font("Monospaced", 0, Integer.parseInt(fontSize)));
                            needUpdate = true;
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.debug("setFnButtons(): can't parse font size attribute ");
                        }
                    }
                    if (needUpdate) {
                        this.functionButtons[i].updateLnF();
                    }
                }
                ++i;
            }
        }
    }

    private void resetFnButton(FunctionButton fb, int i) {
        ThrottlesPreferences preferences = InstanceManager.getDefault(ThrottlesPreferences.class);
        fb.setThrottle(this.mThrottle);
        if (this.mThrottle != null) {
            fb.setState(this.mThrottle.getFunction(i));
            fb.setIsLockable(!this.mThrottle.getFunctionMomentary(i));
        }
        fb.setIdentity(i);
        fb.addFunctionListener(this);
        fb.setButtonLabel(i < 3 ? Bundle.getMessage(Throttle.getFunctionString(i)) : Throttle.getFunctionString(i));
        fb.setDisplay(true);
        if (i == 0 && preferences.isUsingExThrottle() && preferences.isUsingFunctionIcon()) {
            this.setUpDefaultLightFunctionButton();
        } else {
            fb.setIconPath(null);
            fb.setSelectedIconPath(null);
        }
        fb.updateLnF();
        if (i < 3) {
            fb.setVisible(true);
        }
    }

    public void resetFnButtons() {
        if (this.mThrottle == null) {
            this.rebuildFnButons(24);
        } else {
            this.rebuildFnButons(this.mThrottle.getFunctions().length);
        }
        int i = 0;
        while (i < this.functionButtons.length) {
            this.resetFnButton(this.functionButtons[i], i);
            ++i;
        }
        this.updateFnButtons();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this.mThrottle != null) {
            int i = 0;
            while (i < this.mThrottle.getFunctions().length) {
                if (e.getPropertyName().equals(Throttle.getFunctionString(i))) {
                    this.setButtonByFuncNumber(i, false, (Boolean)e.getNewValue());
                } else if (e.getPropertyName().equals(Throttle.getFunctionMomentaryString(i))) {
                    this.setButtonByFuncNumber(i, true, (Boolean)e.getNewValue() == false);
                }
                ++i;
            }
        }
    }

    private void setButtonByFuncNumber(int function, boolean lockable, boolean newVal) {
        FunctionButton[] functionButtonArray = this.functionButtons;
        int n = this.functionButtons.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionButton button = functionButtonArray[n2];
            if (button.getIdentity() == function) {
                if (lockable) {
                    button.setIsLockable(newVal);
                } else {
                    button.setState(newVal);
                }
            }
            ++n2;
        }
    }

    public Element getXml() {
        Element me = new Element("FunctionPanel");
        ArrayList<Element> children = new ArrayList<Element>(1 + this.functionButtons.length);
        children.add(WindowPreferences.getPreferences(this));
        FunctionButton[] functionButtonArray = this.functionButtons;
        int n = this.functionButtons.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionButton functionButton = functionButtonArray[n2];
            children.add(functionButton.getXml());
            ++n2;
        }
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        Element window = e.getChild("window");
        WindowPreferences.setPreferences(this, window);
        List buttonElements = e.getChildren("FunctionButton");
        if (buttonElements != null && buttonElements.size() > 0) {
            this.rebuildFnButons(buttonElements.size());
            int i = 0;
            for (Element buttonElement : buttonElements) {
                this.functionButtons[i++].setXml(buttonElement);
            }
        }
    }

    @Override
    public void notifyAddressThrottleFound(DccThrottle t) {
        log.debug("Throttle found");
        this.mThrottle = t;
        this.mThrottle.addPropertyChangeListener(this);
        this.resizeFnButonsArray(this.mThrottle.getFunctions().length);
        this.updateFnButtons();
        this.setEnabled(true);
    }

    @Override
    public void notifyAddressReleased(LocoAddress la) {
        log.debug("Throttle released");
        if (this.mThrottle != null) {
            this.mThrottle.removePropertyChangeListener(this);
        }
        this.mThrottle = null;
        this.resetFnButtons();
        this.setEnabled(false);
    }

    @Override
    public void notifyAddressChosen(LocoAddress l) {
    }

    @Override
    public void notifyConsistAddressChosen(int newAddress, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressReleased(int address, boolean isLong) {
    }

    @Override
    public void notifyConsistAddressThrottleFound(DccThrottle throttle) {
    }
}

