/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import jmri.Throttle;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.FunctionButtonPropertyEditor;
import jmri.jmrit.throttle.FunctionListener;
import jmri.util.FileUtil;
import jmri.util.com.sun.ToggleOrPressButtonModel;
import jmri.util.swing.ResizableImagePanel;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionButton
extends JToggleButton {
    private final ArrayList<FunctionListener> listeners = new ArrayList();
    private int identity;
    private boolean isDisplayed = true;
    private boolean dirty = false;
    private boolean isImageOK = false;
    private boolean isSelectedImageOK = false;
    private String buttonLabel;
    private JPopupMenu popupMenu;
    private FunctionButtonPropertyEditor editor;
    private String iconPath;
    private String selectedIconPath;
    private String dropFolder;
    private ToggleOrPressButtonModel _model;
    private Throttle _throttle;
    private int img_size = 48;
    private static final int BUT_HGHT = 24;
    private static final int BUT_MAX_WDTH = 256;
    private static final int BUT_MIN_WDTH = 100;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final int DEFAULT_IMG_SIZE = 48;
    private static final Logger log = LoggerFactory.getLogger(FunctionButton.class);

    public static int getButtonHeight() {
        return 24;
    }

    public static int getButtonWidth() {
        return 100;
    }

    public int getButtonImageSize() {
        return this.img_size;
    }

    public void setButtonImageSize(int is) {
        this.img_size = is;
    }

    public FunctionButton() {
        this.initGUI();
    }

    private void initGUI() {
        this._model = new ToggleOrPressButtonModel(this, true);
        this.setModel(this._model);
        this.addMouseListener(new PopupListener());
        this.setFont(new Font("Monospaced", 0, 12));
        this.setMargin(new Insets(2, 2, 2, 2));
        this.setRolloverEnabled(false);
        this.updateLnF();
    }

    public void setIdentity(int id) {
        this.identity = id;
    }

    public int getIdentity() {
        return this.identity;
    }

    public void setState(boolean isOn) {
        super.setSelected(isOn);
        this._model.updateSelected(isOn);
    }

    public boolean getState() {
        return this.isSelected();
    }

    public void setIsLockable(boolean isLockable) {
        this._model.setLockable(isLockable);
        if (this.isDirty()) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).notifyFunctionLockableChanged(this.identity, isLockable);
                ++i;
            }
        }
    }

    public boolean getIsLockable() {
        return this._model.getLockable();
    }

    public void setDisplay(boolean displayed) {
        this.isDisplayed = displayed;
    }

    public boolean getDisplay() {
        return this.isDisplayed;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getButtonLabel() {
        return this.buttonLabel;
    }

    public void setButtonLabel(String label) {
        this.buttonLabel = label;
    }

    @Override
    public void setText(String s) {
        if (s != null) {
            this.buttonLabel = s;
            if (this.isImageOK) {
                this.setToolTipText(this.buttonLabel);
                super.setText(null);
            } else {
                super.setText(s);
            }
            return;
        }
        super.setText(null);
        if (this.buttonLabel != null) {
            this.setToolTipText(this.buttonLabel);
        }
    }

    public void updateLnF() {
        this.setFocusable(false);
        this.setVisible(this.isDisplayed);
        this.setBorderPainted(!this.isImageOK());
        this.setContentAreaFilled(!this.isImageOK());
        if (this.isImageOK()) {
            this.setText(null);
            this.setMinimumSize(new Dimension(this.img_size, this.img_size));
            this.setMaximumSize(new Dimension(this.img_size, this.img_size));
            this.setPreferredSize(new Dimension(this.img_size, this.img_size));
        } else {
            this.setText(this.getButtonLabel());
            this.setMinimumSize(new Dimension(100, 24));
            this.setMaximumSize(new Dimension(256, 24));
            if (this.getButtonLabel() != null) {
                int butWidth = this.getFontMetrics(this.getFont()).stringWidth(this.getButtonLabel()) + 64;
                butWidth = Math.min(butWidth, 256);
                butWidth = Math.max(butWidth, 100);
                this.setPreferredSize(new Dimension(butWidth, 24));
            } else {
                this.setPreferredSize(new Dimension(100, 24));
            }
        }
    }

    @Deprecated
    public void changeState(boolean newState) {
        this.setSelected(newState);
    }

    @Override
    public void setSelected(boolean newState) {
        log.debug("function selected {}", (Object)newState);
        super.setSelected(newState);
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).notifyFunctionStateChanged(this.identity, newState);
            ++i;
        }
    }

    @Deprecated
    public void setFunctionListener(FunctionListener l) {
        this.addFunctionListener(l);
    }

    public void addFunctionListener(FunctionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeFunctionListener(FunctionListener l) {
        this.listeners.remove(l);
    }

    void setDropFolder(String df) {
        this.dropFolder = df;
    }

    private void initPopupMenu() {
        if (this.popupMenu == null) {
            JMenuItem propertiesItem = new JMenuItem(Bundle.getMessage("MenuItemProperties"));
            propertiesItem.addActionListener(e -> {
                if (this.editor == null) {
                    this.editor = new FunctionButtonPropertyEditor(this);
                }
                this.editor.resetProperties();
                this.editor.setLocation(MouseInfo.getPointerInfo().getLocation());
                this.editor.setVisible(true);
                this.editor.setDropFolder(this.dropFolder);
            });
            this.popupMenu = new JPopupMenu();
            this.popupMenu.add(propertiesItem);
        }
    }

    public Element getXml() {
        Element me = new Element("FunctionButton");
        me.setAttribute("id", String.valueOf(this.getIdentity()));
        me.setAttribute("text", this.getButtonLabel());
        me.setAttribute("isLockable", String.valueOf(this.getIsLockable()));
        me.setAttribute("isVisible", String.valueOf(this.getDisplay()));
        me.setAttribute("fontSize", String.valueOf(this.getFont().getSize()));
        me.setAttribute("buttonImageSize", String.valueOf(this.getButtonImageSize()));
        if (this.getIconPath().startsWith(FileUtil.getUserResourcePath())) {
            me.setAttribute("iconPath", this.getIconPath().substring(FileUtil.getUserResourcePath().length()));
        } else {
            me.setAttribute("iconPath", this.getIconPath());
        }
        if (this.getSelectedIconPath().startsWith(FileUtil.getUserResourcePath())) {
            me.setAttribute("selectedIconPath", this.getSelectedIconPath().substring(FileUtil.getUserResourcePath().length()));
        } else {
            me.setAttribute("selectedIconPath", this.getSelectedIconPath());
        }
        return me;
    }

    private boolean checkFile(String name) {
        File fp = new File(name);
        return fp.exists();
    }

    public void setXml(Element e) {
        try {
            this.setIdentity(e.getAttribute("id").getIntValue());
            this.setText(e.getAttribute("text").getValue());
            this.setIsLockable(e.getAttribute("isLockable").getBooleanValue());
            this.setDisplay(e.getAttribute("isVisible").getBooleanValue());
            this.setFont(new Font("Monospaced", 0, e.getAttribute("fontSize").getIntValue()));
            this.setButtonImageSize(e.getAttribute("buttonImageSize") != null ? e.getAttribute("buttonImageSize").getIntValue() : 48);
            if (e.getAttribute("iconPath") != null && e.getAttribute("iconPath").getValue().length() > 0) {
                if (this.checkFile(String.valueOf(FileUtil.getUserResourcePath()) + e.getAttribute("iconPath").getValue())) {
                    this.setIconPath(String.valueOf(FileUtil.getUserResourcePath()) + e.getAttribute("iconPath").getValue());
                } else {
                    this.setIconPath(e.getAttribute("iconPath").getValue());
                }
            }
            if (e.getAttribute("selectedIconPath") != null && e.getAttribute("selectedIconPath").getValue().length() > 0) {
                if (this.checkFile(String.valueOf(FileUtil.getUserResourcePath()) + e.getAttribute("selectedIconPath").getValue())) {
                    this.setSelectedIconPath(String.valueOf(FileUtil.getUserResourcePath()) + e.getAttribute("selectedIconPath").getValue());
                } else {
                    this.setSelectedIconPath(e.getAttribute("selectedIconPath").getValue());
                }
            }
            this.updateLnF();
        }
        catch (DataConversionException ex) {
            log.error("DataConverstionException in setXml: {}", (Throwable)ex);
        }
    }

    public void setIconPath(String fnImg) {
        this.iconPath = fnImg;
        ResizableImagePanel fnImage = new ResizableImagePanel();
        fnImage.setBackground(new Color(0, 0, 0, 0));
        fnImage.setRespectAspectRatio(true);
        fnImage.setSize(new Dimension(this.img_size, this.img_size));
        fnImage.setImagePath(fnImg);
        if (fnImage.getScaledImage() != null) {
            this.setIcon(new ImageIcon(fnImage.getScaledImage()));
            this.isImageOK = true;
        } else {
            this.setIcon(null);
            this.isImageOK = false;
        }
    }

    @Nonnull
    public String getIconPath() {
        if (this.iconPath == null) {
            return "";
        }
        return this.iconPath;
    }

    public void setSelectedIconPath(String fnImg) {
        this.selectedIconPath = fnImg;
        ResizableImagePanel fnSelectedImage = new ResizableImagePanel();
        fnSelectedImage.setBackground(new Color(0, 0, 0, 0));
        fnSelectedImage.setRespectAspectRatio(true);
        fnSelectedImage.setSize(new Dimension(this.img_size, this.img_size));
        fnSelectedImage.setImagePath(fnImg);
        if (fnSelectedImage.getScaledImage() != null) {
            ImageIcon icon = new ImageIcon(fnSelectedImage.getScaledImage());
            this.setSelectedIcon(icon);
            this.setPressedIcon(icon);
            this.isSelectedImageOK = true;
        } else {
            this.setSelectedIcon(null);
            this.setPressedIcon(null);
            this.isSelectedImageOK = false;
        }
    }

    @Nonnull
    public String getSelectedIconPath() {
        if (this.selectedIconPath == null) {
            return "";
        }
        return this.selectedIconPath;
    }

    public boolean isImageOK() {
        return this.isImageOK;
    }

    public boolean isSelectedImageOK() {
        return this.isSelectedImageOK;
    }

    protected void setThrottle(Throttle throttle) {
        this._throttle = throttle;
    }

    @CheckForNull
    protected Throttle getThrottle() {
        return this._throttle;
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.checkTrigger(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkTrigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.checkTrigger(e);
        }

        private void checkTrigger(MouseEvent e) {
            if (e.isPopupTrigger() && e.getComponent().isEnabled()) {
                FunctionButton.this.initPopupMenu();
                FunctionButton.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

