/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.throttle;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleListener;
import jmri.configurexml.LocoAddressXml;
import jmri.jmrit.DccLocoAddressSelector;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.jmrit.symbolicprog.ProgDefault;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import jmri.jmrit.throttle.AddressListener;
import jmri.jmrit.throttle.BackgroundPanel;
import jmri.jmrit.throttle.Bundle;
import jmri.jmrit.throttle.ThrottlesPreferences;
import jmri.jmrit.throttle.WindowPreferences;
import jmri.jmrix.nce.consist.NceConsistRoster;
import jmri.jmrix.nce.consist.NceConsistRosterEntry;
import jmri.util.ThreadingUtil;
import jmri.util.swing.WrapLayout;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressPanel
extends JInternalFrame
implements ThrottleListener,
PropertyChangeListener {
    private DccThrottle throttle;
    private DccThrottle consistThrottle;
    private final DccLocoAddressSelector addrSelector = new DccLocoAddressSelector();
    private DccLocoAddress currentAddress;
    private DccLocoAddress consistAddress;
    private ArrayList<AddressListener> listeners;
    private JPanel mainPanel;
    private JButton releaseButton;
    private JButton dispatchButton;
    private JButton progButton;
    private JButton setButton;
    private RosterEntrySelectorPanel rosterBox;
    private JComboBox<String> conRosterBox;
    private RosterEntry rosterEntry;
    private BackgroundPanel backgroundPanel;
    private static final Logger log = LoggerFactory.getLogger(AddressPanel.class);

    public AddressPanel() {
        if (InstanceManager.getNullableDefault(ThrottlesPreferences.class) == null) {
            log.debug("Creating new ThrottlesPreference Instance");
            InstanceManager.store(new ThrottlesPreferences(), ThrottlesPreferences.class);
        }
        this.initGUI();
        this.applyPreferences();
    }

    public void destroy() {
        if (this.throttle != null) {
            DccLocoAddress l = (DccLocoAddress)this.throttle.getLocoAddress();
            this.throttle.removePropertyChangeListener(this);
            InstanceManager.throttleManagerInstance().cancelThrottleRequest(l, (ThrottleListener)this);
            InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
            this.notifyListenersOfThrottleRelease();
            this.throttle = null;
        }
        if (this.consistThrottle != null) {
            InstanceManager.throttleManagerInstance().releaseThrottle(this.consistThrottle, this);
            this.notifyListenersOfThrottleRelease();
            this.consistThrottle = null;
        }
    }

    public void addAddressListener(AddressListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeAddressListener(AddressListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public int getRosterSelectedIndex() {
        return this.getRosterEntrySelector().getRosterEntryComboBox().getSelectedIndex();
    }

    public void setRosterSelectedIndex(int index) {
        if (this.getRosterEntrySelector().isEnabled() && index >= 0 && index < this.getRosterEntrySelector().getRosterEntryComboBox().getItemCount()) {
            this.getRosterEntrySelector().getRosterEntryComboBox().setSelectedIndex(index);
        }
        if (this.backgroundPanel != null && this.rosterBox.getSelectedRosterEntries().length == 0) {
            this.backgroundPanel.setImagePath(null);
            String rosterEntryTitle = this.getRosterEntrySelector().getSelectedRosterEntries()[0].titleString();
            RosterEntry re = Roster.getDefault().entryFromTitle(rosterEntryTitle);
            if (re != null) {
                this.backgroundPanel.setImagePath(re.getImagePath());
            }
        }
    }

    public void setBackgroundPanel(BackgroundPanel bp) {
        this.backgroundPanel = bp;
    }

    public void selectRosterEntry() {
        this.rosterItemSelected();
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        List<RosterEntry> l2;
        log.debug("Asked for {} got {}", (Object)this.currentAddress.getNumber(), (Object)t.getLocoAddress());
        if (this.consistAddress != null && t.getLocoAddress().getNumber() == this.consistAddress.getNumber()) {
            log.debug("notifying that this is a consist");
            this.notifyConsistThrottleFound(t);
            return;
        }
        if (t.getLocoAddress().getNumber() != this.currentAddress.getNumber()) {
            log.warn("Not correct address, asked for {} got {}, requesting again...", (Object)this.currentAddress.getNumber(), (Object)t.getLocoAddress());
            boolean requestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.currentAddress, (ThrottleListener)this, true);
            if (!requestOK) {
                JOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
            }
            return;
        }
        this.throttle = t;
        this.releaseButton.setEnabled(true);
        this.currentAddress = (DccLocoAddress)t.getLocoAddress();
        this.addrSelector.setAddress(this.currentAddress);
        this.throttle.addPropertyChangeListener(this);
        if (this.rosterEntry == null && InstanceManager.getDefault(ThrottlesPreferences.class).isUsingExThrottle() && InstanceManager.getDefault(ThrottlesPreferences.class).isEnablingRosterSearch() && this.addrSelector.getAddress() != null && (l2 = Roster.getDefault().matchingList(null, null, "" + this.addrSelector.getAddress().getNumber(), null, null, null, null)).size() > 0) {
            this.rosterEntry = l2.get(0);
        }
        this.setButton.setEnabled(false);
        this.addrSelector.setEnabled(false);
        this.getRosterEntrySelector().setEnabled(false);
        this.conRosterBox.setEnabled(false);
        if (InstanceManager.throttleManagerInstance().hasDispatchFunction()) {
            this.dispatchButton.setEnabled(true);
        }
        if (this.rosterEntry != null && ProgDefault.getDefaultProgFile() != null && InstanceManager.getNullableDefault(AddressedProgrammerManager.class) != null && InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible()) {
            this.progButton.setEnabled(true);
        }
        this.listeners.stream().filter(l -> this.currentAddress != null).forEachOrdered(l -> l.notifyAddressThrottleFound(this.throttle));
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        JOptionPane.showMessageDialog(null, reason, Bundle.getMessage("FailedSetupRequestTitle"), 2);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
        if (question != null) {
            switch (question) {
                case STEAL: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
                        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        return;
                    }
                    ThreadingUtil.runOnGUI(() -> {
                        if (JOptionPane.showConfirmDialog(this, Bundle.getMessage("StealQuestionText", address.toString()), Bundle.getMessage("StealRequestTitle"), 0) == 0) {
                            InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        } else {
                            InstanceManager.throttleManagerInstance().cancelThrottleRequest(address, (ThrottleListener)this);
                        }
                    });
                    break;
                }
                case SHARE: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentShare()) {
                        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        return;
                    }
                    ThreadingUtil.runOnGUI(() -> {
                        if (JOptionPane.showConfirmDialog(this, Bundle.getMessage("ShareQuestionText", address.toString()), Bundle.getMessage("ShareRequestTitle"), 0) == 0) {
                            InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        } else {
                            InstanceManager.throttleManagerInstance().cancelThrottleRequest(address, (ThrottleListener)this);
                        }
                    });
                    break;
                }
                case STEAL_OR_SHARE: {
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentSteal()) {
                        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                        return;
                    }
                    if (InstanceManager.getDefault(ThrottlesPreferences.class).isSilentShare()) {
                        InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                        return;
                    }
                    String[] options = new String[]{Bundle.getMessage("StealButton"), Bundle.getMessage("ShareButton"), Bundle.getMessage("CancelButton")};
                    ThreadingUtil.runOnGUI(() -> {
                        int response = JOptionPane.showOptionDialog(this, Bundle.getMessage("StealShareQuestionText", address.toString()), Bundle.getMessage("StealShareRequestTitle"), -1, 3, null, options, options[1]);
                        switch (response) {
                            case 0: {
                                log.debug("steal clicked");
                                InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.STEAL);
                                break;
                            }
                            case 1: {
                                log.debug("share clicked");
                                InstanceManager.throttleManagerInstance().responseThrottleDecision(address, (ThrottleListener)this, ThrottleListener.DecisionType.SHARE);
                                break;
                            }
                            default: {
                                log.debug("cancel clicked");
                                InstanceManager.throttleManagerInstance().cancelThrottleRequest(address, (ThrottleListener)this);
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    public void notifyConsistThrottleFound(DccThrottle t) {
        this.consistThrottle = t;
        this.listeners.forEach(l -> l.notifyConsistAddressThrottleFound(t));
    }

    public void notifyThrottleDisposed() {
        log.debug("notifyThrottleDisposed");
        this.dispatchButton.setEnabled(false);
        this.releaseButton.setEnabled(false);
        this.progButton.setEnabled(false);
        this.setButton.setEnabled(true);
        this.addrSelector.setEnabled(true);
        this.getRosterEntrySelector().setEnabled(true);
        this.conRosterBox.setEnabled(true);
        if (this.throttle != null) {
            this.throttle.removePropertyChangeListener(this);
        }
        this.throttle = null;
        this.rosterEntry = null;
        this.notifyListenersOfThrottleRelease();
    }

    public RosterEntry getRosterEntry() {
        return this.rosterEntry;
    }

    public void setRosterEntry(RosterEntry entry) {
        this.getRosterEntrySelector().setSelectedRosterEntry(entry);
        this.addrSelector.setAddress(entry.getDccLocoAddress());
        this.rosterEntry = entry;
        this.changeOfAddress();
    }

    private void initGUI() {
        this.setDefaultCloseOperation(0);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.setContentPane(this.mainPanel);
        this.addrSelector.setVariableSize(true);
        this.mainPanel.add((Component)this.addrSelector.getCombinedJPanel(), "Center");
        this.addrSelector.getTextField().addActionListener(e -> {
            this.consistAddress = null;
            this.changeOfAddress();
        });
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new WrapLayout(1, 2, 2));
        this.rosterBox = new RosterEntrySelectorPanel();
        this.getRosterEntrySelector().setNonSelectedItem(Bundle.getMessage("NoLocoSelected"));
        this.getRosterEntrySelector().setToolTipText(Bundle.getMessage("SelectLocoFromRosterTT"));
        this.getRosterEntrySelector().addPropertyChangeListener("selectedRosterEntries", pce -> this.rosterItemSelected());
        this.getRosterEntrySelector().setLayout(new WrapLayout(1, 2, 2));
        topPanel.add(this.getRosterEntrySelector());
        this.conRosterBox = InstanceManager.getDefault(NceConsistRoster.class).fullRosterComboBox();
        if (InstanceManager.getDefault(NceConsistRoster.class).numEntries() > 0) {
            this.conRosterBox.insertItemAt(Bundle.getMessage("NoConsistSelected"), 0);
            this.conRosterBox.setSelectedIndex(0);
            this.conRosterBox.setToolTipText(Bundle.getMessage("SelectConsistFromRosterTT"));
            this.conRosterBox.addActionListener(e -> this.consistRosterSelected());
            topPanel.add(this.conRosterBox);
        }
        this.mainPanel.add((Component)topPanel, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new WrapLayout(1, 2, 2));
        this.progButton = new JButton(Bundle.getMessage("ButtonProgram"));
        buttonPanel.add(this.progButton);
        this.progButton.setEnabled(false);
        this.progButton.addActionListener(e -> this.openProgrammer());
        this.dispatchButton = new JButton(Bundle.getMessage("ButtonDispatch"));
        buttonPanel.add(this.dispatchButton);
        this.dispatchButton.setEnabled(false);
        this.dispatchButton.addActionListener(e -> this.dispatchAddress());
        this.releaseButton = new JButton(Bundle.getMessage("ButtonRelease"));
        buttonPanel.add(this.releaseButton);
        this.releaseButton.setEnabled(false);
        this.releaseButton.addActionListener(e -> this.releaseAddress());
        this.setButton = new JButton(Bundle.getMessage("ButtonSet"));
        this.setButton.addActionListener(e -> {
            this.consistAddress = null;
            this.changeOfAddress();
        });
        buttonPanel.add(this.setButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        this.pack();
    }

    private void rosterItemSelected() {
        if (this.getRosterEntrySelector().getSelectedRosterEntries().length != 0) {
            this.setRosterEntry(this.getRosterEntrySelector().getSelectedRosterEntries()[0]);
            this.consistAddress = null;
        }
    }

    private void consistRosterSelected() {
        if (!Objects.equals(this.conRosterBox.getSelectedItem(), Bundle.getMessage("NoConsistSelected"))) {
            String rosterEntryTitle = Objects.requireNonNull(this.conRosterBox.getSelectedItem()).toString();
            NceConsistRosterEntry nceConsistRosterEntry = InstanceManager.getDefault(NceConsistRoster.class).entryFromTitle(rosterEntryTitle);
            DccLocoAddress a = new DccLocoAddress(Integer.parseInt(nceConsistRosterEntry.getLoco1DccAddress()), nceConsistRosterEntry.isLoco1LongAddress());
            this.addrSelector.setAddress(a);
            this.consistAddress = null;
            int cA = 0;
            try {
                cA = Integer.parseInt(nceConsistRosterEntry.getConsistNumber());
            }
            catch (NumberFormatException numberFormatException) {}
            if (cA <= 0 || cA >= 128) {
                log.warn("consist number missing {}", (Object)nceConsistRosterEntry.getLoco1DccAddress());
                JOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("ConsistNumberHasNotBeenAssigned"), Bundle.getMessage("NeedsConsistNumber"), 0);
                return;
            }
            this.consistAddress = new DccLocoAddress(cA, false);
            if (JOptionPane.showConfirmDialog(this.mainPanel, Bundle.getMessage("SendFunctionToLead"), Bundle.getMessage("NCEconsistThrottle"), 0) != 0) {
                this.addrSelector.setAddress(this.consistAddress);
                this.consistAddress = null;
            }
            this.changeOfAddress();
        }
    }

    private void changeOfAddress() {
        this.currentAddress = this.addrSelector.getAddress();
        if (this.currentAddress == null) {
            return;
        }
        this.listeners.forEach(l -> l.notifyAddressChosen(this.currentAddress));
        log.debug("Requesting new slot for address {} rosterEntry {}", (Object)this.currentAddress, (Object)this.rosterEntry);
        boolean requestOK = this.rosterEntry == null ? InstanceManager.throttleManagerInstance().requestThrottle(this.currentAddress, (ThrottleListener)this, true) : InstanceManager.throttleManagerInstance().requestThrottle(this.rosterEntry, (ThrottleListener)this, true);
        if (!requestOK) {
            JOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
        }
    }

    private void changeOfConsistAddress() {
        if (this.consistAddress == null) {
            return;
        }
        for (AddressListener l : this.listeners) {
            l.notifyConsistAddressChosen(this.consistAddress.getNumber(), this.consistAddress.isLongAddress());
        }
        boolean requestOK = InstanceManager.throttleManagerInstance().requestThrottle(this.consistAddress, (ThrottleListener)this, true);
        if (!requestOK) {
            JOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("AddressInUse"));
        }
    }

    protected void openProgrammer() {
        if (this.rosterEntry == null) {
            return;
        }
        ResourceBundle rbt = ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle");
        String ptitle = MessageFormat.format(rbt.getString("FrameOpsProgrammerTitle"), this.rosterEntry.getId());
        int address = Integer.parseInt(this.rosterEntry.getDccAddress());
        boolean longAddr = true;
        if (address < 100) {
            longAddr = false;
        }
        AddressedProgrammer programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddr, address);
        PaneOpsProgFrame p = new PaneOpsProgFrame(null, this.rosterEntry, ptitle, "programmers" + File.separator + ProgDefault.getDefaultProgFile() + ".xml", programmer);
        ((Window)p).pack();
        p.setVisible(true);
    }

    public void dispatchAddress() {
        if (this.throttle != null) {
            int usageCount = InstanceManager.throttleManagerInstance().getThrottleUsageCount(this.throttle.getLocoAddress()) - 1;
            if (usageCount != 0) {
                JOptionPane.showMessageDialog(this.mainPanel, Bundle.getMessage("CannotDisptach", usageCount));
                return;
            }
            InstanceManager.throttleManagerInstance().dispatchThrottle(this.throttle, this);
            if (this.consistThrottle != null) {
                InstanceManager.throttleManagerInstance().dispatchThrottle(this.consistThrottle, this);
                this.consistThrottle = null;
            }
            this.notifyThrottleDisposed();
        }
    }

    public void releaseAddress() {
        InstanceManager.throttleManagerInstance().releaseThrottle(this.throttle, this);
        if (this.consistThrottle != null) {
            InstanceManager.throttleManagerInstance().releaseThrottle(this.consistThrottle, this);
            this.consistThrottle = null;
        }
        this.notifyThrottleDisposed();
    }

    private void notifyListenersOfThrottleRelease() {
        if (this.listeners != null) {
            this.listeners.forEach(l -> l.notifyAddressReleased(this.currentAddress));
        }
    }

    public Element getXml() {
        Element me = new Element("AddressPanel");
        ArrayList<Element> children = new ArrayList<Element>(1);
        children.add(WindowPreferences.getPreferences(this));
        children.add(new LocoAddressXml().store(this.addrSelector.getAddress()));
        children.add(new LocoAddressXml().store(this.consistAddress));
        me.setContent(children);
        return me;
    }

    public void setXml(Element e) {
        List elementList;
        Element window = e.getChild("window");
        WindowPreferences.setPreferences(this, window);
        Element addressElement = e.getChild("address");
        if (addressElement != null && this.getRosterEntry() == null) {
            String address = addressElement.getAttribute("value").getValue();
            this.addrSelector.setAddress(new DccLocoAddress(Integer.parseInt(address), false));
            this.consistAddress = null;
            this.changeOfAddress();
        }
        if ((elementList = e.getChildren("locoaddress")).size() > 0 && this.getThrottle() == null) {
            DccLocoAddress tmpAdd;
            log.debug("found {} locoaddress(es)", (Object)elementList.size());
            this.currentAddress = (DccLocoAddress)new LocoAddressXml().getAddress((Element)elementList.get(0));
            log.debug("Loaded address {} from xml", (Object)this.currentAddress);
            this.addrSelector.setAddress(this.currentAddress);
            this.consistAddress = null;
            if (elementList.size() > 1 && (tmpAdd = (DccLocoAddress)new LocoAddressXml().getAddress((Element)elementList.get(1))) != null && !this.currentAddress.equals(tmpAdd)) {
                log.debug("and consist with {}", (Object)tmpAdd);
                this.consistAddress = tmpAdd;
            }
            this.changeOfAddress();
        }
    }

    public RosterEntrySelectorPanel getRosterEntrySelector() {
        return this.rosterBox;
    }

    public DccThrottle getThrottle() {
        return this.throttle;
    }

    public DccLocoAddress getCurrentAddress() {
        return this.currentAddress;
    }

    public void setCurrentAddress(DccLocoAddress currentAddress) {
        if (log.isDebugEnabled()) {
            log.debug("Setting CurrentAddress to {}", (Object)currentAddress);
        }
        this.addrSelector.setAddress(currentAddress);
        this.changeOfAddress();
    }

    public void setAddress(int consistNumber, boolean b) {
        this.setCurrentAddress(new DccLocoAddress(consistNumber, b));
    }

    public DccLocoAddress getConsistAddress() {
        return this.consistAddress;
    }

    public void setConsistAddress(DccLocoAddress consistAddress) {
        if (log.isDebugEnabled()) {
            log.debug("Setting Consist Address to {}", (Object)consistAddress);
        }
        this.consistAddress = consistAddress;
        this.changeOfConsistAddress();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null) {
            return;
        }
        if ("ThrottleConnected".compareTo(evt.getPropertyName()) == 0 && ((Boolean)evt.getOldValue()).booleanValue() && !((Boolean)evt.getNewValue()).booleanValue()) {
            log.debug("propertyChange: ThrottleConnected to false");
            this.notifyThrottleDisposed();
        }
        if ("DispatchEnabled".compareTo(evt.getPropertyName()) == 0) {
            log.debug("propertyChange: Dispatch Button Enabled {}", evt.getNewValue());
            this.dispatchButton.setEnabled((Boolean)evt.getNewValue());
        }
        if ("ReleaseEnabled".compareTo(evt.getPropertyName()) == 0) {
            log.debug("propertyChange: release Button Enabled {}", evt.getNewValue());
            this.releaseButton.setEnabled((Boolean)evt.getNewValue());
        }
    }

    void applyPreferences() {
    }
}

