/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.ResetTableModel;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.tabbedframe.PaneContainer;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgPane;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneSet {
    List<PaneProgPane> paneList = new ArrayList<PaneProgPane>();
    PaneContainer container;
    Programmer mProgrammer;
    CvTableModel cvModel = null;
    VariableTableModel variableModel;
    ResetTableModel resetModel = null;
    JLabel progStatus = new JLabel(SymbolicProgBundle.getMessage("StateIdle"));
    Element modelElem = null;
    Element decoderRoot = null;
    private static final Logger log = LoggerFactory.getLogger(PaneSet.class);

    public PaneSet(PaneContainer container, RosterEntry re, Programmer programmer) {
        this.container = container;
        this.mProgrammer = programmer;
        this.cvModel = new CvTableModel(this.progStatus, this.mProgrammer);
        this.variableModel = new VariableTableModel(this.progStatus, new String[]{"Name", "Value"}, this.cvModel);
        this.resetModel = new ResetTableModel(this.progStatus, this.mProgrammer);
        if (re.getFileName() != null) {
            re.readFile();
        }
        this.loadDecoderFromLoco(re);
        if (re.getFileName() != null) {
            re.loadCvModel(this.variableModel, this.cvModel);
        }
    }

    protected void loadDecoderFromLoco(RosterEntry r) {
        String decoderModel = r.getDecoderModel();
        String decoderFamily = r.getDecoderFamily();
        if (log.isDebugEnabled()) {
            log.debug("selected loco uses decoder {} {}", (Object)decoderFamily, (Object)decoderModel);
        }
        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, decoderFamily, null, null, null, decoderModel);
        if (log.isDebugEnabled()) {
            log.debug("found {} matches", (Object)l.size());
        }
        if (l.size() == 0) {
            log.debug("Loco uses {} {} decoder, but no such decoder defined", (Object)decoderFamily, (Object)decoderModel);
            l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, decoderModel);
            if (log.isDebugEnabled()) {
                log.debug("found {} matches without family key", (Object)l.size());
            }
        }
        if (l.size() > 0) {
            DecoderFile d = l.get(0);
            this.loadDecoderFile(d, r);
        } else if (decoderModel.equals("")) {
            log.debug("blank decoderModel requested, so nothing loaded");
        } else {
            log.warn("no matching \"{}\" decoder found for loco, no decoder info loaded", (Object)decoderModel);
        }
    }

    protected void loadDecoderFile(DecoderFile df, RosterEntry re) {
        if (df == null) {
            log.warn("loadDecoder file invoked with null object");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("loadDecoderFile from {} {}", (Object)DecoderFile.fileLocation, (Object)df.getFileName());
        }
        try {
            this.decoderRoot = df.rootFromName(String.valueOf(DecoderFile.fileLocation) + df.getFileName());
        }
        catch (IOException | JDOMException e) {
            log.error("Exception while loading decoder XML file: {}", (Object)df.getFileName(), (Object)e);
        }
        df.getProductID();
        df.loadVariableModel(this.decoderRoot.getChild("decoder"), this.variableModel);
        df.loadResetModel(this.decoderRoot.getChild("decoder"), this.resetModel);
        re.loadFunctions(this.decoderRoot.getChild("decoder").getChild("family").getChild("functionlabels"));
        this.modelElem = df.getModelElement();
    }

    public void makePanes(Element root, RosterEntry r) {
        Element base = root.getChild("programmer");
        if (base == null) {
            log.error("xml file top element is not programmer");
            return;
        }
        List paneList = base.getChildren("pane");
        if (log.isDebugEnabled()) {
            log.debug("will process {} pane definitions", (Object)paneList.size());
        }
        for (Element e : paneList) {
            String name = e.getAttribute("name").getValue();
            this.newPane(name, e, this.modelElem, r);
        }
    }

    public void newPane(String name, Element pane, Element modelElem, RosterEntry r) {
        if (log.isDebugEnabled()) {
            log.debug("newPane {}", (Object)name);
        }
        PaneProgPane p = new PaneProgPane(this.container, name, pane, this.cvModel, this.variableModel, modelElem, r);
        this.paneList.add(p);
    }

    public List<PaneProgPane> getList() {
        return this.paneList;
    }

    public void storeFile(RosterEntry re) {
        re.ensureFilenameExists();
        re.writeFile(this.cvModel, this.variableModel);
    }
}

