/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import jmri.AddressedProgrammerManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.UserPreferencesManager;
import jmri.implementation.ProgrammerFacadeSelector;
import jmri.implementation.VerifyWriteProgrammerFacade;
import jmri.implementation.swing.SwingShutDownTask;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.FunctionLabelPane;
import jmri.jmrit.roster.PrintRosterEntry;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.RosterEntryPane;
import jmri.jmrit.roster.RosterMediaPane;
import jmri.jmrit.symbolicprog.CsvExportAction;
import jmri.jmrit.symbolicprog.CsvImportAction;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.DccAddressVarHandler;
import jmri.jmrit.symbolicprog.EnumVariableValue;
import jmri.jmrit.symbolicprog.FactoryResetAction;
import jmri.jmrit.symbolicprog.LokProgImportAction;
import jmri.jmrit.symbolicprog.Pr1ExportAction;
import jmri.jmrit.symbolicprog.Pr1ImportAction;
import jmri.jmrit.symbolicprog.Pr1WinExportAction;
import jmri.jmrit.symbolicprog.PrintAction;
import jmri.jmrit.symbolicprog.PrintCvAction;
import jmri.jmrit.symbolicprog.ProgrammerConfigManager;
import jmri.jmrit.symbolicprog.Qualifier;
import jmri.jmrit.symbolicprog.QualifierAdder;
import jmri.jmrit.symbolicprog.QuantumCvMgrImportAction;
import jmri.jmrit.symbolicprog.ResetTableModel;
import jmri.jmrit.symbolicprog.SpeedTableNumbers;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.jmrit.symbolicprog.tabbedframe.Bundle;
import jmri.jmrit.symbolicprog.tabbedframe.PaneContainer;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgPane;
import jmri.jmrit.symbolicprog.tabbedframe.PaneQualifier;
import jmri.jmrit.symbolicprog.tabbedframe.WatchingLabel;
import jmri.util.BusyGlassPane;
import jmri.util.FileUtil;
import jmri.util.JmriJFrame;
import jmri.util.jdom.LocaleSelector;
import jmri.util.swing.SearchBar;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaneProgFrame
extends JmriJFrame
implements PropertyChangeListener,
PaneContainer {
    JLabel progStatus = new JLabel(Bundle.getMessage("StateIdle"));
    CvTableModel cvModel = null;
    VariableTableModel variableModel;
    ResetTableModel resetModel = null;
    JMenu resetMenu = null;
    Programmer mProgrammer;
    JPanel modePane = null;
    JPanel tempPane;
    boolean _opsMode;
    boolean maxFnNumDirty = false;
    String maxFnNumOld = "";
    String maxFnNumNew = "";
    RosterEntry _rosterEntry = null;
    RosterEntryPane _rPane = null;
    FunctionLabelPane _flPane = null;
    RosterMediaPane _rMPane = null;
    List<JPanel> paneList = new ArrayList<JPanel>();
    int paneListIndex;
    List<Element> decoderPaneList;
    BusyGlassPane glassPane;
    List<JComponent> activeComponents = new ArrayList<JComponent>();
    String filename = null;
    String programmerShowEmptyPanes = "";
    String decoderShowEmptyPanes = "";
    String decoderAllowResetDefaults = "";
    JTabbedPane tabPane = new JTabbedPane();
    JToggleButton readChangesButton = new JToggleButton(Bundle.getMessage("ButtonReadChangesAllSheets"));
    JToggleButton writeChangesButton = new JToggleButton(Bundle.getMessage("ButtonWriteChangesAllSheets"));
    JToggleButton readAllButton = new JToggleButton(Bundle.getMessage("ButtonReadAllSheets"));
    JToggleButton writeAllButton = new JToggleButton(Bundle.getMessage("ButtonWriteAllSheets"));
    ItemListener l1;
    ItemListener l2;
    ItemListener l3;
    ItemListener l4;
    ShutDownTask decoderDirtyTask;
    ShutDownTask fileDirtyTask;
    SearchBar searchBar;
    ArrayList<SearchPair> searchTargetList;
    int nextSearchTarget = 0;
    private Runnable searchForwardTask = new Runnable(){

        @Override
        public void run() {
            log.trace("start forward");
            PaneProgFrame.this.loadSearchTargets();
            String target = PaneProgFrame.this.searchBar.getSearchString();
            ++PaneProgFrame.this.nextSearchTarget;
            if (PaneProgFrame.this.nextSearchTarget < 0) {
                PaneProgFrame.this.nextSearchTarget = 0;
            }
            if (PaneProgFrame.this.nextSearchTarget >= PaneProgFrame.this.searchTargetList.size()) {
                PaneProgFrame.this.nextSearchTarget = 0;
            }
            int startingSearchTarget = PaneProgFrame.this.nextSearchTarget;
            while (PaneProgFrame.this.nextSearchTarget < PaneProgFrame.this.searchTargetList.size()) {
                if (PaneProgFrame.this.checkSearchTarget(PaneProgFrame.this.nextSearchTarget, target)) {
                    PaneProgFrame.this.searchGoesTo(PaneProgFrame.this.searchTargetList.get(PaneProgFrame.this.nextSearchTarget));
                    return;
                }
                ++PaneProgFrame.this.nextSearchTarget;
            }
            PaneProgFrame.this.nextSearchTarget = 0;
            while (PaneProgFrame.this.nextSearchTarget < startingSearchTarget) {
                if (PaneProgFrame.this.checkSearchTarget(PaneProgFrame.this.nextSearchTarget, target)) {
                    PaneProgFrame.this.searchGoesTo(PaneProgFrame.this.searchTargetList.get(PaneProgFrame.this.nextSearchTarget));
                    return;
                }
                ++PaneProgFrame.this.nextSearchTarget;
            }
            PaneProgFrame.this.searchDidNotFind();
        }
    };
    private Runnable searchBackwardTask = new Runnable(){

        @Override
        public void run() {
            log.trace("start backward");
            PaneProgFrame.this.loadSearchTargets();
            String target = PaneProgFrame.this.searchBar.getSearchString();
            --PaneProgFrame.this.nextSearchTarget;
            if (PaneProgFrame.this.nextSearchTarget < 0) {
                PaneProgFrame.this.nextSearchTarget = PaneProgFrame.this.searchTargetList.size() - 1;
            }
            if (PaneProgFrame.this.nextSearchTarget >= PaneProgFrame.this.searchTargetList.size()) {
                PaneProgFrame.this.nextSearchTarget = PaneProgFrame.this.searchTargetList.size() - 1;
            }
            int startingSearchTarget = PaneProgFrame.this.nextSearchTarget;
            while (PaneProgFrame.this.nextSearchTarget > 0) {
                if (PaneProgFrame.this.checkSearchTarget(PaneProgFrame.this.nextSearchTarget, target)) {
                    PaneProgFrame.this.searchGoesTo(PaneProgFrame.this.searchTargetList.get(PaneProgFrame.this.nextSearchTarget));
                    return;
                }
                --PaneProgFrame.this.nextSearchTarget;
            }
            PaneProgFrame.this.nextSearchTarget = PaneProgFrame.this.searchTargetList.size() - 1;
            while (PaneProgFrame.this.nextSearchTarget > startingSearchTarget) {
                if (PaneProgFrame.this.checkSearchTarget(PaneProgFrame.this.nextSearchTarget, target)) {
                    PaneProgFrame.this.searchGoesTo(PaneProgFrame.this.searchTargetList.get(PaneProgFrame.this.nextSearchTarget));
                    return;
                }
                --PaneProgFrame.this.nextSearchTarget;
            }
            PaneProgFrame.this.searchDidNotFind();
        }
    };
    private Runnable searchDoneTask = new Runnable(){

        @Override
        public void run() {
            log.debug("done with search bar");
            PaneProgFrame.this.searchBar.setVisible(false);
        }
    };
    Element modelElem = null;
    Element decoderRoot = null;
    Element programmerRoot = null;
    int[] defaultCvValues = null;
    String[] defaultCvNumbers = null;
    VariableValue primaryAddr = null;
    VariableValue extendAddr = null;
    EnumVariableValue addMode = null;
    boolean longMode = false;
    String newAddr = null;
    boolean justChanges;
    private boolean _busy = false;
    boolean _read = true;
    PaneProgPane _programmingPane = null;
    private static final Logger log = LoggerFactory.getLogger(PaneProgFrame.class);

    protected abstract JPanel getModePane();

    protected void installComponents() {
        JPanel pane;
        if (this.decoderDirtyTask == null) {
            this.decoderDirtyTask = new SwingShutDownTask("DecoderPro Decoder Window Check", Bundle.getMessage("PromptQuitWindowNotWrittenDecoder"), null, this){

                @Override
                public boolean checkPromptNeeded() {
                    return !PaneProgFrame.this.checkDirtyDecoder();
                }
            };
        }
        InstanceManager.getDefault(ShutDownManager.class).register(this.decoderDirtyTask);
        if (this.fileDirtyTask == null) {
            this.fileDirtyTask = new SwingShutDownTask("DecoderPro Decoder Window Check", Bundle.getMessage("PromptQuitWindowNotWrittenConfig"), Bundle.getMessage("PromptSaveQuit"), this){

                @Override
                public boolean checkPromptNeeded() {
                    return !PaneProgFrame.this.checkDirtyFile();
                }

                @Override
                public boolean doPrompt() {
                    return PaneProgFrame.this.storeFile();
                }
            };
        }
        InstanceManager.getDefault(ShutDownManager.class).register(this.fileDirtyTask);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu(Bundle.getMessage("MenuFile"));
        menuBar.add(fileMenu);
        this.resetMenu = new JMenu(Bundle.getMessage("MenuReset"));
        menuBar.add(this.resetMenu);
        this.resetMenu.add(new FactoryResetAction(Bundle.getMessage("MenuFactoryReset"), this.resetModel, this));
        this.resetMenu.setEnabled(false);
        fileMenu.add(new AbstractAction(Bundle.getMessage("MenuSave")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneProgFrame.this.storeFile();
            }
        });
        JMenu printSubMenu = new JMenu(Bundle.getMessage("MenuPrint"));
        printSubMenu.add(new PrintAction(Bundle.getMessage("MenuPrintAll"), this, false));
        printSubMenu.add(new PrintCvAction(Bundle.getMessage("MenuPrintCVs"), this.cvModel, this, false, this._rosterEntry));
        fileMenu.add(printSubMenu);
        JMenu printPreviewSubMenu = new JMenu(Bundle.getMessage("MenuPrintPreview"));
        printPreviewSubMenu.add(new PrintAction(Bundle.getMessage("MenuPrintPreviewAll"), this, true));
        printPreviewSubMenu.add(new PrintCvAction(Bundle.getMessage("MenuPrintPreviewCVs"), this.cvModel, this, true, this._rosterEntry));
        fileMenu.add(printPreviewSubMenu);
        JMenu importSubMenu = new JMenu(Bundle.getMessage("MenuImport"));
        fileMenu.add(importSubMenu);
        importSubMenu.add(new CsvImportAction(Bundle.getMessage("MenuImportCSV"), this.cvModel, this, this.progStatus));
        importSubMenu.add(new Pr1ImportAction(Bundle.getMessage("MenuImportPr1"), this.cvModel, this, this.progStatus));
        importSubMenu.add(new LokProgImportAction(Bundle.getMessage("MenuImportLokProg"), this.cvModel, this, this.progStatus));
        importSubMenu.add(new QuantumCvMgrImportAction(Bundle.getMessage("MenuImportQuantumCvMgr"), this.cvModel, this, this.progStatus));
        JMenu exportSubMenu = new JMenu(Bundle.getMessage("MenuExport"));
        fileMenu.add(exportSubMenu);
        exportSubMenu.add(new CsvExportAction(Bundle.getMessage("MenuExportCSV"), this.cvModel, this));
        exportSubMenu.add(new Pr1ExportAction(Bundle.getMessage("MenuExportPr1DOS"), this.cvModel, this));
        exportSubMenu.add(new Pr1WinExportAction(Bundle.getMessage("MenuExportPr1WIN"), this.cvModel, this));
        JMenu speedTableSubMenu = new JMenu(Bundle.getMessage("MenuSpeedTable"));
        fileMenu.add(speedTableSubMenu);
        ButtonGroup SpeedTableNumbersGroup = new ButtonGroup();
        UserPreferencesManager upm = InstanceManager.getDefault(UserPreferencesManager.class);
        Object speedTableNumbersSelectionObj = upm.getProperty(SpeedTableNumbers.class.getName(), "selection");
        SpeedTableNumbers speedTableNumbersSelection = speedTableNumbersSelectionObj != null ? SpeedTableNumbers.valueOf(speedTableNumbersSelectionObj.toString()) : null;
        SpeedTableNumbers[] speedTableNumbersArray = SpeedTableNumbers.values();
        int n = speedTableNumbersArray.length;
        int n2 = 0;
        while (n2 < n) {
            SpeedTableNumbers speedTableNumbers = speedTableNumbersArray[n2];
            JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(speedTableNumbers.toString());
            rbMenuItem.addActionListener(event -> {
                rbMenuItem.setSelected(true);
                upm.setProperty(SpeedTableNumbers.class.getName(), "selection", speedTableNumbers.name());
                JOptionPane.showMessageDialog(this, Bundle.getMessage("MenuSpeedTable_CloseReopenWindow"));
            });
            rbMenuItem.setSelected(speedTableNumbers == speedTableNumbersSelection);
            speedTableSubMenu.add(rbMenuItem);
            SpeedTableNumbersGroup.add(rbMenuItem);
            ++n2;
        }
        this.tempPane = pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.enableReadButtons();
        this.l1 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaneProgFrame.this.prepGlassPane(PaneProgFrame.this.readChangesButton);
                    PaneProgFrame.this.readChangesButton.setText(Bundle.getMessage("ButtonStopReadChangesAll"));
                    PaneProgFrame.this.readChanges();
                } else {
                    if (PaneProgFrame.this._programmingPane != null) {
                        PaneProgFrame.this._programmingPane.stopProgramming();
                    }
                    PaneProgFrame.this.paneListIndex = PaneProgFrame.this.paneList.size();
                    PaneProgFrame.this.readChangesButton.setText(Bundle.getMessage("ButtonReadChangesAllSheets"));
                }
            }
        };
        this.readChangesButton.addItemListener(this.l1);
        this.l3 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaneProgFrame.this.prepGlassPane(PaneProgFrame.this.readAllButton);
                    PaneProgFrame.this.readAllButton.setText(Bundle.getMessage("ButtonStopReadAll"));
                    PaneProgFrame.this.readAll();
                } else {
                    if (PaneProgFrame.this._programmingPane != null) {
                        PaneProgFrame.this._programmingPane.stopProgramming();
                    }
                    PaneProgFrame.this.paneListIndex = PaneProgFrame.this.paneList.size();
                    PaneProgFrame.this.readAllButton.setText(Bundle.getMessage("ButtonReadAllSheets"));
                }
            }
        };
        this.readAllButton.addItemListener(this.l3);
        this.writeChangesButton.setToolTipText(Bundle.getMessage("TipWriteHighlightedValues"));
        this.l2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaneProgFrame.this.prepGlassPane(PaneProgFrame.this.writeChangesButton);
                    PaneProgFrame.this.writeChangesButton.setText(Bundle.getMessage("ButtonStopWriteChangesAll"));
                    PaneProgFrame.this.writeChanges();
                } else {
                    if (PaneProgFrame.this._programmingPane != null) {
                        PaneProgFrame.this._programmingPane.stopProgramming();
                    }
                    PaneProgFrame.this.paneListIndex = PaneProgFrame.this.paneList.size();
                    PaneProgFrame.this.writeChangesButton.setText(Bundle.getMessage("ButtonWriteChangesAllSheets"));
                }
            }
        };
        this.writeChangesButton.addItemListener(this.l2);
        this.writeAllButton.setToolTipText(Bundle.getMessage("TipWriteAllValues"));
        this.l4 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PaneProgFrame.this.prepGlassPane(PaneProgFrame.this.writeAllButton);
                    PaneProgFrame.this.writeAllButton.setText(Bundle.getMessage("ButtonStopWriteAll"));
                    PaneProgFrame.this.writeAll();
                } else {
                    if (PaneProgFrame.this._programmingPane != null) {
                        PaneProgFrame.this._programmingPane.stopProgramming();
                    }
                    PaneProgFrame.this.paneListIndex = PaneProgFrame.this.paneList.size();
                    PaneProgFrame.this.writeAllButton.setText(Bundle.getMessage("ButtonWriteAllSheets"));
                }
            }
        };
        this.writeAllButton.addItemListener(this.l4);
        pane.add((Component)this.tabPane, "Center");
        this.getContentPane().add(pane);
        this.addHelp();
    }

    void setProgrammingGui(JPanel bottom) {
        this.modePane = this.getModePane();
        if (this.modePane != null) {
            JPanel bottomButtons = new JPanel();
            bottomButtons.setLayout(new BoxLayout(bottomButtons, 0));
            bottomButtons.add(this.readChangesButton);
            bottomButtons.add(this.writeChangesButton);
            bottomButtons.add(this.readAllButton);
            bottomButtons.add(this.writeAllButton);
            bottom.add(bottomButtons);
            bottom.add(new JSeparator(0));
            JPanel temp = new JPanel();
            bottom.add(temp);
            temp.add(this.modePane);
        }
        bottom.add(new JSeparator(0));
        this.progStatus.setAlignmentX(0.5f);
        bottom.add(this.progStatus);
    }

    void setSearchGui(JPanel bottom) {
        this.searchBar = new SearchBar(this.searchForwardTask, this.searchBackwardTask, this.searchDoneTask);
        this.searchBar.setVisible(false);
        this.searchBar.configureKeyModifiers(this);
        bottom.add(this.searchBar);
    }

    protected void loadSearchTargets() {
        if (this.searchTargetList != null) {
            return;
        }
        this.searchTargetList = new ArrayList();
        for (JPanel p : this.getPaneList()) {
            Component[] componentArray = p.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                this.loadJPanel(c, p);
                ++n2;
            }
        }
        for (JPanel tab : this.getPaneList()) {
            this.searchTargetList.add(new SearchPair(null, tab));
        }
    }

    protected void loadJPanel(Component c, JPanel tab) {
        if (c instanceof JPanel) {
            Component[] componentArray = ((JPanel)c).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component d = componentArray[n2];
                this.loadJPanel(d, tab);
                ++n2;
            }
        } else if (c instanceof JScrollPane) {
            this.loadJPanel(((JScrollPane)c).getViewport().getView(), tab);
        } else if (c instanceof WatchingLabel) {
            this.searchTargetList.add(new SearchPair((WatchingLabel)c, tab));
        }
    }

    protected void searchDidNotFind() {
        Toolkit.getDefaultToolkit().beep();
    }

    protected void searchGoesTo(SearchPair result) {
        this.tabPane.setSelectedComponent(result.tab);
        if (result.label != null) {
            SwingUtilities.invokeLater(() -> searchPair.label.getWatched().requestFocus());
        } else {
            log.trace("search result set to tab {}", (Object)result.tab);
        }
    }

    private boolean checkSearchTarget(int index, String target) {
        boolean result = false;
        if (this.searchTargetList.get((int)index).label != null) {
            if (!this.searchTargetList.get((int)index).label.getText().toUpperCase().contains(target.toUpperCase())) {
                return false;
            }
            return this.searchTargetList.get((int)index).label.isShowing();
        }
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            if (this.tabPane.getComponentAt(i) == this.searchTargetList.get((int)index).tab) {
                result = this.tabPane.getTitleAt(i).toUpperCase().contains(target.toUpperCase());
            }
            ++i;
        }
        return result;
    }

    public List<JPanel> getPaneList() {
        return this.paneList;
    }

    void addHelp() {
        this.addHelpMenu("package.jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame", true);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension screen = this.getMaximumSize();
        int width = Math.min(super.getPreferredSize().width, screen.width);
        int height = Math.min(super.getPreferredSize().height, screen.height);
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension screen = this.getToolkit().getScreenSize();
        return new Dimension(screen.width, screen.height - 35);
    }

    void enableReadButtons() {
        this.readChangesButton.setToolTipText(Bundle.getMessage("TipReadChanges"));
        this.readAllButton.setToolTipText(Bundle.getMessage("TipReadAll"));
        if (this.cvModel != null && this.cvModel.getProgrammer() != null && !this.cvModel.getProgrammer().getCanRead()) {
            this.readChangesButton.setEnabled(false);
            this.readAllButton.setEnabled(false);
            this.readChangesButton.setToolTipText(Bundle.getMessage("TipNoRead"));
            this.readAllButton.setToolTipText(Bundle.getMessage("TipNoRead"));
        } else {
            this.readChangesButton.setEnabled(true);
            this.readAllButton.setEnabled(true);
        }
    }

    public PaneProgFrame(DecoderFile pDecoderFile, @Nonnull RosterEntry pRosterEntry, String pFrameTitle, String pProgrammerFile, Programmer pProg, boolean opsMode) {
        super(pFrameTitle);
        this._rosterEntry = pRosterEntry;
        this._opsMode = opsMode;
        this.filename = pProgrammerFile;
        this.mProgrammer = pProg;
        this.cvModel = new CvTableModel(this.progStatus, this.mProgrammer);
        this.variableModel = new VariableTableModel(this.progStatus, new String[]{"Name", "Value"}, this.cvModel);
        this.resetModel = new ResetTableModel(this.progStatus, this.mProgrammer);
        this._rosterEntry.setOpen(true);
        this.installComponents();
        if (this._rosterEntry.getFileName() != null) {
            this._rosterEntry.readFile();
        }
        if (pDecoderFile != null) {
            this.loadDecoderFile(pDecoderFile, this._rosterEntry);
        } else {
            this.loadDecoderFromLoco(pRosterEntry);
        }
        this.saveDefaults();
        if (this._rosterEntry.getFileName() != null) {
            this._rosterEntry.loadCvModel(this.variableModel, this.cvModel);
        }
        this.variableModel.setFileDirty(false);
        if ((!this._opsMode || this.resetModel.hasOpsModeReset()) && this.resetModel.getRowCount() > 0) {
            this.resetMenu.setEnabled(true);
        }
        if (pProg != null) {
            if (InstanceManager.getOptionalDefault(AddressedProgrammerManager.class).isPresent() || InstanceManager.getOptionalDefault(GlobalProgrammerManager.class).isPresent()) {
                Element programming = null;
                if (this.decoderRoot != null && (programming = this.decoderRoot.getChild("decoder").getChild("programming")) != null) {
                    Programmer pf = this.mProgrammer;
                    if (PaneProgFrame.getDoConfirmRead()) {
                        pf = new VerifyWriteProgrammerFacade(pf);
                        log.debug("adding VerifyWriteProgrammerFacade, new programmer is {}", (Object)pf);
                    }
                    pf = ProgrammerFacadeSelector.loadFacadeElements(programming, pf, PaneProgFrame.getCanCacheDefault(), pProg);
                    log.debug("added any other FacadeElements, new programmer is {}", (Object)pf);
                    this.mProgrammer = pf;
                    this.cvModel.setProgrammer(pf);
                    this.resetModel.setProgrammer(pf);
                    log.debug("Found programmer: {}", (Object)this.cvModel.getProgrammer());
                }
                if (programming != null) {
                    this.pickProgrammerMode(programming);
                    this.enableReadButtons();
                } else {
                    log.debug("Skipping programmer setup because found no programmer element");
                }
            } else {
                log.error("Can't set programming mode, no programmer instance");
            }
        }
        this.loadProgrammerFile(pRosterEntry);
        Attribute a = this.programmerRoot.getChild("programmer").getAttribute("decoderFilePanes");
        if (a != null && a.getValue().equals("yes") && this.decoderRoot != null) {
            if (log.isDebugEnabled()) {
                log.debug("will process {} pane definitions from decoder file", (Object)this.decoderPaneList.size());
            }
            int i = 0;
            while (i < this.decoderPaneList.size()) {
                String pname = LocaleSelector.getAttribute(this.decoderPaneList.get(i), "name");
                if (PaneProgFrame.isIncludedFE(this.decoderPaneList.get(i), this.modelElem, this._rosterEntry, "", "")) {
                    this.newPane(pname, this.decoderPaneList.get(i), this.modelElem, true, false);
                }
                ++i;
            }
        }
        JPanel bottom = new JPanel();
        bottom.setLayout(new BoxLayout(bottom, 1));
        this.tempPane.add((Component)bottom, "South");
        this.setProgrammingGui(bottom);
        this.setSearchGui(bottom);
        this.pack();
        if (log.isDebugEnabled()) {
            log.debug("PaneProgFrame \"{}\" constructed for file {}, unconstrained size is {}, constrained to {}", new Object[]{pFrameTitle, this._rosterEntry.getFileName(), super.getPreferredSize(), this.getPreferredSize()});
        }
    }

    public static boolean isIncludedFE(Element e, Element aModelElement, RosterEntry aRosterEntry, String extraIncludes, String extraExcludes) {
        String familyName;
        String modelName;
        String pID;
        try {
            pID = aModelElement.getAttribute("productID").getValue();
        }
        catch (Exception exception) {
            pID = null;
        }
        try {
            modelName = aModelElement.getAttribute("model").getValue();
        }
        catch (Exception exception) {
            modelName = null;
        }
        try {
            familyName = aRosterEntry.getDecoderFamily();
        }
        catch (Exception exception) {
            familyName = null;
        }
        return DecoderFile.isIncluded(e, pID, modelName, familyName, extraIncludes, extraExcludes);
    }

    protected void pickProgrammerMode(@Nonnull Element programming) {
        log.debug("pickProgrammerMode starts");
        boolean paged = true;
        boolean directbit = true;
        boolean directbyte = true;
        boolean register = true;
        Attribute a = programming.getAttribute("paged");
        if (a != null && a.getValue().equals("no")) {
            paged = false;
        }
        if ((a = programming.getAttribute("direct")) != null) {
            if (a.getValue().equals("no")) {
                directbit = false;
                directbyte = false;
            } else if (a.getValue().equals("bitOnly")) {
                directbit = true;
                directbyte = false;
            } else if (a.getValue().equals("byteOnly")) {
                directbit = false;
                directbyte = true;
            } else {
                directbit = true;
                directbyte = true;
            }
        }
        if ((a = programming.getAttribute("register")) != null && a.getValue().equals("no")) {
            register = false;
        }
        List<ProgrammingMode> modes = this.mProgrammer.getSupportedModes();
        if (log.isDebugEnabled()) {
            log.debug("XML specifies modes: P {} DBi {} Dby {} R {} now {}", new Object[]{paged, directbit, directbyte, register, this.mProgrammer.getMode()});
            log.debug("Programmer supports:");
            for (ProgrammingMode m : modes) {
                log.debug("   {} {}", (Object)m.getStandardName(), (Object)m.toString());
            }
        }
        StringBuilder desiredModes = new StringBuilder();
        for (Element el1 : programming.getChildren("mode")) {
            String name = el1.getText();
            if (desiredModes.length() > 0) {
                desiredModes.append(", ");
            }
            desiredModes.append(name);
            if (log.isDebugEnabled()) {
                log.debug(" mode {} was specified", (Object)name);
            }
            for (ProgrammingMode m : modes) {
                if (!name.equals(m.getStandardName())) continue;
                log.info("Programming mode selected: {} ({})", (Object)m.toString(), (Object)m.getStandardName());
                this.mProgrammer.setMode(m);
                return;
            }
        }
        if (modes.contains(ProgrammingMode.DIRECTMODE) && directbit && directbyte) {
            this.mProgrammer.setMode(ProgrammingMode.DIRECTMODE);
            log.debug("Set to DIRECTMODE");
        } else if (modes.contains(ProgrammingMode.DIRECTBITMODE) && directbit) {
            this.mProgrammer.setMode(ProgrammingMode.DIRECTBITMODE);
            log.debug("Set to DIRECTBITMODE");
        } else if (modes.contains(ProgrammingMode.DIRECTBYTEMODE) && directbyte) {
            this.mProgrammer.setMode(ProgrammingMode.DIRECTBYTEMODE);
            log.debug("Set to DIRECTBYTEMODE");
        } else if (modes.contains(ProgrammingMode.PAGEMODE) && paged) {
            this.mProgrammer.setMode(ProgrammingMode.PAGEMODE);
            log.debug("Set to PAGEMODE");
        } else if (modes.contains(ProgrammingMode.REGISTERMODE) && register) {
            this.mProgrammer.setMode(ProgrammingMode.REGISTERMODE);
            log.debug("Set to REGISTERMODE");
        } else {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorCannotSetMode", desiredModes.toString()), Bundle.getMessage("ErrorCannotSetModeTitle"), 0);
            log.warn("No acceptable mode found, leave as found");
        }
    }

    protected void loadDecoderFromLoco(RosterEntry r) {
        String decoderModel = r.getDecoderModel();
        String decoderFamily = r.getDecoderFamily();
        log.debug("selected loco uses decoder {} {}", (Object)decoderFamily, (Object)decoderModel);
        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, decoderFamily, null, null, null, decoderModel);
        log.debug("found {} matches", (Object)l.size());
        if (l.size() == 0) {
            log.debug("Loco uses {} {} decoder, but no such decoder defined", (Object)decoderFamily, (Object)decoderModel);
            l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, decoderModel);
            if (log.isDebugEnabled()) {
                log.debug("found {} matches without family key", (Object)l.size());
            }
        }
        if (l.size() > 0) {
            DecoderFile d = l.get(0);
            this.loadDecoderFile(d, r);
        } else if (decoderModel.equals("")) {
            log.debug("blank decoderModel requested, so nothing loaded");
        } else {
            log.warn("no matching \"{}\" decoder found for loco, no decoder info loaded", (Object)decoderModel);
        }
    }

    protected void loadDecoderFile(@Nonnull DecoderFile df, @Nonnull RosterEntry re) {
        if (df == null) {
            throw new IllegalArgumentException("loadDecoder file invoked with null object");
        }
        if (log.isDebugEnabled()) {
            log.debug("loadDecoderFile from {} {}", (Object)DecoderFile.fileLocation, (Object)df.getFileName());
        }
        try {
            this.decoderRoot = df.rootFromName(String.valueOf(DecoderFile.fileLocation) + df.getFileName());
        }
        catch (JDOMException e) {
            log.error("Exception while parsing decoder XML file: {}", (Object)df.getFileName(), (Object)e);
            return;
        }
        catch (IOException e) {
            log.error("Exception while reading decoder XML file: {}", (Object)df.getFileName(), (Object)e);
            return;
        }
        df.getProductID();
        df.loadVariableModel(this.decoderRoot.getChild("decoder"), this.variableModel);
        df.loadResetModel(this.decoderRoot.getChild("decoder"), this.resetModel);
        re.loadFunctions(this.decoderRoot.getChild("decoder").getChild("family").getChild("functionlabels"), "family");
        re.loadSounds(this.decoderRoot.getChild("decoder").getChild("family").getChild("soundlabels"), "family");
        if (this.decoderRoot.getAttribute("showEmptyPanes") != null) {
            log.debug("Found in decoder showEmptyPanes={}", (Object)this.decoderRoot.getAttribute("showEmptyPanes").getValue());
            this.decoderShowEmptyPanes = this.decoderRoot.getAttribute("showEmptyPanes").getValue();
        } else {
            this.decoderShowEmptyPanes = "";
        }
        log.debug("decoderShowEmptyPanes={}", (Object)this.decoderShowEmptyPanes);
        if (this.decoderRoot.getAttribute("allowResetDefaults") != null) {
            log.debug("Found in decoder allowResetDefaults={}", (Object)this.decoderRoot.getAttribute("allowResetDefaults").getValue());
            this.decoderAllowResetDefaults = this.decoderRoot.getAttribute("allowResetDefaults").getValue();
        } else {
            this.decoderAllowResetDefaults = "yes";
        }
        log.debug("decoderAllowResetDefaults={}", (Object)this.decoderAllowResetDefaults);
        this.modelElem = df.getModelElement();
        re.loadFunctions(this.modelElem.getChild("functionlabels"), "model");
        re.loadSounds(this.modelElem.getChild("soundlabels"), "model");
        Attribute a = this.modelElem.getAttribute("maxFnNum");
        if (a != null) {
            this.maxFnNumOld = re.getMaxFnNum();
            this.maxFnNumNew = a.getValue();
            if (!this.maxFnNumOld.equals(this.maxFnNumNew)) {
                if (!re.getId().equals(Bundle.getMessage("LabelNewDecoder"))) {
                    this.maxFnNumDirty = true;
                    log.info("maxFnNum for \"{}\" changed from {} to {}", new Object[]{re.getId(), this.maxFnNumOld, this.maxFnNumNew});
                    String message = MessageFormat.format(SymbolicProgBundle.getMessage("StatusMaxFnNumUpdated"), re.getDecoderFamily(), re.getDecoderModel(), this.maxFnNumNew);
                    this.progStatus.setText(message);
                }
                re.setMaxFnNum(this.maxFnNumNew);
            }
        }
    }

    protected void loadProgrammerFile(RosterEntry r) {
        XmlFile pf = new XmlFile(){};
        try {
            Attribute a;
            this.programmerRoot = pf.rootFromName(this.filename);
            if (this.programmerRoot.getChild("programmer").getAttribute("showEmptyPanes") != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found in programmer {}", (Object)this.programmerRoot.getChild("programmer").getAttribute("showEmptyPanes").getValue());
                }
                this.programmerShowEmptyPanes = this.programmerRoot.getChild("programmer").getAttribute("showEmptyPanes").getValue();
            } else {
                this.programmerShowEmptyPanes = "";
            }
            if (log.isDebugEnabled()) {
                log.debug("programmerShowEmptyPanes={}", (Object)this.programmerShowEmptyPanes);
            }
            if ((a = this.programmerRoot.getChild("programmer").getAttribute("decoderFilePanes")) != null && a.getValue().equals("yes") && this.decoderRoot != null) {
                this.decoderPaneList = this.decoderRoot.getChildren("pane");
            }
            this.readConfig(this.programmerRoot, r);
        }
        catch (JDOMException e) {
            log.error("exception parsing programmer file: {}", (Object)this.filename, (Object)e);
        }
        catch (IOException e) {
            log.error("exception reading programmer file: {}", (Object)this.filename, (Object)e);
        }
    }

    protected boolean checkDirtyDecoder() {
        if (log.isDebugEnabled()) {
            log.debug("Checking decoder dirty status. CV: {} variables:{}", (Object)this.cvModel.decoderDirty(), (Object)this.variableModel.decoderDirty());
        }
        return this.getModePane() != null && (this.cvModel.decoderDirty() || this.variableModel.decoderDirty());
    }

    protected boolean checkDirtyFile() {
        return this.variableModel.fileDirty() || this._rPane.guiChanged(this._rosterEntry) || this._flPane.guiChanged(this._rosterEntry) || this._rMPane.guiChanged(this._rosterEntry) || this.maxFnNumDirty;
    }

    protected void handleDirtyFile() {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        List<RosterEntry> l;
        int option;
        this.setDefaultCloseOperation(0);
        if (log.isDebugEnabled()) {
            log.debug("Checking decoder dirty status. CV: {} variables:{}", (Object)this.cvModel.decoderDirty(), (Object)this.variableModel.decoderDirty());
        }
        if (this.checkDirtyDecoder() && JOptionPane.showConfirmDialog(null, Bundle.getMessage("PromptCloseWindowNotWrittenDecoder"), Bundle.getMessage("PromptChooseOne"), 2) == 2) {
            return;
        }
        if (this.checkDirtyFile() && ((option = JOptionPane.showOptionDialog(null, Bundle.getMessage("PromptCloseWindowNotWrittenConfig"), Bundle.getMessage("PromptChooseOne"), 1, 2, null, new String[]{Bundle.getMessage("PromptSaveAndClose"), Bundle.getMessage("PromptClose"), Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("PromptSaveAndClose"))) == 0 ? !this.storeFile() : option == 2)) {
            return;
        }
        if (this.maxFnNumDirty && !this.maxFnNumOld.equals("")) {
            this._rosterEntry.setMaxFnNum(this.maxFnNumOld);
        }
        if ((l = Roster.getDefault().matchingList(null, null, null, null, null, null, Bundle.getMessage("LabelNewDecoder"))).size() > 0 && log.isDebugEnabled()) {
            log.debug("Removing {} <new loco> entries", (Object)l.size());
        }
        int x = l.size() + 1;
        while (l.size() > 0) {
            Roster.getDefault().removeEntry(l.get(0));
            l = Roster.getDefault().matchingList(null, null, null, null, null, null, Bundle.getMessage("LabelNewDecoder"));
            if (--x != 0) continue;
            log.error("We have tried to remove all the entries, however an error has occurred which has resulted in the entries not being deleted correctly");
            l = new ArrayList<RosterEntry>();
        }
        this.setDefaultCloseOperation(2);
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.decoderDirtyTask);
        this.decoderDirtyTask = null;
        InstanceManager.getDefault(ShutDownManager.class).deregister(this.fileDirtyTask);
        this.fileDirtyTask = null;
        super.windowClosing(e);
    }

    void readConfig(Element root, RosterEntry r) {
        Element base = root.getChild("programmer");
        if (base == null) {
            log.error("xml file top element is not programmer");
            return;
        }
        if (root.getChild("programmer").getAttribute("showRosterPane") != null) {
            if (root.getChild("programmer").getAttribute("showRosterPane").getValue().equals("no")) {
                this.makeInfoPane(r);
            } else {
                this.tabPane.addTab(Bundle.getMessage("ROSTER ENTRY"), this.makeInfoPane(r));
            }
        } else {
            this.tabPane.addTab(Bundle.getMessage("ROSTER ENTRY"), this.makeInfoPane(r));
        }
        if (root.getChild("programmer").getAttribute("showFnLanelPane").getValue().equals("yes")) {
            this.tabPane.addTab(Bundle.getMessage("FUNCTION LABELS"), this.makeFunctionLabelPane(r));
        } else {
            this.makeFunctionLabelPane(r);
        }
        if (root.getChild("programmer").getAttribute("showRosterMediaPane").getValue().equals("yes")) {
            this.tabPane.addTab(Bundle.getMessage("ROSTER MEDIA"), this.makeMediaPane(r));
        } else {
            this.makeMediaPane(r);
        }
        List progPaneList = base.getChildren("pane");
        if (log.isDebugEnabled()) {
            log.debug("will process {} pane definitions", (Object)progPaneList.size());
        }
        int i = 0;
        while (i < progPaneList.size()) {
            Element temp = (Element)progPaneList.get(i);
            List pnames = temp.getChildren("name");
            boolean isProgPane = true;
            if (pnames.size() > 0 && this.decoderPaneList != null && this.decoderPaneList.size() > 0) {
                String namePrimary = ((Element)pnames.get(0)).getValue();
                int j = this.decoderPaneList.size() - 1;
                while (j >= 0) {
                    String namePrimaryDecoder;
                    List dnames = this.decoderPaneList.get(j).getChildren("name");
                    if (dnames.size() > 0 && namePrimary.equals(namePrimaryDecoder = ((Element)dnames.get(0)).getValue())) {
                        temp = this.decoderPaneList.get(j);
                        this.decoderPaneList.remove(j);
                        isProgPane = false;
                    }
                    --j;
                }
            }
            String name = LocaleSelector.getAttribute(temp, "name");
            if (PaneProgFrame.isIncludedFE(temp, this.modelElem, this._rosterEntry, "", "")) {
                this.newPane(name, temp, this.modelElem, false, isProgPane);
            }
            ++i;
        }
    }

    protected void resetToDefaults() {
        int n = this.defaultCvValues.length;
        int i = 0;
        while (i < n) {
            CvValue cv = this.cvModel.getCvByNumber(this.defaultCvNumbers[i]);
            if (cv == null) {
                log.warn("Trying to set default in CV {} but didn't find the CV object", (Object)this.defaultCvNumbers[i]);
            } else {
                cv.setValue(this.defaultCvValues[i]);
            }
            ++i;
        }
    }

    protected void saveDefaults() {
        int n = this.cvModel.getRowCount();
        this.defaultCvValues = new int[n];
        this.defaultCvNumbers = new String[n];
        int i = 0;
        while (i < n) {
            CvValue cv = this.cvModel.getCvByRow(i);
            this.defaultCvValues[i] = cv.getValue();
            this.defaultCvNumbers[i] = cv.number();
            ++i;
        }
    }

    protected JPanel makeInfoPane(RosterEntry r) {
        JPanel outer = new JPanel();
        outer.setLayout(new BoxLayout(outer, 1));
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        JScrollPane scrollPane = new JScrollPane(body);
        this._rPane = new RosterEntryPane(r);
        this._rPane.setMaximumSize(this._rPane.getPreferredSize());
        body.add(this._rPane);
        JButton store = new JButton(Bundle.getMessage("ButtonSave"));
        store.setAlignmentX(0.5f);
        store.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneProgFrame.this.storeFile();
            }
        });
        JButton reset = new JButton(Bundle.getMessage("ButtonResetDefaults"));
        reset.setAlignmentX(0.5f);
        if (this.decoderAllowResetDefaults.equals("no")) {
            reset.setEnabled(false);
            reset.setToolTipText(Bundle.getMessage("TipButtonResetDefaultsDisabled"));
        } else {
            reset.setToolTipText(Bundle.getMessage("TipButtonResetDefaults"));
            reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PaneProgFrame.this.resetToDefaults();
                }
            });
        }
        int sizeX = Math.max(reset.getPreferredSize().width, store.getPreferredSize().width);
        int sizeY = Math.max(reset.getPreferredSize().height, store.getPreferredSize().height);
        store.setPreferredSize(new Dimension(sizeX, sizeY));
        reset.setPreferredSize(new Dimension(sizeX, sizeY));
        store.setToolTipText(this._rosterEntry.getFileName());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(store);
        buttons.add(reset);
        body.add(buttons);
        outer.add(scrollPane);
        PropertyChangeListener dccNews = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PaneProgFrame.this.updateDccAddress();
            }
        };
        this.primaryAddr = this.variableModel.findVar("Short Address");
        if (this.primaryAddr == null) {
            log.debug("DCC Address monitor didnt find a Short Address variable");
        } else {
            this.primaryAddr.addPropertyChangeListener(dccNews);
        }
        this.extendAddr = this.variableModel.findVar("Long Address");
        if (this.extendAddr == null) {
            log.debug("DCC Address monitor didnt find an Long Address variable");
        } else {
            this.extendAddr.addPropertyChangeListener(dccNews);
        }
        this.addMode = (EnumVariableValue)this.variableModel.findVar("Address Format");
        if (this.addMode == null) {
            log.debug("DCC Address monitor didnt find an Address Format variable");
        } else {
            this.addMode.addPropertyChangeListener(dccNews);
        }
        this.updateDccAddress();
        return outer;
    }

    protected JPanel makeFunctionLabelPane(RosterEntry r) {
        JPanel outer = new JPanel();
        outer.setLayout(new BoxLayout(outer, 1));
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        JScrollPane scrollPane = new JScrollPane(body);
        JLabel title = new JLabel(Bundle.getMessage("UseThisTabCustomize"));
        title.setAlignmentX(0.5f);
        body.add(title);
        body.add(new JLabel(" "));
        this._flPane = new FunctionLabelPane(r);
        body.add(this._flPane);
        JButton store = new JButton(Bundle.getMessage("ButtonSave"));
        store.setAlignmentX(0.5f);
        store.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneProgFrame.this.storeFile();
            }
        });
        store.setToolTipText(this._rosterEntry.getFileName());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(store);
        body.add(buttons);
        outer.add(scrollPane);
        return outer;
    }

    protected JPanel makeMediaPane(RosterEntry r) {
        JPanel outer = new JPanel();
        outer.setLayout(new BoxLayout(outer, 1));
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        JScrollPane scrollPane = new JScrollPane(body);
        JLabel title = new JLabel(Bundle.getMessage("UseThisTabMedia"));
        title.setAlignmentX(0.5f);
        body.add(title);
        body.add(new JLabel(" "));
        this._rMPane = new RosterMediaPane(r);
        this._rMPane.setMaximumSize(this._rMPane.getPreferredSize());
        body.add(this._rMPane);
        JButton store = new JButton(Bundle.getMessage("ButtonSave"));
        store.setAlignmentX(0.5f);
        store.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaneProgFrame.this.storeFile();
            }
        });
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.add(store);
        body.add(buttons);
        outer.add(scrollPane);
        return outer;
    }

    void updateDccAddress() {
        if (log.isDebugEnabled()) {
            log.debug("updateDccAddress: short {} long {} mode {}", new Object[]{this.primaryAddr == null ? "<null>" : this.primaryAddr.getValueString(), this.extendAddr == null ? "<null>" : this.extendAddr.getValueString(), this.addMode == null ? "<null>" : this.addMode.getValueString()});
        }
        new DccAddressVarHandler(this.primaryAddr, this.extendAddr, this.addMode){

            @Override
            protected void doPrimary() {
                PaneProgFrame.this.longMode = false;
                if (PaneProgFrame.this.primaryAddr != null && !PaneProgFrame.this.primaryAddr.getValueString().equals("")) {
                    PaneProgFrame.this.newAddr = PaneProgFrame.this.primaryAddr.getValueString();
                }
            }

            @Override
            protected void doExtended() {
                if (PaneProgFrame.this.extendAddr != null && !PaneProgFrame.this.extendAddr.getValueString().equals("")) {
                    PaneProgFrame.this.longMode = true;
                    PaneProgFrame.this.newAddr = PaneProgFrame.this.extendAddr.getValueString();
                }
            }
        };
        if (this.newAddr != null) {
            this._rPane.setDccAddress(this.newAddr);
            this._rPane.setDccAddressLong(this.longMode);
        }
    }

    public void newPane(String name, Element pane, Element modelElem, boolean enableEmpty, boolean programmerPane) {
        int index;
        if (log.isDebugEnabled()) {
            log.debug("newPane with enableEmpty {} showEmptyPanes {}", (Object)enableEmpty, (Object)this.isShowingEmptyPanes());
        }
        PaneProgPane p = new PaneProgPane(this, name, pane, this.cvModel, this.variableModel, modelElem, this._rosterEntry, programmerPane);
        p.setOpaque(true);
        if (enableEmpty || !p.cvList.isEmpty() || !p.varList.isEmpty()) {
            this.tabPane.addTab(name, p);
            index = this.tabPane.indexOfTab(name);
            this.tabPane.setToolTipTextAt(index, p.getToolTipText());
        } else if (this.isShowingEmptyPanes()) {
            this.tabPane.addTab(name, p);
            index = this.tabPane.indexOfTab(name);
            this.tabPane.setEnabledAt(index, true);
            this.tabPane.setToolTipTextAt(index, Bundle.getMessage("TipTabEmptyNoCategory"));
        } else {
            index = -1;
        }
        this.paneList.add(p);
        if (index >= 0) {
            this.processModifierElements(pane, p, this.variableModel, this.tabPane, index);
        }
    }

    protected void processModifierElements(Element e, final PaneProgPane pane, VariableTableModel model, final JTabbedPane tabPane, final int index) {
        QualifierAdder qa = new QualifierAdder(){

            @Override
            protected Qualifier createQualifier(VariableValue var, String relation, String value) {
                return new PaneQualifier(pane, var, Integer.parseInt(value), relation, tabPane, index);
            }

            @Override
            protected void addListener(PropertyChangeListener qc) {
                pane.addPropertyChangeListener(qc);
            }
        };
        qa.processModifierElements(e, model);
    }

    @Override
    public BusyGlassPane getBusyGlassPane() {
        return this.glassPane;
    }

    @Override
    public void prepGlassPane(AbstractButton activeButton) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        if (this.glassPane != null) {
            this.glassPane.dispose();
        }
        this.activeComponents.clear();
        this.activeComponents.add(activeButton);
        if (activeButton == this.readChangesButton || activeButton == this.readAllButton || activeButton == this.writeChangesButton || activeButton == this.writeAllButton) {
            int i;
            if (activeButton == this.readChangesButton) {
                i = 0;
                while (i < this.paneList.size()) {
                    this.activeComponents.add(((PaneProgPane)this.paneList.get((int)i)).readChangesButton);
                    ++i;
                }
            } else if (activeButton == this.readAllButton) {
                i = 0;
                while (i < this.paneList.size()) {
                    this.activeComponents.add(((PaneProgPane)this.paneList.get((int)i)).readAllButton);
                    ++i;
                }
            } else if (activeButton == this.writeChangesButton) {
                i = 0;
                while (i < this.paneList.size()) {
                    this.activeComponents.add(((PaneProgPane)this.paneList.get((int)i)).writeChangesButton);
                    ++i;
                }
            } else if (activeButton == this.writeAllButton) {
                i = 0;
                while (i < this.paneList.size()) {
                    this.activeComponents.add(((PaneProgPane)this.paneList.get((int)i)).writeAllButton);
                    ++i;
                }
            }
            i = 0;
            while (i < this.tabPane.getTabCount()) {
                rectangles.add(this.tabPane.getUI().getTabBounds(this.tabPane, i));
                ++i;
            }
        }
        this.glassPane = new BusyGlassPane(this.activeComponents, rectangles, this.getContentPane(), this);
        this.setGlassPane(this.glassPane);
    }

    @Override
    public void paneFinished() {
        log.debug("paneFinished with isBusy={}", (Object)this.isBusy());
        if (!this.isBusy()) {
            if (this.glassPane != null) {
                this.glassPane.setVisible(false);
                this.glassPane.dispose();
                this.glassPane = null;
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.enableButtons(true);
        }
    }

    @Override
    public void enableButtons(boolean stat) {
        log.debug("enableButtons({})", (Object)stat);
        if (stat) {
            this.enableReadButtons();
        } else {
            this.readChangesButton.setEnabled(false);
            this.readAllButton.setEnabled(false);
        }
        this.writeChangesButton.setEnabled(stat);
        this.writeAllButton.setEnabled(stat);
        if (this.modePane != null) {
            this.modePane.setEnabled(stat);
        }
    }

    @Override
    public boolean isBusy() {
        return this._busy;
    }

    private void setBusy(boolean stat) {
        log.debug("setBusy({})", (Object)stat);
        this._busy = stat;
        int i = 0;
        while (i < this.paneList.size()) {
            if (stat) {
                ((PaneProgPane)this.paneList.get(i)).enableButtons(false);
            } else {
                ((PaneProgPane)this.paneList.get(i)).enableButtons(true);
            }
            ++i;
        }
        if (!stat) {
            this.paneFinished();
        }
    }

    public boolean readChanges() {
        if (log.isDebugEnabled()) {
            log.debug("readChanges starts");
        }
        this.justChanges = true;
        int i = 0;
        while (i < this.paneList.size()) {
            ((PaneProgPane)this.paneList.get(i)).setToRead(this.justChanges, true);
            ++i;
        }
        this.setBusy(true);
        this.enableButtons(false);
        this.readChangesButton.setEnabled(true);
        this.glassPane.setVisible(true);
        this.paneListIndex = 0;
        return this.doRead();
    }

    public boolean readAll() {
        if (log.isDebugEnabled()) {
            log.debug("readAll starts");
        }
        this.justChanges = false;
        int i = 0;
        while (i < this.paneList.size()) {
            ((PaneProgPane)this.paneList.get(i)).setToRead(this.justChanges, true);
            ++i;
        }
        this.setBusy(true);
        this.enableButtons(false);
        this.readAllButton.setEnabled(true);
        this.glassPane.setVisible(true);
        this.paneListIndex = 0;
        return this.doRead();
    }

    boolean doRead() {
        this._read = true;
        while (this.paneListIndex < this.paneList.size()) {
            if (log.isDebugEnabled()) {
                log.debug("doRead on {}", (Object)this.paneListIndex);
            }
            this._programmingPane = (PaneProgPane)this.paneList.get(this.paneListIndex);
            this._programmingPane.addPropertyChangeListener(this);
            boolean running = this.justChanges ? this._programmingPane.readPaneChanges() : this._programmingPane.readPaneAll();
            ++this.paneListIndex;
            if (running) {
                if (log.isDebugEnabled()) {
                    log.debug("doRead expecting callback from readPane {}", (Object)this.paneListIndex);
                }
                return true;
            }
            this._programmingPane.removePropertyChangeListener(this);
        }
        this._programmingPane = null;
        this.enableButtons(true);
        this.setBusy(false);
        this.readChangesButton.setSelected(false);
        this.readAllButton.setSelected(false);
        if (log.isDebugEnabled()) {
            log.debug("doRead found nothing to do");
        }
        return false;
    }

    public boolean writeAll() {
        if (log.isDebugEnabled()) {
            log.debug("writeAll starts");
        }
        this.justChanges = false;
        int i = 0;
        while (i < this.paneList.size()) {
            ((PaneProgPane)this.paneList.get(i)).setToWrite(this.justChanges, true);
            ++i;
        }
        this.setBusy(true);
        this.enableButtons(false);
        this.writeAllButton.setEnabled(true);
        this.glassPane.setVisible(true);
        this.paneListIndex = 0;
        return this.doWrite();
    }

    public boolean writeChanges() {
        if (log.isDebugEnabled()) {
            log.debug("writeChanges starts");
        }
        this.justChanges = true;
        int i = 0;
        while (i < this.paneList.size()) {
            ((PaneProgPane)this.paneList.get(i)).setToWrite(this.justChanges, true);
            ++i;
        }
        this.setBusy(true);
        this.enableButtons(false);
        this.writeChangesButton.setEnabled(true);
        this.glassPane.setVisible(true);
        this.paneListIndex = 0;
        return this.doWrite();
    }

    boolean doWrite() {
        this._read = false;
        while (this.paneListIndex < this.paneList.size()) {
            if (log.isDebugEnabled()) {
                log.debug("doWrite starts on {}", (Object)this.paneListIndex);
            }
            this._programmingPane = (PaneProgPane)this.paneList.get(this.paneListIndex);
            this._programmingPane.addPropertyChangeListener(this);
            boolean running = this.justChanges ? this._programmingPane.writePaneChanges() : this._programmingPane.writePaneAll();
            ++this.paneListIndex;
            if (running) {
                if (log.isDebugEnabled()) {
                    log.debug("doWrite expecting callback from writePane {}", (Object)this.paneListIndex);
                }
                return true;
            }
            this._programmingPane.removePropertyChangeListener(this);
        }
        this._programmingPane = null;
        this.enableButtons(true);
        this.setBusy(false);
        this.writeChangesButton.setSelected(false);
        this.writeAllButton.setSelected(false);
        if (log.isDebugEnabled()) {
            log.debug("doWrite found nothing to do");
        }
        return false;
    }

    public void printPanes(boolean preview) {
        PrintRosterEntry pre = new PrintRosterEntry(this._rosterEntry, this.paneList, this._flPane, this._rMPane, this);
        pre.printPanes(preview);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (this._programmingPane == null) {
            log.warn("unexpected propertyChange: {}", (Object)e);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("property changed: {} new value: {}", (Object)e.getPropertyName(), e.getNewValue());
        }
        log.debug("check valid: {} {} {}", new Object[]{e.getSource() == this._programmingPane, !e.getPropertyName().equals("Busy"), ((Boolean)e.getNewValue()).equals(Boolean.FALSE)});
        if (e.getSource() == this._programmingPane && e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            if (log.isDebugEnabled()) {
                log.debug("end of a programming pane operation, remove");
            }
            this._programmingPane.removePropertyChangeListener(this);
            this._programmingPane = null;
            if (this._read && this.readChangesButton.isSelected()) {
                if (log.isDebugEnabled()) {
                    log.debug("restart readChanges");
                }
                this.doRead();
            } else if (this._read && this.readAllButton.isSelected()) {
                if (log.isDebugEnabled()) {
                    log.debug("restart readAll");
                }
                this.doRead();
            } else if (this.writeChangesButton.isSelected()) {
                if (log.isDebugEnabled()) {
                    log.debug("restart writeChanges");
                }
                this.doWrite();
            } else if (this.writeAllButton.isSelected()) {
                if (log.isDebugEnabled()) {
                    log.debug("restart writeAll");
                }
                this.doWrite();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("read/write end because button is lifted");
                }
                this.setBusy(false);
            }
        }
    }

    public boolean storeFile() {
        log.debug("storeFile starts");
        if (this._rPane.checkDuplicate()) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorDuplicateID"));
            return false;
        }
        this.updateDccAddress();
        this._rPane.update(this._rosterEntry);
        this._flPane.update(this._rosterEntry);
        this._rMPane.update(this._rosterEntry);
        if (this._rosterEntry.getId().equals("") || this._rosterEntry.getId().equals(Bundle.getMessage("LabelNewDecoder"))) {
            log.debug("storeFile without a filename; issued dialog");
            JOptionPane.showMessageDialog(this, Bundle.getMessage("PromptFillInID"));
            return false;
        }
        this._rosterEntry.ensureFilenameExists();
        String filename = this._rosterEntry.getFileName();
        this._rosterEntry.writeFile(this.cvModel, this.variableModel);
        this.variableModel.setFileDirty(false);
        this.maxFnNumDirty = false;
        FileUtil.createDirectory(FileUtil.getUserFilesPath());
        Roster.getDefault().writeRoster();
        this._rPane.updateGUI(this._rosterEntry);
        this.progStatus.setText(MessageFormat.format(Bundle.getMessage("StateSaveOK"), filename));
        return true;
    }

    @Override
    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose local");
        }
        this.readChangesButton.removeItemListener(this.l1);
        this.writeChangesButton.removeItemListener(this.l2);
        this.readAllButton.removeItemListener(this.l3);
        this.writeAllButton.removeItemListener(this.l4);
        if (this._programmingPane != null) {
            this._programmingPane.removePropertyChangeListener(this);
        }
        int i = 0;
        while (i < this.paneList.size()) {
            PaneProgPane p = (PaneProgPane)this.paneList.get(i);
            p.dispose();
            ++i;
        }
        this.paneList.clear();
        this._rPane.dispose();
        this._flPane.dispose();
        this._rMPane.dispose();
        this.variableModel.dispose();
        this.cvModel.dispose();
        if (this._rosterEntry != null) {
            this._rosterEntry.setOpen(false);
        }
        this.progStatus = null;
        this.cvModel = null;
        this.variableModel = null;
        this._rosterEntry = null;
        this._rPane = null;
        this._flPane = null;
        this._rMPane = null;
        this.paneList.clear();
        this.paneList = null;
        this._programmingPane = null;
        this.tabPane = null;
        this.readChangesButton = null;
        this.writeChangesButton = null;
        this.readAllButton = null;
        this.writeAllButton = null;
        if (log.isDebugEnabled()) {
            log.debug("dispose superclass");
        }
        this.removeAll();
        super.dispose();
    }

    public static void setShowEmptyPanes(boolean yes) {
        if (InstanceManager.getNullableDefault(ProgrammerConfigManager.class) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setShowEmptyPanes(yes);
        }
    }

    public static boolean getShowEmptyPanes() {
        return InstanceManager.getNullableDefault(ProgrammerConfigManager.class) == null ? true : InstanceManager.getDefault(ProgrammerConfigManager.class).isShowEmptyPanes();
    }

    private boolean isShowingEmptyPanes() {
        boolean temp = PaneProgFrame.getShowEmptyPanes();
        if (this.programmerShowEmptyPanes.equals("yes")) {
            temp = true;
        } else if (this.programmerShowEmptyPanes.equals("no")) {
            temp = false;
        }
        if (this.decoderShowEmptyPanes.equals("yes")) {
            temp = true;
        } else if (this.decoderShowEmptyPanes.equals("no")) {
            temp = false;
        }
        return temp;
    }

    public static void setShowCvNumbers(boolean yes) {
        if (InstanceManager.getNullableDefault(ProgrammerConfigManager.class) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setShowCvNumbers(yes);
        }
    }

    public static boolean getShowCvNumbers() {
        return InstanceManager.getNullableDefault(ProgrammerConfigManager.class) == null ? true : InstanceManager.getDefault(ProgrammerConfigManager.class).isShowCvNumbers();
    }

    public static void setCanCacheDefault(boolean yes) {
        if (InstanceManager.getNullableDefault(ProgrammerConfigManager.class) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setCanCacheDefault(yes);
        }
    }

    public static boolean getCanCacheDefault() {
        return InstanceManager.getNullableDefault(ProgrammerConfigManager.class) == null ? true : InstanceManager.getDefault(ProgrammerConfigManager.class).isCanCacheDefault();
    }

    public static void setDoConfirmRead(boolean yes) {
        if (InstanceManager.getNullableDefault(ProgrammerConfigManager.class) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setDoConfirmRead(yes);
        }
    }

    public static boolean getDoConfirmRead() {
        return InstanceManager.getNullableDefault(ProgrammerConfigManager.class) == null ? true : InstanceManager.getDefault(ProgrammerConfigManager.class).isDoConfirmRead();
    }

    public RosterEntry getRosterEntry() {
        return this._rosterEntry;
    }

    static class SearchPair {
        WatchingLabel label;
        JPanel tab;

        SearchPair(WatchingLabel label, @Nonnull JPanel tab) {
            this.label = label;
            this.tab = tab;
        }
    }
}

