/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.tabbedframe;

import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.JPanel;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaneOpsProgFrame
extends PaneProgFrame {
    JPanel modePane;
    private static final Logger log = LoggerFactory.getLogger(PaneOpsProgFrame.class);

    @Override
    protected JPanel getModePane() {
        if (this.modePane == null) {
            this.modePane = new JPanel();
        }
        return this.modePane;
    }

    public PaneOpsProgFrame(DecoderFile decoderFile, RosterEntry r, String name, String file, Programmer p) {
        super(decoderFile, r, name, file, p, true);
        if (log.isDebugEnabled()) {
            log.debug("PaneOpsProgFrame \"{}\" constructed", (Object)name);
        }
    }

    @Override
    void addHelp() {
        this.addHelpMenu("package.jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame", true);
    }

    @Override
    protected void pickProgrammerMode(@Nonnull Element programming) {
        List<ProgrammingMode> modes = this.mProgrammer.getSupportedModes();
        if (log.isDebugEnabled()) {
            log.debug("Programmer supports:");
            for (ProgrammingMode m : modes) {
                log.debug("   {} {}", (Object)m.getStandardName(), (Object)m.toString());
            }
        }
        for (Element el1 : programming.getChildren("mode")) {
            String name = el1.getText();
            if (log.isDebugEnabled()) {
                log.debug(" mode {} was specified", (Object)name);
            }
            for (ProgrammingMode m : modes) {
                if (!name.equals(m.getStandardName())) continue;
                log.info("Programming mode selected: {} ({})", (Object)m.toString(), (Object)m.getStandardName());
                this.mProgrammer.setMode(m);
                return;
            }
        }
        log.debug("Leaving mode as is, supposed to be ops mode");
    }

    @Override
    public void dispose() {
        if (log.isDebugEnabled()) {
            log.debug("dispose local");
        }
        super.dispose();
    }
}

