/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.configurexml;

import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.symbolicprog.ProgrammerConfigManager;
import jmri.jmrit.symbolicprog.ProgrammerConfigPane;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgrammerConfigPaneXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(ProgrammerConfigPaneXml.class);

    @Override
    public Element store(Object o) {
        ProgrammerConfigPane p = (ProgrammerConfigPane)o;
        Element programmer = new Element("programmer");
        if (p.getSelectedItem() != null) {
            programmer.setAttribute("defaultFile", p.getSelectedItem());
        }
        programmer.setAttribute("verifyBeforeWrite", "no");
        if (!p.getShowEmptyTabs()) {
            programmer.setAttribute("showEmptyPanes", "no");
        }
        if (p.getShowCvNums()) {
            programmer.setAttribute("showCvNumbers", "yes");
        }
        if (p.getCanCacheDefault()) {
            programmer.setAttribute("canCacheDefault", "yes");
        } else {
            programmer.setAttribute("canCacheDefault", "no");
        }
        if (p.getDoConfirmRead()) {
            programmer.setAttribute("doConfirmRead", "yes");
        } else {
            programmer.setAttribute("doConfirmRead", "no");
        }
        programmer.setAttribute("class", this.getClass().getName());
        return programmer;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        ConfigureManager cm;
        Attribute a;
        boolean result = true;
        if (shared.getAttribute("defaultFile") != null) {
            if (log.isDebugEnabled()) {
                log.debug("set programmer default file: {}", (Object)shared.getAttribute("defaultFile").getValue());
            }
            InstanceManager.getDefault(ProgrammerConfigManager.class).setDefaultFile(shared.getAttribute("defaultFile").getValue());
        }
        if ((a = shared.getAttribute("showEmptyPanes")) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setShowEmptyPanes(!a.getValue().equals("no"));
        }
        if ((a = shared.getAttribute("showCvNumbers")) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setShowCvNumbers(a.getValue().equals("yes"));
        }
        if ((a = shared.getAttribute("canCacheDefault")) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setCanCacheDefault(a.getValue().equals("yes"));
        }
        if ((a = shared.getAttribute("doConfirmRead")) != null) {
            InstanceManager.getDefault(ProgrammerConfigManager.class).setDoConfirmRead(a.getValue().equals("yes"));
        }
        if ((cm = InstanceManager.getNullableDefault(ConfigureManager.class)) != null) {
            cm.registerPref(new ProgrammerConfigPane());
        }
        return result;
    }

    @Override
    public void load(Element element, Object o) {
        log.warn("unexpected call of 2nd load form");
    }
}

