/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog.autospeed;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterMenu;
import jmri.jmrit.symbolicprog.KnownLocoSelPane;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSpeedAction
extends AbstractAction {
    Object o1;
    Object o2;
    Object o3;
    Object o4;
    JLabel statusLabel = new JLabel("idle");
    private static final Logger log = LoggerFactory.getLogger(AutoSpeedAction.class);

    public AutoSpeedAction(String s) {
        super(s);
        if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) == null || !InstanceManager.getDefault(AddressedProgrammerManager.class).isAddressedModePossible()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (log.isInfoEnabled()) {
            log.debug("auto speed tool requested");
        }
        final JFrame f = new JFrame("Auto-speed Tool Setup");
        f.getContentPane().setLayout(new BoxLayout(f.getContentPane(), 1));
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(new RosterMenu("Roster", 1, f));
        f.setJMenuBar(menuBar);
        KnownLocoSelPane pane1 = new KnownLocoSelPane(false){

            @Override
            protected void startProgrammer(DecoderFile decoderFile, RosterEntry re, String filename) {
                String title = "Set speed info for " + re.getId() + " on main track";
                int address = Integer.parseInt(re.getDccAddress());
                boolean longAddr = true;
                if (address < 100) {
                    longAddr = false;
                }
                AddressedProgrammer programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(longAddr, address);
                PaneOpsProgFrame p = new PaneOpsProgFrame(decoderFile, re, title, "programmers" + File.separator + filename + ".xml", programmer);
                ((Window)p).pack();
                p.setVisible(true);
                f.setVisible(false);
                f.dispose();
            }
        };
        pane1.setAlignmentX(0.5f);
        f.getContentPane().add(pane1);
        f.pack();
        if (log.isInfoEnabled()) {
            log.debug("setup created");
        }
        f.setVisible(true);
    }
}

