/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VariableValue
extends AbstractValue
implements PropertyChangeListener {
    private String _label;
    private String _item;
    private String _cvName;
    protected HashMap<String, CvValue> _cvMap;
    protected JLabel _status = null;
    protected String _tooltipText = null;
    private String _comment;
    private boolean _readOnly;
    private boolean _infoOnly;
    private boolean _writeOnly;
    private boolean _opsOnly;
    private String _cvNum;
    private String _mask;
    private int _state = 0;
    private boolean _busy = false;
    private static final Logger log = LoggerFactory.getLogger(VariableValue.class);

    public abstract Component getCommonRep();

    public abstract Component getNewRep(String var1);

    public abstract String getValueString();

    public abstract Object getValueObject();

    public String getTextValue() {
        return this.getValueString();
    }

    public String getCvDescription() {
        return "CV" + this._cvNum;
    }

    public abstract void setIntValue(int var1);

    public void setValue(String value) {
        try {
            int val = Integer.parseInt(value);
            this.setIntValue(val);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("skipping set of non-integer value \"{}\"", (Object)value);
        }
    }

    public abstract int getIntValue();

    public long getLongValue() {
        return Integer.toUnsignedLong(this.getIntValue());
    }

    void updatedTextField() {
        log.error("unexpected use of updatedTextField()", (Throwable)new Exception("traceback"));
    }

    public abstract void readAll();

    public abstract void writeAll();

    public void confirmAll() {
        log.error("should never execute this");
    }

    public abstract void readChanges();

    public abstract void writeChanges();

    public abstract boolean isChanged();

    public static boolean considerChanged(CvValue c) {
        if (c == null) {
            return false;
        }
        int state = c.getState();
        return state == 4 || state == 0;
    }

    @Override
    public abstract void propertyChange(PropertyChangeEvent var1);

    public abstract void dispose();

    public abstract Object rangeVal();

    public VariableValue(String label, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, HashMap<String, CvValue> v, JLabel status, String item) {
        this._label = label;
        this._comment = comment;
        this._cvName = cvName;
        this._readOnly = readOnly;
        this._infoOnly = infoOnly;
        this._writeOnly = writeOnly;
        this._opsOnly = opsOnly;
        this._cvNum = cvNum;
        this._mask = mask;
        this._cvMap = v;
        this._status = status;
        this._item = item;
    }

    protected VariableValue() {
    }

    public String label() {
        return this._label;
    }

    public String item() {
        return this._item;
    }

    public String cvName() {
        return this._cvName;
    }

    public void setToolTipText(String t) {
        this._tooltipText = t;
    }

    protected JComponent updateRepresentation(JComponent c) {
        c.setToolTipText(this._tooltipText);
        c.setVisible(this.getAvailable());
        return c;
    }

    public String getComment() {
        return this._comment;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public boolean getInfoOnly() {
        return this._infoOnly;
    }

    public boolean getWriteOnly() {
        return this._writeOnly;
    }

    public boolean getOpsOnly() {
        return this._opsOnly;
    }

    public String getCvNum() {
        return this._cvNum;
    }

    public String getCvName() {
        return this._cvName;
    }

    public String getMask() {
        return this._mask;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int state) {
        switch (state) {
            case 0: {
                this.setColor(COLOR_UNKNOWN);
                break;
            }
            case 4: {
                this.setColor(COLOR_EDITED);
                break;
            }
            case 16: {
                this.setColor(COLOR_READ);
                break;
            }
            case 64: {
                this.setColor(COLOR_STORED);
                break;
            }
            case 256: {
                this.setColor(COLOR_FROMFILE);
                break;
            }
            case 512: {
                this.setColor(COLOR_SAME);
                break;
            }
            case 1024: {
                this.setColor(COLOR_DIFF);
                break;
            }
            default: {
                log.error("Inconsistent state: {}", (Object)this._state);
            }
        }
        if (this._state != state || this._state == 0) {
            this.prop.firePropertyChange("State", (Object)this._state, (Object)state);
        }
        this._state = state;
    }

    @Override
    public void setToRead(boolean state) {
        boolean newState = state;
        if (!this.getAvailable() && !state) {
            log.debug("Variable not available, skipping setToRead(false) to leave as is");
            return;
        }
        if (this.getInfoOnly() || this.getWriteOnly()) {
            newState = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("setToRead({}) with overrides {},{},{} sets {}", new Object[]{state, this.getInfoOnly(), this.getWriteOnly(), !this.getAvailable(), newState});
        }
        if (this.getCvNum() == null || this.getCvNum().equals("")) {
            log.debug("no CV defined for value {}. setToRead skipped", (Object)this._item);
            return;
        }
        this._cvMap.get(this.getCvNum()).setToRead(newState);
    }

    @Override
    public boolean isToRead() {
        if (this._cvMap.get(this.getCvNum()) != null) {
            return this._cvMap.get(this.getCvNum()).isToRead();
        }
        return false;
    }

    @Override
    public void setToWrite(boolean state) {
        CvValue cvVal;
        boolean newState = state;
        if (!this.getAvailable() && !state) {
            log.debug("Variable not available, skipping setToRead(false) to leave as is");
            return;
        }
        if (this.getInfoOnly() || this.getReadOnly()) {
            newState = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("setToRead({}) with overrides {},{},{} sets {}", new Object[]{state, this.getInfoOnly(), this.getWriteOnly(), !this.getAvailable(), newState});
        }
        try {
            cvVal = this._cvMap.get(this.getCvNum());
        }
        catch (NullPointerException nullPointerException) {
            log.error("no CV defined for value {}. setToWrite skipped. Verify variable was defined", (Object)this._item);
            return;
        }
        if (cvVal != null) {
            cvVal.setToWrite(newState);
        }
    }

    @Override
    public boolean isToWrite() {
        if (this._cvMap.get(this.getCvNum()) != null) {
            return this._cvMap.get(this.getCvNum()).isToWrite();
        }
        return false;
    }

    public abstract void setCvState(int var1);

    public boolean isBusy() {
        return this._busy;
    }

    protected void setBusy(boolean newBusy) {
        boolean oldBusy = this._busy;
        this._busy = newBusy;
        if (newBusy != oldBusy) {
            this.prop.firePropertyChange("Busy", (Object)oldBusy, (Object)newBusy);
        }
    }

    protected void simplifyMask() {
        if (this._mask != null && this._mask.contains(" ")) {
            log.debug("Mask for var {} was:{}", (Object)this.getCvName(), (Object)this._mask);
            this._mask = this._mask.split(" ")[0];
            log.debug("Mask1 for var {} is:{}", (Object)this.getCvName(), (Object)this._mask);
        }
    }

    protected int maskValAsInt(String maskString) {
        int mask = 0;
        int i = 0;
        while (i < maskString.length()) {
            mask <<= 1;
            try {
                if (maskString.charAt(i) == 'V') {
                    mask |= 1;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                log.error("mask \"{}\" could not be handled for variable {}", (Object)maskString, (Object)this.label());
            }
            ++i;
        }
        return mask;
    }

    protected boolean isBitMask(String mask) {
        return mask.isEmpty() || mask.startsWith("X") || mask.startsWith("V");
    }

    protected int offsetVal(String maskString) {
        int offset = 0;
        int i = 0;
        while (i < maskString.length()) {
            if (maskString.charAt(i) == 'V') {
                offset = maskString.length() - 1 - i;
            }
            ++i;
        }
        return offset;
    }

    protected int getValueInCV(int Cv, String maskString, int maxVal) {
        if (this.isBitMask(maskString)) {
            return (Cv & this.maskValAsInt(maskString)) >>> this.offsetVal(maskString);
        }
        int radix = Integer.parseInt(maskString);
        log.trace("get value {} radix {} returns {}", new Object[]{Cv, radix, Cv / radix});
        return Cv / radix % (maxVal + 1);
    }

    protected int setValueInCV(int oldCv, int newVal, String maskString, int maxVal) {
        if (this.isBitMask(maskString)) {
            int mask = this.maskValAsInt(maskString);
            int offset = this.offsetVal(maskString);
            return (oldCv & ~mask) + (newVal << offset & mask);
        }
        int radix = Integer.parseInt(maskString);
        int lowPart = oldCv % radix;
        int newPart = newVal % (maxVal + 1) * radix;
        int highPart = oldCv / (radix * (maxVal + 1)) * (radix * (maxVal + 1));
        int retval = highPart + newPart + lowPart;
        log.trace("Set sees oldCv {} radix {}, lowPart {}, newVal {}, highPart {}, does {}", new Object[]{oldCv, radix, lowPart, newVal, highPart, retval});
        return retval;
    }

    public abstract CvValue[] usesCVs();
}

