/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueEditor
extends JComboBox<Object>
implements TableCellEditor,
FocusListener {
    protected transient Vector<CellEditorListener> listeners = new Vector();
    protected transient String originalValue = null;
    protected Object mValue;
    private static final Logger log = LoggerFactory.getLogger(ValueEditor.class);

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.mValue = value;
        if (log.isDebugEnabled()) {
            log.debug("getTableCellEditorComponent {} {} {} {}", new Object[]{row, column, isSelected, value.getClass()});
        }
        table.setRowSelectionInterval(row, row);
        table.setColumnSelectionInterval(column, column);
        if (value instanceof Component) {
            if (value instanceof JTextField) {
                JTextField tempField = (JTextField)value;
                this.originalValue = tempField.getText();
                tempField.addFocusListener(this);
                return tempField;
            }
            return (Component)value;
        }
        if (value instanceof String) {
            return new JLabel((String)value);
        }
        return new JLabel("Unknown value type!");
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("focusGained");
        }
        if (this.mValue instanceof JTextField) {
            JTextField tempField = (JTextField)this.mValue;
            this.originalValue = tempField.getText();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("focusLost");
        }
        if (!(this.mValue instanceof JTextField) || !this.originalValue.equals(((JTextField)this.mValue).getText())) {
            this.fireEditingStopped();
        }
    }

    void removeFocusListener() {
        if (this.mValue instanceof JTextField) {
            JTextField tempField = (JTextField)this.mValue;
            this.originalValue = null;
            tempField.removeFocusListener(this);
        }
    }

    @Override
    public void cancelCellEditing() {
        if (log.isDebugEnabled()) {
            log.debug("cancelCellEditing");
        }
        this.removeFocusListener();
        this.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        if (log.isDebugEnabled()) {
            log.debug("getCellEditorValue with 'value' object of type {}", this.mValue.getClass());
        }
        if (this.mValue instanceof JTextField) {
            return Integer.valueOf(((JTextField)this.mValue).getText());
        }
        if (this.mValue instanceof Component) {
            return this.mValue;
        }
        log.error("getCellEditorValue unable to return a value from unknown type {}", this.mValue.getClass());
        return null;
    }

    @Override
    public boolean isCellEditable(EventObject eo) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject eo) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (log.isDebugEnabled()) {
            log.debug("stopCellEditing");
        }
        this.removeFocusListener();
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener cel) {
        this.listeners.addElement(cel);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener cel) {
        this.listeners.removeElement(cel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEditingCanceled() {
        Vector<CellEditorListener> local;
        if (log.isDebugEnabled()) {
            log.debug("fireEditingCancelled, but we are not setting back the old value");
        }
        Vector<CellEditorListener> vector = this.listeners;
        synchronized (vector) {
            local = new Vector<CellEditorListener>(this.listeners);
        }
        ChangeEvent ce = new ChangeEvent(this);
        int i = local.size() - 1;
        while (i >= 0) {
            local.elementAt(i).editingCanceled(ce);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEditingStopped() {
        Vector<CellEditorListener> local;
        if (log.isDebugEnabled()) {
            log.debug("fireEditingStopped");
        }
        Vector<CellEditorListener> vector = this.listeners;
        synchronized (vector) {
            local = new Vector<CellEditorListener>(this.listeners);
        }
        ChangeEvent ce = new ChangeEvent(this);
        int i = local.size() - 1;
        while (i >= 0) {
            local.elementAt(i).editingStopped(ce);
            --i;
        }
    }
}

