/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitVariableValue
extends VariableValue
implements ActionListener,
FocusListener {
    private static final int RETRY_COUNT = 2;
    String mSecondCV;
    String _uppermask;
    int mFactor;
    int mOffset;
    String _name;
    String _mask;
    String[] _maskArray = new String[0];
    String _cvNum;
    List<CvItem> cvList;
    int cvCount = 0;
    int currentOffset = 0;
    long _minVal = 0L;
    long _maxVal = -1L;
    String oldContents = "0";
    boolean _fieldShrink = false;
    Color _defaultColor;
    int _columns = 1;
    List<Component> reps = new ArrayList<Component>();
    private int retry = 0;
    private int _progState = 0;
    private static final int IDLE = 0;
    private static final int READING_FIRST = 1;
    private static final int WRITING_FIRST = -1;
    private static final int bitCount = Long.bitCount(-1L);
    private static final long intMask = Integer.toUnsignedLong(-1);
    JTextField _textField = null;
    private static final Logger log = LoggerFactory.getLogger(SplitVariableValue.class);

    public SplitVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this.stepOneActions(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
        this._name = name;
        this._mask = mask;
        if (mask != null && mask.contains(" ")) {
            this._maskArray = mask.split(" ");
        } else {
            this._maskArray = new String[1];
            this._maskArray[0] = mask;
        }
        this._cvNum = cvNum;
        this._textField = new JTextField("0");
        this._defaultColor = this._textField.getBackground();
        this._textField.setBackground(COLOR_UNKNOWN);
        this.mFactor = pFactor;
        this.mOffset = pOffset;
        this.mSecondCV = pSecondCV;
        this._uppermask = uppermask;
        this._textField.addActionListener(this);
        this._textField.addFocusListener(this);
        log.debug("Variable={};comment={};cvName={};cvNum={};stdname={}", new Object[]{this._name, comment, cvName, this._cvNum, stdname});
        log.debug("Variable={}; upper mask {} had offsetVal={} so upperbitoffset={}", new Object[]{this._name, this._uppermask, this.offsetVal(this._uppermask), this.offsetVal(this._uppermask)});
        this.cvList = new ArrayList<CvItem>();
        List<String> nameList = CvUtil.expandCvList(this._cvNum);
        if (nameList.isEmpty()) {
            String tMask;
            if (this._maskArray != null && this._maskArray.length == 1) {
                log.debug("PrimaryCV mask={}", (Object)this._maskArray[0]);
                tMask = this._maskArray[0];
            } else {
                tMask = this._mask;
            }
            this.cvList.add(new CvItem(this._cvNum, tMask));
            if (pSecondCV != null && !pSecondCV.equals("")) {
                this.cvList.add(new CvItem(pSecondCV, this._uppermask));
            }
        } else {
            int i = 0;
            while (i < nameList.size()) {
                this.cvList.add(new CvItem(nameList.get(i), this._maskArray[Math.min(i, this._maskArray.length - 1)]));
                log.debug("Added mask #{}: {}", (Object)i, (Object)this._maskArray[Math.min(i, this._maskArray.length - 1)]);
                ++i;
            }
        }
        this.cvCount = this.cvList.size();
        int i = 0;
        while (i < this.cvCount) {
            CvValue cv;
            this.cvList.get((int)i).startOffset = this.currentOffset;
            String t = this.cvList.get((int)i).cvMask;
            if (t.contains("V")) {
                this.currentOffset = this.currentOffset + t.lastIndexOf("V") - t.indexOf("V") + 1;
            } else {
                log.error("Variable={};cvName={};cvMask={} is an invalid bitmask", new Object[]{this._name, this.cvList.get((int)i).cvName, this.cvList.get((int)i).cvMask});
            }
            log.debug("Variable={};cvName={};cvMask={};startOffset={};currentOffset={}", new Object[]{this._name, this.cvList.get((int)i).cvName, this.cvList.get((int)i).cvMask, this.cvList.get((int)i).startOffset, this.currentOffset});
            this.cvList.get((int)i).thisCV = cv = (CvValue)this._cvMap.get(this.cvList.get((int)i).cvName);
            ++i;
        }
        this.stepTwoActions();
        this._textField.setColumns(this._columns);
        i = 0;
        while (i < this.cvCount) {
            this.cvList.get((int)i).thisCV.addPropertyChangeListener(this);
            this.cvList.get((int)i).thisCV.setState(256);
            ++i;
        }
    }

    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        if (extra3 != null) {
            this._minVal = this.getValueFromText(extra3);
        }
        if (extra4 != null) {
            this._maxVal = this.getValueFromText(extra4);
        }
    }

    public void stepTwoActions() {
        if (this.currentOffset > bitCount) {
            String eol = System.getProperty("line.separator");
            throw new Error("Decoder File parsing error:" + eol + "The Decoder Definition File specified \"" + this._cvNum + "\" for variable \"" + this._name + "\". This expands to:" + eol + "\"" + this.getCvDescription() + "\"" + eol + "This requires " + this.currentOffset + " bits, which exceeds the " + bitCount + " bit capacity of the long integer used to store the variable." + eol + "The Decoder Definition File needs correction.");
        }
        this._columns = this.cvCount * 2;
    }

    @Override
    public CvValue[] usesCVs() {
        CvValue[] theseCvs = new CvValue[this.cvCount];
        int i = 0;
        while (i < this.cvCount) {
            theseCvs[i] = this.cvList.get((int)i).thisCV;
            ++i;
        }
        return theseCvs;
    }

    @Override
    public String getMask() {
        if (this.mSecondCV != null && !this.mSecondCV.equals("")) {
            return String.valueOf(this._uppermask) + this._mask;
        }
        return this._mask;
    }

    protected String getMask(int i) {
        if (i < this.cvCount) {
            return this.cvList.get((int)i).cvMask;
        }
        return "";
    }

    @Override
    public String getCvDescription() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.cvCount) {
            if (buf.length() > 0) {
                buf.append(" & ");
            }
            buf.append("CV");
            buf.append(this.cvList.get((int)i).cvName);
            String temp = CvUtil.getMaskDescription(this.cvList.get((int)i).cvMask);
            if (temp.length() > 0) {
                buf.append(" ");
                buf.append(temp);
            }
            ++i;
        }
        buf.append(".");
        return buf.toString();
    }

    @Override
    public String getCvNum() {
        String retString = "";
        if (this.cvCount > 0) {
            retString = this.cvList.get((int)0).cvName;
        }
        return retString;
    }

    @Deprecated
    public String getSecondCvNum() {
        String retString = "";
        if (this.cvCount > 1) {
            retString = this.cvList.get((int)1).cvName;
        }
        return retString;
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._textField.setToolTipText(t);
    }

    @Override
    public Object rangeVal() {
        return "Split value";
    }

    long getValueFromText(String s) {
        return Long.parseUnsignedLong(s);
    }

    String getTextFromValue(long v) {
        return Long.toUnsignedString(v);
    }

    int[] getCvValsFromTextField() {
        long newEntry;
        try {
            newEntry = this.getValueFromText(this._textField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            newEntry = 0L;
        }
        long newVal = (newEntry - (long)this.mOffset) / (long)this.mFactor;
        log.debug("Variable={};newEntry={};newVal={} with Offset={} + Factor={} applied", new Object[]{this._name, newEntry, newVal, this.mOffset, this.mFactor});
        int[] retVals = new int[this.cvCount];
        int i = 0;
        while (i < this.cvCount) {
            retVals[i] = (int)(newVal >>> this.cvList.get((int)i).startOffset) & this.maskValAsInt(this.cvList.get((int)i).cvMask) >>> this.offsetVal(this.cvList.get((int)i).cvMask);
            ++i;
        }
        return retVals;
    }

    void updateVariableValue(int[] intVals) {
        long newVal = 0L;
        int i = 0;
        while (i < intVals.length) {
            log.debug("Variable={}; i={}; newVal={}", new Object[]{this._name, i, this.getTextFromValue(newVal |= (long)intVals[i] << this.cvList.get((int)i).startOffset)});
            ++i;
        }
        log.debug("Variable={}; set value to {}", (Object)this._name, (Object)newVal);
        this.setLongValue(newVal);
        log.debug("Variable={}; in property change after setValue call", (Object)this._name);
    }

    void enterField() {
        this.oldContents = this._textField.getText();
    }

    void exitField() {
        if (this._textField != null && !this.oldContents.equals(this._textField.getText())) {
            long newFieldVal = 0L;
            try {
                newFieldVal = this.getValueFromText(this._textField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this._textField.setText(this.oldContents);
            }
            log.debug("_minVal={};_maxVal={};newFieldVal={}", new Object[]{Long.toUnsignedString(this._minVal), Long.toUnsignedString(this._maxVal), Long.toUnsignedString(newFieldVal)});
            if (Long.compareUnsigned(newFieldVal, this._minVal) < 0 || Long.compareUnsigned(newFieldVal, this._maxVal) > 0) {
                this._textField.setText(this.oldContents);
            } else {
                long newVal = (newFieldVal - (long)this.mOffset) / (long)this.mFactor;
                long oldVal = (this.getValueFromText(this.oldContents) - (long)this.mOffset) / (long)this.mFactor;
                log.debug("Enter updatedTextField from exitField");
                this.updatedTextField();
                this.prop.firePropertyChange("Value", oldVal, newVal);
            }
        }
    }

    @Override
    void updatedTextField() {
        log.debug("Variable='{}'; enter updatedTextField in {} with TextField='{}'", new Object[]{this._name, this.getClass().getSimpleName(), this._textField.getText()});
        int[] retVals = this.getCvValsFromTextField();
        int j = 0;
        while (j < this.cvCount) {
            int i = j;
            if (this._fieldShrink) {
                i = this.cvCount - 1 - j;
            }
            log.debug("retVals[{}]={};cvList.get({}).cvMask{};offsetVal={}", new Object[]{i, retVals[i], i, this.cvList.get((int)i).cvMask, this.offsetVal(this.cvList.get((int)i).cvMask)});
            int cvMask = this.maskValAsInt(this.cvList.get((int)i).cvMask);
            CvValue thisCV = this.cvList.get((int)i).thisCV;
            int oldCvVal = thisCV.getValue();
            int newCvVal = oldCvVal & ~cvMask | retVals[i] << this.offsetVal(this.cvList.get((int)i).cvMask) & cvMask;
            log.debug("{};cvMask={};oldCvVal={};retVals[{}]={};newCvVal={}", new Object[]{this.cvList.get((int)i).cvName, cvMask, oldCvVal, i, retVals[i], newCvVal});
            if (newCvVal != oldCvVal) {
                thisCV.setValue(newCvVal);
            }
            ++j;
        }
        log.debug("Variable={}; exit updatedTextField", (Object)this._name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Variable='{}'; actionPerformed", (Object)this._name);
        this.exitField();
    }

    @Override
    public void focusGained(FocusEvent e) {
        log.debug("Variable={}; focusGained", (Object)this._name);
        this.enterField();
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.debug("Variable={}; focusLost", (Object)this._name);
        this.exitField();
    }

    @Override
    public String getValueString() {
        log.debug("getValueString {}", (Object)this._textField.getText());
        return this._textField.getText();
    }

    @Override
    public void setValue(String value) {
        try {
            long val = Long.parseUnsignedLong(value);
            this.setLongValue(val);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("skipping set of non-long value \"{}\"", (Object)value);
        }
    }

    @Override
    public void setIntValue(int i) {
        this.setLongValue(i);
    }

    @Override
    public int getIntValue() {
        long y;
        long x = this.getLongValue();
        if (Long.compareUnsigned(x, y = x & intMask) != 0) {
            log.error("Value {} from textField {} cannot be converted to 'int'", (Object)x, (Object)this._name);
        }
        return (int)((this.getValueFromText(this._textField.getText()) - (long)this.mOffset) / (long)this.mFactor);
    }

    @Override
    public long getLongValue() {
        return (this.getValueFromText(this._textField.getText()) - (long)this.mOffset) / (long)this.mFactor;
    }

    @Override
    public Object getValueObject() {
        return this.getLongValue();
    }

    @Override
    public Component getCommonRep() {
        if (this.getReadOnly()) {
            JLabel r = new JLabel(this._textField.getText());
            this.updateRepresentation(r);
            return r;
        }
        return this._textField;
    }

    public void setLongValue(long value) {
        long oldVal;
        log.debug("Variable={}; enter setValue {}", (Object)this._name, (Object)value);
        try {
            oldVal = (this.getValueFromText(this._textField.getText()) - (long)this.mOffset) / (long)this.mFactor;
        }
        catch (NumberFormatException numberFormatException) {
            oldVal = -999L;
        }
        log.debug("Variable={}; setValue with new value {} old value {}", new Object[]{this._name, value, oldVal});
        this._textField.setText(this.getTextFromValue(value * (long)this.mFactor + (long)this.mOffset));
        if (oldVal != value || this.getState() == 0) {
            this.actionPerformed(null);
        }
        this.prop.firePropertyChange("Value", oldVal, value * (long)this.mFactor + (long)this.mOffset);
        log.debug("Variable={}; exit setLongValue old={} new={}", new Object[]{this._name, oldVal, value});
    }

    @Override
    void setColor(Color c) {
        if (c != null) {
            this._textField.setBackground(c);
        } else {
            this._textField.setBackground(this._defaultColor);
        }
    }

    @Override
    public Component getNewRep(String format) {
        VarTextField value = new VarTextField(this._textField.getDocument(), this._textField.getText(), this._columns, this);
        if (this.getReadOnly() || this.getInfoOnly()) {
            value.setEditable(false);
        }
        this.reps.add(value);
        return this.updateRepresentation(value);
    }

    @Override
    public void setAvailable(boolean a) {
        this._textField.setVisible(a);
        for (Component c : this.reps) {
            c.setVisible(a);
        }
        super.setAvailable(a);
    }

    @Override
    public void setCvState(int state) {
        int i = 0;
        while (i < this.cvCount) {
            this.cvList.get((int)i).thisCV.setState(state);
            ++i;
        }
    }

    @Override
    public boolean isChanged() {
        boolean changed = false;
        int i = 0;
        while (i < this.cvCount) {
            changed = changed || SplitVariableValue.considerChanged(this.cvList.get((int)i).thisCV);
            ++i;
        }
        return changed;
    }

    @Override
    public boolean isToRead() {
        boolean toRead = false;
        int i = 0;
        while (i < this.cvCount) {
            toRead = toRead || this.cvList.get((int)i).thisCV.isToRead();
            ++i;
        }
        return toRead;
    }

    @Override
    public boolean isToWrite() {
        boolean toWrite = false;
        int i = 0;
        while (i < this.cvCount) {
            toWrite = toWrite || this.cvList.get((int)i).thisCV.isToWrite();
            ++i;
        }
        return toWrite;
    }

    @Override
    public void readChanges() {
        if (this.isToRead() && !this.isChanged()) {
            log.debug("!!!!!!! unacceptable combination in readChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToRead()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isToWrite() && !this.isChanged()) {
            log.debug("!!!!!! unacceptable combination in writeChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToWrite()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        log.debug("Variable={}; splitVal read() invoked", (Object)this._name);
        this.setToRead(false);
        this.setBusy(true);
        if (this._progState != 0) {
            log.warn("Variable={}; programming state {}, not IDLE, in read()", (Object)this._name, (Object)this._progState);
        }
        this._textField.setText("");
        int i = 0;
        while (i < this.cvCount) {
            this.cvList.get((int)i).thisCV.setState(0);
            ++i;
        }
        this._progState = 1;
        this.retry = 0;
        log.debug("Variable={}; invoke CV read", (Object)this._name);
        this.cvList.get((int)0).thisCV.read(this._status);
    }

    @Override
    public void writeAll() {
        log.debug("Variable={}; write() invoked", (Object)this._name);
        if (this.getReadOnly()) {
            log.error("Variable={}; unexpected write operation when readOnly is set", (Object)this._name);
        }
        this.setToWrite(false);
        this.setBusy(true);
        if (this._progState != 0) {
            log.warn("Variable={}; Programming state {}, not IDLE, in write()", (Object)this._name, (Object)this._progState);
        }
        this._progState = -1;
        log.debug("Variable={}; invoke CV write", (Object)this._name);
        this.cvList.get((int)0).thisCV.write(this._status);
    }

    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT", "SF_SWITCH_FALLTHROUGH"}, justification="Intentional fallthrough to produce correct value")
    int priorityValue(int state) {
        int value = 0;
        switch (state) {
            case 0: {
                ++value;
            }
            case 1024: {
                ++value;
            }
            case 4: {
                ++value;
            }
            case 256: {
                ++value;
            }
        }
        return value;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Variable={}; property changed event - name: {}", (Object)this._name, (Object)e.getPropertyName());
        if (e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            if (log.isDebugEnabled() && this._progState != 0) {
                log.debug("getState() = {}", (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.getState());
            }
            if (this._progState == 0) {
                log.debug("Variable={}; Busy goes false with state IDLE", (Object)this._name);
            } else if (this._progState >= 1) {
                if (this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.getState() == 16) {
                    this.retry = 0;
                    if (Math.abs(this._progState) < this.cvCount) {
                        ++this._progState;
                        if (log.isDebugEnabled()) {
                            log.debug("Reading CV={}", (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).cvName);
                        }
                        this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.read(this._status);
                    } else {
                        log.debug("Variable={}; Busy goes false with success READING state {}", (Object)this._name, (Object)this._progState);
                        this._progState = 0;
                        this.setBusy(false);
                    }
                } else {
                    log.debug("Variable={}; Busy goes false with failure READING state {}", (Object)this._name, (Object)this._progState);
                    if (this.retry < 2) {
                        ++this.retry;
                        this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.read(this._status);
                    } else {
                        this._progState = 0;
                        this.setBusy(false);
                        int i = 0;
                        while (i < this.cvCount) {
                            this.cvList.get((int)i).thisCV.setState(0);
                            ++i;
                        }
                    }
                }
            } else if (this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.getState() == 64) {
                if (Math.abs(this._progState) < this.cvCount) {
                    --this._progState;
                    if (log.isDebugEnabled()) {
                        log.debug("Writing CV={}", (Object)this.cvList.get((int)(Math.abs((int)this._progState) - 1)).cvName);
                    }
                    this.cvList.get((int)(Math.abs((int)this._progState) - 1)).thisCV.write(this._status);
                } else {
                    log.debug("Variable={}; Busy goes false with success WRITING state {}", (Object)this._name, (Object)this._progState);
                    this._progState = 0;
                    this.setBusy(false);
                }
            } else {
                log.debug("Variable={}; Busy goes false with failure WRITING state {}", (Object)this._name, (Object)this._progState);
                this._progState = 0;
                this.setBusy(false);
            }
        } else if (e.getPropertyName().equals("State")) {
            log.debug("state change due to CV state change, so propagate that");
            int varState = this.getState();
            log.debug("{} state was {}", (Object)this._name, (Object)varState);
            int i = 0;
            while (i < this.cvCount) {
                int state = this.cvList.get((int)i).thisCV.getState();
                if (i == 0) {
                    varState = state;
                } else if (this.priorityValue(state) > this.priorityValue(varState)) {
                    varState = 0;
                }
                ++i;
            }
            this.setState(varState);
            log.debug("{} state set to {}", (Object)this._name, (Object)varState);
        } else if (e.getPropertyName().equals("Value")) {
            log.debug("update value of Variable");
            int[] intVals = new int[this.cvCount];
            int i = 0;
            while (i < this.cvCount) {
                intVals[i] = (this.cvList.get((int)i).thisCV.getValue() & this.maskValAsInt(this.cvList.get((int)i).cvMask)) >>> this.offsetVal(this.cvList.get((int)i).cvMask);
                ++i;
            }
            this.updateVariableValue(intVals);
            log.debug("state change due to CV value change, so propagate that");
            int varState = 512;
            int i2 = 0;
            while (i2 < this.cvCount) {
                int state = this.cvList.get((int)i2).thisCV.getState();
                if (this.priorityValue(state) > this.priorityValue(varState)) {
                    varState = state;
                }
                ++i2;
            }
            this.setState(varState);
        }
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        if (this._textField != null) {
            this._textField.removeActionListener(this);
        }
        int i = 0;
        while (i < this.cvCount) {
            ((CvValue)this._cvMap.get(this.cvList.get((int)i).cvName)).removePropertyChangeListener(this);
            ++i;
        }
        this._textField = null;
        this._maskArray = null;
    }

    static class CvItem {
        String cvName;
        String cvMask;
        int startOffset;
        CvValue thisCV;

        CvItem(String cvNameVal, String cvMaskVal) {
            this.cvName = cvNameVal;
            this.cvMask = cvMaskVal;
        }
    }

    public class VarTextField
    extends JTextField {
        SplitVariableValue _var;

        VarTextField(Document doc, String text, int col, SplitVariableValue var) {
            super(doc, text, col);
            this._var = var;
            this.setBackground(this._var._textField.getBackground());
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VarTextField.this.thisActionPerformed(e);
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    log.debug("Variable={}; focusGained", (Object)((VarTextField)VarTextField.this).SplitVariableValue.this._name);
                    SplitVariableValue.this.enterField();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    log.debug("Variable={}; focusLost", (Object)((VarTextField)VarTextField.this).SplitVariableValue.this._name);
                    SplitVariableValue.this.exitField();
                }
            });
            this._var.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    VarTextField.this.originalPropertyChanged(e);
                }
            });
        }

        void thisActionPerformed(ActionEvent e) {
            this._var.actionPerformed(e);
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var._textField.getBackground());
            }
        }
    }
}

