/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.util.HashMap;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.SplitVariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitHexVariableValue
extends SplitVariableValue {
    String _case;
    private static final Logger log = LoggerFactory.getLogger(SplitHexVariableValue.class);

    public SplitHexVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname, pSecondCV, pFactor, pOffset, uppermask, extra1, extra2, extra3, extra4);
    }

    @Override
    public void stepOneActions(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname, String pSecondCV, int pFactor, int pOffset, String uppermask, String extra1, String extra2, String extra3, String extra4) {
        this._case = extra1;
        if (extra3 != null) {
            this._minVal = this.getValueFromText(extra3);
        }
        if (extra4 != null) {
            this._maxVal = this.getValueFromText(extra4);
        }
    }

    @Override
    long getValueFromText(String s) {
        return Long.parseUnsignedLong(s, 16);
    }

    @Override
    String getTextFromValue(long v) {
        String ret = Long.toHexString(v);
        if (this._case.equals("upper")) {
            ret = ret.toUpperCase();
        } else if (this._case.equals("lower")) {
            ret = ret.toLowerCase();
        }
        return ret;
    }

    @Override
    public void setValue(String value) {
        try {
            long val = Long.parseUnsignedLong(value, 16);
            this.setLongValue(val);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("skipping set of non-hex value \"{}\"", (Object)value);
        }
    }
}

