/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.util.HashMap;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.DecVariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortAddrVariableValue
extends DecVariableValue {
    int firstFreeSpace = 0;
    static final int maxCVs = 20;
    String[] cvNumbers = new String[20];
    int[] newValues = new int[20];
    private static final Logger log = LoggerFactory.getLogger(ShortAddrVariableValue.class);

    public ShortAddrVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, HashMap<String, CvValue> v, JLabel status, String stdname) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, 0, 127, v, status, stdname);
        this.setModifiedCV("19");
        this.setModifiedCV("29");
    }

    public void setModifiedCV(String cvNum) {
        if (this.firstFreeSpace >= 20) {
            log.error("too many CVs registered for changes!");
            return;
        }
        this.cvNumbers[this.firstFreeSpace] = cvNum;
        this.newValues[this.firstFreeSpace] = -10;
        ++this.firstFreeSpace;
    }

    private void updateCvForAddrChange() {
        int i = 0;
        while (i < this.firstFreeSpace) {
            CvValue cv = (CvValue)this._cvMap.get(this.cvNumbers[i]);
            if (cv != null) {
                if (!this.cvNumbers[i].equals(cv.number())) {
                    log.error("CV numbers don't match: {} {}", (Object)this.cvNumbers[i], (Object)cv.number());
                }
                cv.setToWrite(true);
                cv.setState(4);
                if (log.isDebugEnabled()) {
                    log.debug("Mark to write {}", (Object)cv.number());
                }
            }
            ++i;
        }
    }

    @Override
    public void writeChanges() {
        if (this.getReadOnly()) {
            log.error("unexpected writeChanges operation when readOnly is set");
        }
        this.setBusy(true);
        this.updateCvForAddrChange();
        ((CvValue)this._cvMap.get(this.getCvNum())).write(this._status);
    }

    @Override
    public void writeAll() {
        if (this.getReadOnly()) {
            log.error("unexpected writeAll operation when readOnly is set");
        }
        this.setBusy(true);
        this.updateCvForAddrChange();
        ((CvValue)this._cvMap.get(this.getCvNum())).write(this._status);
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

