/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.util.jdom.LocaleSelector;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetTableModel
extends AbstractTableModel
implements ActionListener,
PropertyChangeListener {
    private String[] headers = new String[]{"Label", "Name", "Value", "Write", "State"};
    private List<CvValue> rowVector = new ArrayList<CvValue>();
    private List<String> labelVector = new ArrayList<String>();
    private List<List<String>> modeVector = new ArrayList<List<String>>();
    private List<JButton> _writeButtons = new ArrayList<JButton>();
    private JLabel _status = null;
    private Programmer mProgrammer;
    private boolean hasOpsModeFlag = false;
    private ProgrammingMode savedMode;
    private String decoderModel;
    private int _progState = 0;
    private static final int IDLE = 0;
    private static final int WRITING_CV = 3;
    private static final Logger log = LoggerFactory.getLogger(ResetTableModel.class);

    public ResetTableModel(JLabel status, Programmer pProgrammer) {
        this.mProgrammer = pProgrammer;
        this._status = status;
    }

    public void setProgrammer(Programmer p) {
        this.mProgrammer = p;
        this.rowVector.forEach(cv -> cv.setProgrammer(p));
    }

    protected void flagIfOpsMode(String mode) {
        if (mode.startsWith("OPS")) {
            this.hasOpsModeFlag = true;
        }
    }

    public boolean hasOpsModeReset() {
        return this.hasOpsModeFlag;
    }

    @Override
    public int getRowCount() {
        return this.rowVector.size();
    }

    @Override
    public int getColumnCount() {
        return this.headers.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.rowVector.size()) {
            log.debug("row greater than row vector");
            return "Error";
        }
        CvValue cv = this.rowVector.get(row);
        if (cv == null) {
            log.debug("cv is null!");
            return "Error CV";
        }
        switch (this.headers[col]) {
            case "Label": {
                return this.labelVector.get(row);
            }
            case "Name": {
                return cv.cvName();
            }
            case "Value": {
                return "" + cv.getValue();
            }
            case "Write": {
                return this._writeButtons.get(row);
            }
            case "State": {
                int state = cv.getState();
                switch (state) {
                    case 0: {
                        return "Unknown";
                    }
                    case 16: {
                        return "Read";
                    }
                    case 4: {
                        return "Edited";
                    }
                    case 64: {
                        return "Stored";
                    }
                    case 256: {
                        return "From file";
                    }
                }
                return "inconsistent";
            }
        }
        return "hmmm ... missed it";
    }

    public void setRow(int row, Element e, Element p, String model) {
        this.decoderModel = model;
        String label = LocaleSelector.getAttribute(e, "label");
        log.debug("Starting to setRow \"{}\"", (Object)label);
        String cv = e.getAttribute("CV").getValue();
        int cvVal = Integer.parseInt(e.getAttribute("default").getValue());
        log.debug("            CV \"{}\" value {}", (Object)cv, (Object)cvVal);
        CvValue resetCV = new CvValue(cv, this.mProgrammer);
        resetCV.addPropertyChangeListener(this);
        resetCV.setValue(cvVal);
        resetCV.setWriteOnly(true);
        resetCV.setState(64);
        this.rowVector.add(resetCV);
        this.labelVector.add(label);
        this.modeVector.add(this.getResetModeList(e, p));
    }

    protected List<String> getResetModeList(Element e, Element p) {
        ArrayList<Element> elementList = new ArrayList<Element>();
        ArrayList<String> modeList = new ArrayList<String>();
        boolean resetsModeFound = false;
        elementList.add(p);
        elementList.add(e);
        for (Element ep : elementList) {
            try {
                String mode = ep.getAttribute("mode").getValue();
                if (ep.getName().equals("resets")) {
                    resetsModeFound = true;
                } else if (resetsModeFound) {
                    modeList.clear();
                    resetsModeFound = false;
                }
                modeList.add(mode);
                this.flagIfOpsMode(mode);
            }
            catch (NullPointerException nullPointerException) {}
            try {
                List elementModes = ep.getChildren("mode");
                for (Element s : elementModes) {
                    if (ep.getName().equals("resets")) {
                        resetsModeFound = true;
                    } else if (resetsModeFound) {
                        modeList.clear();
                        resetsModeFound = false;
                    }
                    modeList.add(s.getText());
                    this.flagIfOpsMode(s.getText());
                }
            }
            catch (NullPointerException nullPointerException) {}
        }
        return modeList;
    }

    protected void performReset(int row) {
        this.savedMode = this.mProgrammer.getMode();
        if (this.modeVector.get(row) != null) {
            List<ProgrammingMode> modes = this.mProgrammer.getSupportedModes();
            List<String> validModes = this.modeVector.get(row);
            StringBuilder programmerModeListBuffer = new StringBuilder("");
            modes.forEach(m -> programmerModeListBuffer.append(",").append(m.toString()));
            String programmerModeList = programmerModeListBuffer.toString();
            if (programmerModeList.length() <= 1) {
                programmerModeList = "";
            } else if (programmerModeList.startsWith(",")) {
                programmerModeList = programmerModeList.substring(1);
            }
            StringBuilder resetModeBuilder = new StringBuilder("");
            validModes.forEach(mode -> resetModeBuilder.append(",").append(new ProgrammingMode((String)mode).toString()));
            String resetModeList = resetModeBuilder.toString();
            if (resetModeList.length() <= 1) {
                resetModeList = "";
            } else if (resetModeList.startsWith(",")) {
                resetModeList = resetModeList.substring(1);
            }
            if (resetModeList.length() > 0) {
                boolean modeFound = false;
                block0: for (ProgrammingMode m2 : modes) {
                    for (String mode2 : validModes) {
                        if (!mode2.equals(m2.getStandardName())) continue;
                        this.mProgrammer.setMode(m2);
                        modeFound = true;
                        break block0;
                    }
                }
                if (this.mProgrammer.getMode().getStandardName().startsWith("OPS") && !this.opsResetOk()) {
                    return;
                }
                if (!modeFound) {
                    if (!this.badModeOk(this.savedMode.toString(), resetModeList, programmerModeList)) {
                        return;
                    }
                    log.warn("{} for {} was attempted in {} mode.", new Object[]{this.labelVector.get(row), this.decoderModel, this.savedMode});
                    log.warn("Recommended mode(s) were \"{}\" but available modes were \"{}\"", (Object)resetModeList, (Object)programmerModeList);
                }
            }
        }
        CvValue cv = this.rowVector.get(row);
        log.debug("performReset: {}", (Object)cv);
        this._progState = 3;
        cv.write(this._status);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("action command: {}", (Object)e.getActionCommand());
        char b = e.getActionCommand().charAt(0);
        int row = Integer.parseInt(e.getActionCommand().substring(1));
        log.debug("event on {} row {}", (Object)Character.valueOf(b), (Object)row);
        if (b == 'W') {
            this.performReset(row);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property changed: {}", (Object)e.getPropertyName());
        if (e.getPropertyName().equals("Busy") && ((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
            switch (this._progState) {
                case 0: {
                    log.debug("Busy goes false with state IDLE");
                    return;
                }
                case 3: {
                    log.debug("Finished writing the CV");
                    this.mProgrammer.setMode(this.savedMode);
                    this._progState = 0;
                    return;
                }
            }
            log.error("Unexpected state found: {}", (Object)this._progState);
            this.mProgrammer.setMode(this.savedMode);
            this._progState = 0;
        }
    }

    boolean badModeOk(String currentMode, String resetModes, String availableModes) {
        String resetWarning = String.valueOf(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetModeWarn1")) + "\n\n" + MessageFormat.format(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetModeWarn2"), resetModes) + "\n" + MessageFormat.format(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetModeWarn3"), availableModes) + "\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetModeWarn4") + "\n\n" + MessageFormat.format(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetModeWarn5"), currentMode);
        return JOptionPane.showConfirmDialog(null, resetWarning, ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetTitle"), 0, 2) == 0;
    }

    boolean opsResetOk() {
        String resetWarning = String.valueOf(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn1")) + "\n\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn2") + "\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn3") + "\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn4") + "\n\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn5") + "\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn6") + "\n\n" + ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsWarn7");
        return JOptionPane.showConfirmDialog(null, resetWarning, ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("FactoryResetOpsTitle"), 0, 2) == 0;
    }

    public void dispose() {
        log.debug("dispose");
        int i = 0;
        while (i < this._writeButtons.size()) {
            this._writeButtons.get(i).removeActionListener(this);
            ++i;
        }
        this._writeButtons.clear();
        this._writeButtons = null;
        i = 0;
        while (i < this.rowVector.size()) {
            CvValue cv = this.rowVector.get(i);
            cv.dispose();
            ++i;
        }
        this.rowVector.clear();
        this.rowVector = null;
        this.labelVector.clear();
        this.labelVector = null;
        this.modeVector.clear();
        this.modeVector = null;
        this.headers = null;
        this._status = null;
    }
}

