/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrit.symbolicprog.AbstractQualifier;
import jmri.jmrit.symbolicprog.Qualifier;
import jmri.jmrit.symbolicprog.VariableValue;

public class QualifierCombiner
implements Qualifier,
PropertyChangeListener {
    List<Qualifier> qualifiers;

    public QualifierCombiner(List<Qualifier> qualifiers) {
        this.qualifiers = qualifiers;
        ArrayList<VariableValue> lv = new ArrayList<VariableValue>();
        for (Qualifier q : qualifiers) {
            AbstractQualifier aq = (AbstractQualifier)q;
            VariableValue v = aq.getWatchedVariable();
            if (v == null) continue;
            if (!lv.contains(v)) {
                lv.add(v);
                v.addPropertyChangeListener(this);
            }
            v.removePropertyChangeListener(aq);
        }
        this.setWatchedAvailable(this.currentDesiredState());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("Value")) {
            this.setWatchedAvailable(this.currentDesiredState());
        }
    }

    @Override
    public void setWatchedAvailable(boolean enable) {
        this.qualifiers.get(0).setWatchedAvailable(enable);
    }

    @Override
    public boolean currentDesiredState() {
        for (Qualifier q : this.qualifiers) {
            if (q.currentDesiredState()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update() {
        this.setWatchedAvailable(this.currentDesiredState());
    }
}

