/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import jmri.jmrit.symbolicprog.Qualifier;
import jmri.jmrit.symbolicprog.QualifierCombiner;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QualifierAdder {
    private static final Logger log = LoggerFactory.getLogger(QualifierAdder.class);

    protected abstract Qualifier createQualifier(VariableValue var1, String var2, String var3);

    protected abstract void addListener(PropertyChangeListener var1);

    public void processModifierElements(Element e, VariableTableModel model) {
        ArrayList<Qualifier> lq = new ArrayList<Qualifier>();
        List le = e.getChildren("qualifier");
        this.processList(le, lq, model);
        Element p = e;
        while ((p = p.getParent()) != null && p instanceof Element) {
            Element el = p;
            if (el.getName().equals("pane")) break;
            List le2 = el.getChildren("qualifier");
            this.processList(le2, lq, model);
        }
        if (lq.size() > 1) {
            new QualifierCombiner(lq);
        }
    }

    void processList(List<Element> le, ArrayList<Qualifier> lq, VariableTableModel model) {
        for (Element q : le) {
            this.processElement(q, lq, model);
        }
    }

    void processElement(Element q, ArrayList<Qualifier> lq, VariableTableModel model) {
        if (q.getChild("variableref") == null) {
            log.error("Pane qualifier element 'variableref' is NULL");
            return;
        }
        String variableRef = q.getChild("variableref").getText();
        if (q.getChild("relation") == null) {
            log.error("Pane qualifier element 'relation' is NULL");
            return;
        }
        String relation = q.getChild("relation").getText();
        if (q.getChild("value") == null) {
            log.error("Pane qualifier element 'value' is NULL");
            return;
        }
        String value = q.getChild("value").getText();
        VariableValue var = model.findVar(variableRef);
        if (var != null || relation.equals("exists")) {
            log.debug("Attached {} variable for {} {} qualifier", new Object[]{variableRef, relation, value});
        } else {
            log.debug("Didn't find {} variable for {} {} qualifier", new Object[]{variableRef, relation, value});
        }
        Qualifier qual = this.createQualifier(var, relation, value);
        qual.update();
        lq.add(qual);
    }
}

