/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgFrame;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintCvAction
extends AbstractAction {
    final int TABLE_COLS = 3;
    PaneProgFrame mFrame;
    CvTableModel mModel;
    RosterEntry mRoster;
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintCvAction.class);

    public PrintCvAction(String actionName, CvTableModel pModel, PaneProgFrame pParent, boolean preview, RosterEntry pRoster) {
        super(actionName);
        this.mModel = pModel;
        this.mFrame = pParent;
        this.isPreview = preview;
        this.mRoster = pRoster;
    }

    public void printInfoSection(HardcopyWriter w) {
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        w.write(icon.getImage(), new JLabel(icon));
        w.setFontStyle(1);
        int height = icon.getImage().getHeight(null);
        int blanks = (height - w.getLineAscent()) / w.getLineHeight();
        try {
            int i = 0;
            while (i < blanks) {
                String s = "\n";
                w.write(s, 0, s.length());
                ++i;
            }
        }
        catch (IOException e) {
            log.warn("error during printing: {}", (Throwable)e);
        }
        this.mRoster.printEntry(w);
        w.setFontStyle(0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HardcopyWriter writer = null;
        try {
            int i;
            writer = new HardcopyWriter(this.mFrame, this.mFrame.getRosterEntry().getId(), 10, 0.8, 0.5, 0.5, 0.5, this.isPreview);
            this.printInfoSection(writer);
            String s = "\n\n";
            writer.write(s, 0, s.length());
            int cvCount = this.mModel.getRowCount();
            int tableLeft = 1;
            int tableRight = 73;
            int tableTopRow = 0;
            int tableBottomRow = 0;
            int tableHeight = cvCount / 3;
            if (cvCount % 3 > 0) {
                ++tableHeight;
            }
            tableTopRow = writer.getCurrentLineNumber();
            writer.write(tableTopRow, tableLeft, tableTopRow, tableRight);
            tableBottomRow = tableTopRow + tableHeight + 2;
            int i2 = 1;
            while (i2 < 76) {
                writer.write(tableTopRow, i2, tableBottomRow, i2);
                i2 += 24;
            }
            writer.write(tableTopRow + 2, tableLeft, tableTopRow + 2, tableRight);
            writer.write(tableBottomRow, tableLeft, tableBottomRow, tableRight);
            writer.setFontStyle(1);
            s = String.format("%1$21s%1$24s%1$24s", Bundle.getMessage("Value"));
            writer.write(s, 0, s.length());
            s = "\n";
            writer.write(s, 0, s.length());
            s = "            CV  Dec Hex             CV  Dec Hex             CV  Dec Hex\n";
            writer.write(s, 0, s.length());
            writer.setFontStyle(0);
            String[] cvStrings = new String[3 * tableHeight];
            int i3 = 0;
            while (i3 < cvStrings.length) {
                cvStrings[i3] = "";
                ++i3;
            }
            i3 = 0;
            while (i3 < this.mModel.getRowCount()) {
                CvValue cv = this.mModel.getCvByRow(i3);
                int value = cv.getValue();
                String numString = String.format("%12s", cv.number());
                String valueString = Integer.toString(value);
                String valueStringHex = Integer.toHexString(value).toUpperCase();
                if (value < 16) {
                    valueStringHex = "0" + valueStringHex;
                }
                int j = 1;
                while (j < 3) {
                    if (valueString.length() < 3) {
                        valueString = " " + valueString;
                    }
                    ++j;
                }
                cvStrings[i3] = s = "  " + numString + "  " + valueString + "  " + valueStringHex + " ";
                ++i3;
            }
            boolean swap = false;
            do {
                swap = false;
                i = 0;
                while (i < this.mModel.getRowCount() - 1) {
                    if (PrintCvAction.cvSortOrderVal(cvStrings[i + 1].substring(0, 15).trim()) < PrintCvAction.cvSortOrderVal(cvStrings[i].substring(0, 15).trim())) {
                        String temp = cvStrings[i + 1];
                        cvStrings[i + 1] = cvStrings[i];
                        cvStrings[i] = temp;
                        swap = true;
                    }
                    ++i;
                }
            } while (swap);
            i = 0;
            while (i < tableHeight) {
                s = String.valueOf(cvStrings[i]) + cvStrings[i + tableHeight] + cvStrings[i + tableHeight * 2] + "\n";
                writer.write(s, 0, s.length());
                ++i;
            }
            s = " \n";
            writer.write(s, 0, s.length());
        }
        catch (IOException iOException) {
            log.error("IO exception while printing");
            return;
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            log.debug("Print cancelled");
            return;
        }
        writer.close();
    }

    public static long cvSortOrderVal(String cvName) {
        String[] cvNumStrings = cvName.split("\\.");
        long sortVal = 0L;
        int i = 0;
        while (i < cvNumStrings.length) {
            sortVal = sortVal * 1200L + (long)Integer.parseInt(cvNumStrings[i]);
            ++i;
        }
        return sortVal;
    }
}

