/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import jmri.JmriException;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pr1Importer {
    private static final Logger log = LoggerFactory.getLogger(Pr1Importer.class);
    private static final String VERSION_KEY = "Version";
    private static final String CV_PREFIX = "CV";
    private static final int CV_INDEX_OFFSET = 2;
    Properties m_CVs = new Properties();
    boolean m_packedValues = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pr1Importer(File file) throws IOException {
        try (FileInputStream fileStream = new FileInputStream(file);){
            this.m_CVs.load(fileStream);
        }
        if (this.m_CVs.containsKey(VERSION_KEY)) {
            if (!this.m_CVs.get(VERSION_KEY).equals("0")) throw new IOException("Unsupported PR1 File Version");
            this.m_packedValues = true;
            return;
        } else {
            Enumeration<Object> cvKeys = this.m_CVs.keys();
            while (cvKeys.hasMoreElements()) {
                String cvValue;
                int cvIntValue;
                String cvKey = (String)cvKeys.nextElement();
                if (!cvKey.startsWith(CV_PREFIX) || (cvIntValue = Integer.parseInt(cvValue = (String)this.m_CVs.get(cvKey))) >= 0 && cvIntValue <= 255) continue;
                this.m_packedValues = true;
                return;
            }
        }
    }

    public void setCvTable(CvTableModel pCvTable) {
        Enumeration<Object> keyIterator = this.m_CVs.keys();
        while (keyIterator.hasMoreElements()) {
            int highCV;
            int lowCV;
            String key = (String)keyIterator.nextElement();
            if (!key.startsWith(CV_PREFIX)) continue;
            int Index = Integer.parseInt(key.substring(2));
            if (this.m_packedValues) {
                lowCV = Index * 4 - 3;
                highCV = Index * 4;
            } else {
                lowCV = Index;
                highCV = Index;
            }
            int cvNum = lowCV;
            while (cvNum <= highCV) {
                if (cvNum <= 1024) {
                    try {
                        CvValue cv = pCvTable.allCvMap().get("" + cvNum);
                        if (cv != null) {
                            cv.setValue(this.getCV(cvNum));
                        }
                    }
                    catch (JmriException jmriException) {
                        log.error("failed to getCV() {}", (Object)cvNum);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        log.error("failed to getCvByNumber() {}", (Object)cvNum);
                    }
                }
                ++cvNum;
            }
        }
    }

    public int getCV(int cvNumber) throws JmriException {
        int result;
        if (this.m_packedValues) {
            String cvKey = CV_PREFIX + (cvNumber / 4 + 1);
            String cvValueStr = this.m_CVs.getProperty(cvKey);
            if (cvValueStr == null) {
                throw new JmriException("CV not found");
            }
            int shiftBits = (cvNumber - 1) % 4 * 8;
            long cvValue = Long.parseLong(cvValueStr);
            if (cvValue < 0L) {
                result = (int)((cvValue + Integer.MAX_VALUE >> shiftBits) % 256L);
                if (shiftBits > 16) {
                    result += 127;
                }
            } else {
                result = (int)((cvValue >> shiftBits) % 256L);
            }
        } else {
            String cvKey = CV_PREFIX + cvNumber;
            String cvValueStr = this.m_CVs.getProperty(cvKey);
            if (cvValueStr == null) {
                throw new JmriException("CV not found");
            }
            result = Integer.parseInt(cvValueStr);
        }
        return result;
    }
}

