/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pr1ExportAction
extends AbstractAction {
    JFileChooser fileChooser;
    JFrame mParent;
    CvTableModel mModel;
    private static final Logger log = LoggerFactory.getLogger(Pr1ExportAction.class);

    public Pr1ExportAction(String actionName, CvTableModel pModel, JFrame pParent) {
        super(actionName);
        this.mModel = pModel;
        this.mParent = pParent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if ((retVal = this.fileChooser.showSaveDialog(this.mParent)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to PR1 file {}", (Object)file);
            }
            try {
                PrintStream str = new PrintStream(new FileOutputStream(file));
                str.println("[DecoderData]");
                int i = 1;
                while (i <= 256) {
                    int lowCvIndex = i;
                    CvValue cv1 = this.mModel.allCvMap().get("" + lowCvIndex);
                    int value1 = cv1 != null ? cv1.getValue() : 0;
                    str.println("CV" + i + "=" + value1);
                    ++i;
                }
                str.flush();
                str.close();
            }
            catch (IOException ex) {
                log.error("Error writing file: {}", (Throwable)ex);
            }
        }
    }
}

