/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.decoderdefn.IdentifyDecoder;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.GlobalRosterEntryComboBox;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLocoSelPane
extends JmriPanel {
    ProgModeSelector selector;
    JLabel _statusLabel = null;
    private JComboBox<Object> locoBox = null;
    private JComboBox<String> decoderBox = null;
    private static final Logger log = LoggerFactory.getLogger(NewLocoSelPane.class);

    public NewLocoSelPane(JLabel s, ProgModeSelector selector) {
        this._statusLabel = s;
        this.selector = selector;
        this.init();
    }

    public NewLocoSelPane() {
        this.init();
    }

    public void init() {
        this.setLayout(new BoxLayout(this, 1));
        JLabel last = new JLabel(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("NewLocoProgTrack"));
        this.add(last);
        last.setBorder(new EmptyBorder(6, 0, 6, 0));
        this.add(new JLabel(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("CopySettings")));
        this.locoBox = new GlobalRosterEntryComboBox();
        this.locoBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("Locomotive selected changed");
                }
                NewLocoSelPane.this.matchDecoderToLoco();
            }
        });
        this.add(this.locoBox);
        JPanel pane1a = new JPanel();
        pane1a.setLayout(new BoxLayout(pane1a, 0));
        pane1a.add(new JLabel(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("LabelDecoderInstalled")));
        JButton iddecoder = new JButton(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("IdentifyDecoder"));
        iddecoder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("identify decoder pressed");
                }
                NewLocoSelPane.this.startIdentify();
            }
        });
        pane1a.add(iddecoder);
        pane1a.setAlignmentX(0.0f);
        this.add(pane1a);
        this.decoderBox = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null);
        this.add(this.decoderBox);
        JButton go1 = new JButton(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("IdentifyDecoder"));
        go1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("Open programmer pressed");
                }
                NewLocoSelPane.this.openButton();
            }
        });
        this.add(go1);
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
    }

    private void startIdentify() {
        NewLocoSelPane me = this;
        Programmer p = null;
        if (this.selector != null && this.selector.isSelected()) {
            p = this.selector.getProgrammer();
        }
        if (p == null) {
            log.warn("Selector did not provide a programmer, use default");
            p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        }
        IdentifyDecoder id = new IdentifyDecoder(p, me){
            private NewLocoSelPane who;
            {
                this.who = newLocoSelPane2;
            }

            @Override
            protected void done(int mfg, int model, int productID) {
                this.who.selectDecoder(mfg, model, productID);
            }

            @Override
            protected void message(String m) {
                if (NewLocoSelPane.this._statusLabel != null) {
                    NewLocoSelPane.this._statusLabel.setText(m);
                }
            }

            @Override
            public void error() {
            }
        };
        id.start();
    }

    private void selectDecoder(int mfgID, int modelID, int productID) {
        JComboBox<String> temp = null;
        if (productID != -1) {
            String sz_productID = Integer.toString(productID);
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, Integer.toString(mfgID), Integer.toString(modelID), sz_productID, null);
            if (temp.getItemCount() == 0) {
                log.debug("selectDecoder found no items with product ID {}", (Object)productID);
                temp = null;
            } else {
                log.debug("selectDecoder found {} matches with productID {}", (Object)temp.getItemCount(), (Object)productID);
            }
        }
        if (temp == null) {
            temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, Integer.toString(mfgID), Integer.toString(modelID), null, null);
            if (log.isDebugEnabled()) {
                log.debug("selectDecoder without productID found {} matches", (Object)temp.getItemCount());
            }
        }
        if (temp.getItemCount() > 0) {
            this.decoderBox.setModel(temp.getModel());
            this.decoderBox.setSelectedIndex(0);
        } else {
            log.warn("Decoder says {} {} decoder, but no such decoder defined", (Object)mfgID, (Object)modelID);
        }
    }

    private void matchDecoderToLoco() {
        if (((String)this.locoBox.getSelectedItem()).equals("<none>")) {
            return;
        }
        RosterEntry r = Roster.getDefault().entryFromTitle((String)this.locoBox.getSelectedItem());
        String decoderModel = r.getDecoderModel();
        String decoderFamily = r.getDecoderFamily();
        if (log.isDebugEnabled()) {
            log.debug("selected loco uses decoder {} {}", (Object)decoderFamily, (Object)decoderModel);
        }
        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, decoderFamily, null, null, null, decoderModel);
        if (log.isDebugEnabled()) {
            log.debug("found {} matches", (Object)l.size());
        }
        if (l.size() > 0) {
            DecoderFile d = l.get(0);
            String title = d.titleString();
            if (log.isDebugEnabled()) {
                log.debug("Decoder file title {}", (Object)title);
            }
            int i = 0;
            while (i < this.decoderBox.getItemCount()) {
                if (title.equals(this.decoderBox.getItemAt(i))) {
                    this.decoderBox.setSelectedIndex(i);
                }
                ++i;
            }
        } else {
            log.warn("Loco uses {} {} decoder, but no such decoder defined", (Object)decoderFamily, (Object)decoderModel);
        }
    }

    protected void openButton() {
        DecoderFile decoderFile = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle((String)this.decoderBox.getSelectedItem());
        if (log.isDebugEnabled()) {
            log.debug("decoder file: {}", (Object)decoderFile.getFileName());
        }
        RosterEntry re = new RosterEntry();
        re.setDecoderFamily(decoderFile.getFamily());
        re.setDecoderModel(decoderFile.getModel());
        re.setId(Bundle.getMessage("LabelNewDecoder"));
        Roster.getDefault().addEntry(re);
        this.startProgrammer(decoderFile, re);
    }

    protected void startProgrammer(DecoderFile decoderFile, RosterEntry r) {
        log.error("startProgrammer method in NewLocoSelPane should have been overridden");
    }
}

