/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.XmlFile;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NameFile
extends XmlFile {
    protected HashMap<String, Element> _nameHash = new HashMap();
    static String fileLocation = "";
    static String nameFileName = "names.xml";
    private static final Logger log = LoggerFactory.getLogger(NameFile.class);

    public Set<String> names() {
        return this._nameHash.keySet();
    }

    public Element elementFromName(String name) {
        return this._nameHash.get(name);
    }

    public boolean checkName(String name) {
        return this.elementFromName(name) != null;
    }

    void readFile(String name) throws JDOMException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("readFile {}", (Object)name);
        }
        Element root = this.rootFromName(name);
        this.readNames(root);
    }

    void readNames(Element root) {
        Element el;
        List l = root.getChildren("definition");
        if (log.isDebugEnabled()) {
            log.debug("readNames sees {} direct children", (Object)l.size());
        }
        int i = 0;
        while (i < l.size()) {
            el = (Element)l.get(i);
            this.storeDefinition(el);
            ++i;
        }
        l = root.getChildren("definitiongroup");
        if (log.isDebugEnabled()) {
            log.debug("readNames sees {} groups", (Object)l.size());
        }
        i = 0;
        while (i < l.size()) {
            el = (Element)l.get(i);
            this.readNames(el);
            ++i;
        }
    }

    void storeDefinition(Element el) {
        String name = el.getAttribute("item").getValue();
        this._nameHash.put(name, el);
    }

    protected static String defaultNameFilename() {
        return String.valueOf(fileLocation) + nameFileName;
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(NameFile.class)) {
                if (log.isDebugEnabled()) {
                    log.debug("NameFile creating instance");
                }
                NameFile instance = new NameFile();
                try {
                    instance.readFile(NameFile.defaultNameFilename());
                }
                catch (IOException | JDOMException e) {
                    log.error("Exception during name file reading: {}", (Object)e.getMessage());
                }
                log.debug("NameFile returns instance {}", (Object)instance);
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(NameFile.class);
            return set;
        }
    }
}

