/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LokProgImporter {
    private static final Logger log = LoggerFactory.getLogger(LokProgImporter.class);
    private static final String INDEX_PREFIX = "Index:";
    private static final String INDEX_1 = "CV31=";
    private static final String INDEX_1_TERMINATOR = ",";
    private static final String INDEX_2 = "CV32=";
    private static final String INDEX_2_TERMINATOR = ")";
    private static final String CV_PREFIX = "CV ";
    private static final String CV_SEPARATOR = " = ";

    public LokProgImporter(File file, CvTableModel cvModel) throws IOException {
        block14: {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    String line;
                    String cvIndex = "";
                    fileReader = new FileReader(file);
                    bufferedReader = new BufferedReader(fileReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.startsWith(INDEX_PREFIX)) {
                            cvIndex = String.valueOf(line.substring(line.indexOf(INDEX_1) + INDEX_1.length(), line.indexOf(INDEX_1_TERMINATOR))) + ".";
                            cvIndex = String.valueOf(cvIndex) + line.substring(line.indexOf(INDEX_2) + INDEX_2.length(), line.indexOf(INDEX_2_TERMINATOR)) + ".";
                            continue;
                        }
                        if (!line.startsWith(CV_PREFIX) || !line.regionMatches(6, CV_SEPARATOR, 0, 3)) continue;
                        String name = String.valueOf(cvIndex) + String.valueOf(Integer.parseInt(line.substring(3, 6)));
                        int value = Integer.parseInt(line.substring(9, 12));
                        CvValue cvObject = cvModel.allCvMap().get(name);
                        if (cvObject == null) {
                            log.warn("CV {} was in import file, but not defined by the decoder definition", (Object)name);
                            cvModel.addCV(name, false, false, false);
                            cvObject = cvModel.allCvMap().get(name);
                        }
                        log.debug("Settting CV {} to {}", (Object)name, (Object)value);
                        cvObject.setValue(value);
                    }
                }
                catch (IOException e) {
                    log.error("Error reading file: {}", (Throwable)e);
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (fileReader != null) {
                        fileReader.close();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
        log.debug("LokProgImporter finished reading file");
    }
}

