/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.roster.IdentifyLoco;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.LocoSelPane;
import jmri.jmrit.symbolicprog.ProgDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KnownLocoSelPane
extends LocoSelPane {
    boolean mCanIdent;
    JComboBox<String> programmerBox;
    ProgModeSelector selector;
    JLabel mStatusLabel = null;
    private RosterEntrySelectorPanel locoBox = null;
    private static final Logger log = LoggerFactory.getLogger(KnownLocoSelPane.class);

    public KnownLocoSelPane(JLabel s, boolean ident, ProgModeSelector selector) {
        this.mCanIdent = ident;
        this.mStatusLabel = s;
        this.selector = selector;
        this.init();
    }

    public KnownLocoSelPane(boolean ident) {
        this(null, ident, null);
    }

    protected void init() {
        this.setLayout(new BoxLayout(this, 1));
        JPanel pane2a = new JPanel();
        pane2a.setLayout(new BoxLayout(pane2a, 0));
        pane2a.add(new JLabel(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("UseExisting")));
        if (this.mCanIdent) {
            JButton idloco = new JButton(ResourceBundle.getBundle("jmri/jmrit/symbolicprog/SymbolicProgBundle").getString("ReadAndSelect"));
            idloco.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (log.isDebugEnabled()) {
                        log.debug("Identify locomotive pressed");
                    }
                    KnownLocoSelPane.this.startIdentify();
                }
            });
            pane2a.add(idloco);
            pane2a.setAlignmentX(0.0f);
        }
        this.add(pane2a);
        this.locoBox = new RosterEntrySelectorPanel();
        this.locoBox.setNonSelectedItem("Locomotive");
        this.add(this.locoBox);
        this.addProgrammerBox();
        JButton go2 = new JButton(Bundle.getMessage("OpenProgrammer"));
        go2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("Open programmer pressed");
                }
                KnownLocoSelPane.this.openButton();
            }
        });
        this.add(go2);
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
    }

    private void addProgrammerBox() {
        JPanel pane3a = new JPanel();
        pane3a.setLayout(new BoxLayout(pane3a, 0));
        pane3a.add(new JLabel(Bundle.getMessage("ProgrammerFormat")));
        this.programmerBox = new JComboBox<String>(ProgDefault.findListOfProgFiles());
        this.programmerBox.setSelectedIndex(0);
        if (ProgDefault.getDefaultProgFile() != null) {
            this.programmerBox.setSelectedItem(ProgDefault.getDefaultProgFile());
        }
        pane3a.add(this.programmerBox);
        this.add(pane3a);
    }

    private void startIdentify() {
        KnownLocoSelPane me = this;
        Programmer p = null;
        if (this.selector != null && this.selector.isSelected()) {
            p = this.selector.getProgrammer();
        }
        if (p == null) {
            log.warn("Selector did not provide a programmer, use default");
            p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer();
        }
        IdentifyLoco id = new IdentifyLoco(p, me){
            private KnownLocoSelPane who;
            {
                this.who = knownLocoSelPane2;
            }

            @Override
            protected void done(int dccAddress) {
                this.who.selectLoco(dccAddress);
            }

            @Override
            protected void message(String m) {
                if (KnownLocoSelPane.this.mStatusLabel != null) {
                    KnownLocoSelPane.this.mStatusLabel.setText(m);
                }
            }

            @Override
            public void error() {
            }
        };
        id.start();
    }

    protected void selectLoco(int dccAddress) {
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, Integer.toString(dccAddress), null, null, null, null);
        if (log.isDebugEnabled()) {
            log.debug("selectLoco found {} matches", (Object)l.size());
        }
        if (l.size() > 0) {
            String group;
            RosterEntry r = l.get(0);
            String id = r.getId();
            if (log.isDebugEnabled()) {
                log.debug("Loco id is {}", (Object)id);
            }
            if ((group = this.locoBox.getSelectedRosterGroup()) != null && !group.equals(Roster.ALLENTRIES)) {
                List<RosterEntry> entries = Roster.getDefault().getEntriesWithAttributeKeyValue(Roster.getRosterGroupProperty(group), "yes");
                if (entries.contains(r)) {
                    this.locoBox.setSelectedRosterEntry(r);
                } else {
                    this.locoBox.setSelectedRosterEntryAndGroup(r, Roster.ALLENTRIES);
                }
            } else {
                this.locoBox.setSelectedRosterEntry(r);
            }
        } else {
            log.warn("Read address {}, but no such loco in roster", (Object)dccAddress);
        }
    }

    protected void openButton() {
        if (this.locoBox.getSelectedRosterEntries().length != 0) {
            RosterEntry re = this.locoBox.getSelectedRosterEntries()[0];
            this.startProgrammer(null, re, (String)this.programmerBox.getSelectedItem());
        } else {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("LocoMustSelected"), Bundle.getMessage("NoSelection"), 0);
        }
    }

    protected abstract void startProgrammer(DecoderFile var1, RosterEntry var2, String var3);
}

