/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import jmri.util.CvUtil;
import jmri.util.jdom.LocaleSelector;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Parent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FnMapPanel
extends JPanel {
    int fnNameCol = 0;
    int firstOutCol = 1;
    int outputNameRow = 0;
    int outputNumRow = 1;
    int outputLabelRow = 2;
    int firstFnRow = 3;
    int highestFn = 28;
    int highestSensor = 28;
    int numFn;
    int numOut = 20;
    int maxOut = 40;
    final String[] outName = new String[this.maxOut];
    final String[] outLabel = new String[this.maxOut];
    final boolean[] outIsUsed = new boolean[this.maxOut];
    final String[] fnExtraList = new String[]{"STOP", "DRIVE", "FWD", "REV", "FL"};
    final String[] fnVariantList = new String[]{"", "(f)", "(r)"};
    List<String> fnList;
    GridBagLayout gl = null;
    GridBagConstraints cs = null;
    VariableTableModel _varModel;
    private static final Logger log = LoggerFactory.getLogger(FnMapPanel.class);

    public FnMapPanel(VariableTableModel v, List<Integer> varsUsed, Element model) {
        if (log.isDebugEnabled()) {
            log.debug("Function map starts");
        }
        this._varModel = v;
        this.fnList = new ArrayList<String>();
        this.fnList.addAll(Arrays.asList(this.fnExtraList));
        int i = 0;
        while (i <= this.highestFn) {
            this.fnList.add("F" + i);
            ++i;
        }
        i = 0;
        while (i <= this.highestSensor) {
            this.fnList.add("S" + i);
            ++i;
        }
        this.numFn = this.fnList.size() * this.fnVariantList.length;
        int iOut = 0;
        while (iOut < this.maxOut) {
            this.outName[iOut] = Integer.toString(iOut + 1);
            this.outIsUsed[iOut] = false;
            try {
                this.outLabel[iOut] = Bundle.getMessage("FnMapOutLabelDefault_" + (iOut + 1));
            }
            catch (MissingResourceException missingResourceException) {
                this.outLabel[iOut] = "";
            }
            ++iOut;
        }
        this.configOutputs(model);
        this.gl = new GridBagLayout();
        this.cs = new GridBagConstraints();
        this.setLayout(this.gl);
        JLabel l = new JLabel(Bundle.getMessage("FnMapOutWireOr"));
        this.cs.gridy = this.outputNameRow;
        this.cs.gridx = this.firstOutCol;
        this.cs.gridwidth = 0;
        this.gl.setConstraints(l, this.cs);
        this.add(l);
        this.cs.gridwidth = 1;
        this.labelAt(0, this.fnNameCol, Bundle.getMessage("FnMapDesc"), 21);
        int row = this.firstFnRow;
        for (String fnNameBase : this.fnList) {
            if (row - this.firstFnRow >= this.numFn) break;
            String[] stringArray = this.fnVariantList;
            int n = this.fnVariantList.length;
            int n2 = 0;
            while (n2 < n) {
                String fnDirVariant = stringArray[n2];
                String fnNameString = String.valueOf(fnNameBase) + fnDirVariant;
                boolean rowIsUsed = false;
                int iOut2 = 0;
                while (iOut2 < this.numOut) {
                    if (!this.outName[iOut2].equals("") || !this.outLabel[iOut2].equals("")) {
                        String searchNameBase = String.valueOf(fnNameString) + " controls output ";
                        ArrayList<String> names = new ArrayList<String>();
                        if (!this.outName[iOut2].equals(Integer.toString(iOut2 + 1))) {
                            names.add(String.valueOf(searchNameBase) + (iOut2 + 1));
                            names.add(String.valueOf(searchNameBase) + (iOut2 + 1) + "(alt)");
                        }
                        names.add(String.valueOf(searchNameBase) + this.outName[iOut2]);
                        names.add(String.valueOf(searchNameBase) + this.outName[iOut2] + "(alt)");
                        for (String name : names) {
                            int iVar = this._varModel.findVarIndex(name);
                            if (iVar >= 0) {
                                if (log.isDebugEnabled()) {
                                    log.debug("Process var: {} as index {}", (Object)name, (Object)iVar);
                                }
                                varsUsed.add(iVar);
                                VariableValue var = this._varModel.getVariable(iVar);
                                String displayFormat = "checkbox";
                                if (var.getMask() != null && var.getMask().replace("X", "").length() != 1) {
                                    displayFormat = "";
                                }
                                JComponent j = (JComponent)this._varModel.getRep(iVar, displayFormat);
                                j.setToolTipText(CvUtil.addCvDescription(String.valueOf(fnNameString) + " " + Bundle.getMessage("FnMapControlsOutput") + " " + this.outName[iOut2] + " " + this.outLabel[iOut2], var.getCvDescription(), var.getMask()));
                                int column = this.firstOutCol + iOut2;
                                this.saveAt(row, column, j);
                                rowIsUsed = true;
                                this.outIsUsed[iOut2] = true;
                                continue;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Did not find var: {}", (Object)name);
                        }
                    }
                    ++iOut2;
                }
                if (rowIsUsed) {
                    if (fnNameBase.matches("F\\d+")) {
                        fnNameString = String.valueOf(Bundle.getMessage("FnMap_F")) + " " + fnNameBase.substring(1);
                        if (!fnDirVariant.equals("")) {
                            fnNameString = String.valueOf(fnNameString) + Bundle.getMessage("FnMap_" + fnDirVariant);
                        }
                    } else if (fnNameBase.matches("S\\d+")) {
                        fnNameString = String.valueOf(Bundle.getMessage("FnMap_S")) + " " + fnNameBase.substring(1);
                        if (!fnDirVariant.equals("")) {
                            fnNameString = String.valueOf(fnNameString) + Bundle.getMessage("FnMap_" + fnDirVariant);
                        }
                    } else {
                        try {
                            fnNameString = Bundle.getMessage("FnMap_" + fnNameString);
                        }
                        catch (MissingResourceException missingResourceException) {
                            try {
                                fnNameString = Bundle.getMessage("FnMap_" + fnNameBase);
                                if (!fnDirVariant.equals("")) {
                                    fnNameString = String.valueOf(fnNameString) + Bundle.getMessage("FnMap_" + fnDirVariant);
                                }
                            }
                            catch (MissingResourceException missingResourceException2) {}
                        }
                    }
                    this.labelAt(row, this.fnNameCol, fnNameString, 21);
                    ++row;
                }
                ++n2;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Function map complete");
        }
        int iOut3 = 0;
        while (iOut3 < this.numOut) {
            if (this.outIsUsed[iOut3]) {
                this.labelAt(this.outputNumRow, this.firstOutCol + iOut3, this.outName[iOut3]);
                this.labelAt(this.outputLabelRow, this.firstOutCol + iOut3, this.outLabel[iOut3]);
            }
            ++iOut3;
        }
        this.cs.gridwidth = 0;
        this.labelAt(this.outputNumRow, this.firstOutCol + this.numOut, "");
    }

    void saveAt(int row, int column, JComponent j) {
        this.saveAt(row, column, j, 10);
    }

    void saveAt(int row, int column, JComponent j, int anchor) {
        if (row < 0 || column < 0) {
            return;
        }
        this.cs = new GridBagConstraints();
        this.cs.gridy = row;
        this.cs.gridx = column;
        this.cs.anchor = anchor;
        this.gl.setConstraints(j, this.cs);
        this.add(j);
    }

    void labelAt(int row, int column, String name) {
        this.labelAt(row, column, name, 10);
    }

    void labelAt(int row, int column, String name, int anchor) {
        if (row < 0 || column < 0) {
            return;
        }
        JLabel t = new JLabel(" " + name + " ");
        this.saveAt(row, column, t, anchor);
    }

    protected void configOutputs(Element model) {
        if (model == null) {
            log.debug("configOutputs was given a null model");
            return;
        }
        Element family = null;
        Parent parent = model.getParent();
        if (parent == null || !(parent instanceof Element)) {
            log.debug("configOutputs found an invalid parent family");
            return;
        }
        family = (Element)parent;
        Attribute a = model.getAttribute("numOuts");
        try {
            if (a != null) {
                this.numOut = Integer.parseInt(a.getValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.error("error handling decoder's numOuts value");
        }
        a = model.getAttribute("numFns");
        try {
            if (a != null) {
                this.numFn = Integer.parseInt(a.getValue());
            }
        }
        catch (NumberFormatException numberFormatException) {
            log.error("error handling decoder's numFns value");
        }
        if (log.isDebugEnabled()) {
            log.debug("numFns, numOuts {},{}", (Object)this.numFn, (Object)this.numOut);
        }
        ArrayList<Element> elemList = new ArrayList<Element>();
        this.addOutputElements(family.getChildren(), elemList);
        this.addOutputElements(model.getChildren(), elemList);
        log.debug("output scan starting with {} elements", (Object)elemList.size());
        int i = 0;
        while (i < elemList.size()) {
            block13: {
                Element e = (Element)elemList.get(i);
                String name = e.getAttribute("name").getValue();
                log.debug("output element name: {} value: {}", (Object)e.getAttributeValue("name"), (Object)e.getAttributeValue("label"));
                try {
                    int outputNum = Integer.parseInt(name);
                    String at = LocaleSelector.getAttribute(e, "label");
                    if (at != null) {
                        this.loadSplitLabel(outputNum - 1, at);
                        this.numOut = Math.max(this.numOut, outputNum);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    if (this.numOut >= this.maxOut) break block13;
                    this.outName[this.numOut] = name;
                    String at = LocaleSelector.getAttribute(e, "label");
                    this.outLabel[this.numOut] = at != null ? at : "";
                    ++this.numOut;
                }
            }
            ++i;
        }
    }

    void addOutputElements(List<Element> input, List<Element> accumulate) {
        for (Element elem : input) {
            if (elem.getName().equals("outputs")) {
                log.debug(" found outputs element of size {}", (Object)elem.getChildren().size());
                this.addOutputElements(elem.getChildren(), accumulate);
                continue;
            }
            if (!elem.getName().equals("output")) continue;
            log.debug("adding output element name: {} value: {}", (Object)elem.getAttributeValue("name"), (Object)elem.getAttributeValue("label"));
            accumulate.add(elem);
        }
    }

    void loadSplitLabel(int iOut, String theLabel) {
        if (iOut < this.maxOut) {
            String[] itemList = theLabel.split("\\|");
            if (theLabel.equals("|")) {
                this.outName[iOut] = "";
                this.outLabel[iOut] = "";
            } else if (itemList.length == 1) {
                this.outLabel[iOut] = itemList[0];
            } else if (itemList.length > 1) {
                this.outName[iOut] = itemList[0];
                this.outLabel[iOut] = itemList[1];
            }
        }
    }

    public void dispose() {
        this.removeAll();
    }
}

