/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jmri.jmrit.symbolicprog.ComboCheckBox;
import jmri.jmrit.symbolicprog.ComboOffRadioButton;
import jmri.jmrit.symbolicprog.ComboOnRadioButton;
import jmri.jmrit.symbolicprog.ComboRadioButtons;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnumVariableValue
extends VariableValue
implements ActionListener {
    JComboBox<String> _value = null;
    private String[] _itemArray = null;
    private TreePath[] _pathArray = null;
    private int[] _valueArray = null;
    private int _nstored;
    Deque<DefaultMutableTreeNode> treeNodes = new ArrayDeque<DefaultMutableTreeNode>();
    int _maxVal;
    int _minVal;
    Color _defaultColor;
    private final List<ComboCheckBox> comboCBs = new ArrayList<ComboCheckBox>();
    private final List<VarComboBox> comboVars = new ArrayList<VarComboBox>();
    private final List<ComboRadioButtons> comboRBs = new ArrayList<ComboRadioButtons>();
    private final List<JTree> trees = new ArrayList<JTree>();
    private static final Logger log = LoggerFactory.getLogger(EnumVariableValue.class);

    public EnumVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, v, status, stdname);
        this._maxVal = maxVal;
        this._minVal = minVal;
        this.treeNodes.addLast(new DefaultMutableTreeNode(""));
        this.simplifyMask();
    }

    public EnumVariableValue() {
    }

    @Override
    public CvValue[] usesCVs() {
        return new CvValue[]{(CvValue)this._cvMap.get(this.getCvNum())};
    }

    public void nItems(int n) {
        this._itemArray = new String[n];
        this._pathArray = new TreePath[n];
        this._valueArray = new int[n];
        this._nstored = 0;
        log.debug("enumeration arrays size={}", (Object)n);
    }

    public void addItem(String s) {
        if (this._nstored == 0) {
            this.addItem(s, 0);
        } else {
            this.addItem(s, this._valueArray[this._nstored - 1] + 1);
        }
    }

    public void addItem(String s, int value) {
        this._valueArray[this._nstored] = value;
        TreeLeafNode node = new TreeLeafNode(s, this._nstored);
        this.treeNodes.getLast().add(node);
        this._pathArray[this._nstored] = new TreePath(node.getPath());
        this._itemArray[this._nstored++] = s;
        log.debug("_itemArray.length={},_nstored={},s='{}',value={}", new Object[]{this._itemArray.length, this._nstored, s, value});
    }

    public void startGroup(String name) {
        DefaultMutableTreeNode next = new DefaultMutableTreeNode(name);
        this.treeNodes.getLast().add(next);
        this.treeNodes.addLast(next);
    }

    public void endGroup() {
        this.treeNodes.removeLast();
    }

    public void lastItem() {
        this._value = new JComboBox<String>(Arrays.copyOf(this._itemArray, this._nstored));
        this._value.setActionCommand("");
        this._defaultColor = this._value.getBackground();
        this._value.setBackground(COLOR_UNKNOWN);
        this._value.setOpaque(true);
        this._value.addActionListener(this);
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        if (cv == null) {
            log.error("no CV defined in enumVal {}, skipping setState", (Object)this.getCvName());
            return;
        }
        cv.addPropertyChangeListener(this);
        cv.setState(256);
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    @Override
    public void setAvailable(boolean a) {
        this._value.setVisible(a);
        for (ComboCheckBox comboCheckBox : this.comboCBs) {
            comboCheckBox.setVisible(a);
        }
        for (VarComboBox varComboBox : this.comboVars) {
            varComboBox.setVisible(a);
        }
        for (ComboRadioButtons comboRadioButtons : this.comboRBs) {
            comboRadioButtons.setVisible(a);
        }
        super.setAvailable(a);
    }

    @Override
    public Object rangeVal() {
        return "enum: " + this._minVal + " - " + this._maxVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int newVal;
        if (log.isDebugEnabled()) {
            log.debug("{} start action event: {}", (Object)this.label(), (Object)e);
        }
        if (!e.getActionCommand().equals("")) {
            this._value.setSelectedItem(e.getActionCommand());
            if (log.isDebugEnabled()) {
                log.debug("{} action event was from alternate rep", (Object)this.label());
            }
            if (this._nstored > 0) {
                int i = 0;
                while (i < this._nstored) {
                    if (e.getActionCommand().equals(this._itemArray[i])) {
                        TreePath path = this._pathArray[i];
                        for (JTree tree : this.trees) {
                            tree.setSelectionPath(path);
                            tree.scrollPathToVisible(path);
                        }
                        break;
                    }
                    ++i;
                }
            }
        }
        int oldVal = this.getIntValue();
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        if (cv == null) {
            log.error("no CV defined in enumVal {}, skipping setValue", this._cvMap.get(this.getCvName()));
            return;
        }
        int oldCv = cv.getValue();
        int newCv = this.setValueInCV(oldCv, newVal = this.getIntValue(), this.getMask(), this._maxVal - 1);
        if (newCv != oldCv) {
            cv.setValue(newCv);
            log.debug("{} about to firePropertyChange", (Object)this.label());
            this.prop.firePropertyChange("Value", null, (Object)oldVal);
            log.debug("{} returned to from firePropertyChange", (Object)this.label());
        }
        log.debug("{} end action event saw oldCv={} newVal={} newCv={}", new Object[]{this.label(), oldCv, newVal, newCv});
    }

    @Override
    public String getValueString() {
        return Integer.toString(this.getIntValue());
    }

    @Override
    public void setIntValue(int i) {
        this.setValue(i);
    }

    @Override
    public String getTextValue() {
        if (this._value.getSelectedItem() != null) {
            return this._value.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public Object getValueObject() {
        return this._value.getSelectedIndex();
    }

    protected void selectValue(int value) {
        if (this._nstored > 0) {
            int i = 0;
            while (i < this._nstored) {
                if (this._valueArray[i] == value) {
                    this._value.setSelectedIndex(i);
                    TreePath path = this._pathArray[i];
                    for (JTree tree : this.trees) {
                        tree.setSelectionPath(path);
                        tree.scrollPathToVisible(path);
                    }
                    return;
                }
                ++i;
            }
        }
        log.debug("Create new item with value {} count was {} in {}", new Object[]{value, this._value.getItemCount(), this.label()});
        this._valueArray = Arrays.copyOf(this._valueArray, this._valueArray.length + 1);
        this._itemArray = Arrays.copyOf(this._itemArray, this._itemArray.length + 1);
        this._pathArray = Arrays.copyOf(this._pathArray, this._pathArray.length + 1);
        this.addItem("Reserved value " + value, value);
        this._value.addItem(this._itemArray[this._nstored - 1]);
        this._value.setSelectedItem(this._itemArray[this._nstored - 1]);
        for (JTree tree : this.trees) {
            ((DefaultTreeModel)tree.getModel()).reload();
            tree.setSelectionPath(this._pathArray[this._nstored - 1]);
            tree.scrollPathToVisible(this._pathArray[this._nstored - 1]);
        }
    }

    @Override
    public int getIntValue() {
        if (this._value.getSelectedIndex() >= this._valueArray.length || this._value.getSelectedIndex() < 0) {
            log.error("trying to get value {} too large for array length {} in var {}", new Object[]{this._value.getSelectedIndex(), this._valueArray.length, this.label()});
        }
        log.debug("SelectedIndex={}", (Object)this._value.getSelectedIndex());
        return this._valueArray[this._value.getSelectedIndex()];
    }

    @Override
    public Component getCommonRep() {
        return this._value;
    }

    public void setValue(int value) {
        int oldVal = this.getIntValue();
        this.selectValue(value);
        if (oldVal != value || this.getState() == 0) {
            this.prop.firePropertyChange("Value", null, (Object)value);
        }
    }

    @Override
    public Component getNewRep(String format) {
        switch (format) {
            case "checkbox": {
                ComboCheckBox b = new ComboCheckBox(this._value, this);
                this.comboCBs.add(b);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    b.setEnabled(false);
                }
                this.updateRepresentation(b);
                return b;
            }
            case "radiobuttons": {
                ComboRadioButtons b = new ComboRadioButtons(this._value, this);
                this.comboRBs.add(b);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    b.setEnabled(false);
                }
                this.updateRepresentation(b);
                return b;
            }
            case "onradiobutton": {
                ComboOnRadioButton b = new ComboOnRadioButton(this._value, this);
                this.comboRBs.add(b);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    b.setEnabled(false);
                }
                this.updateRepresentation(b);
                return b;
            }
            case "offradiobutton": {
                ComboOffRadioButton b = new ComboOffRadioButton(this._value, this);
                this.comboRBs.add(b);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    b.setEnabled(false);
                }
                this.updateRepresentation(b);
                return b;
            }
            case "tree": {
                DefaultTreeModel dModel = new DefaultTreeModel(this.treeNodes.getFirst());
                JTree dTree = new JTree(dModel);
                this.trees.add(dTree);
                JScrollPane dScroll = new JScrollPane(dTree);
                dTree.setRootVisible(false);
                dTree.setShowsRootHandles(true);
                dTree.setScrollsOnExpand(true);
                dTree.setExpandsSelectedPaths(true);
                dTree.getSelectionModel().setSelectionMode(1);
                dTree.addTreeSelectionListener(new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent e) {
                        TreePath[] paths;
                        TreePath[] treePathArray = paths = e.getPaths();
                        int n = paths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreePath path = treePathArray[n2];
                            DefaultMutableTreeNode o = (DefaultMutableTreeNode)path.getLastPathComponent();
                            if (o.getChildCount() > 0) {
                                ((JTree)e.getSource()).removeSelectionPath(path);
                            }
                            ++n2;
                        }
                        if (paths.length >= 1 && paths[0].getLastPathComponent() instanceof TreeLeafNode) {
                            EnumVariableValue.this.setValue(EnumVariableValue.this._valueArray[((TreeLeafNode)paths[0].getLastPathComponent()).index]);
                        }
                    }
                });
                TreePath path = this._pathArray[this._value.getSelectedIndex()];
                dTree.setSelectionPath(path);
                dTree.scrollPathToVisible(path);
                if (this.getReadOnly() || this.getInfoOnly()) {
                    log.error("read only variables cannot use tree format: {}", (Object)this.item());
                }
                this.updateRepresentation(dScroll);
                return dScroll;
            }
        }
        VarComboBox b = new VarComboBox(this._value.getModel(), this);
        this.comboVars.add(b);
        if (this.getReadOnly() || this.getInfoOnly()) {
            b.setEnabled(false);
        }
        this.updateRepresentation(b);
        return b;
    }

    @Override
    void setColor(Color c) {
        if (c != null) {
            this._value.setBackground(c);
        } else {
            this._value.setBackground(this._defaultColor);
        }
        this._value.setOpaque(true);
    }

    @Override
    public void setCvState(int state) {
        ((CvValue)this._cvMap.get(this.getCvNum())).setState(state);
    }

    @Override
    public boolean isChanged() {
        CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
        return EnumVariableValue.considerChanged(cv);
    }

    @Override
    public void readChanges() {
        if (this.isToRead() && !this.isChanged()) {
            log.debug("!!!!!!! unacceptable combination in readChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToRead()) {
            this.readAll();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isToWrite() && !this.isChanged()) {
            log.debug("!!!!!! unacceptable combination in writeChanges: {}", (Object)this.label());
        }
        if (this.isChanged() || this.isToWrite()) {
            this.writeAll();
        }
    }

    @Override
    public void readAll() {
        this.setToRead(false);
        this.setBusy(true);
        ((CvValue)this._cvMap.get(this.getCvNum())).read(this._status);
    }

    @Override
    public void writeAll() {
        this.setToWrite(false);
        if (this.getReadOnly() || this.getInfoOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.setBusy(true);
        ((CvValue)this._cvMap.get(this.getCvNum())).write(this._status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "Busy": {
                if (!((Boolean)e.getNewValue()).equals(Boolean.FALSE)) break;
                this.setToRead(false);
                this.setToWrite(false);
                this.setBusy(false);
                break;
            }
            case "State": {
                CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
                if (cv.getState() == 64) {
                    this.setToWrite(false);
                }
                if (cv.getState() == 16) {
                    this.setToRead(false);
                }
                this.setState(cv.getState());
                for (JTree tree : this.trees) {
                    tree.setBackground(this._value.getBackground());
                }
                break;
            }
            case "Value": {
                CvValue cv = (CvValue)this._cvMap.get(this.getCvNum());
                int newVal = this.getValueInCV(cv.getValue(), this.getMask(), this._maxVal - 1);
                this.setValue(newVal);
                break;
            }
        }
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        if (this._cvMap.get(this.getCvNum()) == null) {
            log.error("no CV defined for variable {}, no listeners to remove", (Object)this.getCvNum());
        } else {
            ((CvValue)this._cvMap.get(this.getCvNum())).removePropertyChangeListener(this);
        }
        this.disposeReps();
    }

    void disposeReps() {
        if (this._value != null) {
            this._value.removeActionListener(this);
        }
        int i = 0;
        while (i < this.comboCBs.size()) {
            this.comboCBs.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.comboVars.size()) {
            this.comboVars.get(i).dispose();
            ++i;
        }
        i = 0;
        while (i < this.comboRBs.size()) {
            this.comboRBs.get(i).dispose();
            ++i;
        }
    }

    static class TreeLeafNode
    extends DefaultMutableTreeNode {
        int index;

        TreeLeafNode(String name, int index) {
            super(name);
            this.index = index;
        }
    }

    public static class VarComboBox
    extends JComboBox<String> {
        EnumVariableValue _var;
        transient PropertyChangeListener _l = null;

        VarComboBox(ComboBoxModel<String> m, EnumVariableValue var) {
            super(m);
            this._var = var;
            this._l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (log.isDebugEnabled()) {
                        log.debug("VarComboBox saw property change: {}", (Object)e);
                    }
                    this.originalPropertyChanged(e);
                }
            };
            this.setBackground(this._var._value.getBackground());
            this.setOpaque(true);
            this._var.addPropertyChangeListener(this._l);
        }

        void originalPropertyChanged(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("State")) {
                this.setBackground(this._var._value.getBackground());
                this.setOpaque(true);
            }
        }

        public void dispose() {
            if (this._var != null && this._l != null) {
                this._var.removePropertyChangeListener(this._l);
            }
            this._l = null;
            this._var = null;
        }
    }
}

