/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.jmrit.symbolicprog.DccAddressVarHandler;
import jmri.jmrit.symbolicprog.EnumVariableValue;
import jmri.jmrit.symbolicprog.VariableTableModel;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccAddressPanel
extends JPanel {
    JTextField val = new JTextField(6);
    VariableValue primaryAddr = null;
    VariableValue extendAddr = null;
    EnumVariableValue addMode = null;
    VariableTableModel variableModel = null;
    String oldContents = "";
    private static final Logger log = LoggerFactory.getLogger(DccAddressPanel.class);

    public DccAddressPanel(VariableTableModel mod) {
        this(mod, ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("TextDccAddress"));
    }

    public DccAddressPanel(VariableTableModel mod, String label) {
        this.variableModel = mod;
        this.setLayout(new BoxLayout(this, 1));
        PropertyChangeListener dccNews = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DccAddressPanel.this.updateDccAddress();
            }
        };
        this.primaryAddr = this.variableModel.findVar("Short Address");
        if (this.primaryAddr == null) {
            log.debug("DCC Address monitor did not find a Short Address variable");
        } else {
            this.primaryAddr.addPropertyChangeListener(dccNews);
        }
        this.extendAddr = this.variableModel.findVar("Long Address");
        if (this.extendAddr == null) {
            log.debug("DCC Address monitor did not find an Long Address variable");
        } else {
            this.extendAddr.addPropertyChangeListener(dccNews);
        }
        this.addMode = (EnumVariableValue)this.variableModel.findVar("Address Format");
        if (this.addMode == null) {
            log.debug("DCC Address monitor didnt find an Address Format variable");
        } else {
            this.addMode.addPropertyChangeListener(dccNews);
        }
        if (this.addMode != null) {
            this.add(this.addMode.getNewRep("radiobuttons"));
        }
        this.add(new JLabel(label));
        this.val.setToolTipText(ResourceBundle.getBundle("jmri.jmrit.symbolicprog.SymbolicProgBundle").getString("ToolTipDccAddress"));
        this.add(this.val);
        new DccAddressVarHandler(this.primaryAddr, this.extendAddr, this.addMode){

            @Override
            protected void doPrimary() {
                JTextField f;
                if (DccAddressPanel.this.primaryAddr.getCommonRep() instanceof JTextField) {
                    f = (JTextField)DccAddressPanel.this.primaryAddr.getCommonRep();
                } else {
                    f = new JTextField();
                    f.setText(((JLabel)DccAddressPanel.this.primaryAddr.getCommonRep()).getText());
                }
                DccAddressPanel.this.val.setBackground(DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                DccAddressPanel.this.val.setDocument(f.getDocument());
            }

            @Override
            protected void doExtended() {
                JTextField f;
                if (DccAddressPanel.this.extendAddr.getCommonRep() instanceof JTextField) {
                    f = (JTextField)DccAddressPanel.this.extendAddr.getCommonRep();
                } else {
                    f = new JTextField();
                    f.setText(((JLabel)DccAddressPanel.this.extendAddr.getCommonRep()).getText());
                }
                DccAddressPanel.this.val.setBackground(DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                DccAddressPanel.this.val.setDocument(f.getDocument());
            }
        };
        this.val.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DccAddressVarHandler(DccAddressPanel.this.primaryAddr, DccAddressPanel.this.extendAddr, DccAddressPanel.this.addMode){

                    @Override
                    protected void doPrimary() {
                        (this).DccAddressPanel.this.primaryAddr.updatedTextField();
                        (this).DccAddressPanel.this.val.setBackground((this).DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                        if (log.isDebugEnabled()) {
                            log.debug("set color: {}", (Object)(this).DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                        }
                    }

                    @Override
                    protected void doExtended() {
                        (this).DccAddressPanel.this.extendAddr.updatedTextField();
                        (this).DccAddressPanel.this.val.setBackground((this).DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                        if (log.isDebugEnabled()) {
                            log.debug("set color: {}", (Object)(this).DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                        }
                    }
                };
            }
        });
        this.val.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("focusGained");
                }
                DccAddressPanel.this.enterField();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("focusLost");
                }
                DccAddressPanel.this.exitField();
            }
        });
    }

    void enterField() {
        this.oldContents = this.val.getText();
    }

    void exitField() {
        if (!this.oldContents.equals(this.val.getText())) {
            new DccAddressVarHandler(this.primaryAddr, this.extendAddr, this.addMode){

                @Override
                protected void doPrimary() {
                    DccAddressPanel.this.primaryAddr.updatedTextField();
                    DccAddressPanel.this.val.setBackground(DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                    if (log.isDebugEnabled()) {
                        log.debug("set color: {}", (Object)DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                    }
                }

                @Override
                protected void doExtended() {
                    DccAddressPanel.this.extendAddr.updatedTextField();
                    DccAddressPanel.this.val.setBackground(DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                    if (log.isDebugEnabled()) {
                        log.debug("set color: {}", (Object)DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                    }
                }
            };
        }
    }

    void updateDccAddress() {
        if (log.isDebugEnabled()) {
            log.debug("updateDccAddress: short {} long {} mode {}", new Object[]{this.primaryAddr == null ? "<null>" : this.primaryAddr.getValueString(), this.extendAddr == null ? "<null>" : this.extendAddr.getValueString(), this.addMode == null ? "<null>" : this.addMode.getValueString()});
        }
        new DccAddressVarHandler(this.primaryAddr, this.extendAddr, this.addMode){

            @Override
            protected void doPrimary() {
                JTextField f;
                if (DccAddressPanel.this.primaryAddr.getCommonRep() instanceof JTextField) {
                    f = (JTextField)DccAddressPanel.this.primaryAddr.getCommonRep();
                } else {
                    f = new JTextField();
                    f.setText(((JLabel)DccAddressPanel.this.primaryAddr.getCommonRep()).getText());
                }
                DccAddressPanel.this.val.setBackground(DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                DccAddressPanel.this.val.setDocument(f.getDocument());
                if (log.isDebugEnabled()) {
                    log.debug("set color: {}", (Object)DccAddressPanel.this.primaryAddr.getCommonRep().getBackground());
                }
            }

            @Override
            protected void doExtended() {
                JTextField f;
                if (DccAddressPanel.this.extendAddr.getCommonRep() instanceof JTextField) {
                    f = (JTextField)DccAddressPanel.this.extendAddr.getCommonRep();
                } else {
                    f = new JTextField();
                    f.setText(((JLabel)DccAddressPanel.this.extendAddr.getCommonRep()).getText());
                }
                DccAddressPanel.this.val.setBackground(DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                DccAddressPanel.this.val.setDocument(f.getDocument());
                if (log.isDebugEnabled()) {
                    log.debug("set color: {}", (Object)DccAddressPanel.this.extendAddr.getCommonRep().getBackground());
                }
            }
        };
    }
}

