/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.jmrit.symbolicprog.AbstractValue;
import jmri.jmrit.symbolicprog.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvValue
extends AbstractValue
implements ProgListener {
    private final String _num;
    private String _cvName = "";
    private JLabel _status = null;
    private Programmer mProgrammer;
    private int _value = 0;
    private int _decoderValue = 0;
    private int _state = 0;
    private boolean _busy = false;
    Color _defaultColor;
    JTextField _tableEntry = null;
    private boolean _readOnly = false;
    private boolean _infoOnly = false;
    private boolean _writeOnly = false;
    private boolean _toRead = false;
    private boolean _toWrite = false;
    private boolean _reading = false;
    private boolean _confirm = false;
    private static final Logger log = LoggerFactory.getLogger(CvValue.class);

    public CvValue(String num, Programmer pProgrammer) {
        this._num = num;
        this.mProgrammer = pProgrammer;
        this._tableEntry = new JTextField("0", 3);
        this._defaultColor = this._tableEntry.getBackground();
        this._tableEntry.setBackground(COLOR_UNKNOWN);
    }

    public CvValue(String num, String cvName, Programmer pProgrammer) {
        this._num = num;
        this._cvName = cvName;
        if (cvName == null) {
            log.error("cvName == null in ctor num: {}", (Object)num);
        }
        this.mProgrammer = pProgrammer;
        this._tableEntry = new JTextField("0", 3);
        this._defaultColor = this._tableEntry.getBackground();
        this._tableEntry.setBackground(COLOR_UNKNOWN);
    }

    public String toString() {
        return "CvValue _num=" + this._num + " _cvName=" + this._cvName;
    }

    void setProgrammer(Programmer p) {
        this.mProgrammer = p;
    }

    public String number() {
        return this._num;
    }

    public String cvName() {
        return this._cvName;
    }

    public int getValue() {
        return this._value;
    }

    Color getDefaultColor() {
        return this._defaultColor;
    }

    Color getColor() {
        return this._tableEntry.getBackground();
    }

    protected void notifyValueChange(int value) {
        this.prop.firePropertyChange("Value", null, (Object)value);
    }

    public void setValue(int value) {
        log.debug("CV {} value changed from {} to {}", new Object[]{this.number(), this._value, value});
        this.setState(4);
        if (this._value != value) {
            this._value = value;
            this._tableEntry.setText("" + value);
            this.notifyValueChange(value);
        }
    }

    public int getDecoderValue() {
        return this._decoderValue;
    }

    public int getState() {
        return this._state;
    }

    public void setState(int state) {
        if (log.isDebugEnabled()) {
            log.debug("cv {} set state from {} to {}", new Object[]{this.number(), this.stateToString(this._state), this.stateToString(state)});
        }
        int oldstate = this._state;
        this._state = state;
        switch (state) {
            case 0: {
                this.setColor(COLOR_UNKNOWN);
                break;
            }
            case 4: {
                this.setColor(COLOR_EDITED);
                break;
            }
            case 16: {
                this.setColor(COLOR_READ);
                break;
            }
            case 64: {
                this.setColor(COLOR_STORED);
                break;
            }
            case 256: {
                this.setColor(COLOR_FROMFILE);
                break;
            }
            case 512: {
                this.setColor(COLOR_SAME);
                break;
            }
            case 1024: {
                this.setColor(COLOR_DIFF);
                break;
            }
            default: {
                log.error("Inconsistent state: {}", (Object)this._state);
            }
        }
        if (oldstate != state) {
            this.prop.firePropertyChange("State", (Object)oldstate, (Object)state);
        }
    }

    String stateToString(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 4: {
                return "EDITED";
            }
            case 16: {
                return "READ";
            }
            case 64: {
                return "STORED";
            }
            case 256: {
                return "FROMFILE";
            }
            case 512: {
                return "SAME";
            }
            case 1024: {
                return "DIFF";
            }
        }
        log.error("Inconsistent state: {}", (Object)this._state);
        return "ERROR!!";
    }

    public boolean isBusy() {
        return this._busy;
    }

    private void setBusy(boolean busy) {
        log.debug("setBusy from {} to {} state {}", new Object[]{this._busy, busy, this._state});
        boolean oldBusy = this._busy;
        this._busy = busy;
        this.notifyBusyChange(oldBusy, busy);
    }

    private void notifyBusyChange(boolean oldBusy, boolean newBusy) {
        log.debug("notifyBusyChange from {} to {} current state {}", new Object[]{oldBusy, newBusy, this._state});
        if (oldBusy != newBusy) {
            this.prop.firePropertyChange("Busy", oldBusy ? Boolean.TRUE : Boolean.FALSE, newBusy ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    void setColor(Color c) {
        if (c != null) {
            this._tableEntry.setBackground(c);
        } else {
            this._tableEntry.setBackground(this._defaultColor);
        }
    }

    JTextField getTableEntry() {
        return this._tableEntry;
    }

    public void setReadOnly(boolean is) {
        this._readOnly = is;
    }

    public boolean getReadOnly() {
        return this._readOnly;
    }

    public void setInfoOnly(boolean is) {
        this._infoOnly = is;
    }

    public boolean getInfoOnly() {
        return this._infoOnly;
    }

    public void setWriteOnly(boolean is) {
        this._writeOnly = is;
    }

    public boolean getWriteOnly() {
        return this._writeOnly;
    }

    @Override
    public void setToRead(boolean state) {
        if (this.getInfoOnly() || this.getWriteOnly()) {
            state = false;
        }
        this._toRead = state;
    }

    @Override
    public boolean isToRead() {
        return this._toRead;
    }

    @Override
    public void setToWrite(boolean state) {
        if (this.getInfoOnly() || this.getReadOnly()) {
            state = false;
        }
        this._toWrite = state;
    }

    @Override
    public boolean isToWrite() {
        return this._toWrite;
    }

    public void read(JLabel status) {
        log.debug("read call with Cv number {} and programmer {}", (Object)this._num, (Object)this.mProgrammer);
        this.setToRead(false);
        this._status = status;
        if (status != null) {
            status.setText(MessageFormat.format(Bundle.getMessage("StateReadingCV"), this._num));
        }
        if (this.mProgrammer != null) {
            this.setBusy(true);
            this._reading = true;
            this._confirm = false;
            try {
                this.mProgrammer.readCV(this._num, this, this.getValue());
            }
            catch (Exception e) {
                if (status != null) {
                    status.setText(MessageFormat.format(Bundle.getMessage("StateExceptionDuringRead"), e.toString()));
                }
                log.warn("Exception during CV read: {}", (Throwable)e);
                this.setBusy(false);
            }
        } else {
            if (status != null) {
                status.setText(Bundle.getMessage("StateNoProgrammer"));
            }
            log.error("No programmer available!");
        }
    }

    public void confirm(JLabel status) {
        log.debug("confirm call with Cv number {}", (Object)this._num);
        this._status = status;
        if (status != null) {
            status.setText(MessageFormat.format(Bundle.getMessage("StateConfirmingCV"), this._num));
        }
        if (this.mProgrammer != null) {
            this.setBusy(true);
            this._reading = false;
            this._confirm = true;
            try {
                this.mProgrammer.confirmCV(this._num, this._value, this);
            }
            catch (Exception e) {
                if (status != null) {
                    status.setText(MessageFormat.format(Bundle.getMessage("StateExceptionDuringConfirm"), e.toString()));
                }
                log.warn("Exception during CV confirm: {}", (Throwable)e);
                this.setBusy(false);
            }
        } else {
            if (status != null) {
                status.setText(Bundle.getMessage("StateNoProgrammer"));
            }
            log.error("No programmer available!");
        }
    }

    public void write(JLabel status) {
        log.debug("write call with Cv number {}", (Object)this._num);
        this.setToWrite(false);
        this._status = status;
        if (status != null) {
            status.setText(MessageFormat.format(Bundle.getMessage("StateWritingCV"), this._num));
        }
        if (this.mProgrammer != null) {
            this.setBusy(true);
            this._reading = false;
            this._confirm = false;
            try {
                this.setState(0);
                this.mProgrammer.writeCV(this._num, this._value, this);
            }
            catch (Exception e) {
                this.setState(0);
                if (status != null) {
                    status.setText(MessageFormat.format(Bundle.getMessage("StateExceptionDuringWrite"), e.toString()));
                }
                log.warn("Exception during write CV '{}' to '{}'", new Object[]{this._num, this._value, e});
                this.setBusy(false);
            }
        } else {
            if (status != null) {
                status.setText(Bundle.getMessage("StateNoProgrammer"));
            }
            log.error("No programmer available!");
        }
    }

    @Override
    public void programmingOpReply(int value, int retval) {
        if (log.isDebugEnabled()) {
            log.debug("CV progOpReply for CV {} with retval {} during {}", new Object[]{this._num, retval, this._reading ? "read sequence" : (this._confirm ? "confirm sequence" : "write sequence")});
        }
        if (!this._busy) {
            log.error("opReply when not busy!");
        }
        boolean oldBusy = this._busy;
        if (retval == 0) {
            if (this._status != null) {
                this._status.setText(Bundle.getMessage("StateOK"));
            }
            if (this._reading) {
                this._value = value;
                this._tableEntry.setText(Integer.toString(value));
                this.notifyValueChange(value);
                this.setState(16);
                log.debug("CV setting not busy on end read");
                this._busy = false;
                this.notifyBusyChange(oldBusy, this._busy);
            } else if (this._confirm) {
                this._decoderValue = value;
                if (value == this._value) {
                    this.setState(512);
                } else {
                    this.setState(1024);
                }
                this._busy = false;
                this.notifyBusyChange(oldBusy, this._busy);
            } else {
                this.setState(64);
                this._busy = false;
                this.notifyBusyChange(oldBusy, this._busy);
            }
        } else {
            if (this._status != null) {
                this._status.setText(MessageFormat.format(Bundle.getMessage("StateProgrammerError"), this.mProgrammer.decodeErrorCode(retval)));
            }
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CvValue.this.errorTimeout();
                }
            });
            timer.setInitialDelay(1000);
            timer.setRepeats(false);
            timer.start();
        }
        log.debug("CV progOpReply end of handling CV {}", (Object)this._num);
    }

    void errorTimeout() {
        this.setState(0);
        log.debug("CV setting not busy on error reply");
        this._busy = false;
        this.notifyBusyChange(true, this._busy);
    }

    public void dispose() {
        log.debug("dispose");
    }
}

