/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvImporter {
    private static final Logger log = LoggerFactory.getLogger(CsvImporter.class);

    public CsvImporter(File file, CvTableModel cvModel) throws IOException {
        InputStreamReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            try {
                String line = null;
                String name = null;
                int value = 0;
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                while ((line = bufferedReader.readLine()) != null) {
                    String[] lineStrings = line.split(" *, *");
                    if (lineStrings.length < 2) {
                        bufferedReader.close();
                        throw new IOException();
                    }
                    if (lineStrings[0].equals("CV")) {
                        log.debug("Header OK");
                        continue;
                    }
                    name = lineStrings[0].trim();
                    value = Integer.parseInt(lineStrings[1].trim());
                    CvValue cvObject = cvModel.allCvMap().get(name);
                    if (cvObject == null) {
                        log.warn("CV {} was in import file, but not defined by the decoder definition", (Object)name);
                        cvModel.addCV(name, false, false, false);
                        cvObject = cvModel.allCvMap().get(name);
                    }
                    cvObject.setValue(value);
                }
            }
            catch (IOException e) {
                log.error("Error reading file: {}", (Throwable)e);
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (fileReader != null) {
                fileReader.close();
            }
        }
    }
}

