/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvExportAction
extends AbstractAction {
    JFileChooser fileChooser;
    JFrame mParent;
    CvTableModel mModel;
    private static final Logger log = LoggerFactory.getLogger(CsvExportAction.class);

    public CsvExportAction(String actionName, CvTableModel pModel, JFrame pParent) {
        super(actionName);
        this.mModel = pModel;
        this.mParent = pParent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int retVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
        }
        if ((retVal = this.fileChooser.showSaveDialog(this.mParent)) == 0) {
            File file = this.fileChooser.getSelectedFile();
            if (log.isDebugEnabled()) {
                log.debug("start to export to CSV file {}", (Object)file);
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (CSVPrinter str = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), CSVFormat.DEFAULT);){
                    str.printRecord(new Object[]{"CV, value"});
                    int i = 0;
                    while (i < this.mModel.getRowCount()) {
                        CvValue cv = this.mModel.getCvByRow(i);
                        String num = cv.number();
                        int value = cv.getValue();
                        str.printRecord(new Object[]{num, value});
                        ++i;
                    }
                    str.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                log.error("Error writing file: {}", (Throwable)ex);
            }
        }
    }
}

