/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.EnumVariableValue;
import jmri.jmrit.symbolicprog.VariableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeVariableValue
extends EnumVariableValue {
    Hashtable<String, SettingList> choiceHash = new Hashtable();
    HashSet<VariableValue> variables = new HashSet(20);
    boolean amReading = false;
    boolean readingChanges = false;
    boolean amWriting = false;
    boolean writingChanges = false;
    private static final Logger log = LoggerFactory.getLogger(CompositeVariableValue.class);

    public CompositeVariableValue(String name, String comment, String cvName, boolean readOnly, boolean infoOnly, boolean writeOnly, boolean opsOnly, String cvNum, String mask, int minVal, int maxVal, HashMap<String, CvValue> v, JLabel status, String stdname) {
        super(name, comment, cvName, readOnly, infoOnly, writeOnly, opsOnly, cvNum, mask, minVal, maxVal, v, status, stdname);
        this._maxVal = maxVal;
        this._minVal = minVal;
        this._value = new JComboBox();
        log.debug("New Composite named {}", (Object)name);
    }

    public CompositeVariableValue() {
        this._value = new JComboBox();
    }

    @Override
    public CvValue[] usesCVs() {
        HashSet<CvValue> cvSet = new HashSet<CvValue>(20);
        for (VariableValue v : this.variables) {
            CvValue[] cvs = v.usesCVs();
            int k = 0;
            while (k < cvs.length) {
                cvSet.add(cvs[k]);
                ++k;
            }
        }
        CvValue[] retval = new CvValue[cvSet.size()];
        Iterator j = cvSet.iterator();
        int index = 0;
        while (j.hasNext()) {
            retval[index++] = (CvValue)j.next();
        }
        return retval;
    }

    public void addChoice(String name) {
        SettingList l = new SettingList();
        this.choiceHash.put(name, l);
        this._value.addItem(name);
    }

    public void addSetting(String choice, String varName, VariableValue variable, String value) {
        SettingList s = this.choiceHash.get(choice);
        s.addSetting(varName, variable, value);
        if (variable != null) {
            this.variables.add(variable);
            if (!variable.label().equals(varName)) {
                log.warn("Unexpected label /{}/ for varName /{}/ during addSetting", (Object)variable.label(), (Object)varName);
            }
        } else {
            log.error("Variable pointer null when varName={} in choice {}; ignored", (Object)varName, (Object)choice);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="we want to force an exception")
    public void lastItem() {
        this._defaultColor = this._value.getBackground();
        super.setState(16);
        this.findValue();
        for (VariableValue v : this.variables) {
            if (v == null) {
                log.error("Variable found as null in last item");
            }
            v.addPropertyChangeListener(this);
        }
        this._value.setActionCommand("");
        this._value.addActionListener(this);
    }

    @Override
    public void setToolTipText(String t) {
        super.setToolTipText(t);
        this._value.setToolTipText(t);
    }

    @Override
    public Object rangeVal() {
        return "composite: " + this._minVal + " - " + this._maxVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("")) {
            this._value.setSelectedItem(e.getActionCommand());
        }
        log.debug("action event: {}", (Object)e);
        this.prop.firePropertyChange("Value", null, (Object)this.getIntValue());
        this.selectValue(this.getIntValue());
    }

    @Override
    public void setState(int state) {
        log.debug("Ignore setState({})", (Object)state);
    }

    @Override
    protected void selectValue(int value) {
        log.debug("selectValue({})", (Object)value);
        if (value > this._value.getItemCount() - 1) {
            log.error("Saw unreasonable internal value for pane combo box: {}", (Object)value);
            return;
        }
        String choice = (String)this._value.getItemAt(value);
        SettingList sl = this.choiceHash.get(choice);
        sl.setValues();
    }

    @Override
    public int getIntValue() {
        return this._value.getSelectedIndex();
    }

    @Override
    public Component getCommonRep() {
        return this._value;
    }

    @Override
    public void setValue(int value) {
        int oldVal = this.getIntValue();
        this.selectValue(value);
        if (oldVal != value || this.getState() == 0) {
            this.prop.firePropertyChange("Value", null, (Object)value);
        }
    }

    @Override
    public void setCvState(int state) {
        for (VariableValue v : this.variables) {
            v.setCvState(state);
        }
    }

    @Override
    public boolean isChanged() {
        for (VariableValue v : this.variables) {
            if (!v.isChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setToRead(boolean state) {
        for (VariableValue v : this.variables) {
            v.setToRead(state);
        }
    }

    @Override
    public boolean isToRead() {
        for (VariableValue v : this.variables) {
            if (!v.isToRead()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setToWrite(boolean state) {
        log.debug("Start setToWrite with {}", (Object)state);
        for (VariableValue v : this.variables) {
            v.setToWrite(state);
        }
        log.debug("End setToWrite");
    }

    @Override
    public boolean isToWrite() {
        for (VariableValue v : this.variables) {
            if (!v.isToWrite()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readChanges() {
        if (this.isChanged()) {
            this.readingChanges = true;
            this.amReading = true;
            this.continueRead();
        }
    }

    @Override
    public void writeChanges() {
        if (this.isChanged()) {
            this.writingChanges = true;
            this.amWriting = true;
            this.continueWrite();
        }
    }

    @Override
    public void readAll() {
        this.readingChanges = false;
        this.amReading = true;
        this.continueRead();
    }

    protected void continueRead() {
        log.debug("Start continueRead");
        for (VariableValue v : this.variables) {
            if (!v.isToRead() || this.readingChanges && !v.isChanged()) continue;
            this.amReading = true;
            this.setBusy(true);
            if (this.readingChanges) {
                v.readChanges();
            } else {
                v.readAll();
            }
            return;
        }
        this.amReading = false;
        super.setState(16);
        this.setBusy(false);
        log.debug("End continueRead, nothing to do");
    }

    @Override
    public void writeAll() {
        if (this.getReadOnly()) {
            log.error("unexpected write operation when readOnly is set");
        }
        this.writingChanges = false;
        this.amWriting = true;
        this.continueWrite();
    }

    protected void continueWrite() {
        log.debug("Start continueWrite");
        for (VariableValue v : this.variables) {
            if (!v.isToWrite() || this.writingChanges && !v.isChanged()) continue;
            this.amWriting = true;
            this.setBusy(true);
            log.debug("request write of {} writing changes {}", (Object)v.label(), (Object)this.writingChanges);
            if (this.writingChanges) {
                v.writeChanges();
            } else {
                v.writeAll();
            }
            log.debug("return from starting write request");
            return;
        }
        this.amWriting = false;
        super.setState(64);
        this.setBusy(false);
        log.debug("End continueWrite, nothing to do");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (log.isDebugEnabled()) {
            log.debug("propertyChange in {} type {} new value {}", new Object[]{this.label(), e.getPropertyName(), e.getNewValue()});
        }
        if (e.getPropertyName().equals("Busy")) {
            if (((Boolean)e.getNewValue()).equals(Boolean.FALSE)) {
                log.debug("busy change continues programming");
                if (this.amReading) {
                    this.continueRead();
                } else if (this.amWriting) {
                    this.continueWrite();
                }
            }
        } else if (e.getPropertyName().equals("Value")) {
            this.findValue();
        }
    }

    void findValue() {
        if (log.isDebugEnabled()) {
            log.debug("findValue invoked on {}", (Object)this.label());
        }
        int i = 0;
        while (i < this._value.getItemCount()) {
            String choice = (String)this._value.getItemAt(i);
            SettingList sl = this.choiceHash.get(choice);
            if (sl.match()) {
                log.debug("  match in {}", (Object)i);
                this._value.setSelectedItem(choice);
                return;
            }
            ++i;
        }
        log.debug("   no match");
    }

    @Override
    public void dispose() {
        log.debug("dispose");
        for (VariableValue v : this.variables) {
            v.removePropertyChangeListener(this);
        }
        this.disposeReps();
    }

    static class Setting {
        String varName;
        VariableValue variable;
        int value;

        Setting(String varName, VariableValue variable, String value) {
            this.varName = varName;
            this.variable = variable;
            try {
                this.value = Integer.parseInt(value);
            }
            catch (NullPointerException | NumberFormatException runtimeException) {
                log.error("Illegal value received for CompositeVariable {}. Should be int but was {}", (Object)varName, (Object)value);
                return;
            }
            log.debug("    cTor Setting {} = {}", (Object)varName, (Object)value);
        }

        void setValue() {
            log.debug("    Setting.setValue of {} to {}", (Object)this.varName, (Object)this.value);
            if (this.variable == null) {
                log.error("Variable {} not (yet) created. Verify correct compositeSetting", (Object)this.varName);
                return;
            }
            this.variable.setIntValue(this.value);
        }

        boolean match() {
            if (log.isDebugEnabled()) {
                log.debug("         Match checks {} == {}", (Object)this.variable.getIntValue(), (Object)this.value);
            }
            if (this.variable == null) {
                log.error("Variable {} not (yet) created. Verify correct compositeSetting", (Object)this.varName);
                return false;
            }
            return this.variable.getIntValue() == this.value;
        }
    }

    static class SettingList
    extends ArrayList<Setting> {
        public SettingList() {
            log.debug("New setting list");
        }

        void addSetting(String varName, VariableValue variable, String value) {
            Setting s = new Setting(varName, variable, value);
            this.add(s);
        }

        void setValues() {
            if (log.isDebugEnabled()) {
                log.debug(" setValues in length {}", (Object)this.size());
            }
            int i = 0;
            while (i < this.size()) {
                Setting s = (Setting)this.get(i);
                s.setValue();
                ++i;
            }
        }

        boolean match() {
            int i = 0;
            while (i < this.size()) {
                if (!((Setting)this.get(i)).match()) {
                    if (log.isDebugEnabled()) {
                        log.debug("      No match in setting list of length {} at position {}", (Object)this.size(), (Object)i);
                    }
                    return false;
                }
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug("      Match in setting list of length {}", (Object)this.size());
            }
            return true;
        }
    }
}

