/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CombinedLocoSelPane;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedLocoSelTreePane
extends CombinedLocoSelPane {
    protected JTree dTree;
    protected JPanel viewButtons;
    protected volatile transient TreeSelectionListener dListener;
    InvisibleTreeModel dModel;
    DecoderTreeNode dRoot;
    JRadioButton showAll;
    JRadioButton showMatched;
    ArrayList<TreePath> selectedPath = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(CombinedLocoSelTreePane.class);

    public CombinedLocoSelTreePane(JLabel s, ProgModeSelector selector) {
        super(s, selector);
    }

    @Override
    protected JPanel layoutDecoderSelection() {
        JPanel pane1a = new JPanel(new BorderLayout());
        pane1a.add((Component)new JLabel(Bundle.getMessage("LabelDecoderInstalled")), "North");
        this.dRoot = new DecoderTreeNode("Root");
        this.dModel = new InvisibleTreeModel(this.dRoot);
        this.dTree = new JTree(this.dModel){

            @Override
            public String getToolTipText(MouseEvent evt) {
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                return ((DecoderTreeNode)curPath.getLastPathComponent()).getToolTipText();
            }
        };
        this.dTree.setToolTipText("");
        this.createDecoderTypeContents();
        pane1a.add((Component)new JScrollPane(this.dTree), "Center");
        this.dTree.expandPath(new TreePath(this.dRoot));
        this.dTree.setRootVisible(false);
        this.dTree.setShowsRootHandles(true);
        this.dTree.setScrollsOnExpand(true);
        this.dTree.setExpandsSelectedPaths(true);
        this.dTree.getSelectionModel().setSelectionMode(1);
        this.dListener = e -> {
            log.debug("selection changed {} {}", (Object)this.dTree.isSelectionEmpty(), (Object)this.dTree.getSelectionPath());
            if (!this.dTree.isSelectionEmpty() && this.dTree.getSelectionPath() != null && this.dTree.getSelectionPath().getPathCount() > 2 && this.dTree.getSelectionCount() < 2) {
                log.debug("Selection event with {}", (Object)this.dTree.getSelectionPath());
                if (this.locoBox != null) {
                    this.locoBox.setSelectedIndex(0);
                }
                this.go2.setEnabled(true);
                this.go2.setRequestFocusEnabled(true);
                this.go2.requestFocus();
                this.go2.setToolTipText(Bundle.getMessage("TipClickToOpen"));
            } else {
                this.go2.setEnabled(false);
                this.go2.setToolTipText(Bundle.getMessage("TipSelectLoco"));
            }
        };
        this.dTree.addTreeSelectionListener(this.dListener);
        this.dTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (CombinedLocoSelTreePane.this._statusLabel != null) {
                    CombinedLocoSelTreePane.this._statusLabel.setText(Bundle.getMessage("StateIdle"));
                }
                CombinedLocoSelTreePane.this.dTree.getSelectionModel().setSelectionMode(1);
                if (me.getClickCount() == 2 && CombinedLocoSelTreePane.this.go2.isEnabled() && ((TreeNode)CombinedLocoSelTreePane.this.dTree.getSelectionPath().getLastPathComponent()).isLeaf()) {
                    CombinedLocoSelTreePane.this.go2.doClick();
                }
            }
        });
        this.viewButtons = new JPanel();
        this.iddecoder = this.addDecoderIdentButton();
        if (this.iddecoder != null) {
            this.viewButtons.add(this.iddecoder);
        }
        this.showAll = new JRadioButton(Bundle.getMessage("LabelAll"));
        this.showAll.setSelected(true);
        this.showMatched = new JRadioButton(Bundle.getMessage("LabelMatched"));
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && InstanceManager.getDefault(GlobalProgrammerManager.class).isGlobalProgrammerAvailable()) {
            ButtonGroup group = new ButtonGroup();
            group.add(this.showAll);
            group.add(this.showMatched);
            this.viewButtons.add(this.showAll);
            this.viewButtons.add(this.showMatched);
            pane1a.add((Component)this.viewButtons, "South");
            this.showAll.addActionListener(e -> this.setShowMatchedOnly(false));
            this.showMatched.addActionListener(e -> this.setShowMatchedOnly(true));
        }
        return pane1a;
    }

    public void setShowMatchedOnly(boolean state) {
        this.showMatched.setSelected(state);
        this.showAll.setSelected(!state);
        this.dModel.activateFilter(state);
        this.dModel.reload();
        for (TreePath path : this.selectedPath) {
            log.debug("action selects path: {}", (Object)path);
            this.dTree.expandPath(path);
            this.dTree.addSelectionPath(path);
            this.dTree.scrollPathToVisible(path);
        }
    }

    void createDecoderTypeContents() {
        List<DecoderFile> decoders = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, null);
        int len = decoders.size();
        DefaultMutableTreeNode mfgElement = null;
        DefaultMutableTreeNode familyElement = null;
        HashMap<String, DefaultMutableTreeNode> familyNameNode = new HashMap<String, DefaultMutableTreeNode>();
        int i = 0;
        while (i < len) {
            DecoderFile decoder = decoders.get(i);
            String mfg = decoder.getMfg();
            String family = decoder.getFamily();
            String model = decoder.getModel();
            log.debug(" process {}/{}/{} on nodes {}/{}", new Object[]{mfg, family, model, mfgElement == null ? "<null>" : String.valueOf(mfgElement.toString()) + "(" + mfgElement.getChildCount() + ")", familyElement == null ? "<null>" : String.valueOf(familyElement.toString()) + "(" + familyElement.getChildCount() + ")"});
            if (mfgElement == null || !mfg.equals(mfgElement.toString())) {
                mfgElement = new DecoderTreeNode(mfg, "CV8 = " + InstanceManager.getDefault(DecoderIndexFile.class).mfgIdFromName(mfg), "");
                this.dModel.insertNodeInto(mfgElement, this.dRoot, this.dRoot.getChildCount());
                familyNameNode = new HashMap();
                familyElement = null;
            }
            String famComment = decoders.get(i).getFamilyComment();
            String verString = decoders.get(i).getVersionsAsString();
            if (familyElement == null || !family.equals(familyElement.toString()) && !familyNameNode.containsKey(family)) {
                if (i + 2 >= len || decoders.get(i + 2).getFamily().equals(family) || !decoders.get(i + 1).getModel().equals(family)) {
                    log.debug("normal family update case: {}", (Object)family);
                    familyElement = new DecoderTreeNode(family, this.getHoverText(verString, famComment), decoders.get(i).titleString());
                    this.dModel.insertNodeInto(familyElement, mfgElement, mfgElement.getChildCount());
                    familyNameNode.put(family, familyElement);
                } else {
                    log.debug("short case, i={} family={} next {}", new Object[]{i, family, decoders.get(i + 1).getModel()});
                    if (i + 1 > len) {
                        log.error("Unexpected single entry for family: {}", (Object)family);
                    }
                    family = decoders.get(i + 1).getModel();
                    familyElement = new DecoderTreeNode(family, this.getHoverText(verString, famComment), decoders.get(i).titleString());
                    this.dModel.insertNodeInto(familyElement, mfgElement, mfgElement.getChildCount());
                    familyNameNode.put(family, familyElement);
                    ++i;
                }
            } else if (!family.equals(model)) {
                if (familyNameNode.containsKey(family)) {
                    familyElement = (DecoderTreeNode)familyNameNode.get(family);
                }
                String modelComment = decoders.get(i).getModelComment();
                DecoderTreeNode decoderNameNode = new DecoderTreeNode(model, this.getHoverText(verString, modelComment), decoders.get(i).titleString());
                decoderNameNode.setShowable(decoder.getShowable());
                this.dModel.insertNodeInto(decoderNameNode, familyElement, familyElement.getChildCount());
            }
            ++i;
        }
    }

    String getHoverText(String verString, String comment) {
        if (comment == null || comment.equals("")) {
            if (!verString.equals("")) {
                return "CV7=" + verString;
            }
            return "";
        }
        if (verString.equals("")) {
            return comment;
        }
        return StringUtil.concatTextHtmlAware(comment, " (CV7=" + verString + ")");
    }

    @Override
    protected synchronized void startIdentifyDecoder() {
        this.resetSelections();
        super.startIdentifyDecoder();
    }

    public void resetSelections() {
        Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            ((DecoderTreeNode)e.nextElement()).setIdentified(false);
        }
        this.setShowMatchedOnly(false);
        this.selectedPath = new ArrayList();
        this.dTree.expandPath(new TreePath(this.dRoot));
        this.dTree.setExpandsSelectedPaths(true);
        int row = this.dTree.getRowCount() - 1;
        while (row >= 0) {
            this.dTree.collapseRow(row);
            --row;
        }
    }

    @Override
    public void updateForDecoderTypeID(List<DecoderFile> pList) {
        if (log.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder("Identified " + pList.size() + " matches: ");
            int i = 0;
            while (i < pList.size()) {
                buf.append(pList.get(i).getModel()).append(":");
                ++i;
            }
            log.debug(buf.toString());
        }
        if (pList.size() <= 0) {
            log.error("Found empty list in updateForDecoderTypeID, should not happen");
            return;
        }
        this.dTree.clearSelection();
        if (pList.size() > 1) {
            this.dTree.getSelectionModel().setSelectionMode(4);
            this._statusLabel.setText(Bundle.getMessage("StateMultipleMatch"));
        } else {
            this.dTree.getSelectionModel().setSelectionMode(1);
            this._statusLabel.setText(Bundle.getMessage("StateIdle"));
        }
        Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
            node.setIdentified(false);
        }
        this.selectedPath = new ArrayList();
        int i = 0;
        while (i < pList.size()) {
            e = this.dRoot.breadthFirstEnumeration();
            DecoderFile f = pList.get(i);
            String findMfg = f.getMfg();
            String findFamily = f.getFamily();
            String findModel = f.getModel();
            while (e.hasMoreElements()) {
                TreePath path;
                DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
                if (node.getShowable() == DecoderFile.Showable.NO) continue;
                TreeNode[] list = node.getPath();
                if (list.length == 3) {
                    if (!list[1].toString().equals(findMfg) || !list[2].toString().equals(findModel)) continue;
                    log.debug("match length 3");
                    node.setIdentified(true);
                    this.dModel.reload();
                    ((DecoderTreeNode)list[1]).setIdentified(true);
                    ((DecoderTreeNode)list[2]).setIdentified(true);
                    path = new TreePath(node.getPath());
                    this.selectedPath.add(path);
                    break;
                }
                if (list.length != 4 || !list[1].toString().equals(findMfg) || !list[2].toString().equals(findFamily) || !list[3].toString().equals(findModel)) continue;
                log.debug("match length 4");
                node.setIdentified(true);
                this.dModel.reload();
                ((DecoderTreeNode)list[1]).setIdentified(true);
                ((DecoderTreeNode)list[2]).setIdentified(true);
                ((DecoderTreeNode)list[3]).setIdentified(true);
                path = new TreePath(node.getPath());
                this.selectedPath.add(path);
                break;
            }
            ++i;
        }
        for (TreePath path : this.selectedPath) {
            this.dTree.addSelectionPath(path);
            this.dTree.expandPath(path);
            this.dTree.scrollPathToVisible(path);
        }
    }

    @Override
    void updateForDecoderMfgID(String pMfg, int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " (" + pMfg + ") version " + pModelID + "; no such decoder defined";
        log.warn(msg);
        this._statusLabel.setText(msg);
        this.dTree.clearSelection();
        Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
        ArrayList<DecoderTreeNode> selected = new ArrayList<DecoderTreeNode>();
        this.selectedPath = new ArrayList();
        while (e.hasMoreElements()) {
            DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
            if (node.getParent() != null && node.getParent().toString().equals("Root")) {
                if (!node.toString().equals(pMfg)) continue;
                TreePath path = new TreePath(node.getPath());
                this.dTree.expandPath(path);
                this.dTree.addSelectionPath(path);
                this.dTree.scrollPathToVisible(path);
                this.selectedPath.add(path);
                node.setIdentified(true);
                selected.add(node);
                continue;
            }
            node.setIdentified(false);
        }
        for (DecoderTreeNode node : selected) {
            node.setIdentified(true);
            Enumeration<TreeNode> es = this.dRoot.breadthFirstEnumeration();
            while (es.hasMoreElements()) {
                ((DecoderTreeNode)es.nextElement()).setIdentified(true);
            }
        }
        if (this.showMatched.isSelected()) {
            this.dModel.activateFilter(true);
            this.dModel.reload();
        }
    }

    @Override
    void updateForDecoderNotID(int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " version " + pModelID + "; no such manufacturer defined";
        log.warn(msg);
        this._statusLabel.setText(msg);
        this.dTree.clearSelection();
    }

    @Override
    void setDecoderSelectionFromLoco(String loco) {
        RosterEntry locoEntry = Roster.getDefault().entryFromTitle(loco);
        if (locoEntry == null) {
            return;
        }
        this.dTree.removeTreeSelectionListener(this.dListener);
        this.dTree.clearSelection();
        String modelString = locoEntry.getDecoderModel();
        String familyString = locoEntry.getDecoderFamily();
        Enumeration<TreeNode> e = this.dRoot.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
            DecoderTreeNode parentNode = (DecoderTreeNode)node.getParent();
            if (!node.toString().equals(modelString) || !parentNode.toString().equals(familyString)) continue;
            TreePath path = new TreePath(node.getPath());
            node.setIdentified(true);
            parentNode.setIdentified(true);
            this.dModel.reload();
            this.dTree.addSelectionPath(path);
            this.dTree.scrollPathToVisible(path);
            break;
        }
        this.dTree.addTreeSelectionListener(this.dListener);
    }

    @Override
    protected String selectedDecoderType() {
        if (!this.isDecoderSelected()) {
            return null;
        }
        return ((DecoderTreeNode)this.dTree.getLastSelectedPathComponent()).getTitle();
    }

    @Override
    boolean isDecoderSelected() {
        return !this.dTree.isSelectionEmpty();
    }

    static class DecoderTreeNode
    extends DefaultMutableTreeNode {
        protected boolean isIdentified;
        private String toolTipText;
        private String title;
        DecoderFile.Showable showable = DecoderFile.Showable.YES;

        public DecoderTreeNode(String str, String toolTipText, String title) {
            this(str);
            this.toolTipText = toolTipText;
            this.title = title;
        }

        @Override
        public Enumeration<TreeNode> breadthFirstEnumeration() {
            return super.breadthFirstEnumeration();
        }

        public String getTitle() {
            return this.title;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public DecoderTreeNode(Object userObject) {
            this(userObject, true, false, DecoderFile.Showable.YES);
        }

        public DecoderTreeNode(Object userObject, boolean allowsChildren, boolean isIdentified, DecoderFile.Showable showable) {
            super(userObject, allowsChildren);
            this.isIdentified = isIdentified;
            this.showable = showable;
        }

        public TreeNode getChildAt(int index, boolean filterIsActive) {
            if (this.children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            int realIndex = -1;
            int visibleIndex = -1;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
                if (node.isVisible(filterIsActive)) {
                    ++visibleIndex;
                }
                ++realIndex;
                if (visibleIndex != index) continue;
                return (TreeNode)this.children.elementAt(realIndex);
            }
            throw new ArrayIndexOutOfBoundsException("index unmatched");
        }

        public int getChildCount(boolean filterIsActive) {
            if (this.children == null) {
                return 0;
            }
            int count = 0;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
                if (!node.isVisible(filterIsActive)) continue;
                ++count;
            }
            return count;
        }

        public void setIdentified(boolean isIdentified) {
            this.isIdentified = isIdentified;
        }

        public void setShowable(DecoderFile.Showable showable) {
            this.showable = showable;
        }

        public DecoderFile.Showable getShowable() {
            return this.showable;
        }

        private boolean isVisible(boolean filterIsActive) {
            if (this.children != null) {
                Enumeration e = this.children.elements();
                while (e.hasMoreElements()) {
                    DecoderTreeNode node = (DecoderTreeNode)e.nextElement();
                    if (!node.isVisible(filterIsActive)) continue;
                    return true;
                }
                return false;
            }
            return this.isIdentified || !filterIsActive && this.showable == DecoderFile.Showable.YES;
        }
    }

    static class InvisibleTreeModel
    extends DefaultTreeModel {
        protected boolean filterIsActive;

        public InvisibleTreeModel(TreeNode root) {
            this(root, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren) {
            this(root, false, false);
        }

        public InvisibleTreeModel(TreeNode root, boolean asksAllowsChildren, boolean filterIsActive) {
            super(root, asksAllowsChildren);
            this.filterIsActive = filterIsActive;
        }

        public void activateFilter(boolean newValue) {
            this.filterIsActive = newValue;
        }

        public boolean isActivatedFilter() {
            return this.filterIsActive;
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent instanceof DecoderTreeNode) {
                return ((DecoderTreeNode)parent).getChildAt(index, this.filterIsActive);
            }
            return ((TreeNode)parent).getChildAt(index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent instanceof DecoderTreeNode) {
                return ((DecoderTreeNode)parent).getChildCount(this.filterIsActive);
            }
            return ((TreeNode)parent).getChildCount();
        }
    }
}

