/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.progsupport.ProgModeSelector;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.Bundle;
import jmri.jmrit.symbolicprog.CombinedLocoSelPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CombinedLocoSelListPane
extends CombinedLocoSelPane {
    JList<String> mDecoderList;
    ListSelectionListener mDecoderListener;
    JList<String> mMfgList;
    ListSelectionListener mMfgListener;
    private static final Logger log = LoggerFactory.getLogger(CombinedLocoSelListPane.class);

    public CombinedLocoSelListPane(JLabel s, ProgModeSelector selector) {
        super(s, selector);
    }

    @Override
    protected JPanel layoutDecoderSelection() {
        Programmer p;
        JPanel pane1a = new JPanel();
        pane1a.setLayout(new BoxLayout(pane1a, 0));
        pane1a.add(new JLabel("Decoder installed: "));
        this.mMfgList = new JList();
        this.updateMfgListContents(null);
        this.mMfgList.clearSelection();
        this.mMfgList.setSelectionMode(0);
        this.mMfgListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!CombinedLocoSelListPane.this.mMfgList.isSelectionEmpty()) {
                    String vMfg = CombinedLocoSelListPane.this.mMfgList.getSelectedValue();
                    try {
                        int vMfgID = Integer.parseInt(InstanceManager.getDefault(DecoderIndexFile.class).mfgIdFromName(vMfg));
                        CombinedLocoSelListPane.this.listDecodersFromMfg(vMfgID, vMfg);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        };
        this.mMfgList.addListSelectionListener(this.mMfgListener);
        this.mDecoderList = new JList<String>(InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null).getModel());
        this.mDecoderList.clearSelection();
        this.mDecoderList.setSelectionMode(0);
        this.mDecoderListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!CombinedLocoSelListPane.this.mDecoderList.isSelectionEmpty()) {
                    CombinedLocoSelListPane.this.locoBox.setSelectedIndex(0);
                    CombinedLocoSelListPane.this.go2.setEnabled(true);
                    CombinedLocoSelListPane.this.go2.setToolTipText(Bundle.getMessage("TipClickToOpen"));
                    CombinedLocoSelListPane.this.updateMfgListToSelectedDecoder();
                } else {
                    CombinedLocoSelListPane.this.go2.setEnabled(false);
                    CombinedLocoSelListPane.this.go2.setToolTipText(Bundle.getMessage("TipSelectLoco"));
                }
            }
        };
        this.mDecoderList.addListSelectionListener(this.mDecoderListener);
        pane1a.add(new JScrollPane(this.mMfgList));
        pane1a.add(new JScrollPane(this.mDecoderList));
        this.iddecoder = new JToggleButton("Ident");
        this.iddecoder.setToolTipText("Read the decoders mfg and version, then attempt to select its type");
        if (InstanceManager.getNullableDefault(GlobalProgrammerManager.class) != null && (p = InstanceManager.getDefault(GlobalProgrammerManager.class).getGlobalProgrammer()) != null && !p.getCanRead()) {
            this.iddecoder.setEnabled(false);
            this.iddecoder.setToolTipText("Button disabled because configured command station can't read CVs");
        }
        this.iddecoder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (log.isDebugEnabled()) {
                    log.debug("identify decoder pressed");
                }
                CombinedLocoSelListPane.this.startIdentifyDecoder();
            }
        });
        pane1a.add(this.iddecoder);
        pane1a.setAlignmentX(1.0f);
        return pane1a;
    }

    void updateMfgListContents(String specific) {
        if (this.mMfgListener != null) {
            this.mMfgList.removeListSelectionListener(this.mMfgListener);
        }
        String currentValue = this.mMfgList.getSelectedValue();
        List<String> allMfgList = InstanceManager.getDefault(DecoderIndexFile.class).getMfgNameList();
        ArrayList<String> theMfgList = new ArrayList<String>();
        int i = 0;
        while (i < allMfgList.size()) {
            if (specific != null && allMfgList.get(i).equals(specific) || InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(allMfgList.get(i), null, null, null, null, null).size() != 0) {
                theMfgList.add(allMfgList.get(i));
            }
            ++i;
        }
        this.mMfgList.setListData((String[])theMfgList.toArray(new String[0]));
        this.mMfgList.setSelectedValue(currentValue, true);
        if (this.mMfgListener != null) {
            this.mMfgList.addListSelectionListener(this.mMfgListener);
        }
    }

    void updateMfgListToSelectedDecoder() {
        DecoderFile df = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(this.mDecoderList.getSelectedValue());
        if (log.isDebugEnabled()) {
            log.debug("decoder selection changed to {}", (Object)this.mDecoderList.getSelectedValue());
        }
        if (df != null) {
            if (log.isDebugEnabled()) {
                log.debug("matching mfg is {}", (Object)df.getMfg());
            }
            this.updateMfgListWithoutTrigger(df.getMfg());
        }
    }

    void updateMfgListWithoutTrigger(String mfg) {
        this.mMfgList.removeListSelectionListener(this.mMfgListener);
        this.mMfgList.setSelectedValue(mfg, true);
        this.mMfgList.addListSelectionListener(this.mMfgListener);
    }

    @Override
    void updateForDecoderTypeID(List<DecoderFile> pModelList) {
        this.mDecoderList.setModel(DecoderIndexFile.jComboBoxModelFromList(pModelList));
        this.mDecoderList.setSelectedIndex(0);
    }

    @Override
    void updateForDecoderMfgID(String pMfg, int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " (" + pMfg + ") version " + pModelID + "; no such decoder defined";
        log.warn(msg);
        this._statusLabel.setText(msg);
        this.updateMfgListContents(pMfg);
        this.updateMfgListWithoutTrigger(pMfg);
        this.listDecodersFromMfg(pMfgID, pMfg);
    }

    void listDecodersFromMfg(int pMfgID, String pMfg) {
        JComboBox<String> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, Integer.toString(pMfgID), null, null, null);
        if (log.isDebugEnabled()) {
            log.debug("mfg-only selectDecoder found {} matches", (Object)temp.getItemCount());
        }
        this.mDecoderList.setModel(temp.getModel());
        this.mDecoderList.clearSelection();
        this.updateMfgListWithoutTrigger(pMfg);
    }

    @Override
    void updateForDecoderNotID(int pMfgID, int pModelID) {
        String msg = "Found mfg " + pMfgID + " version " + pModelID + "; no such manufacterer defined";
        log.warn(msg);
        this._statusLabel.setText(msg);
        this.mMfgList.setSelectedIndex(1);
        this.mMfgList.clearSelection();
        JComboBox<String> temp = InstanceManager.getDefault(DecoderIndexFile.class).matchingComboBox(null, null, null, null, null, null);
        this.mDecoderList.setModel(temp.getModel());
        this.mDecoderList.clearSelection();
    }

    @Override
    void setDecoderSelectionFromLoco(String loco) {
        RosterEntry locoEntry = Roster.getDefault().entryFromTitle(loco);
        if (locoEntry == null) {
            return;
        }
        String modelString = locoEntry.getDecoderModel();
        String mfgString = InstanceManager.getDefault(DecoderIndexFile.class).fileFromTitle(modelString).getMfg();
        this.updateMfgListWithoutTrigger(mfgString);
        String[] tempArray = new String[]{modelString};
        this.mDecoderList.setListData((String[])tempArray);
        this.mDecoderList.removeListSelectionListener(this.mDecoderListener);
        this.mDecoderList.setSelectedIndex(0);
        this.mDecoderList.addListSelectionListener(this.mDecoderListener);
    }

    @Override
    boolean isDecoderSelected() {
        return !this.mDecoderList.isSelectionEmpty();
    }

    @Override
    protected String selectedDecoderType() {
        if (!this.isDecoderSelected()) {
            return null;
        }
        return this.mDecoderList.getSelectedValue();
    }
}

