/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.symbolicprog;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractValue {
    PropertyChangeSupport prop = new PropertyChangeSupport(this);
    public static final int UNKNOWN = 0;
    public static final int EDITED = 4;
    public static final int READ = 16;
    public static final int STORED = 64;
    public static final int FROMFILE = 256;
    public static final int SAME = 512;
    public static final int DIFF = 1024;
    static final Color COLOR_UNKNOWN = Color.red.brighter();
    static final Color COLOR_EDITED = Color.orange;
    static final Color COLOR_READ = null;
    static final Color COLOR_STORED = null;
    static final Color COLOR_FROMFILE = Color.yellow;
    static final Color COLOR_SAME = null;
    static final Color COLOR_DIFF = Color.red.brighter();
    private boolean _toRead = false;
    private boolean _toWrite = false;
    private boolean available = true;

    abstract void setColor(Color var1);

    public void setToRead(boolean state) {
        this._toRead = state;
    }

    public boolean isToRead() {
        return this._toRead;
    }

    public void setToWrite(boolean state) {
        this._toWrite = state;
    }

    public boolean isToWrite() {
        return this._toWrite;
    }

    public static Color stateColorFromValue(int val) {
        switch (val) {
            case 0: {
                return COLOR_UNKNOWN;
            }
            case 4: {
                return COLOR_EDITED;
            }
            case 16: {
                return COLOR_READ;
            }
            case 64: {
                return COLOR_STORED;
            }
            case 256: {
                return COLOR_FROMFILE;
            }
            case 512: {
                return COLOR_SAME;
            }
            case 1024: {
                return COLOR_DIFF;
            }
        }
        return null;
    }

    public static String stateNameFromValue(int val) {
        switch (val) {
            case 0: {
                return "Unknown";
            }
            case 4: {
                return "Edited";
            }
            case 16: {
                return "Read";
            }
            case 64: {
                return "Stored";
            }
            case 256: {
                return "FromFile";
            }
            case 512: {
                return "Same";
            }
            case 1024: {
                return "Different";
            }
        }
        return "<unexpected value: " + val + ">";
    }

    public void setAvailable(boolean avail) {
        boolean oldval = this.available;
        this.available = avail;
        if (oldval != this.available) {
            this.prop.firePropertyChange("Available", (Object)oldval, (Object)avail);
        }
    }

    public boolean getAvailable() {
        return this.available;
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.prop.addPropertyChangeListener(p);
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.prop.removePropertyChangeListener(p);
    }
}

