/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.swing.meter.configurexml;

import java.awt.GraphicsEnvironment;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.jmrit.swing.meter.MeterFrame;
import jmri.jmrit.swing.meter.MeterFrameManager;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterFrameManagerXml
extends AbstractXmlAdapter {
    private final AbstractXmlAdapter.EnumIO<MeterFrame.Unit> unitEnumMap = new AbstractXmlAdapter.EnumIoNames<MeterFrame.Unit>(MeterFrame.Unit.class);
    private static final Logger log = LoggerFactory.getLogger(MeterFrameManagerXml.class);

    @Override
    public Element store(Object o) {
        Element meterFrames = new Element("meterFrames");
        this.setStoreElementClass(meterFrames);
        for (MeterFrame frame : MeterFrameManager.getInstance().getMeterFrames()) {
            meterFrames.addContent((Content)this.storeMeterFrame(frame));
        }
        return meterFrames;
    }

    public Element storeMeterFrame(MeterFrame frame) {
        Element e = new Element("meterFrame");
        Element e2 = new Element("uuid");
        e2.addContent(frame.getUUID().toString());
        e.addContent((Content)e2);
        e2 = new Element("meter");
        if (frame.getMeter() == null) {
            return e;
        }
        e2.addContent(frame.getMeter().getSystemName());
        e.addContent((Content)e2);
        e.setAttribute("unit", this.unitEnumMap.outputFromEnum(frame.getUnit()));
        e.setAttribute("integer-digits", Integer.toString(frame.getNumIntegerDigits()));
        e.setAttribute("decimal-digits", Integer.toString(frame.getNumDecimalDigits()));
        e.setAttribute("x", Integer.toString(frame.getX()));
        e.setAttribute("y", Integer.toString(frame.getY()));
        e.setAttribute("width", Integer.toString(frame.getWidth()));
        e.setAttribute("height", Integer.toString(frame.getHeight()));
        return e;
    }

    public void setStoreElementClass(Element meterFrames) {
        meterFrames.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(@Nonnull Element shared, Element perNode) throws JmriConfigureXmlException {
        if (GraphicsEnvironment.isHeadless()) {
            return true;
        }
        List frames = shared.getChildren("meterFrame");
        for (Element elem : frames) {
            String uuidStr = elem.getChild("uuid").getText();
            String meterSystemName = elem.getChild("meter").getText();
            Meter meter = (Meter)InstanceManager.getDefault(MeterManager.class).getBySystemName(meterSystemName);
            UUID uuid = UUID.fromString(uuidStr);
            MeterFrame frame = MeterFrameManager.getInstance().getByUUID(uuid);
            if (frame == null) {
                log.debug("creating frame for uuid: {}, selected meter: {}", (Object)uuidStr, (Object)meterSystemName);
                frame = new MeterFrame(uuid);
                frame.initComponents();
            }
            if (meter != null) {
                frame.setMeter(meter);
            } else {
                log.debug("selected meter '{}' not (yet) defined, remembering for later.", (Object)meterSystemName);
                frame.setInitialMeterName(meterSystemName);
            }
            Attribute a = elem.getAttribute("unit");
            if (a != null) {
                frame.setUnit(this.unitEnumMap.inputFromAttribute(a));
            }
            frame.setNumIntegerDigits(this.getAttributeIntegerValue(elem, "integer-digits", 3));
            frame.setNumDecimalDigits(this.getAttributeIntegerValue(elem, "decimal-digits", 0));
            frame.setLocation(Integer.parseInt(elem.getAttributeValue("x")), Integer.parseInt(elem.getAttributeValue("y")));
            frame.setSize(Integer.parseInt(elem.getAttributeValue("width")), Integer.parseInt(elem.getAttributeValue("height")));
            frame.setVisible(true);
        }
        return true;
    }
}

