/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.swing.meter;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.jmrit.swing.meter.MeterFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterFrameManager {
    private static final Logger log = LoggerFactory.getLogger(MeterFrameManager.class);
    private static final MeterFrameManager _instance = new MeterFrameManager();
    private final Map<UUID, MeterFrame> _meterFrameList = new HashMap<UUID, MeterFrame>();

    @CheckReturnValue
    public static MeterFrameManager getInstance() {
        return _instance;
    }

    private MeterFrameManager() {
        log.debug("registerSelf for config of type {}", this.getClass());
        InstanceManager.getOptionalDefault(ConfigureManager.class).ifPresent(cm -> {
            cm.registerConfig(this, this.getXMLOrder());
            log.debug("registering for config of type {}", this.getClass());
        });
    }

    @CheckReturnValue
    public int getXMLOrder() {
        return 400;
    }

    public void register(@Nonnull MeterFrame frame) {
        this._meterFrameList.put(frame.getUUID(), frame);
    }

    public void deregister(@Nonnull MeterFrame frame) {
        this._meterFrameList.remove(frame.getUUID());
    }

    public MeterFrame getByUUID(@Nonnull UUID uuid) {
        return this._meterFrameList.get(uuid);
    }

    public Collection<MeterFrame> getMeterFrames() {
        return Collections.unmodifiableCollection(this._meterFrameList.values());
    }
}

