/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.swing.meter;

import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import jmri.CurrentMeter;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.Meter;
import jmri.MeterManager;
import jmri.VoltageMeter;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.swing.meter.Bundle;
import jmri.jmrit.swing.meter.MeterFrameManager;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeterFrame
extends JmriJFrame {
    private static final int MAX_INTEGER_DIGITS = 7;
    private static final int MAX_DECIMAL_DIGITS = 3;
    private final UUID uuid;
    private final List<Meter> voltageMeters = new ArrayList<Meter>();
    private final List<Meter> currentMeters = new ArrayList<Meter>();
    private JMenuBar menuBar;
    ArrayList<JLabel> integerDigitIcons;
    ArrayList<JLabel> decimalDigitIcons;
    JLabel decimal;
    boolean decimalDot = true;
    Map<Unit, JLabel> unitLabels = new HashMap<Unit, JLabel>();
    Map<Meter, JCheckBoxMenuItem> meter_MenuItemMap = new HashMap<Meter, JCheckBoxMenuItem>();
    Map<Unit, JCheckBoxMenuItem> units_MenuItemMap = new HashMap<Unit, JCheckBoxMenuItem>();
    Map<Integer, JCheckBoxMenuItem> integerDigits_MenuItemMap = new HashMap<Integer, JCheckBoxMenuItem>();
    Map<Integer, JCheckBoxMenuItem> decimalDigits_MenuItemMap = new HashMap<Integer, JCheckBoxMenuItem>();
    JMenuItem lastSelectedMeterMenuItem;
    JMenuItem lastSelectedIntegerDigitsMenuItem;
    JMenuItem lastSelectedDecimalDigitsMenuItem;
    int numIntegerDigits = 3;
    int numDecimalDigits = 0;
    int lastNumDecimalDigits = -1;
    int widthOfAllIconsToDisplay = 0;
    int oldWidthOfAllIconsToDisplay = -1;
    boolean frameIsInitialized = false;
    Unit selectedUnit = Unit.Volt;
    int digitIconWidth;
    int decimalIconWidth;
    int unitIconWidth;
    int iconHeight;
    private PropertyChangeListener propertyChangeListener;
    private Meter meter;
    private String initialMeterName = "";
    NamedIcon[] integerDigits = new NamedIcon[10];
    NamedIcon[] decimalDigits = new NamedIcon[10];
    NamedIcon decimalIcon;
    NamedIcon microVoltIcon;
    NamedIcon milliVoltIcon;
    NamedIcon voltIcon;
    NamedIcon kiloVoltIcon;
    NamedIcon microAmpIcon;
    NamedIcon milliAmpIcon;
    NamedIcon ampIcon;
    NamedIcon kiloAmpIcon;
    NamedIcon percentIcon;
    NamedIcon errorIcon;
    JPanel pane1;
    JPanel meterPane;
    JMenu voltageMetersMenu = null;
    JMenu currentMetersMenu = null;
    private static final Logger log = LoggerFactory.getLogger(MeterFrame.class);

    public MeterFrame() {
        this(UUID.randomUUID());
    }

    public MeterFrame(UUID uuid) {
        super(Bundle.getMessage("VoltageMeterTitle"));
        this.uuid = uuid;
        MeterManager mm = InstanceManager.getNullableDefault(MeterManager.class);
        if (mm == null) {
            throw new RuntimeException("No meter manager exists");
        }
        this.addAllMeters();
        if (!this.voltageMeters.isEmpty()) {
            this.setMeter(this.voltageMeters.get(0));
        } else if (!this.currentMeters.isEmpty()) {
            this.setMeter(this.currentMeters.get(0));
        } else {
            this.setTitle(Bundle.getMessage("VoltageMeterTitle"));
        }
        MeterFrameManager.getInstance().register(this);
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public Meter getMeter() {
        return this.meter;
    }

    public void setMeter(Meter m) {
        if (this.lastSelectedMeterMenuItem != null) {
            this.lastSelectedMeterMenuItem.setSelected(false);
        }
        if (this.meter != null) {
            this.meter.disable();
            this.meter.removePropertyChangeListener("state", this.propertyChangeListener);
        }
        this.meter = m;
        if (this.meter == null) {
            return;
        }
        this.meter.addPropertyChangeListener("state", this.propertyChangeListener);
        this.meter.enable();
        if (this.frameIsInitialized) {
            this.scaleImage();
            JCheckBoxMenuItem menuItem = this.meter_MenuItemMap.get(this.meter);
            menuItem.setSelected(true);
            this.lastSelectedMeterMenuItem = menuItem;
            this.updateMenuUnits();
            if (!this.getInitialMeterName().equals(m.getSystemName())) {
                this.initSettingsMenu();
                this.setInitialMeterName("");
            }
        }
        if (this.meter instanceof VoltageMeter) {
            this.setTitle(Bundle.getMessage("VoltageMeterTitle2", m.getDisplayName()));
        } else {
            this.setTitle(Bundle.getMessage("CurrentMeterTitle2", m.getDisplayName()));
        }
    }

    @Override
    public void initComponents() {
        JCheckBoxMenuItem item;
        JCheckBoxMenuItem item2;
        MeterManager mm = InstanceManager.getNullableDefault(MeterManager.class);
        if (mm == null) {
            return;
        }
        mm.addDataListener(new BeanListListener(this));
        this.menuBar = new JMenuBar();
        this.voltageMetersMenu = new JMenu(Bundle.getMessage("MenuVoltageMeters"));
        this.menuBar.add(this.voltageMetersMenu);
        if (this.voltageMeters.size() == 0) {
            this.voltageMetersMenu.add(new JMenuItem(Bundle.getMessage("NoMeters")));
        } else {
            for (Meter m : this.voltageMeters) {
                item2 = new JCheckBoxMenuItem(new SelectMeterAction(m.getDisplayName(), m));
                this.voltageMetersMenu.add(item2);
                this.meter_MenuItemMap.put(m, item2);
            }
        }
        this.currentMetersMenu = new JMenu(Bundle.getMessage("MenuCurrentMeters"));
        this.menuBar.add(this.currentMetersMenu);
        if (this.currentMeters.size() == 0) {
            this.currentMetersMenu.add(new JMenuItem(Bundle.getMessage("NoMeters")));
        } else {
            for (Meter m : this.currentMeters) {
                item2 = new JCheckBoxMenuItem(new SelectMeterAction(m.getDisplayName(), m));
                this.currentMetersMenu.add(item2);
                this.meter_MenuItemMap.put(m, item2);
            }
        }
        JMenu settingsMenu = new JMenu(Bundle.getMessage("MenuMeterSettings"));
        this.menuBar.add(settingsMenu);
        JMenu unitsMenu = new JMenu(Bundle.getMessage("MenuMeterUnitMenu"));
        settingsMenu.add(unitsMenu);
        Unit[] unitArray = Unit.values();
        int n = unitArray.length;
        int n2 = 0;
        while (n2 < n) {
            Unit unit;
            final Unit u = unit = unitArray[n2];
            item = new JCheckBoxMenuItem(new AbstractAction(Bundle.getMessage("MenuMeter_" + unit.name())){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MeterFrame.this.units_MenuItemMap.get((Object)MeterFrame.this.selectedUnit).setSelected(false);
                    MeterFrame.this.unitLabels.get((Object)MeterFrame.this.selectedUnit).setVisible(false);
                    MeterFrame.this.units_MenuItemMap.get((Object)u).setSelected(true);
                    MeterFrame.this.unitLabels.get((Object)u).setVisible(true);
                    MeterFrame.this.selectedUnit = u;
                    MeterFrame.this.update();
                }
            });
            this.units_MenuItemMap.put(unit, item);
            unitsMenu.add(item);
            ++n2;
        }
        settingsMenu.addSeparator();
        JMenu digitsMenu = new JMenu(Bundle.getMessage("MenuMeterIntegerDigits"));
        settingsMenu.add(digitsMenu);
        int i = 1;
        while (i <= 7) {
            final int ii = i;
            String label = String.valueOf(i);
            JCheckBoxMenuItem item3 = new JCheckBoxMenuItem(new AbstractAction(label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MeterFrame.this.integerDigits_MenuItemMap.get(MeterFrame.this.numIntegerDigits).setSelected(false);
                    MeterFrame.this.numIntegerDigits = ii;
                    MeterFrame.this.update();
                }
            });
            this.integerDigits_MenuItemMap.put(ii, item3);
            digitsMenu.add(item3);
            if (ii == this.numIntegerDigits) {
                item3.setSelected(true);
            }
            ++i;
        }
        JMenu decimalMenu = new JMenu(Bundle.getMessage("MenuMeterDecimalDigits"));
        settingsMenu.add(decimalMenu);
        int i2 = 0;
        while (i2 <= 3) {
            final int ii = i2;
            String label2 = String.valueOf(i2);
            item = new JCheckBoxMenuItem(new AbstractAction(label2){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MeterFrame.this.decimalDigits_MenuItemMap.get(MeterFrame.this.numDecimalDigits).setSelected(false);
                    MeterFrame.this.decimalDigits_MenuItemMap.get(ii).setSelected(true);
                    MeterFrame.this.numDecimalDigits = ii;
                    MeterFrame.this.update();
                }
            });
            this.decimalDigits_MenuItemMap.put(ii, item);
            decimalMenu.add(item);
            if (ii == this.numDecimalDigits) {
                item.setSelected(true);
            }
            ++i2;
        }
        this.setJMenuBar(this.menuBar);
        this.getContentPane().removeAll();
        this.pane1 = new JPanel();
        this.pane1.setLayout(new BoxLayout(this.pane1, 1));
        this.meterPane = new JPanel();
        this.meterPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder()));
        this.meterPane.setLayout(new BoxLayout(this.meterPane, 0));
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        if (symbols.getDecimalSeparator() == ',') {
            this.decimalDot = false;
        }
        int i3 = 0;
        while (i3 < 10) {
            this.integerDigits[i3] = new NamedIcon("resources/icons/misc/LCD/Lcd_" + i3 + "b.GIF", "resources/icons/misc/LCD/Lcd_" + i3 + "b.GIF");
            ++i3;
        }
        i3 = 0;
        while (i3 < 10) {
            this.decimalDigits[i3] = new NamedIcon("resources/icons/misc/LCD/Lcd_" + i3 + "b.GIF", "resources/icons/misc/LCD/Lcd_" + i3 + "b.GIF");
            ++i3;
        }
        this.decimalIcon = this.decimalDot ? new NamedIcon("resources/icons/misc/LCD/decimalb.gif", "resources/icons/misc/LCD/decimalb.gif") : new NamedIcon("resources/icons/misc/LCD/decimalc.gif", "resources/icons/misc/LCD/decimalc.gif");
        this.microVoltIcon = new NamedIcon("resources/icons/misc/LCD/uvoltb.gif", "resources/icons/misc/LCD/uvoltb.gif");
        this.milliVoltIcon = new NamedIcon("resources/icons/misc/LCD/mvoltb.gif", "resources/icons/misc/LCD/mvoltb.gif");
        this.voltIcon = new NamedIcon("resources/icons/misc/LCD/voltb.gif", "resources/icons/misc/LCD/voltb.gif");
        this.kiloVoltIcon = new NamedIcon("resources/icons/misc/LCD/kvoltb.gif", "resources/icons/misc/LCD/kvoltb.gif");
        this.microAmpIcon = new NamedIcon("resources/icons/misc/LCD/uampb.gif", "resources/icons/misc/LCD/uampb.gif");
        this.milliAmpIcon = new NamedIcon("resources/icons/misc/LCD/mampb.gif", "resources/icons/misc/LCD/mampb.gif");
        this.ampIcon = new NamedIcon("resources/icons/misc/LCD/ampb.gif", "resources/icons/misc/LCD/ampb.gif");
        this.kiloAmpIcon = new NamedIcon("resources/icons/misc/LCD/kampb.gif", "resources/icons/misc/LCD/kampb.gif");
        this.percentIcon = new NamedIcon("resources/icons/misc/LCD/percentb.gif", "resources/icons/misc/LCD/percentb.gif");
        this.errorIcon = new NamedIcon("resources/icons/misc/LCD/Lcd_Error.GIF", "resources/icons/misc/LCD/Lcd_Error.GIF");
        this.decimal = new JLabel(this.decimalIcon);
        this.unitLabels.put(Unit.Percent, new JLabel(this.percentIcon));
        this.unitLabels.put(Unit.MicroVolt, new JLabel(this.microVoltIcon));
        this.unitLabels.put(Unit.MilliVolt, new JLabel(this.milliVoltIcon));
        this.unitLabels.put(Unit.Volt, new JLabel(this.voltIcon));
        this.unitLabels.put(Unit.KiloVolt, new JLabel(this.kiloVoltIcon));
        this.unitLabels.put(Unit.MicroAmpere, new JLabel(this.microAmpIcon));
        this.unitLabels.put(Unit.MilliAmpere, new JLabel(this.milliAmpIcon));
        this.unitLabels.put(Unit.Ampere, new JLabel(this.ampIcon));
        this.unitLabels.put(Unit.KiloAmpere, new JLabel(this.kiloAmpIcon));
        Unit[] unitArray2 = Unit.values();
        int n3 = unitArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Unit unit = unitArray2[n4];
            this.unitLabels.get((Object)unit).setVisible(false);
            ++n4;
        }
        this.integerDigitIcons = new ArrayList(7);
        i = 0;
        while (i < 7) {
            this.integerDigitIcons.add(i, new JLabel(this.integerDigits[i]));
            this.meterPane.add(this.integerDigitIcons.get(i));
            ++i;
        }
        this.meterPane.add(this.decimal);
        this.decimalDigitIcons = new ArrayList(3);
        i = 0;
        while (i < 3) {
            this.decimalDigitIcons.add(i, new JLabel(this.decimalDigits[i]));
            this.meterPane.add(this.decimalDigitIcons.get(i));
            ++i;
        }
        for (JLabel label : this.unitLabels.values()) {
            this.meterPane.add(label);
        }
        this.iconHeight = this.integerDigits[0].getIconHeight();
        this.digitIconWidth = this.integerDigits[0].getIconWidth();
        this.decimalIconWidth = this.decimalIcon.getIconWidth();
        this.unitIconWidth = this.milliVoltIcon.getIconWidth();
        this.scaleImage();
        if (this.meter != null) {
            this.meter.enable();
        }
        this.updateMenuUnits();
        this.initSettingsMenu();
        this.propertyChangeListener = e -> this.update();
        if (this.meter != null) {
            this.meter.addPropertyChangeListener("state", this.propertyChangeListener);
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MeterFrame.this.scaleImage();
            }
        });
        this.pane1.add(this.meterPane);
        this.getContentPane().add(this.pane1);
        this.getContentPane().setPreferredSize(this.meterPane.getPreferredSize());
        this.pack();
        this.frameIsInitialized = true;
    }

    private void initSettingsMenu() {
        boolean isPercent = this.meter != null && this.meter.getUnit() == Meter.Unit.Percent;
        boolean isVoltage = this.meter != null && this.meter instanceof VoltageMeter && !isPercent;
        boolean isCurrent = this.meter != null && this.meter instanceof CurrentMeter && !isPercent;
        this.units_MenuItemMap.get((Object)this.selectedUnit).setSelected(false);
        this.unitLabels.get((Object)this.selectedUnit).setVisible(false);
        this.selectedUnit = isPercent ? Unit.Percent : (isVoltage && this.meter.getUnit() == Meter.Unit.Milli ? Unit.MilliVolt : (isVoltage ? Unit.Volt : (isCurrent && this.meter.getUnit() == Meter.Unit.Milli ? Unit.MilliAmpere : Unit.Ampere)));
        this.units_MenuItemMap.get((Object)this.selectedUnit).setSelected(true);
        this.unitLabels.get((Object)this.selectedUnit).setVisible(true);
        log.debug("selectedUnit set to '{}' for '{}'", (Object)this.selectedUnit, (Object)this.uuid);
        this.update();
        if (this.meter == null) {
            return;
        }
        double max = this.meter.getMax();
        int iDigits = (int)(Math.log10(max) + 1.0);
        log.debug("integer digits set to {} for max={} for '{}'", new Object[]{iDigits, max, this.uuid});
        this.setNumIntegerDigits(iDigits);
        double res = this.meter.getResolution();
        int dDigits = 0;
        if (res % 1.0 != 0.0) {
            dDigits = new BigDecimal(String.valueOf(res)).scale();
        }
        log.debug("decimal digits set to {} for resolution={} for '{}'", new Object[]{dDigits, res, this.uuid});
        this.setNumDecimalDigits(dDigits);
    }

    public synchronized void scaleImage() {
        int frameHeight = this.getContentPane().getHeight() - this.meterPane.getInsets().top - this.meterPane.getInsets().bottom;
        int frameWidth = this.getContentPane().getWidth() - this.meterPane.getInsets().left - this.meterPane.getInsets().right;
        double hscale = (double)frameHeight / (double)this.iconHeight;
        double wscale = (double)frameWidth / (double)this.widthOfAllIconsToDisplay;
        double scale = Math.min(hscale, wscale);
        int i = 0;
        while (i < 10) {
            this.integerDigits[i].scale(scale, this);
            ++i;
        }
        i = 0;
        while (i < 10) {
            this.decimalDigits[i].scale(scale, this);
            ++i;
        }
        this.decimalIcon.scale(scale, this);
        this.microVoltIcon.scale(scale, this);
        this.milliVoltIcon.scale(scale, this);
        this.voltIcon.scale(scale, this);
        this.kiloVoltIcon.scale(scale, this);
        this.microAmpIcon.scale(scale, this);
        this.milliAmpIcon.scale(scale, this);
        this.ampIcon.scale(scale, this);
        this.kiloAmpIcon.scale(scale, this);
        this.percentIcon.scale(scale, this);
        this.errorIcon.scale(scale, this);
        this.meterPane.revalidate();
        this.getContentPane().revalidate();
    }

    private void updateMenuUnits() {
        boolean isPercent = this.meter != null && this.meter.getUnit() == Meter.Unit.Percent;
        boolean isVoltage = this.meter != null && this.meter instanceof VoltageMeter && !isPercent;
        boolean isCurrent = this.meter != null && this.meter instanceof CurrentMeter && !isPercent;
        this.units_MenuItemMap.get((Object)Unit.Percent).setVisible(isPercent);
        this.units_MenuItemMap.get((Object)Unit.MicroVolt).setVisible(isVoltage);
        this.units_MenuItemMap.get((Object)Unit.MilliVolt).setVisible(isVoltage);
        this.units_MenuItemMap.get((Object)Unit.Volt).setVisible(isVoltage);
        this.units_MenuItemMap.get((Object)Unit.KiloVolt).setVisible(isVoltage);
        this.units_MenuItemMap.get((Object)Unit.MicroAmpere).setVisible(isCurrent);
        this.units_MenuItemMap.get((Object)Unit.MilliAmpere).setVisible(isCurrent);
        this.units_MenuItemMap.get((Object)Unit.Ampere).setVisible(isCurrent);
        this.units_MenuItemMap.get((Object)Unit.KiloAmpere).setVisible(isCurrent);
    }

    private void showError() {
        JLabel label;
        int i = 0;
        while (i < 7) {
            label = this.integerDigitIcons.get(i);
            if (i < this.numIntegerDigits) {
                label.setIcon(this.errorIcon);
                label.setVisible(true);
            } else {
                label.setVisible(false);
            }
            ++i;
        }
        this.decimal.setVisible(this.numDecimalDigits > 0);
        i = 0;
        while (i < 3) {
            label = this.decimalDigitIcons.get(i);
            if (i < this.numDecimalDigits) {
                label.setIcon(this.errorIcon);
                label.setVisible(true);
            } else {
                label.setVisible(false);
            }
            ++i;
        }
        this.widthOfAllIconsToDisplay = this.digitIconWidth * this.numIntegerDigits;
        if (this.numDecimalDigits > 0) {
            this.widthOfAllIconsToDisplay += this.decimalIconWidth;
        }
        this.widthOfAllIconsToDisplay += this.digitIconWidth * this.numDecimalDigits;
        this.widthOfAllIconsToDisplay += this.unitIconWidth;
        if (this.widthOfAllIconsToDisplay != this.oldWidthOfAllIconsToDisplay) {
            this.scaleImage();
            this.oldWidthOfAllIconsToDisplay = this.widthOfAllIconsToDisplay;
        }
    }

    synchronized void update() {
        JLabel label;
        String[] valueParts;
        if (this.meter == null) {
            this.showError();
            return;
        }
        double meterValue = this.meter.getKnownAnalogValue() * this.selectedUnit.multiply;
        switch (this.meter.getUnit()) {
            case Kilo: {
                meterValue *= 1000.0;
                break;
            }
            case Milli: {
                meterValue /= 1000.0;
                break;
            }
            case Micro: {
                meterValue /= 1000000.0;
            }
        }
        int numChars = this.numIntegerDigits + this.numDecimalDigits + 2;
        String formatStr = String.format("%%0%d.%df", numChars, this.numDecimalDigits + 1);
        String valueStr = String.format(formatStr, meterValue);
        String rgx = "\\.";
        if (!this.decimalDot) {
            rgx = ",";
        }
        if ((valueParts = valueStr.split(rgx)).length < 2) {
            log.warn("cannot parse meter value using locale decimal separator");
            return;
        }
        if (valueParts[0].length() > 7) {
            this.showError();
            return;
        }
        int i = 0;
        while (i < 7) {
            label = this.integerDigitIcons.get(i);
            if (i < valueParts[0].length()) {
                label.setIcon(this.integerDigits[valueParts[0].charAt(i) - 48]);
                label.setVisible(true);
            } else {
                label.setVisible(false);
            }
            ++i;
        }
        this.decimal.setVisible(this.numDecimalDigits > 0);
        i = 0;
        while (i < 3) {
            label = this.decimalDigitIcons.get(i);
            if (i < valueParts[1].length() - 1) {
                label.setIcon(this.integerDigits[valueParts[1].charAt(i) - 48]);
                label.setVisible(true);
            } else {
                label.setVisible(false);
            }
            ++i;
        }
        this.widthOfAllIconsToDisplay = this.digitIconWidth * valueParts[0].length();
        if (this.numDecimalDigits > 0) {
            this.widthOfAllIconsToDisplay += this.decimalIconWidth;
        }
        this.widthOfAllIconsToDisplay += this.digitIconWidth * (valueParts[1].length() - 1);
        this.widthOfAllIconsToDisplay += this.unitIconWidth;
        if (this.widthOfAllIconsToDisplay != this.oldWidthOfAllIconsToDisplay) {
            this.scaleImage();
            this.oldWidthOfAllIconsToDisplay = this.widthOfAllIconsToDisplay;
        }
    }

    @Override
    public void dispose() {
        if (this.meter != null) {
            this.meter.disable();
            this.meter.removePropertyChangeListener(this.propertyChangeListener);
        }
        MeterFrameManager.getInstance().deregister(this);
        super.dispose();
    }

    public int getNumIntegerDigits() {
        return this.numIntegerDigits;
    }

    public void setNumIntegerDigits(int digits) {
        this.integerDigits_MenuItemMap.get(this.numIntegerDigits).setSelected(false);
        this.integerDigits_MenuItemMap.get(digits).setSelected(true);
        this.numIntegerDigits = digits;
        this.update();
    }

    public int getNumDecimalDigits() {
        return this.numDecimalDigits;
    }

    public void setNumDecimalDigits(int digits) {
        this.decimalDigits_MenuItemMap.get(this.numDecimalDigits).setSelected(false);
        this.decimalDigits_MenuItemMap.get(digits).setSelected(true);
        this.numDecimalDigits = digits;
        this.update();
    }

    public Unit getUnit() {
        return this.selectedUnit;
    }

    public void setUnit(Unit unit) {
        this.units_MenuItemMap.get((Object)this.selectedUnit).setSelected(false);
        this.unitLabels.get((Object)this.selectedUnit).setVisible(false);
        this.units_MenuItemMap.get((Object)unit).setSelected(true);
        this.unitLabels.get((Object)unit).setVisible(true);
        this.selectedUnit = unit;
        this.update();
    }

    public String getInitialMeterName() {
        return this.initialMeterName;
    }

    public void setInitialMeterName(String initialMeterName) {
        this.initialMeterName = initialMeterName;
    }

    private void addAllMeters() {
        MeterManager mm = InstanceManager.getNullableDefault(MeterManager.class);
        if (mm == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("attempting to add all meters.  There are {} meters to add.", (Object)mm.getNamedBeanSet().size());
        }
        mm.getNamedBeanSet().forEach(m -> {
            String n = m.getDisplayName();
            if (m instanceof VoltageMeter) {
                if (this.voltageMeters.contains(m)) {
                    log.trace("voltage meter '{}' is already present", (Object)n);
                } else {
                    this.voltageMeters.add((Meter)m);
                    log.trace("Added voltage meter '{}'", (Object)n);
                }
            } else if (m instanceof CurrentMeter) {
                if (this.currentMeters.contains(m)) {
                    log.trace("current meter '{}' is already present", (Object)n);
                } else {
                    this.currentMeters.add((Meter)m);
                    log.trace("Added current meter '{}'", (Object)n);
                }
            }
        });
        if (this.menuBar != null && this.voltageMetersMenu != null) {
            this.updateMetersMenu(this.voltageMetersMenu, this.voltageMeters);
        }
        if (this.menuBar != null && this.currentMetersMenu != null) {
            this.updateMetersMenu(this.currentMetersMenu, this.currentMeters);
        }
    }

    private void updateMetersMenu(JMenu menu, List<Meter> meters) {
        for (Meter meter : meters) {
            String n = meter.getDisplayName();
            log.trace("need to add a new checkbox for meter '{}'?", (Object)n);
            boolean found = false;
            if (menu.getItemCount() > 0) {
                int i = 0;
                while (i < menu.getItemCount() && !found) {
                    JMenuItem jim = menu.getItem(i);
                    if (jim instanceof JCheckBoxMenuItem) {
                        if (jim.getText().compareTo(meter.getDisplayName()) == 0) {
                            log.trace("item '{}' is already in menu", (Object)n);
                            found = true;
                        } else {
                            log.trace("item '{}' is not already in menu", (Object)n);
                        }
                    }
                    ++i;
                }
            }
            if (found) continue;
            log.trace("Adding item '{}' to menu for frame {}", (Object)n, (Object)this.uuid);
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(new SelectMeterAction(n, meter));
            menu.add(item);
            this.meter_MenuItemMap.put(meter, item);
            if (!this.getInitialMeterName().equals(n)) continue;
            this.setMeter(meter);
        }
        if (menu.getItemCount() > meters.size()) {
            int i = 0;
            while (i < menu.getItemCount()) {
                JMenuItem jim = menu.getItem(i);
                if (jim.getText().compareTo(Bundle.getMessage("NoMeters")) == 0) {
                    menu.remove(jim);
                    log.trace("item '{}' removed from this menu for frame {}", (Object)jim.getText(), (Object)this.uuid);
                    break;
                }
                ++i;
            }
        }
    }

    private void updateCheckboxList() {
        log.trace("Updating the checkbox lists of meters.");
        this.addAllMeters();
        this.currentMetersMenu.repaint();
        this.voltageMetersMenu.repaint();
    }

    private static class BeanListListener
    implements Manager.ManagerDataListener<Meter> {
        MeterFrame mf;

        private BeanListListener(MeterFrame mf) {
            this.mf = mf;
        }

        @Override
        public void contentsChanged(Manager.ManagerDataEvent<Meter> e) {
            log.warn("contents of the bean list changed.");
            this.mf.updateCheckboxList();
        }

        @Override
        public void intervalRemoved(Manager.ManagerDataEvent<Meter> e) {
            this.mf.updateCheckboxList();
        }

        @Override
        public void intervalAdded(Manager.ManagerDataEvent<Meter> e) {
            this.mf.updateCheckboxList();
        }
    }

    public class SelectMeterAction
    extends AbstractAction {
        private final Meter m;

        public SelectMeterAction(String actionName, Meter meter) {
            super(actionName);
            this.m = meter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MeterFrame.this.setMeter(this.m);
            JMenuItem selectedItem = (JMenuItem)e.getSource();
            selectedItem.setSelected(true);
            MeterFrame.this.lastSelectedMeterMenuItem = selectedItem;
        }
    }

    public static enum Unit {
        Percent(1.0),
        MicroVolt(1000000.0),
        MilliVolt(1000.0),
        Volt(1.0),
        KiloVolt(0.001),
        MicroAmpere(1000000.0),
        MilliAmpere(1000.0),
        Ampere(1.0),
        KiloAmpere(0.001);

        private final double multiply;

        private Unit(double m) {
            this.multiply = m;
        }
    }
}

