/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.speedometer;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jmri.Application;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.panelEditor.PanelEditor;
import jmri.jmrit.speedometer.Bundle;
import jmri.util.FileUtil;
import jmri.util.IntlUtilities;
import jmri.util.JmriJFrame;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeedometerFrame
extends JmriJFrame {
    final String blank = "       ";
    JTextField startSensor = new JTextField(5);
    ButtonGroup startGroup = new ButtonGroup();
    JRadioButton startOnEntry = new JRadioButton(Bundle.getMessage("RadioButtonEntry"));
    JRadioButton startOnExit = new JRadioButton(Bundle.getMessage("RadioButtonExit"));
    JTextField stopSensor1 = new JTextField(5);
    ButtonGroup stopGroup1 = new ButtonGroup();
    JRadioButton stopOnEntry1 = new JRadioButton(Bundle.getMessage("RadioButtonEntry"));
    JRadioButton stopOnExit1 = new JRadioButton(Bundle.getMessage("RadioButtonExit"));
    public JTextField stopSensor2 = new JTextField(5);
    ButtonGroup stopGroup2 = new ButtonGroup();
    JRadioButton stopOnEntry2 = new JRadioButton(Bundle.getMessage("RadioButtonEntry"));
    JRadioButton stopOnExit2 = new JRadioButton(Bundle.getMessage("RadioButtonExit"));
    JTextField distance1 = new JTextField(5);
    JTextField distance2 = new JTextField(5);
    JButton dimButton = new JButton("");
    JButton startButton = new JButton(Bundle.getMessage("ButtonStart"));
    JLabel text1 = new JLabel(Bundle.getMessage("Distance1English"));
    JLabel text2 = new JLabel(Bundle.getMessage("Distance2English"));
    JLabel text3 = new JLabel(Bundle.getMessage("Speed1English"));
    JLabel text4 = new JLabel(Bundle.getMessage("Speed2English"));
    JButton clearButton = new JButton(Bundle.getMessage("ButtonClear"));
    JLabel result1 = new JLabel("       ");
    JLabel time1 = new JLabel("       ");
    JLabel result2 = new JLabel("       ");
    JLabel time2 = new JLabel("       ");
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    SensorIcon startSensorIcon;
    SensorIcon stopSensorIcon1;
    SensorIcon stopSensorIcon2;
    long startTime = 0L;
    long stopTime1 = 0L;
    long stopTime2 = 0L;
    boolean dim;
    private static final Logger log = LoggerFactory.getLogger(SpeedometerFrame.class);

    public void setInputs(String start, String stop1, String stop2, String d1, String d2) {
        this.startSensor.setText(start);
        this.stopSensor1.setText(stop1);
        this.stopSensor2.setText(stop2);
        this.distance1.setText(d1);
        this.distance2.setText(d2);
    }

    public final void setInputBehavior(boolean startOnEntry, boolean stopOnEntry1, boolean stopOnEntry2) {
        this.startOnEntry.setSelected(startOnEntry);
        this.startOnExit.setSelected(!startOnEntry);
        this.stopOnEntry1.setSelected(stopOnEntry1);
        this.stopOnExit1.setSelected(!stopOnEntry1);
        this.stopOnEntry2.setSelected(stopOnEntry2);
        this.stopOnExit2.setSelected(!stopOnEntry2);
    }

    public final void setUnitsMetric(boolean metric) {
        if (this.dim != metric) {
            this.dim();
        }
    }

    public SpeedometerFrame() {
        super(false, false);
        this.setInputBehavior(true, true, true);
        this.startGroup.add(this.startOnEntry);
        this.startGroup.add(this.startOnExit);
        this.stopGroup1.add(this.stopOnEntry1);
        this.stopGroup1.add(this.stopOnExit1);
        this.stopGroup2.add(this.stopOnEntry2);
        this.stopGroup2.add(this.stopOnExit2);
        this.setTitle(Bundle.getMessage("TitleSpeedometer"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        PanelEditor editor = new PanelEditor();
        editor.makePrivateWindow();
        editor.setVisible(false);
        JPanel pane1 = new JPanel();
        pane1.setLayout(new FlowLayout());
        pane1.add(new JLabel(Bundle.getMessage("LabelSensor")));
        this.startSensor.setToolTipText(Bundle.getMessage("TooltipStartSensor"));
        pane1.add(this.startSensor);
        JLabel startSensorLabel = new JLabel(Bundle.getMessage("LabelStartSensor"));
        startSensorLabel.setLabelFor(this.startSensor);
        pane1.add(startSensorLabel);
        pane1.add(this.startOnEntry);
        pane1.add(this.startOnExit);
        this.startSensorIcon = new SensorIcon(editor);
        this.setupIconMap(this.startSensorIcon);
        this.startSensorIcon.setToolTipText(Bundle.getMessage("TooltipStartSensorIcon"));
        pane1.add(this.startSensorIcon);
        this.getContentPane().add(pane1);
        JPanel pane2 = new JPanel();
        pane2.setLayout(new FlowLayout());
        pane2.add(new JLabel(Bundle.getMessage("LabelSensor")));
        this.stopSensor1.setToolTipText(Bundle.getMessage("TooltipStopSensor1"));
        pane2.add(this.stopSensor1);
        JLabel stopSensor1Label = new JLabel(Bundle.getMessage("LabelStopSensor1"));
        stopSensor1Label.setLabelFor(this.stopSensor1);
        pane2.add(stopSensor1Label);
        pane2.add(this.stopOnEntry1);
        pane2.add(this.stopOnExit1);
        this.stopSensorIcon1 = new SensorIcon(editor);
        this.setupIconMap(this.stopSensorIcon1);
        this.stopSensorIcon1.setToolTipText(Bundle.getMessage("TooltipStartSensorIcon"));
        pane2.add(this.stopSensorIcon1);
        this.getContentPane().add(pane2);
        JPanel pane3 = new JPanel();
        pane3.setLayout(new FlowLayout());
        pane3.add(new JLabel(Bundle.getMessage("LabelSensor")));
        this.stopSensor2.setToolTipText(Bundle.getMessage("TooltipStopSensor2"));
        pane3.add(this.stopSensor2);
        JLabel stopSensor2Label = new JLabel(Bundle.getMessage("LabelStopSensor2"));
        stopSensor2Label.setLabelFor(this.stopSensor2);
        pane3.add(stopSensor2Label);
        pane3.add(this.stopOnEntry2);
        pane3.add(this.stopOnExit2);
        this.stopSensorIcon2 = new SensorIcon(editor);
        this.setupIconMap(this.stopSensorIcon2);
        this.stopSensorIcon2.setToolTipText(Bundle.getMessage("TooltipStartSensorIcon"));
        pane3.add(this.stopSensorIcon2);
        this.getContentPane().add(pane3);
        JPanel pane4 = new JPanel();
        pane4.setLayout(new FlowLayout());
        pane4.add(this.text1);
        this.text1.setLabelFor(this.distance1);
        pane4.add(this.distance1);
        this.getContentPane().add(pane4);
        JPanel pane5 = new JPanel();
        pane5.setLayout(new FlowLayout());
        pane5.add(this.text2);
        this.text2.setLabelFor(this.distance2);
        pane5.add(this.distance2);
        this.getContentPane().add(pane5);
        JPanel buttons = new JPanel();
        buttons.add(this.dimButton);
        this.dimButton.setToolTipText(Bundle.getMessage("TooltipSwitchUnits"));
        buttons.add(this.startButton);
        buttons.add(this.clearButton);
        buttons.add(this.saveButton);
        this.getContentPane().add(buttons);
        this.clearButton.setVisible(false);
        if (InstanceManager.getNullableDefault(SensorManager.class) == null) {
            this.startButton.setEnabled(false);
            this.startButton.setToolTipText(Bundle.getMessage("TooltipSensorsNotSupported"));
        }
        JPanel pane6 = new JPanel();
        pane6.setLayout(new FlowLayout());
        pane6.add(this.text3);
        pane6.add(this.result1);
        this.text3.setLabelFor(this.result1);
        JLabel time1Label = new JLabel(Bundle.getMessage("LabelTime"));
        pane6.add(time1Label);
        pane6.add(this.time1);
        time1Label.setLabelFor(this.time1);
        this.getContentPane().add(pane6);
        JPanel pane7 = new JPanel();
        pane7.setLayout(new FlowLayout());
        pane7.add(this.text4);
        pane7.add(this.result2);
        this.text4.setLabelFor(this.result2);
        JLabel time2Label = new JLabel(Bundle.getMessage("LabelTime"));
        pane7.add(time2Label);
        pane7.add(this.time2);
        time2Label.setLabelFor(this.time2);
        this.getContentPane().add(pane7);
        this.dim();
        this.dimButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.dim();
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.setup();
            }
        });
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.time1.setText("       ");
                SpeedometerFrame.this.time2.setText("       ");
                SpeedometerFrame.this.result1.setText("       ");
                SpeedometerFrame.this.result2.setText("       ");
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.doStore();
            }
        });
        this.startSensor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.startSensorIcon.setSensor(SpeedometerFrame.this.startSensor.getText());
            }
        });
        this.stopSensor1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.stopSensorIcon1.setSensor(SpeedometerFrame.this.stopSensor1.getText());
            }
        });
        this.stopSensor2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpeedometerFrame.this.stopSensorIcon2.setSensor(SpeedometerFrame.this.stopSensor2.getText());
            }
        });
        this.addHelpMenu("package.jmri.jmrit.speedometer.SpeedometerFrame", true);
        this.pack();
        this.doLoad();
    }

    final void dim() {
        this.dimButton.setEnabled(true);
        if (this.dimButton.getText().equals(Bundle.getMessage("ButtonToMetric"))) {
            this.dimButton.setText(Bundle.getMessage("ButtonToEnglish"));
            this.dim = true;
            this.text1.setText(Bundle.getMessage("Distance1Metric"));
            this.text2.setText(Bundle.getMessage("Distance2Metric"));
            this.text3.setText(Bundle.getMessage("Speed1Metric"));
            this.text4.setText(Bundle.getMessage("Speed2Metric"));
        } else {
            this.dimButton.setText(Bundle.getMessage("ButtonToMetric"));
            this.dim = false;
            this.text1.setText(Bundle.getMessage("Distance1English"));
            this.text2.setText(Bundle.getMessage("Distance2English"));
            this.text3.setText(Bundle.getMessage("Speed1English"));
            this.text4.setText(Bundle.getMessage("Speed2English"));
        }
    }

    public void setup() {
        int valid = this.verifyInputs(true);
        if (log.isDebugEnabled()) {
            log.debug("Number of valid stop sensors: {}", (Object)valid);
        }
        this.enableConfiguration(valid == 0);
        if (valid == 0) {
            return;
        }
        Sensor s = InstanceManager.sensorManagerInstance().provideSensor(this.startSensor.getText());
        s.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int now;
                log.debug("start sensor fired");
                if (e.getPropertyName().equals("KnownState") && ((now = ((Integer)e.getNewValue()).intValue()) == 2 && SpeedometerFrame.this.startOnEntry.isSelected() || now == 4 && SpeedometerFrame.this.startOnExit.isSelected())) {
                    SpeedometerFrame.this.startTime = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("set start {}", (Object)SpeedometerFrame.this.startTime);
                    }
                }
            }
        });
        this.startSensorIcon.setSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.startSensor.getText(), s));
        s = InstanceManager.sensorManagerInstance().provideSensor(this.stopSensor1.getText());
        s.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int now;
                log.debug("stop sensor fired");
                if (e.getPropertyName().equals("KnownState") && ((now = ((Integer)e.getNewValue()).intValue()) == 2 && SpeedometerFrame.this.stopOnEntry1.isSelected() || now == 4 && SpeedometerFrame.this.stopOnExit1.isSelected())) {
                    SpeedometerFrame.this.stopTime1 = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("set stop {}", (Object)SpeedometerFrame.this.stopTime1);
                    }
                    float secs = (float)(SpeedometerFrame.this.stopTime1 - SpeedometerFrame.this.startTime) / 1000.0f;
                    float feet = 0.0f;
                    try {
                        feet = IntlUtilities.floatValue(SpeedometerFrame.this.distance1.getText());
                    }
                    catch (ParseException parseException) {
                        log.error("invalid floating point number as input: {}", (Object)SpeedometerFrame.this.distance1.getText());
                    }
                    float speed = !SpeedometerFrame.this.dim ? feet / 5280.0f * (3600.0f / secs) : feet / 100000.0f * (3600.0f / secs);
                    if (log.isDebugEnabled()) {
                        log.debug("calc from {},{}:{}", new Object[]{Float.valueOf(secs), Float.valueOf(feet), Float.valueOf(speed)});
                    }
                    SpeedometerFrame.this.result1.setText(String.valueOf(speed).substring(0, 4));
                    String time = String.valueOf(secs);
                    int offset = time.indexOf(".");
                    if (offset == -1) {
                        offset = time.length();
                    }
                    if ((offset += 2) > time.length()) {
                        offset = time.length();
                    }
                    SpeedometerFrame.this.time1.setText(time.substring(0, offset));
                }
            }
        });
        this.stopSensorIcon1.setSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.stopSensor1.getText(), s));
        if (valid == 1) {
            return;
        }
        s = InstanceManager.sensorManagerInstance().provideSensor(this.stopSensor2.getText());
        s.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int now;
                log.debug("stop sensor fired");
                if (e.getPropertyName().equals("KnownState") && ((now = ((Integer)e.getNewValue()).intValue()) == 2 && SpeedometerFrame.this.stopOnEntry2.isSelected() || now == 4 && SpeedometerFrame.this.stopOnExit2.isSelected())) {
                    SpeedometerFrame.this.stopTime2 = System.currentTimeMillis();
                    if (log.isDebugEnabled()) {
                        log.debug("set stop {}", (Object)SpeedometerFrame.this.stopTime2);
                    }
                    float secs = (float)(SpeedometerFrame.this.stopTime2 - SpeedometerFrame.this.startTime) / 1000.0f;
                    float feet = 0.0f;
                    try {
                        feet = IntlUtilities.floatValue(SpeedometerFrame.this.distance2.getText());
                    }
                    catch (ParseException parseException) {
                        log.error("invalid floating point number as input: {}", (Object)SpeedometerFrame.this.distance2.getText());
                    }
                    float speed = !SpeedometerFrame.this.dim ? feet / 5280.0f * (3600.0f / secs) : feet / 100000.0f * (3600.0f / secs);
                    if (log.isDebugEnabled()) {
                        log.debug("calc from {},{}:{}", new Object[]{Float.valueOf(secs), Float.valueOf(feet), Float.valueOf(speed)});
                    }
                    SpeedometerFrame.this.result2.setText(String.valueOf(speed).substring(0, 4));
                    String time = String.valueOf(secs);
                    int offset = time.indexOf(".");
                    if (offset == -1) {
                        offset = time.length();
                    }
                    if ((offset += 2) > time.length()) {
                        offset = time.length();
                    }
                    SpeedometerFrame.this.time2.setText(time.substring(0, offset));
                }
            }
        });
        NamedBeanHandle<Sensor> namedSensor2 = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(this.stopSensor2.getText(), s);
        this.stopSensorIcon2.setSensor(namedSensor2);
    }

    private void enableConfiguration(boolean enable) {
        this.startButton.setEnabled(enable);
        this.startButton.setVisible(enable);
        this.clearButton.setEnabled(!enable);
        this.clearButton.setVisible(!enable);
        this.saveButton.setEnabled(enable);
        this.startSensor.setEnabled(enable);
        this.startOnEntry.setEnabled(enable);
        this.startOnExit.setEnabled(enable);
        this.stopSensor1.setEnabled(enable);
        this.stopOnEntry1.setEnabled(enable);
        this.stopOnExit1.setEnabled(enable);
        this.stopSensor2.setEnabled(enable);
        this.stopOnEntry2.setEnabled(enable);
        this.stopOnExit2.setEnabled(enable);
        this.distance1.setEnabled(enable);
        this.distance2.setEnabled(enable);
        this.dimButton.setEnabled(enable);
    }

    private int verifyInputs(boolean warn) {
        Sensor s;
        int verify = 0;
        try {
            s = InstanceManager.sensorManagerInstance().provideSensor(this.startSensor.getText());
            if (s == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            log.error("Start sensor invalid: {}", (Object)this.startSensor.getText());
            if (warn) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorStartSensor"), Bundle.getMessage("TitleError"), 2);
            }
            return verify;
        }
        try {
            s = InstanceManager.sensorManagerInstance().provideSensor(this.stopSensor1.getText());
            if (s == null) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            log.error("Stop 1 sensor invalid : {}", (Object)this.stopSensor1.getText());
            if (warn) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorStopSensor1"), Bundle.getMessage("TitleError"), 2);
            }
            return verify;
        }
        if (this.distance1.getText().equals("")) {
            log.error("Distance 1 has not been defined");
            if (warn) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorDistance1"), Bundle.getMessage("TitleError"), 2);
            }
            return verify;
        }
        verify = 1;
        if (!this.stopSensor2.getText().equals("") || !this.distance2.getText().equals("")) {
            try {
                s = InstanceManager.sensorManagerInstance().provideSensor(this.stopSensor2.getText());
                if (s == null) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                log.error("Stop 2 sensor invalid: {}", (Object)this.stopSensor2.getText());
                if (warn) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorStopSensor2"), Bundle.getMessage("TitleError"), 2);
                }
                return 0;
            }
            if (this.distance2.getText().equals("")) {
                log.error("Distance 2 has not been defined");
                this.enableConfiguration(true);
                if (warn) {
                    JOptionPane.showMessageDialog(this, Bundle.getMessage("ErrorDistance2"), Bundle.getMessage("TitleError"), 2);
                }
                return 0;
            }
            verify = 2;
        }
        return verify;
    }

    private void doStore() {
        log.debug("Check if there's anything to store");
        int verify = this.verifyInputs(false);
        if (verify == 0 && JOptionPane.showConfirmDialog(this, Bundle.getMessage("QuestionNothingToStore"), Bundle.getMessage("TitleStoreQuestion"), 0, 3) == 1) {
            return;
        }
        log.debug("Start storing speedometer settings...");
        SpeedometerXml x = new SpeedometerXml();
        x.makeBackupFile(SpeedometerXml.getDefaultFileName());
        File file = x.getFile(true);
        Element root = new Element("speedometer-config");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/speedometer-3-9-3.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = new Document(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/speedometer.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        Element values = new Element("configuration");
        root.addContent((Content)values);
        values.addContent((Content)new Element("useMetric").addContent(this.dim ? "yes" : "no"));
        if (verify > 0 || this.startSensor.getText().length() > 0) {
            values = new Element("sensors");
            root.addContent((Content)values);
            Element e = new Element("sensor");
            e.addContent((Content)new Element("sensorName").addContent(this.startSensor.getText()));
            e.addContent((Content)new Element("type").addContent("StartSensor"));
            e.addContent((Content)new Element("trigger").addContent(this.startOnEntry.isSelected() ? "entry" : "exit"));
            values.addContent((Content)e);
            if (verify > 0) {
                e = new Element("sensor");
                e.addContent((Content)new Element("sensorName").addContent(this.stopSensor1.getText()));
                e.addContent((Content)new Element("type").addContent("StopSensor1"));
                e.addContent((Content)new Element("trigger").addContent(this.stopOnEntry1.isSelected() ? "entry" : "exit"));
                try {
                    e.addContent((Content)new Element("distance").addContent(String.valueOf(IntlUtilities.floatValue(this.distance1.getText()))));
                }
                catch (ParseException parseException) {
                    log.error("Distance isn't a valid floating number: {}", (Object)this.distance1.getText());
                }
                values.addContent((Content)e);
            }
            if (verify > 1) {
                e = new Element("sensor");
                e.addContent((Content)new Element("sensorName").addContent(this.stopSensor2.getText()));
                e.addContent((Content)new Element("type").addContent("StopSensor2"));
                e.addContent((Content)new Element("trigger").addContent(this.stopOnEntry2.isSelected() ? "entry" : "exit"));
                try {
                    e.addContent((Content)new Element("distance").addContent(String.valueOf(IntlUtilities.floatValue(this.distance2.getText()))));
                }
                catch (ParseException parseException) {
                    log.error("Distance isn't a valid floating number: {}", (Object)this.distance2.getText());
                }
                values.addContent((Content)e);
            }
        }
        try {
            x.writeXML(file, doc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing: {}", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error("IO Exception when writing: {}", (Throwable)ex);
        }
        log.debug("...done");
    }

    private void doLoad() {
        log.debug("Check if there's anything to load");
        SpeedometerXml x = new SpeedometerXml();
        File file = x.getFile(false);
        if (file == null) {
            log.debug("Nothing to load");
            return;
        }
        log.debug("Start loading speedometer settings...");
        try {
            Element e;
            int i;
            List l;
            Element root = x.rootFromFile(file);
            if (root == null) {
                log.debug("File could not be read");
                return;
            }
            if (root.getChild("configuration") != null) {
                l = root.getChild("configuration").getChildren();
                if (log.isDebugEnabled()) {
                    log.debug("readFile sees {} configurations", (Object)l.size());
                }
                i = 0;
                while (i < l.size()) {
                    e = (Element)l.get(i);
                    if (log.isDebugEnabled()) {
                        log.debug("Configuration {} value {}", (Object)e.getName(), (Object)e.getValue());
                    }
                    if (e.getName().equals("useMetric")) {
                        this.setUnitsMetric(e.getValue().equals("yes"));
                    }
                    ++i;
                }
            }
            if (root.getChild("sensors") != null) {
                l = root.getChild("sensors").getChildren("sensor");
                if (log.isDebugEnabled()) {
                    log.debug("readFile sees {} sensors", (Object)l.size());
                }
                i = 0;
                while (i < l.size()) {
                    boolean trigger;
                    e = (Element)l.get(i);
                    String sensorType = e.getChild("type").getText();
                    if (sensorType.equals("StartSensor")) {
                        this.startSensor.setText(e.getChild("sensorName").getText());
                        trigger = e.getChild("trigger").getValue().equals("entry");
                        this.startOnEntry.setSelected(trigger);
                        this.startOnExit.setSelected(!trigger);
                    } else if (sensorType.equals("StopSensor1")) {
                        this.stopSensor1.setText(e.getChild("sensorName").getText());
                        trigger = e.getChild("trigger").getValue().equals("entry");
                        this.stopOnEntry1.setSelected(trigger);
                        this.stopOnExit1.setSelected(!trigger);
                        this.distance1.setText(IntlUtilities.valueOf(Float.parseFloat(e.getChild("distance").getText())));
                    } else if (sensorType.equals("StopSensor2")) {
                        this.stopSensor2.setText(e.getChild("sensorName").getText());
                        trigger = e.getChild("trigger").getValue().equals("entry");
                        this.stopOnEntry2.setSelected(trigger);
                        this.stopOnExit2.setSelected(!trigger);
                        this.distance2.setText(IntlUtilities.valueOf(Float.parseFloat(e.getChild("distance").getText())));
                    } else {
                        log.warn("Unknown sensor type: {}", (Object)sensorType);
                    }
                    ++i;
                }
            }
        }
        catch (JDOMException ex) {
            log.error("File invalid: {}", (Throwable)ex);
        }
        catch (IOException ex) {
            log.error("Error reading file: {}", (Throwable)ex);
        }
        log.debug("...done");
    }

    private void setupIconMap(SensorIcon sensor) {
        sensor.setIcon("SensorStateActive", new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-occupied.gif", "resources/icons/smallschematics/tracksegments/circuit-occupied.gif"));
        sensor.setIcon("SensorStateInactive", new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-empty.gif", "resources/icons/smallschematics/tracksegments/circuit-empty.gif"));
        sensor.setIcon("BeanStateInconsistent", new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"));
        sensor.setIcon("BeanStateUnknown", new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"));
    }

    private static class SpeedometerXml
    extends XmlFile {
        private static String baseFileName = "Speedometer.xml";
        private static String fileLocation = FileUtil.getUserFilesPath();

        private SpeedometerXml() {
        }

        public static String getDefaultFileName() {
            return String.valueOf(SpeedometerXml.getFileLocation()) + SpeedometerXml.getFileName();
        }

        public File getFile(boolean store) {
            File file = this.findFile(SpeedometerXml.getDefaultFileName());
            if (file == null && store) {
                file = new File(SpeedometerXml.getDefaultFileName());
            }
            return file;
        }

        public static String getFileName() {
            return String.valueOf(Application.getApplicationName()) + baseFileName;
        }

        public static String getFileLocation() {
            return fileLocation;
        }
    }
}

