/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simpleturnoutctrl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Turnout;
import jmri.UserPreferencesManager;
import jmri.jmrit.simpleturnoutctrl.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTurnoutCtrlFrame
extends JmriJFrame
implements PropertyChangeListener {
    private static final String LOCKED = Bundle.getMessage("Locked");
    private static final String UNLOCKED = Bundle.getMessage("Normal");
    JTextField adrTextField = new JTextField(8);
    JButton throwButton = new JButton();
    JButton closeButton = new JButton();
    JLabel nowStateLabel = new JLabel();
    JLabel nowFeedbackLabel = new JLabel();
    JLabel lockButtonLabel = new JLabel();
    JButton lockButton = new JButton();
    JLabel lockPushButtonLabel = new JLabel();
    JButton lockPushButton = new JButton();
    Turnout turnout = null;
    String newState = "";
    private static final Logger log = LoggerFactory.getLogger(SimpleTurnoutCtrlFrame.class);

    public SimpleTurnoutCtrlFrame() {
        this.adrTextField.setText("");
        this.adrTextField.setVisible(true);
        this.adrTextField.setToolTipText(Bundle.getMessage("AddressToolTip"));
        this.throwButton.setText(InstanceManager.turnoutManagerInstance().getThrownText());
        this.throwButton.setVisible(true);
        this.throwButton.setToolTipText(Bundle.getMessage("ThrowButtonToolTip", InstanceManager.turnoutManagerInstance().getThrownText()));
        this.throwButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTurnoutCtrlFrame.this.throwButtonActionPerformed(e);
            }
        });
        this.closeButton.setText(InstanceManager.turnoutManagerInstance().getClosedText());
        this.closeButton.setVisible(true);
        this.closeButton.setToolTipText(Bundle.getMessage("ThrowButtonToolTip", InstanceManager.turnoutManagerInstance().getClosedText()));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTurnoutCtrlFrame.this.closeButtonActionPerformed(e);
            }
        });
        this.nowStateLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        this.nowStateLabel.setVisible(true);
        this.nowFeedbackLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        this.nowFeedbackLabel.setVisible(true);
        this.lockButtonLabel.setText(String.valueOf(Bundle.getMessage("LockButtonLabel")) + " ");
        this.lockButtonLabel.setVisible(true);
        this.lockButton.setText(UNLOCKED);
        this.lockButton.setVisible(true);
        this.lockButton.setEnabled(false);
        this.lockButton.setToolTipText(Bundle.getMessage("LockButtonToolTip"));
        this.lockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTurnoutCtrlFrame.this.lockButtonActionPerformed(e);
            }
        });
        this.lockPushButtonLabel.setText(Bundle.getMessage("PushButtonLabel"));
        this.lockPushButtonLabel.setVisible(true);
        this.lockPushButton.setText(UNLOCKED);
        this.lockPushButton.setVisible(true);
        this.lockPushButton.setEnabled(false);
        this.lockPushButton.setToolTipText(Bundle.getMessage("PushButtonToolTip"));
        this.lockPushButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTurnoutCtrlFrame.this.lockPushButtonActionPerformed(e);
            }
        });
        this.setTitle(Bundle.getMessage("FrameTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        JPanel tPanel = new JPanel();
        tPanel.setLayout(new GridBagLayout());
        tPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(Bundle.getMessage("BeanNameTurnout")) + " "));
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        tPanel.add((Component)this.adrTextField, c);
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        tPanel.add((Component)this.throwButton, c);
        c.gridx = 2;
        c.anchor = 17;
        tPanel.add((Component)this.closeButton, c);
        JPanel sPanel = new JPanel();
        sPanel.setLayout(new GridBagLayout());
        sPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(Bundle.getMessage("CurrentStateTitle")) + " "));
        sPanel.add(this.nowStateLabel);
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new GridBagLayout());
        fPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(Bundle.getMessage("FeedbackModeTitle")) + " "));
        fPanel.add(this.nowFeedbackLabel);
        JPanel avPanel = new JPanel();
        avPanel.setLayout(new GridBagLayout());
        avPanel.setBorder(BorderFactory.createTitledBorder(String.valueOf(Bundle.getMessage("AdvancedFeaturesTitle")) + " "));
        c.gridx = 0;
        c.gridy = 5;
        c.anchor = 13;
        avPanel.add((Component)this.lockButtonLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        avPanel.add((Component)this.lockButton, c);
        c.gridx = 0;
        c.gridy = 6;
        c.anchor = 13;
        avPanel.add((Component)this.lockPushButtonLabel, c);
        c.gridx = 1;
        c.anchor = 17;
        avPanel.add((Component)this.lockPushButton, c);
        this.getContentPane().add(tPanel);
        this.getContentPane().add(sPanel);
        this.getContentPane().add(fPanel);
        this.getContentPane().add(avPanel);
        this.addHelpMenu("package.jmri.jmrit.simpleturnoutctrl.SimpleTurnoutCtrl", true);
        this.pack();
    }

    public void closeButtonActionPerformed(ActionEvent e) {
        if (this.adrTextField.getText().length() < 1) {
            this.nowStateLabel.setText(Bundle.getMessage("NoAddressHint"));
            return;
        }
        try {
            if (this.turnout != null) {
                this.turnout.removePropertyChangeListener(this);
            }
            this.turnout = InstanceManager.turnoutManagerInstance().provideTurnout(this.adrTextField.getText());
            this.turnout.addPropertyChangeListener(this);
            this.updateTurnoutStatusFields();
            if (this.turnout.getCommandedState() == 2) {
                this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getClosedText());
            }
            log.debug("about to command CLOSED");
            this.turnout.setCommandedState(2);
        }
        catch (IllegalArgumentException ex1) {
            this.invalidTurnout(this.adrTextField.getText(), ex1);
        }
        catch (Exception ex2) {
            log.error("exception during closeButtonActionPerformed", (Throwable)ex2);
            this.nowStateLabel.setText(Bundle.getMessage("ErrorTitle"));
            this.nowFeedbackLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        }
    }

    public void throwButtonActionPerformed(ActionEvent e) {
        if (this.adrTextField.getText().length() < 1) {
            this.nowStateLabel.setText(Bundle.getMessage("NoAddressHint"));
            return;
        }
        try {
            if (this.turnout != null) {
                this.turnout.removePropertyChangeListener(this);
            }
            this.turnout = InstanceManager.turnoutManagerInstance().provideTurnout(this.adrTextField.getText());
            this.turnout.addPropertyChangeListener(this);
            this.updateTurnoutStatusFields();
            if (this.turnout.getCommandedState() == 4) {
                this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getThrownText());
            }
            log.debug("about to command THROWN");
            this.turnout.setCommandedState(4);
        }
        catch (IllegalArgumentException ex1) {
            this.invalidTurnout(this.adrTextField.getText(), ex1);
        }
        catch (Exception ex2) {
            log.error("exception during throwButtonActionPerformed", (Throwable)ex2);
            this.nowStateLabel.setText(Bundle.getMessage("ErrorTitle"));
            this.nowFeedbackLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        }
    }

    public void lockButtonActionPerformed(ActionEvent e) {
        try {
            if (this.turnout != null) {
                this.turnout.removePropertyChangeListener(this);
            }
            this.turnout = InstanceManager.turnoutManagerInstance().provideTurnout(this.adrTextField.getText());
            this.turnout.addPropertyChangeListener(this);
            this.updateTurnoutStatusFields();
            if (this.lockButton.getText().equals(LOCKED)) {
                this.turnout.setLocked(1, false);
            } else if (this.turnout.canLock(1)) {
                this.turnout.setLocked(1, true);
            }
        }
        catch (IllegalArgumentException ex1) {
            this.invalidTurnout(this.adrTextField.getText(), ex1);
        }
        catch (Exception ex2) {
            log.error("exception during lockButtonActionPerformed", (Throwable)ex2);
            this.nowStateLabel.setText(Bundle.getMessage("ErrorTitle"));
            this.nowFeedbackLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        }
    }

    public void lockPushButtonActionPerformed(ActionEvent e) {
        try {
            if (this.turnout != null) {
                this.turnout.removePropertyChangeListener(this);
            }
            this.turnout = InstanceManager.turnoutManagerInstance().provideTurnout(this.adrTextField.getText());
            this.turnout.addPropertyChangeListener(this);
            this.updateTurnoutStatusFields();
            if (this.lockPushButton.getText().equals(LOCKED)) {
                this.turnout.setLocked(2, false);
            } else if (this.turnout.canLock(2)) {
                this.turnout.setLocked(2, true);
            }
        }
        catch (IllegalArgumentException ex1) {
            this.invalidTurnout(this.adrTextField.getText(), ex1);
        }
        catch (Exception ex2) {
            log.error("exception during lockPushButtonActionPerformed", (Throwable)ex2);
            this.nowStateLabel.setText(Bundle.getMessage("ErrorTitle"));
            this.nowFeedbackLabel.setText(Bundle.getMessage("BeanStateUnknown"));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CommandedState")) {
            this.nowStateLabel.setText(Bundle.getMessage("BeanStateInconsistent"));
        }
        if (e.getPropertyName().equals("KnownState")) {
            int now = (Integer)e.getNewValue();
            switch (now) {
                case 1: {
                    this.nowStateLabel.setText(Bundle.getMessage("BeanStateUnknown"));
                    return;
                }
                case 2: {
                    this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getClosedText());
                    return;
                }
                case 4: {
                    this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getThrownText());
                    return;
                }
            }
            this.nowStateLabel.setText(Bundle.getMessage("BeanStateInconsistent"));
            return;
        }
        if (e.getPropertyName().equals("locked")) {
            if (this.turnout.canLock(1)) {
                if (this.turnout.getLocked(1)) {
                    this.lockButton.setText(LOCKED);
                } else {
                    this.lockButton.setText(UNLOCKED);
                }
                this.lockButton.setEnabled(true);
            } else {
                this.lockButton.setText(UNLOCKED);
                this.lockButton.setEnabled(false);
            }
            if (this.turnout.canLock(2)) {
                if (this.turnout.getLocked(2)) {
                    this.lockPushButton.setText(LOCKED);
                } else {
                    this.lockPushButton.setText(UNLOCKED);
                }
                this.lockPushButton.setEnabled(true);
            } else {
                this.lockPushButton.setText(UNLOCKED);
                this.lockPushButton.setEnabled(false);
            }
        }
        if (e.getPropertyName().equals("feedbackchange")) {
            this.updateTurnoutStatusFields();
        }
    }

    private void updateTurnoutStatusFields() {
        this.nowFeedbackLabel.setText(this.turnout.getFeedbackModeName());
        if (this.turnout.canLock(1)) {
            if (this.turnout.getLocked(1)) {
                this.lockButton.setText(LOCKED);
            } else {
                this.lockButton.setText(UNLOCKED);
            }
            this.lockButton.setEnabled(true);
        } else {
            this.lockButton.setText(UNLOCKED);
            this.lockButton.setEnabled(false);
        }
        if (this.turnout.canLock(2)) {
            if (this.turnout.getLocked(2)) {
                this.lockPushButton.setText(LOCKED);
            } else {
                this.lockPushButton.setText(UNLOCKED);
            }
            this.lockPushButton.setEnabled(true);
        } else {
            this.lockPushButton.setText(UNLOCKED);
            this.lockPushButton.setEnabled(false);
        }
        int knownState = this.turnout.getKnownState();
        switch (knownState) {
            case 1: {
                this.nowStateLabel.setText(Bundle.getMessage("BeanStateUnknown"));
                return;
            }
            case 2: {
                this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getClosedText());
                return;
            }
            case 4: {
                this.nowStateLabel.setText(InstanceManager.turnoutManagerInstance().getThrownText());
                return;
            }
        }
        this.nowStateLabel.setText(Bundle.getMessage("BeanStateInconsistent"));
    }

    void invalidTurnout(String name, Exception ex) {
        InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage(Bundle.getMessage("ErrorTitle"), Bundle.getMessage("ErrorConvertHW", name), ex.toString(), "", true, false);
    }
}

