/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simpleprog;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrit.progsupport.ProgModePane;
import jmri.jmrit.simpleprog.Bundle;
import jmri.jmrit.symbolicprog.SymbolicProgBundle;
import jmri.util.JmriJFrame;

public class SimpleProgFrame
extends JmriJFrame
implements ProgListener {
    JToggleButton readButton = new JToggleButton();
    JToggleButton writeButton = new JToggleButton();
    SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 1024, 1);
    JSpinner addrField = new JSpinner(this.model);
    JTextField valField = new JTextField(4);
    ProgModePane modePane = new ProgModePane(1);
    ButtonGroup radixGroup = new ButtonGroup();
    JRadioButton hexButton = new JRadioButton();
    JRadioButton decButton = new JRadioButton();
    JLabel resultsField = new JLabel(" ");

    public SimpleProgFrame() {
        this.readButton.setText(SymbolicProgBundle.getMessage("READ CV"));
        this.readButton.setToolTipText(SymbolicProgBundle.getMessage("READ THE VALUE FROM THE SELECTED CV"));
        this.writeButton.setText(SymbolicProgBundle.getMessage("WRITE CV"));
        this.writeButton.setToolTipText(SymbolicProgBundle.getMessage("WRITE THE VALUE TO THE SELECTED CV"));
        this.hexButton.setText(SymbolicProgBundle.getMessage("Hexadecimal"));
        this.decButton.setText(SymbolicProgBundle.getMessage("Decimal"));
        this.decButton.setSelected(true);
        this.readButton.addActionListener(this::readPushed);
        this.writeButton.addActionListener(this::writePushed);
        this.decButton.addActionListener(this::decHexButtonChanged);
        this.hexButton.addActionListener(this::decHexButtonChanged);
        this.resultsField.setAlignmentX(0.5f);
        Container contentPane = super.getContentPane();
        this.setTitle(SymbolicProgBundle.getMessage("SIMPLE PROGRAMMER"));
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel tPane = new JPanel();
        tPane.setLayout(new BoxLayout(tPane, 0));
        tPane.add(this.readButton);
        tPane.add(this.writeButton);
        contentPane.add(tPane);
        tPane = new JPanel();
        tPane.setLayout(new GridLayout(2, 2));
        tPane.add(new JLabel(SymbolicProgBundle.getMessage("CV NUMBER:")));
        tPane.add(this.addrField);
        tPane.add(new JLabel(SymbolicProgBundle.getMessage("VALUE:")));
        tPane.add(this.valField);
        contentPane.add(tPane);
        contentPane.add(new JSeparator());
        tPane = new JPanel();
        tPane.setLayout(new BoxLayout(tPane, 0));
        tPane.add(this.modePane);
        tPane.add(new JSeparator(1));
        JPanel tPane2 = new JPanel();
        tPane2.setLayout(new BoxLayout(tPane2, 1));
        this.radixGroup.add(this.decButton);
        this.radixGroup.add(this.hexButton);
        tPane2.add(new JLabel(SymbolicProgBundle.getMessage("VALUE IS:")));
        tPane2.add(this.decButton);
        tPane2.add(this.hexButton);
        tPane2.add(Box.createVerticalGlue());
        tPane.add(tPane2);
        contentPane.add(tPane);
        contentPane.add(new JSeparator());
        contentPane.add(this.resultsField);
        if (this.modePane.getProgrammer() != null) {
            this.readButton.setEnabled(this.modePane.getProgrammer().getCanRead());
        } else {
            this.readButton.setEnabled(false);
        }
        this.addHelpMenu("package.jmri.jmrit.simpleprog.SimpleProgFrame", true);
    }

    private int getNewVal() {
        try {
            if (this.decButton.isSelected()) {
                return Integer.parseInt(this.valField.getText());
            }
            return Integer.parseInt(this.valField.getText(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.valField.setText("");
            return 0;
        }
    }

    private String getNewAddr() {
        return "" + this.addrField.getValue();
    }

    private String statusCode(int status) {
        Programmer p = this.modePane.getProgrammer();
        if (status == 0) {
            return SymbolicProgBundle.getMessage("StateOK");
        }
        if (p == null) {
            return SymbolicProgBundle.getMessage("StateNoProgrammer");
        }
        return p.decodeErrorCode(status);
    }

    @Override
    public void programmingOpReply(int value, int status) {
        this.resultsField.setText(this.statusCode(status));
        this.readButton.setSelected(false);
        this.writeButton.setSelected(false);
        if (value != -1) {
            if (this.decButton.isSelected()) {
                this.valField.setText("" + value);
            } else {
                this.valField.setText(Integer.toHexString(value));
            }
        }
    }

    public void readPushed(ActionEvent e) {
        Programmer p = this.modePane.getProgrammer();
        if (p == null) {
            this.resultsField.setText(SymbolicProgBundle.getMessage("StateNoProgrammer"));
            this.readButton.setSelected(false);
        } else if (p.getCanRead()) {
            try {
                this.resultsField.setText(SymbolicProgBundle.getMessage("StateReading"));
                p.readCV(this.getNewAddr(), this);
            }
            catch (ProgrammerException ex) {
                this.resultsField.setText("" + ex);
                this.readButton.setSelected(false);
            }
        } else {
            this.resultsField.setText(SymbolicProgBundle.getMessage("CantReadThisMode"));
            this.readButton.setSelected(false);
        }
    }

    public void writePushed(ActionEvent e) {
        Programmer p = this.modePane.getProgrammer();
        if (p == null) {
            this.resultsField.setText(SymbolicProgBundle.getMessage("StateNoProgrammer"));
            this.writeButton.setSelected(false);
        } else {
            try {
                this.resultsField.setText(SymbolicProgBundle.getMessage("StateWriting"));
                p.writeCV(this.getNewAddr(), this.getNewVal(), this);
            }
            catch (ProgrammerException ex) {
                this.resultsField.setText("" + ex);
                this.writeButton.setSelected(false);
            }
        }
    }

    public void decHexButtonChanged(ActionEvent e) {
        this.resultsField.setText(SymbolicProgBundle.getMessage("StateOK"));
        if (this.valField.getText().equals("")) {
            return;
        }
        int value = 0;
        try {
            value = this.decButton.isSelected() ? Integer.valueOf(this.valField.getText(), 16) : Integer.parseInt(this.valField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.resultsField.setText(Bundle.getMessage("ErrorTitle"));
        }
        if (value != 0) {
            if (this.decButton.isSelected()) {
                this.valField.setText(Integer.toString(value));
            } else {
                this.valField.setText(Integer.toHexString(value));
            }
        }
    }

    @Override
    public void dispose() {
        this.modePane.dispose();
        super.dispose();
    }
}

