/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simplelightctrl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.Light;
import jmri.VariableLight;
import jmri.jmrit.beantable.LightTableAction;
import jmri.jmrit.simplelightctrl.Bundle;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLightCtrlFrame
extends JmriJFrame {
    DecimalFormat threeDigits = new DecimalFormat("000");
    DecimalFormat oneDigits = new DecimalFormat("0");
    DecimalFormat oneDotTwoDigits = new DecimalFormat("0.00");
    Light light = null;
    String newState = "";
    JButton onButton = new JButton();
    JButton offButton = new JButton();
    JLabel textStateLabel = new JLabel();
    JLabel nowStateTextField = new JLabel();
    JLabel nowControllersTextField = new JLabel();
    JLabel textIsEnabledLabel = new JLabel();
    JCheckBox statusIsEnabledCheckBox = new JCheckBox();
    JLabel textIsVariableLabel = new JLabel();
    JCheckBox statusIsVariableCheckBox = new JCheckBox();
    JLabel textIsTransitionLabel = new JLabel();
    JCheckBox statusIsTransitionCheckBox = new JCheckBox();
    JLabel intensityTextLabel1 = new JLabel();
    JLabel nowIntensityLabel = new JLabel();
    JTextField intensityTextField = new JTextField(4);
    JLabel intensityTextLabel2 = new JLabel();
    JButton intensityButton = new JButton();
    JLabel intensityMinTextLabel = new JLabel();
    JLabel nowIntensityMinLabel = new JLabel();
    JTextField intensityMinTextField = new JTextField(4);
    JLabel intensityMaxTextLabel = new JLabel();
    JLabel nowIntensityMaxLabel = new JLabel();
    JTextField intensityMaxTextField = new JTextField(4);
    JLabel transitionTimeTextLabel = new JLabel();
    JLabel nowTransitionTimeLabel = new JLabel();
    JTextField transitionTimeTextField = new JTextField(4);
    JButton applyButton = new JButton();
    private final NamedBeanComboBox<Light> to1 = new NamedBeanComboBox<Light>(InstanceManager.lightManagerInstance());
    private PropertyChangeListener _parentLightListener = null;
    private static final Logger log = LoggerFactory.getLogger(SimpleLightCtrlFrame.class);

    public SimpleLightCtrlFrame() {
        this.to1.setAllowNull(true);
        this.to1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                log.debug("actionevent");
                SimpleLightCtrlFrame.this.resetLightToCombo();
            }
        });
        this.textStateLabel.setText(Bundle.getMessage("LightStatusLabel"));
        this.textStateLabel.setVisible(true);
        this.nowStateTextField.setText(Bundle.getMessage("BeanStateUnknown"));
        this.nowStateTextField.setVisible(true);
        this.nowControllersTextField.setText("");
        this.nowControllersTextField.setVisible(true);
        this.textIsEnabledLabel.setText(Bundle.getMessage("LightIsEnabledLabel"));
        this.textIsEnabledLabel.setToolTipText(Bundle.getMessage("LightIsEnabledLabelToolTip"));
        this.textIsEnabledLabel.setVisible(true);
        this.statusIsEnabledCheckBox.setVisible(true);
        this.statusIsEnabledCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLightCtrlFrame.this.enabledCheckboxActionPerformed(e);
            }
        });
        this.textIsVariableLabel.setText(Bundle.getMessage("LightIsVariableLabel"));
        this.textIsVariableLabel.setVisible(true);
        this.statusIsVariableCheckBox.setVisible(true);
        this.statusIsVariableCheckBox.setEnabled(false);
        this.textIsTransitionLabel.setText(Bundle.getMessage("LightIsTransitionLabel"));
        this.textIsTransitionLabel.setVisible(true);
        this.statusIsTransitionCheckBox.setVisible(true);
        this.statusIsTransitionCheckBox.setEnabled(false);
        this.onButton.setText(Bundle.getMessage("StateOn"));
        this.onButton.setVisible(true);
        this.onButton.setToolTipText(Bundle.getMessage("LightOnButtonToolTip"));
        this.onButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLightCtrlFrame.this.onButtonActionPerformed(e);
            }
        });
        this.offButton.setText(Bundle.getMessage("StateOff"));
        this.offButton.setVisible(true);
        this.offButton.setToolTipText(Bundle.getMessage("LightOffButtonToolTip"));
        this.offButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLightCtrlFrame.this.offButtonActionPerformed(e);
            }
        });
        this.intensityTextLabel1.setText(Bundle.getMessage("LightIntensityTextLabel"));
        this.intensityTextLabel1.setVisible(true);
        this.nowIntensityLabel.setText("");
        this.nowIntensityLabel.setVisible(true);
        this.intensityTextField.setText(this.oneDigits.format(0L));
        this.intensityTextField.setVisible(true);
        this.intensityTextLabel2.setText("%");
        this.intensityTextField.setToolTipText(Bundle.getMessage("LightIntensityTextToolTip"));
        this.intensityMinTextLabel.setText(Bundle.getMessage("LightMinIntensityLabel"));
        this.nowIntensityMinLabel.setText("");
        this.nowIntensityMinLabel.setVisible(true);
        this.intensityMinTextField.setText(this.oneDigits.format(0L));
        this.intensityMinTextField.setVisible(true);
        this.intensityMinTextField.setToolTipText(Bundle.getMessage("LightMinIntensityToolTip"));
        this.intensityMaxTextLabel.setText(Bundle.getMessage("LightMaxIntensityLabel"));
        this.nowIntensityMaxLabel.setText("");
        this.nowIntensityMaxLabel.setVisible(true);
        this.intensityMaxTextField.setText(this.oneDigits.format(100L));
        this.intensityMaxTextField.setVisible(true);
        this.intensityMaxTextField.setToolTipText(Bundle.getMessage("LightMinIntensityToolTip"));
        this.transitionTimeTextLabel.setText(Bundle.getMessage("LightTransitionTimeLabel"));
        this.nowTransitionTimeLabel.setText("");
        this.nowTransitionTimeLabel.setVisible(true);
        this.transitionTimeTextField.setText(this.oneDigits.format(0L));
        this.transitionTimeTextField.setVisible(true);
        this.transitionTimeTextField.setEnabled(true);
        this.transitionTimeTextField.setToolTipText(Bundle.getMessage("LightTransitionTimeToolTip"));
        this.intensityButton.setText(Bundle.getMessage("LightSetButton"));
        this.intensityButton.setVisible(true);
        this.intensityButton.setToolTipText(Bundle.getMessage("LightSetButtonToolTip"));
        this.intensityButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLightCtrlFrame.this.intensityButtonActionPerformed(e);
            }
        });
        this.applyButton.setText(Bundle.getMessage("ButtonApply"));
        this.applyButton.setVisible(true);
        this.applyButton.setToolTipText(Bundle.getMessage("LightApplyButtonToolTip"));
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleLightCtrlFrame.this.applyButtonActionPerformed(e);
            }
        });
        this.setControlFrameActive(false);
        this.setTitle(Bundle.getMessage("LightBorder"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pane2 = new JPanel();
        pane2.add(this.to1);
        this.getContentPane().add(pane2);
        pane2 = new JPanel();
        pane2.add(this.textStateLabel);
        pane2.add(this.nowStateTextField);
        this.getContentPane().add(pane2);
        pane2 = new JPanel();
        pane2.add(this.onButton);
        pane2.add(this.offButton);
        this.getContentPane().add(pane2);
        this.getContentPane().add(new JSeparator(0));
        pane2 = new JPanel();
        pane2.add(this.textIsEnabledLabel);
        pane2.add(this.statusIsEnabledCheckBox);
        this.getContentPane().add(pane2);
        pane2 = new JPanel();
        pane2.add(this.nowControllersTextField);
        this.getContentPane().add(pane2);
        this.getContentPane().add(new JSeparator(0));
        pane2 = new JPanel();
        pane2.add(this.intensityTextLabel1);
        pane2.add(this.nowIntensityLabel);
        pane2.add(this.intensityTextField);
        pane2.add(this.intensityTextLabel2);
        pane2.add(this.intensityButton);
        this.getContentPane().add(pane2);
        this.getContentPane().add(new JSeparator(0));
        pane2 = new JPanel();
        pane2.add(this.intensityMinTextLabel);
        pane2.add(this.nowIntensityMinLabel);
        pane2.add(this.intensityMinTextField);
        pane2.add(this.intensityMaxTextLabel);
        pane2.add(this.nowIntensityMaxLabel);
        pane2.add(this.intensityMaxTextField);
        this.getContentPane().add(pane2);
        pane2 = new JPanel();
        pane2.add(this.transitionTimeTextLabel);
        pane2.add(this.nowTransitionTimeLabel);
        pane2.add(this.transitionTimeTextField);
        pane2.add(this.applyButton);
        this.getContentPane().add(pane2);
        this.addHelpMenu("package.jmri.jmrit.simplelightctrl.SimpleLightCtrl", true);
        this.pack();
    }

    private void setControlFrameActive(boolean showLight) {
        log.debug("selected light is {}", this.to1.getSelectedItem());
        this.onButton.setEnabled(showLight);
        this.offButton.setEnabled(showLight);
        this.statusIsEnabledCheckBox.setEnabled(showLight);
        if (showLight && this.light instanceof VariableLight) {
            this.intensityButton.setEnabled(true);
            this.intensityMinTextField.setEnabled(true);
            this.intensityMaxTextField.setEnabled(true);
            this.intensityTextField.setEnabled(true);
            this.applyButton.setEnabled(true);
        } else {
            this.intensityButton.setEnabled(false);
            this.intensityMinTextField.setEnabled(false);
            this.intensityMaxTextField.setEnabled(false);
            this.intensityTextField.setEnabled(false);
            this.intensityButton.setEnabled(false);
            this.applyButton.setEnabled(false);
        }
        if (showLight && this.light instanceof VariableLight && ((VariableLight)this.light).isTransitionAvailable()) {
            this.transitionTimeTextField.setEnabled(true);
        } else {
            this.transitionTimeTextField.setEnabled(false);
        }
    }

    public void offButtonActionPerformed(ActionEvent e) {
        if (this.to1.getSelectedItem() == null) {
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
            return;
        }
        try {
            this.light.setState(4);
        }
        catch (Exception ex) {
            log.error("{}{}", (Object)Bundle.getMessage("ErrorTitle"), (Object)ex.toString());
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
        }
    }

    public void onButtonActionPerformed(ActionEvent e) {
        if (this.to1.getSelectedItem() == null) {
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
            return;
        }
        try {
            this.light.setState(2);
        }
        catch (Exception ex) {
            log.error("{}{}", (Object)Bundle.getMessage("ErrorTitle"), (Object)ex.toString());
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
        }
    }

    public void intensityButtonActionPerformed(ActionEvent e) {
        if (this.to1.getSelectedItem() == null) {
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
            return;
        }
        try {
            log.debug("about to command DIM");
            if (this.light instanceof VariableLight) {
                ((VariableLight)this.light).setTargetIntensity(Double.parseDouble(this.intensityTextField.getText().trim()) / 100.0);
            }
        }
        catch (NumberFormatException ex) {
            log.error("{}{}", (Object)Bundle.getMessage("LightErrorIntensityButtonException"), (Object)ex.toString());
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
        }
    }

    private void enabledCheckboxActionPerformed(ActionEvent e) {
        if (this.statusIsEnabledCheckBox.isSelected()) {
            this.light.setEnabled(true);
        } else {
            this.light.setEnabled(false);
        }
    }

    public void applyButtonActionPerformed(ActionEvent e) {
        if (this.to1.getSelectedItem() == null) {
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
            this.resetLightToCombo();
            return;
        }
        try {
            if (this.light instanceof VariableLight) {
                VariableLight variableLight = (VariableLight)this.light;
                double min = Double.parseDouble(this.intensityMinTextField.getText()) / 100.0;
                double max = Double.parseDouble(this.intensityMaxTextField.getText()) / 100.0;
                double time = Double.parseDouble(this.transitionTimeTextField.getText());
                log.debug("setting min: {} max: {} transition: {}", new Object[]{min, max, time});
                if (!variableLight.isTransitionAvailable()) {
                    time = 0.0;
                }
                variableLight.setMinIntensity(min);
                variableLight.setMaxIntensity(max);
                variableLight.setTransitionTime(time);
                this.updateLightStatusFields(false);
            }
        }
        catch (NumberFormatException ex) {
            log.error("{}{}", (Object)Bundle.getMessage("ErrorTitle"), (Object)ex.toString());
            this.nowStateTextField.setText(Bundle.getMessage("ErrorTitle"));
        }
    }

    private void resetLightToCombo() {
        if (this.light != null && this.light == this.to1.getSelectedItem()) {
            return;
        }
        log.debug("Light changed in combobox to {}", this.to1.getSelectedItem());
        if (this.light != null) {
            this.light.removePropertyChangeListener(this._parentLightListener);
        }
        this.light = (Light)this.to1.getSelectedItem();
        if (this.light != null) {
            this._parentLightListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    log.debug("recv propChange: {} {} -> {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
                    SimpleLightCtrlFrame.this.updateLightStatusFields(false);
                }
            };
            this.light.addPropertyChangeListener(this._parentLightListener);
            this.setControlFrameActive(true);
            this.updateLightStatusFields(true);
            StringBuilder name = new StringBuilder("<html>");
            this.light.getLightControlList().forEach(otherLc -> {
                name.append(LightTableAction.getDescriptionText(otherLc, otherLc.getControlType()));
                name.append("<br>");
            });
            if (this.light.getLightControlList().isEmpty()) {
                name.append("None");
            }
            name.append("</html>");
            this.nowControllersTextField.setText(name.toString());
            this.repaint();
            this.revalidate();
            this.pack();
        } else {
            this.setControlFrameActive(false);
            this.nowStateTextField.setText(Bundle.getMessage("BeanStateUnknown"));
            this.nowControllersTextField.setText("");
        }
    }

    private void updateLightStatusFields(boolean flag) {
        int knownState = this.light.getState();
        switch (knownState) {
            case 2: {
                this.nowStateTextField.setText(Bundle.getMessage("StateOn"));
                break;
            }
            case 8: {
                this.nowStateTextField.setText(Bundle.getMessage("LightStateIntermediate"));
                break;
            }
            case 4: {
                this.nowStateTextField.setText(Bundle.getMessage("StateOff"));
                break;
            }
            case 784: {
                this.nowStateTextField.setText(Bundle.getMessage("LightStateTransitioningToFullOn"));
                break;
            }
            case 528: {
                this.nowStateTextField.setText(Bundle.getMessage("LightStateTransitioningHigher"));
                break;
            }
            case 272: {
                this.nowStateTextField.setText(Bundle.getMessage("LightStateTransitioningLower"));
                break;
            }
            case 16: {
                this.nowStateTextField.setText(Bundle.getMessage("LightStateTransitioningToFullOff"));
                break;
            }
            default: {
                this.nowStateTextField.setText(Bundle.getMessage("UnexpectedValueLabel", knownState));
            }
        }
        this.statusIsEnabledCheckBox.setSelected(this.light.getEnabled());
        if (this.light instanceof VariableLight) {
            VariableLight variableLight = (VariableLight)this.light;
            this.statusIsVariableCheckBox.setSelected(true);
            this.statusIsTransitionCheckBox.setSelected(variableLight.isTransitionAvailable());
            this.nowIntensityLabel.setText(this.oneDigits.format(variableLight.getCurrentIntensity() * 100.0));
            this.nowTransitionTimeLabel.setText(this.oneDotTwoDigits.format(variableLight.getTransitionTime()));
            this.nowIntensityMinLabel.setText(this.oneDigits.format(variableLight.getMinIntensity() * 100.0));
            this.nowIntensityMaxLabel.setText(this.oneDigits.format(variableLight.getMaxIntensity() * 100.0));
            if (flag) {
                this.intensityTextField.setText(this.oneDigits.format(variableLight.getTargetIntensity() * 100.0));
                this.transitionTimeTextField.setText(this.oneDotTwoDigits.format(variableLight.getTransitionTime()));
                this.intensityMinTextField.setText(this.oneDigits.format(variableLight.getMinIntensity() * 100.0));
                this.intensityMaxTextField.setText(this.oneDigits.format(variableLight.getMaxIntensity() * 100.0));
            }
        } else {
            this.statusIsVariableCheckBox.setSelected(false);
            this.statusIsTransitionCheckBox.setSelected(false);
            if (this.light.getState() == 2) {
                this.nowIntensityLabel.setText(this.oneDigits.format(1L));
            } else {
                this.nowIntensityLabel.setText(this.oneDigits.format(0L));
            }
            this.nowTransitionTimeLabel.setText(this.oneDotTwoDigits.format(0.0));
            this.nowIntensityMinLabel.setText(this.oneDigits.format(0L));
            this.nowIntensityMaxLabel.setText(this.oneDigits.format(1L));
            if (flag) {
                if (this.light.getState() == 2) {
                    this.nowIntensityLabel.setText(this.oneDigits.format(1L));
                } else {
                    this.nowIntensityLabel.setText(this.oneDigits.format(0L));
                }
                this.transitionTimeTextField.setText(this.oneDotTwoDigits.format(0.0));
                this.intensityMinTextField.setText(this.oneDigits.format(0L));
                this.intensityMaxTextField.setText(this.oneDigits.format(1L));
            }
        }
    }
}

