/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.simpleclock;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.Timer;
import jmri.ClockControl;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.Sensor;
import jmri.SystemConnectionMemo;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.implementation.AbstractNamedBean;
import jmri.jmrit.analogclock.AnalogClockFrame;
import jmri.jmrit.lcdclock.LcdClockFrame;
import jmri.jmrit.nixieclock.NixieClockFrame;
import jmri.jmrit.pragotronclock.PragotronClockFrame;
import jmri.jmrit.simpleclock.Bundle;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTimebase
extends AbstractNamedBean
implements Timebase {
    public static final double MINIMUM_RATE = 0.1;
    public static final double MAXIMUM_RATE = 100.0;
    protected final SystemConnectionMemo memo;
    private double mFactor = 1.0;
    private double hardwareFactor = 1.0;
    private double startupFactor = 1.0;
    private boolean startSetRate = true;
    private boolean haveStartupFactor = false;
    private Date startAtTime;
    private Date setTimeValue;
    private Date pauseTime;
    private Sensor clockSensor = null;
    private Memory clockMemory = null;
    private Memory factorMemory = null;
    private boolean internalMaster = true;
    private String masterName = "";
    private ClockControl hardwareTimeSource = null;
    private boolean synchronizeWithHardware = false;
    private boolean correctHardware = false;
    private boolean display12HourClock = false;
    private Timebase.ClockInitialRunState initialState = Timebase.ClockInitialRunState.DO_START;
    private boolean startSetTime = false;
    private Date startTime = new Date();
    private int startClockOption = 0;
    private boolean notInitialized = true;
    private boolean showStopButton = false;
    private SimpleDateFormat timeStorageFormat = null;
    private Timer timer = null;
    private int oldHours = -1;
    private int oldMinutes = -1;
    private Date oldDate = null;
    private static final Logger log = LoggerFactory.getLogger(SimpleTimebase.class);

    public SimpleTimebase(InternalSystemConnectionMemo memo) {
        super("SIMPLECLOCK");
        this.memo = memo;
        try {
            this.clockMemory = InstanceManager.memoryManagerInstance().provideMemory(String.valueOf(memo.getSystemPrefix()) + "MCURRENTTIME");
            this.clockMemory.setValue("--");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log.warn("Unable to create CURRENTTIME time memory variable");
        }
        this.init();
    }

    final void init() {
        this.setTime(new Date());
        this.pauseTime = null;
        try {
            this.clockSensor = InstanceManager.sensorManagerInstance().provideSensor(String.valueOf(this.memo.getSystemPrefix()) + "SCLOCKRUNNING");
            this.clockSensor.setKnownState(2);
            this.clockSensor.addPropertyChangeListener(this::clockSensorChanged);
        }
        catch (JmriException e) {
            log.warn("Exception setting CLOCKRUNNING sensor ACTIVE: {}", (Throwable)e);
        }
        if (InstanceManager.getNullableDefault(MemoryManager.class) != null) {
            try {
                this.factorMemory = InstanceManager.memoryManagerInstance().provideMemory(String.valueOf(this.memo.getSystemPrefix()) + "MRATEFACTOR");
                this.factorMemory.setValue(this.userGetRate());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log.warn("Unable to create RATEFACTOR time memory variable");
            }
        }
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameTime");
    }

    @Override
    public Date getTime() {
        if (this.pauseTime != null) {
            return new Date(this.pauseTime.getTime());
        }
        long elapsedMSec = new Date().getTime() - this.startAtTime.getTime();
        long nowMSec = this.setTimeValue.getTime() + (long)(this.mFactor * (double)elapsedMSec);
        return new Date(nowMSec);
    }

    @Override
    public void setTime(Date d) {
        this.startAtTime = new Date();
        this.setTimeValue = new Date(d.getTime());
        if (this.synchronizeWithHardware && InstanceManager.getDefault(ClockControl.class) != this.hardwareTimeSource) {
            InstanceManager.getDefault(ClockControl.class).setTime(d);
        }
        if (this.pauseTime != null) {
            this.pauseTime = this.setTimeValue;
        }
        this.handleAlarm(null);
    }

    @Override
    public void setTime(Instant i) {
        this.setTime(Date.from(i));
    }

    @Override
    public void userSetTime(Date d) {
        this.startAtTime = new Date();
        this.setTimeValue = new Date(d.getTime());
        if (this.synchronizeWithHardware) {
            InstanceManager.getDefault(ClockControl.class).setTime(d);
        } else if (!this.internalMaster && this.hardwareTimeSource != null) {
            this.hardwareTimeSource.setTime(d);
        }
        if (this.pauseTime != null) {
            this.pauseTime = this.setTimeValue;
        }
        this.handleAlarm(null);
    }

    @Override
    public void setRun(boolean run) {
        if (run && this.pauseTime != null) {
            this.setTime(this.pauseTime);
            if (this.synchronizeWithHardware) {
                InstanceManager.getDefault(ClockControl.class).startHardwareClock(this.getTime());
            } else if (!this.internalMaster && this.hardwareTimeSource != null) {
                this.hardwareTimeSource.startHardwareClock(this.getTime());
            }
            this.pauseTime = null;
            if (this.clockSensor != null) {
                try {
                    this.clockSensor.setKnownState(2);
                }
                catch (JmriException e) {
                    log.warn("Exception setting ISClockRunning sensor ACTIVE: {}", (Throwable)e);
                }
            }
        } else if (!run && this.pauseTime == null) {
            this.pauseTime = this.getTime();
            if (this.synchronizeWithHardware) {
                InstanceManager.getDefault(ClockControl.class).stopHardwareClock();
            } else if (!this.internalMaster && this.hardwareTimeSource != null) {
                this.hardwareTimeSource.stopHardwareClock();
            }
            if (this.clockSensor != null) {
                try {
                    this.clockSensor.setKnownState(4);
                }
                catch (JmriException e) {
                    log.warn("Exception setting ISClockRunning sensor INACTIVE: {}", (Throwable)e);
                }
            }
        }
        this.firePropertyChange("run", !run, run);
        this.handleAlarm(null);
    }

    @Override
    public boolean getRun() {
        return this.pauseTime == null;
    }

    @Override
    public void setRate(double factor) throws TimebaseRateException {
        if (factor < 0.1 || factor > 100.0) {
            log.error("rate of {} is out of reasonable range", (Object)factor);
            throw new TimebaseRateException();
        }
        if (this.internalMaster && !this.notInitialized) {
            log.error("Probable Error - questionable attempt to change fast clock rate");
        }
        double oldFactor = this.mFactor;
        Date now = this.getTime();
        this.mFactor = factor;
        if (this.internalMaster || this.notInitialized) {
            this.hardwareFactor = factor;
        }
        if ((this.internalMaster || this.synchronizeWithHardware && this.notInitialized) && InstanceManager.getDefault(ClockControl.class) != this.hardwareTimeSource) {
            InstanceManager.getDefault(ClockControl.class).setRate(factor);
        }
        this.setTime(now);
        if (this.internalMaster) {
            this.firePropertyChange("rate", oldFactor, factor);
        }
        this.handleAlarm(null);
    }

    @Override
    public void userSetRate(double factor) throws TimebaseRateException {
        if (factor < 0.1 || factor > 100.0) {
            log.error("rate of {} is out of reasonable range", (Object)factor);
            throw new TimebaseRateException();
        }
        double oldFactor = this.hardwareFactor;
        Date now = this.getTime();
        this.mFactor = factor;
        this.hardwareFactor = factor;
        if (this.synchronizeWithHardware) {
            InstanceManager.getDefault(ClockControl.class).setRate(factor);
        } else if (!this.internalMaster && this.hardwareTimeSource != null) {
            this.hardwareTimeSource.setRate(factor);
        }
        this.setTime(now);
        this.updateMemory(factor);
        this.firePropertyChange("rate", oldFactor, factor);
        this.handleAlarm(null);
    }

    @Override
    public double getRate() {
        return this.mFactor;
    }

    @Override
    public double userGetRate() {
        return this.internalMaster ? this.mFactor : this.hardwareFactor;
    }

    @Override
    public void setInternalMaster(boolean master, boolean update) {
        if (master != this.internalMaster) {
            this.internalMaster = master;
            if (this.internalMaster) {
                this.mFactor = this.hardwareFactor;
            }
            if (update) {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(this.userGetRate(), this.getTime(), false);
            }
            if (this.internalMaster) {
                this.masterName = "";
                this.hardwareTimeSource = null;
            } else {
                this.hardwareTimeSource = InstanceManager.getDefault(ClockControl.class);
                this.masterName = this.hardwareTimeSource.getHardwareClockName();
            }
        }
    }

    @Override
    public boolean getInternalMaster() {
        return this.internalMaster;
    }

    @Override
    public void setMasterName(String name) {
        if (!this.internalMaster) {
            this.masterName = name;
            this.hardwareTimeSource = InstanceManager.getDefault(ClockControl.class);
        } else {
            this.masterName = "";
            this.hardwareTimeSource = null;
        }
    }

    @Override
    public String getMasterName() {
        return this.masterName;
    }

    @Override
    public void setSynchronize(boolean synchronize, boolean update) {
        if (this.synchronizeWithHardware != synchronize) {
            this.synchronizeWithHardware = synchronize;
            if (update) {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(this.userGetRate(), this.getTime(), false);
            }
        }
    }

    @Override
    public boolean getSynchronize() {
        return this.synchronizeWithHardware;
    }

    @Override
    public void setCorrectHardware(boolean correct, boolean update) {
        if (this.correctHardware != correct) {
            this.correctHardware = correct;
            if (update) {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(this.userGetRate(), this.getTime(), false);
            }
        }
    }

    @Override
    public boolean getCorrectHardware() {
        return this.correctHardware;
    }

    @Override
    public void set12HourDisplay(boolean display, boolean update) {
        if (display != this.display12HourClock) {
            this.display12HourClock = display;
            if (update) {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(this.userGetRate(), this.getTime(), false);
            }
        }
    }

    @Override
    public boolean use12HourDisplay() {
        return this.display12HourClock;
    }

    @Override
    public void setClockInitialRunState(Timebase.ClockInitialRunState state) {
        this.initialState = state;
    }

    @Override
    public Timebase.ClockInitialRunState getClockInitialRunState() {
        return this.initialState;
    }

    @Override
    public void setShowStopButton(boolean displayed) {
        this.showStopButton = displayed;
    }

    @Override
    public boolean getShowStopButton() {
        return this.showStopButton;
    }

    @Override
    public void setStartSetTime(boolean set, Date time) {
        this.startSetTime = set;
        this.startTime = new Date(time.getTime());
    }

    @Override
    public boolean getStartSetTime() {
        return this.startSetTime;
    }

    @Override
    public void setStartRate(double factor) {
        this.startupFactor = factor;
        this.haveStartupFactor = true;
    }

    @Override
    public double getStartRate() {
        if (this.haveStartupFactor) {
            return this.startupFactor;
        }
        return this.userGetRate();
    }

    @Override
    public void setSetRateAtStart(boolean set) {
        this.startSetRate = set;
    }

    @Override
    public boolean getSetRateAtStart() {
        return this.startSetRate;
    }

    @Override
    public Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    @Override
    public void setStartClockOption(int option) {
        this.startClockOption = option;
    }

    @Override
    public int getStartClockOption() {
        return this.startClockOption;
    }

    @Override
    public void initializeClock() {
        switch (this.startClockOption) {
            case 1: {
                NixieClockFrame f = new NixieClockFrame();
                f.setVisible(true);
                break;
            }
            case 2: {
                AnalogClockFrame g = new AnalogClockFrame();
                g.setVisible(true);
                break;
            }
            case 4: {
                LcdClockFrame h = new LcdClockFrame();
                h.setVisible(true);
                break;
            }
            case 8: {
                PragotronClockFrame p = new PragotronClockFrame();
                p.setVisible(true);
                break;
            }
            default: {
                log.debug("initializeClock() called with invalid startClockOption: {}", (Object)this.startClockOption);
            }
        }
    }

    @Override
    public void initializeHardwareClock() {
        boolean startStopped;
        boolean bl = startStopped = this.initialState == Timebase.ClockInitialRunState.DO_STOP;
        if (this.synchronizeWithHardware || this.correctHardware) {
            if (startStopped) {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(0.0, this.getTime(), !this.internalMaster && !this.startSetTime);
            } else {
                InstanceManager.getDefault(ClockControl.class).initializeHardwareClock(this.mFactor, this.getTime(), !this.internalMaster && !this.startSetTime);
            }
        } else if (!this.internalMaster) {
            if (startStopped) {
                this.hardwareTimeSource.initializeHardwareClock(0.0, this.getTime(), !this.startSetTime);
            } else {
                this.hardwareTimeSource.initializeHardwareClock(this.hardwareFactor, this.getTime(), !this.startSetTime);
            }
        }
        this.notInitialized = false;
    }

    @Override
    public boolean getIsInitialized() {
        return !this.notInitialized;
    }

    private void clockSensorChanged(PropertyChangeEvent e) {
        if (this.clockSensor.getKnownState() == 2) {
            if (this.pauseTime == null) {
                return;
            }
            this.setRun(true);
        } else {
            if (this.pauseTime != null) {
                return;
            }
            this.setRun(false);
        }
    }

    @Override
    public void dispose() {
        if (this.timer != null) {
            ActionListener[] listeners;
            this.timer.setRepeats(false);
            this.timer.stop();
            ActionListener[] actionListenerArray = listeners = (ActionListener[])this.timer.getListeners(ActionListener.class);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ActionListener listener = actionListenerArray[n2];
                this.timer.removeActionListener(listener);
                ++n2;
            }
            this.timer = null;
        }
    }

    void startAlarm() {
        if (this.timer == null) {
            this.handleAlarm(null);
        }
    }

    void handleAlarm(ActionEvent e) {
        if (this.timer == null) {
            this.timer = new Timer(60000, this::handleAlarm);
        }
        Calendar calendar = Calendar.getInstance();
        this.timer.stop();
        Date date = this.getTime();
        calendar.setTime(date);
        int waitSeconds = 60 - calendar.get(13);
        int delay = (int)((double)(waitSeconds * 1000) / this.mFactor) + 100;
        this.timer.setInitialDelay(delay);
        this.timer.setRepeats(true);
        this.timer.start();
        calendar.setTime(date);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        if (hours != this.oldHours || minutes != this.oldMinutes) {
            this.updateMemory(date);
            this.firePropertyChange("minutes", this.oldMinutes, minutes);
            this.firePropertyChange("time", this.oldDate != null ? new Date(this.oldDate.getTime()) : null, new Date(date.getTime()));
        }
        this.oldDate = date;
        this.oldHours = hours;
        this.oldMinutes = minutes;
    }

    void updateMemory(Date date) {
        if (this.timeStorageFormat == null) {
            try {
                this.timeStorageFormat = new SimpleDateFormat(ResourceBundle.getBundle("jmri.jmrit.simpleclock.SimpleClockBundle").getString("TimeStorageFormat"));
            }
            catch (IllegalArgumentException e) {
                log.info("Dropping back to default time format due to exception {}", (Throwable)e);
                this.timeStorageFormat = new SimpleDateFormat("h:mm a");
            }
        }
        this.clockMemory.setValue(this.timeStorageFormat.format(date));
    }

    void updateMemory(double factor) {
        this.factorMemory.setValue(factor);
    }

    @Override
    public void addMinuteChangeListener(PropertyChangeListener l) {
        this.addPropertyChangeListener("minutes", l);
    }

    @Override
    public void removeMinuteChangeListener(PropertyChangeListener l) {
        this.removePropertyChangeListener("minutes", l);
    }

    @Override
    public PropertyChangeListener[] getMinuteChangeListeners() {
        return this.getPropertyChangeListeners("minutes");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        super.addPropertyChangeListener(listener);
        this.startAlarm();
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        if (propertyName != null && (propertyName.equals("minutes") || propertyName.equals("time"))) {
            this.startAlarm();
        }
    }

    @Override
    public void setState(int s) throws JmriException {
    }

    @Override
    public int getState() {
        return 0;
    }
}

