/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sensorgroup;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.NamedBean;
import jmri.Route;
import jmri.RouteManager;
import jmri.implementation.DefaultConditionalAction;
import jmri.implementation.SensorGroupConditional;
import jmri.jmrit.sensorgroup.Bundle;
import jmri.jmrit.sensorgroup.SensorTableModel;
import jmri.swing.RowSorterUtil;
import jmri.util.AlphanumComparator;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorGroupFrame
extends JmriJFrame {
    private static final String namePrefix = "SENSOR GROUP:";
    private static final String nameDivider = ":";
    public static final String logixSysName;
    public static final String logixUserName = "System Logix";
    public static final String ConditionalSystemPrefix;
    private static final String ConditionalUserPrefix = "Sensor Group ";
    private int rowHeight;
    SensorTableModel _sensorModel;
    JScrollPane _sensorScrollPane;
    JTextField _nameField;
    JList<String> _sensorGroupList;
    private static final Logger log;

    static {
        String logixPrefix = InstanceManager.getDefault(LogixManager.class).getSystemNamePrefix();
        logixSysName = String.valueOf(logixPrefix) + ":SYS";
        ConditionalSystemPrefix = String.valueOf(logixSysName) + "_SGC_";
        log = LoggerFactory.getLogger(SensorGroupFrame.class);
    }

    @Override
    public void initComponents() {
        this.addHelpMenu("package.jmri.jmrit.sensorgroup.SensorGroupFrame", true);
        this.setTitle(Bundle.getMessage("Title"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p2xs = new JPanel();
        JPanel p21s = new JPanel();
        p21s.setLayout(new BoxLayout(p21s, 1));
        p21s.add(new JLabel(Bundle.getMessage("SensorTableLabel1")));
        p21s.add(new JLabel(Bundle.getMessage("SensorTableLabel2")));
        p21s.add(new JLabel(Bundle.getMessage("SensorTableLabel3")));
        p21s.add(new JLabel(Bundle.getMessage("SensorTableLabel4")));
        p2xs.add(p21s);
        this._sensorModel = new SensorTableModel();
        JTable sensorTable = new JTable(this._sensorModel);
        TableRowSorter<SensorTableModel> sorter = new TableRowSorter<SensorTableModel>(this._sensorModel);
        sorter.setComparator(0, new AlphanumComparator());
        sorter.setComparator(1, new AlphanumComparator());
        RowSorterUtil.setSortOrder(sorter, 0, SortOrder.ASCENDING);
        sensorTable.setRowSorter(sorter);
        sensorTable.setRowSelectionAllowed(false);
        sensorTable.setPreferredScrollableViewportSize(new Dimension(450, 200));
        TableColumnModel sensorColumnModel = sensorTable.getColumnModel();
        TableColumn includeColumnS = sensorColumnModel.getColumn(2);
        includeColumnS.setResizable(false);
        includeColumnS.setMinWidth(50);
        includeColumnS.setMaxWidth(60);
        TableColumn sNameColumnS = sensorColumnModel.getColumn(0);
        sNameColumnS.setResizable(true);
        sNameColumnS.setMinWidth(75);
        sNameColumnS.setPreferredWidth(95);
        TableColumn uNameColumnS = sensorColumnModel.getColumn(1);
        uNameColumnS.setResizable(true);
        uNameColumnS.setMinWidth(210);
        uNameColumnS.setPreferredWidth(260);
        this.rowHeight = sensorTable.getRowHeight();
        this._sensorScrollPane = new JScrollPane(sensorTable);
        p2xs.add((Component)this._sensorScrollPane, "Center");
        this.getContentPane().add(p2xs);
        p2xs.setVisible(true);
        JPanel p3 = new JPanel();
        p3.add(new JLabel(Bundle.getMessage("GroupName")));
        this._nameField = new JTextField(20);
        p3.add(this._nameField);
        this.getContentPane().add(p3);
        JPanel p4 = new JPanel();
        JButton viewButton = new JButton(Bundle.getMessage("ButtonViewGroup"));
        viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorGroupFrame.this.viewPressed();
            }
        });
        p4.add(viewButton);
        JButton addButton = new JButton(Bundle.getMessage("ButtonMakeGroup"));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorGroupFrame.this.addPressed();
            }
        });
        p4.add(addButton);
        JButton undoButton = new JButton(Bundle.getMessage("ButtonUndoGroup"));
        undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorGroupFrame.this.undoGroupPressed();
            }
        });
        p4.add(undoButton);
        this.getContentPane().add(p4);
        JPanel p5 = new JPanel();
        DefaultListModel<String> groupModel = new DefaultListModel<String>();
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        int i = 0;
        for (NamedBean obj : rm.getNamedBeanSet()) {
            String name = obj.getSystemName();
            if (name.startsWith(namePrefix)) {
                name = name.substring(namePrefix.length());
                String group = name.substring(0, name.indexOf(nameDivider));
                String prefix = namePrefix + group + nameDivider;
                while (++i < rm.getNamedBeanSet().size() && (name = obj.getSystemName()).startsWith(prefix)) {
                }
                groupModel.addElement(group);
            }
            ++i;
        }
        Logix logix = this.getSystemLogix();
        i = 0;
        while (i < logix.getNumConditionals()) {
            String name = logix.getConditionalByNumberOrder(i);
            Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(name);
            String uname = null;
            if (c != null) {
                uname = c.getUserName();
            }
            if (uname != null) {
                groupModel.addElement(uname.substring(ConditionalUserPrefix.length()));
            }
            ++i;
        }
        this._sensorGroupList = new JList(groupModel);
        this._sensorGroupList.setPrototypeCellValue("Sensor Group XXXXXXXXXX");
        this._sensorGroupList.setSelectionMode(0);
        this._sensorGroupList.setVisibleRowCount(5);
        JScrollPane scrollPane = new JScrollPane(this._sensorGroupList);
        p5.add(scrollPane);
        p5.add(Box.createHorizontalStrut(10));
        JButton doneButton = new JButton(Bundle.getMessage("ButtonDone"));
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SensorGroupFrame.this.donePressed(e);
            }
        });
        p5.add(doneButton);
        this.getContentPane().add(p5);
        this.pack();
    }

    void addPressed() {
        this.deleteGroup(false);
        String group = this._nameField.getText();
        if (group == null || group.length() == 0) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MessageError1"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        Logix logix = this.getSystemLogix();
        logix.deActivateLogix();
        String cSystemName = String.valueOf(ConditionalSystemPrefix) + group;
        String cUserName = ConditionalUserPrefix + group;
        ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
        ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
        int count = 0;
        int i = 0;
        while (i < this._sensorModel.getRowCount()) {
            if (((Boolean)this._sensorModel.getValueAt(i, 2)).booleanValue()) {
                String sensor = (String)this._sensorModel.getValueAt(i, 1);
                if (sensor == null || sensor.length() == 0) {
                    sensor = (String)this._sensorModel.getValueAt(i, 0);
                }
                variableList.add(new ConditionalVariable(false, Conditional.Operator.OR, Conditional.Type.SENSOR_ACTIVE, sensor, true));
                actionList.add(new DefaultConditionalAction(1, Conditional.Action.SET_SENSOR, sensor, 4, ""));
                ++count;
            }
            ++i;
        }
        if (count < 2) {
            JOptionPane.showMessageDialog(this, Bundle.getMessage("MessageError2"), Bundle.getMessage("ErrorTitle"), 0);
        }
        SensorGroupConditional c = new SensorGroupConditional(cSystemName, cUserName);
        c.setStateVariables(variableList);
        c.setLogicType(Conditional.AntecedentOperator.ALL_OR, "");
        c.setAction(actionList);
        logix.addConditional(cSystemName, 0);
        logix.addConditional(cSystemName, c);
        logix.setEnabled(true);
        logix.activateLogix();
        ((DefaultListModel)this._sensorGroupList.getModel()).addElement(cUserName.substring(ConditionalUserPrefix.length()));
        this.clear();
    }

    void viewPressed() {
        int i = 0;
        while (i < this._sensorModel.getRowCount()) {
            this._sensorModel.setValueAt(Boolean.FALSE, i, 2);
            ++i;
        }
        String group = this._sensorGroupList.getSelectedValue();
        if (group == null) {
            group = this._nameField.getText();
        }
        this._nameField.setText(group);
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        String prefix = namePrefix + group + nameDivider;
        boolean isRoute = false;
        int setRow = 0;
        for (Route r : rm.getNamedBeanSet()) {
            String name = r.getSystemName();
            if (!name.startsWith(prefix)) continue;
            isRoute = true;
            String sensor = name.substring(prefix.length());
            int j = this._sensorModel.getRowCount() - 1;
            while (j >= 0) {
                if (this._sensorModel.getValueAt(j, 0).equals(sensor)) {
                    this._sensorModel.setValueAt(Boolean.TRUE, j, 2);
                    setRow = j;
                }
                --j;
            }
        }
        if (!isRoute) {
            Logix logix = this.getSystemLogix();
            String cSystemName = String.valueOf(ConditionalSystemPrefix) + group;
            String cUserName = ConditionalUserPrefix + group;
            int i2 = 0;
            while (i2 < logix.getNumConditionals()) {
                String name = logix.getConditionalByNumberOrder(i2);
                if (cSystemName.equalsIgnoreCase(name) || cUserName.equals(name)) {
                    Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(name);
                    if (c == null) {
                        log.error("Conditional \"{}\" expected but NOT found in Logix {}", (Object)name, (Object)logix.getSystemName());
                    } else {
                        List<ConditionalVariable> variableList = c.getCopyOfStateVariables();
                        int k = 0;
                        while (k < variableList.size()) {
                            String sensor = variableList.get(k).getName();
                            if (sensor != null) {
                                int j = this._sensorModel.getRowCount() - 1;
                                while (j >= 0) {
                                    if (sensor.equals(this._sensorModel.getValueAt(j, 1)) || sensor.equals(this._sensorModel.getValueAt(j, 0))) {
                                        this._sensorModel.setValueAt(Boolean.TRUE, j, 2);
                                        setRow = j;
                                    }
                                    --j;
                                }
                            }
                            ++k;
                        }
                    }
                }
                ++i2;
            }
        }
        this._sensorModel.fireTableDataChanged();
        if ((setRow -= 9) < 0) {
            setRow = 0;
        }
        this._sensorScrollPane.getVerticalScrollBar().setValue(setRow * this.rowHeight);
    }

    Logix getSystemLogix() {
        Logix logix = InstanceManager.getDefault(LogixManager.class).getBySystemName(logixSysName);
        if (logix == null) {
            logix = InstanceManager.getDefault(LogixManager.class).createNewLogix(logixSysName, logixUserName);
        }
        return logix;
    }

    void clear() {
        this._sensorGroupList.getSelectionModel().clearSelection();
        this._nameField.setText("");
        int i = 0;
        while (i < this._sensorModel.getRowCount()) {
            this._sensorModel.setValueAt(Boolean.FALSE, i, 2);
            ++i;
        }
        this._sensorModel.fireTableDataChanged();
    }

    void donePressed(ActionEvent e) {
        this._sensorModel.dispose();
        this.dispose();
    }

    void deleteGroup(boolean showMsg) {
        String group = this._nameField.getText();
        if (group == null || group.equals("")) {
            if (showMsg) {
                JOptionPane.showMessageDialog(this, Bundle.getMessage("MessageError3"), Bundle.getMessage("ErrorTitle"), 0);
            }
            return;
        }
        String prefix = namePrefix + group + nameDivider;
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        for (Route r : rm.getNamedBeanSet()) {
            String name = r.getSystemName();
            if (!name.startsWith(prefix)) continue;
            r.deActivateRoute();
            rm.deleteRoute(r);
        }
        String cSystemName = String.valueOf(ConditionalSystemPrefix) + group;
        String cUserName = ConditionalUserPrefix + group;
        Logix logix = this.getSystemLogix();
        int i = 0;
        while (i < logix.getNumConditionals()) {
            String name = logix.getConditionalByNumberOrder(i);
            if (cSystemName.equals(name) || cUserName.equals(name)) {
                Conditional c = InstanceManager.getDefault(ConditionalManager.class).getBySystemName(name);
                if (c == null) {
                    log.error("Conditional \"{}\" expected but NOT found in Logix {}", (Object)name, (Object)logix.getSystemName());
                } else {
                    logix.deleteConditional(cSystemName);
                    break;
                }
            }
            ++i;
        }
        DefaultListModel model = (DefaultListModel)this._sensorGroupList.getModel();
        int index = model.indexOf(group);
        if (index > -1) {
            model.remove(index);
        }
        if ((index = this._sensorGroupList.getSelectedIndex()) > -1) {
            String sysName = String.valueOf(ConditionalSystemPrefix) + (String)model.elementAt(index);
            String[] msgs = logix.deleteConditional(sysName);
            if (msgs != null) {
                if (showMsg) {
                    JOptionPane.showMessageDialog(this, String.valueOf(Bundle.getMessage("MessageError41")) + " " + msgs[0] + " (" + msgs[1] + ") " + Bundle.getMessage("MessageError42") + " " + msgs[2] + " (" + msgs[3] + "), " + Bundle.getMessage("MessageError43") + " " + msgs[4] + " (" + msgs[5] + "). " + Bundle.getMessage("MessageError44"), Bundle.getMessage("ErrorTitle"), 0);
                }
            } else {
                model.remove(index);
            }
        }
    }

    void undoGroupPressed() {
        this.deleteGroup(true);
        this.clear();
    }
}

