/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.sensorgroup;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.Route;
import jmri.RouteManager;
import jmri.implementation.DefaultRoute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorGroup {
    private static final String namePrefix = "SENSOR GROUP:";
    private static final String nameDivider = ":";
    String name;
    ArrayList<String> sensorList;
    private static final Logger log = LoggerFactory.getLogger(SensorGroup.class);

    SensorGroup(String name) {
        this.name = name;
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        String group = name;
        String prefix = namePrefix + group + nameDivider;
        this.sensorList = new ArrayList();
        for (Route route : rm.getNamedBeanSet()) {
            String routeName = route.getSystemName();
            if (!routeName.startsWith(prefix)) continue;
            String sensor = routeName.substring(prefix.length());
            this.sensorList.add(sensor);
        }
    }

    void addPressed() {
        String routeName;
        log.debug("start with {} lines", (Object)this.sensorList.size());
        RouteManager rm = InstanceManager.getDefault(RouteManager.class);
        String group = this.name;
        String prefix = namePrefix + group + nameDivider;
        for (Route r : rm.getNamedBeanSet()) {
            routeName = r.getSystemName();
            if (!routeName.startsWith(prefix)) continue;
            r.deActivateRoute();
            rm.deleteRoute(r);
        }
        int i = 0;
        while (i < this.sensorList.size()) {
            String sensor = this.sensorList.get(i);
            routeName = namePrefix + group + nameDivider + sensor;
            DefaultRoute r = new DefaultRoute(routeName);
            r.addSensorToRoute(sensor, 0);
            int j = 0;
            while (j < this.sensorList.size()) {
                String outSensor = this.sensorList.get(j);
                int mode = 4;
                if (i == j) {
                    mode = 2;
                }
                r.addOutputSensor(outSensor, mode);
                ++j;
            }
            r.activateRoute();
            rm.register(r);
            ++i;
        }
    }
}

